/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$AddPartitionsListener$;
import kafka.controller.PartitionStateMachine$DeleteTopicsListener$;
import kafka.controller.PartitionStateMachine$TopicChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tUg\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtDC\u0001\u000f\u001e!\t1\u0002\u0001C\u0003\u00043\u0001\u0007Q\u0003C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001\"!\t1\"%\u0003\u0002$\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r\u0015\u0002\u0001\u0015!\u0003\"\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0006\u0005\u0002\nU%\u00111F\u0003\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%\u0011&A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003!Q8n\u00117jK:$X#A\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014\u0001\u0003>lG2LWM\u001c;\u000b\u0005Y:\u0014AB%1\u0013R,7MC\u00019\u0003\ry'oZ\u0005\u0003uM\u0012\u0001BW6DY&,g\u000e\u001e\u0005\u0007y\u0001\u0001\u000b\u0011B\u0019\u0002\u0013i\\7\t\\5f]R\u0004\u0003b\u0002 \u0001\u0005\u0004%IaP\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f+\u0005\u0001\u0005\u0003B!G\u0011:k\u0011A\u0011\u0006\u0003\u0007\u0012\u000bq!\\;uC\ndWM\u0003\u0002F\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d\u0013%aA'baB\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nB\u0001\u0007G>lWn\u001c8\n\u00055S%!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011acT\u0005\u0003!\n\u0011a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\r\u0003\u0004S\u0001\u0001\u0006I\u0001Q\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fA!9A\u000b\u0001b\u0001\n\u0013)\u0016A\u00052s_.,'OU3rk\u0016\u001cHOQ1uG\",\u0012A\u0016\t\u0003-]K!\u0001\u0017\u0002\u00039\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\"1!\f\u0001Q\u0001\nY\u000b1C\u0019:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0002Bq\u0001\u0018\u0001C\u0002\u0013%Q,\u0001\u0006iCN\u001cF/\u0019:uK\u0012,\u0012A\u0018\t\u0003?\"l\u0011\u0001\u0019\u0006\u0003C\n\fa!\u0019;p[&\u001c'BA2e\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003K\u001a\fA!\u001e;jY*\tq-\u0001\u0003kCZ\f\u0017BA5a\u00055\tEo\\7jG\n{w\u000e\\3b]\"11\u000e\u0001Q\u0001\ny\u000b1\u0002[1t'R\f'\u000f^3eA!9Q\u000e\u0001b\u0001\n\u0013q\u0017a\u00078p\u001fB\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'/F\u0001p!\t1\u0002/\u0003\u0002r\u0005\t\u0011bj\\(q\u0019\u0016\fG-\u001a:TK2,7\r^8s\u0011\u0019\u0019\b\u0001)A\u0005_\u0006abn\\(q!\u0006\u0014H/\u001b;j_:dU-\u00193feN+G.Z2u_J\u0004\u0003bB;\u0001\u0005\u0004%IA^\u0001\u0014i>\u0004\u0018nY\"iC:<W\rT5ti\u0016tWM]\u000b\u0002oB\u0011\u00010_\u0007\u0002\u0001\u0019!!\u0010\u0001\u0001|\u0005M!v\u000e]5d\u0007\"\fgnZ3MSN$XM\\3s'\u0015IH0!\u0002\u000f!\ri\u0018\u0011A\u0007\u0002}*\u0011qPZ\u0001\u0005Y\u0006tw-C\u0002\u0002\u0004y\u0014aa\u00142kK\u000e$\bc\u0001\u001a\u0002\b%\u0019\u0011\u0011B\u001a\u0003!%S6n\u00115jY\u0012d\u0015n\u001d;f]\u0016\u0014\bB\u0002\u000ez\t\u0003\ti\u0001F\u0001x\u0011\u001d\t\t\"\u001fC\u0001\u0003'\t\u0011\u0003[1oI2,7\t[5mI\u000eC\u0017M\\4f)\u0019\t)\"a\u0007\u0002.A\u0019\u0011\"a\u0006\n\u0007\u0005e!B\u0001\u0003V]&$\b\u0002CA\u000f\u0003\u001f\u0001\r!a\b\u0002\u0015A\f'/\u001a8u!\u0006$\b\u000e\u0005\u0003\u0002\"\u0005\u001dbbA\u0005\u0002$%\u0019\u0011Q\u0005\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)C\u0003\u0005\t\u0003_\ty\u00011\u0001\u00022\u0005A1\r[5mIJ,g\u000e\u0005\u0004\u00024\u0005U\u0012qD\u0007\u0002I&\u0019\u0011q\u00073\u0003\t1K7\u000f\u001e\u0015\u0007\u0003\u001f\tY$!\u0017\u0011\u000b%\ti$!\u0011\n\u0007\u0005}\"B\u0001\u0004uQJ|wo\u001d\t\u0005\u0003\u0007\n\u0019F\u0004\u0003\u0002F\u0005=c\u0002BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-c!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0019\u0011\u0011\u000b\u0006\u0002\u000fA\f7m[1hK&!\u0011QKA,\u0005%)\u0005pY3qi&|gNC\u0002\u0002R)\u0019#!!\u0011\t\u000f\u0005u\u0003\u0001)A\u0005o\u0006!Bo\u001c9jG\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe\u0002B\u0011\"!\u0019\u0001\u0005\u0004%I!a\u0019\u0002)\u0011,G.\u001a;f)>\u0004\u0018nY:MSN$XM\\3s+\t\t)\u0007E\u0002y\u0003O2a!!\u001b\u0001\u0001\u0005-$\u0001\u0006#fY\u0016$X\rV8qS\u000e\u001cH*[:uK:,'o\u0005\u0004\u0002hq\f)A\u0004\u0005\b5\u0005\u001dD\u0011AA8)\t\t)\u0007\u0003\u00050\u0003O\u0012\r\u0011\"\u00011\u0011\u001da\u0014q\rQ\u0001\nEB\u0001\"!\u0005\u0002h\u0011\u0005\u0011q\u000f\u000b\u0007\u0003+\tI(a\u001f\t\u0011\u0005u\u0011Q\u000fa\u0001\u0003?A\u0001\"a\f\u0002v\u0001\u0007\u0011\u0011\u0007\u0015\u0007\u0003k\nY$!\u0017\t\u0011\u0005\u0005\u0015q\rC\u0001\u0003\u0007\u000b\u0011\u0003[1oI2,G)\u0019;b\t\u0016dW\r^3e)\u0011\t)\"!\"\t\u0011\u0005\u001d\u0015q\u0010a\u0001\u0003?\t\u0001\u0002Z1uCB\u000bG\u000f\u001b\u0015\u0007\u0003\u007f\nY$!\u0017\t\u0011\u00055\u0005\u0001)A\u0005\u0003K\nQ\u0003Z3mKR,Gk\u001c9jGNd\u0015n\u001d;f]\u0016\u0014\b\u0005C\u0005\u0002\u0012\u0002\u0011\r\u0011\"\u0003\u0002\u0014\u0006)\u0012\r\u001a3QCJ$\u0018\u000e^5p]Nd\u0015n\u001d;f]\u0016\u0014XCAAK!\u0019\te)a\b\u0002\u0018B\u0019\u00010!'\u0007\r\u0005m\u0005\u0001AAO\u0005U\tE\r\u001a)beRLG/[8og2K7\u000f^3oKJ\u001cb!!'}\u0003?s\u0001c\u0001\u001a\u0002\"&\u0019\u00111U\u001a\u0003\u001f%S6\u000eR1uC2K7\u000f^3oKJD1\"a*\u0002\u001a\n\u0005\t\u0015!\u0003\u0002 \u0005)Ao\u001c9jG\"9!$!'\u0005\u0002\u0005-F\u0003BAL\u0003[C\u0001\"a*\u0002*\u0002\u0007\u0011q\u0004\u0005\t\u0003c\u000bI\n\"\u0001\u00024\u0006\u0001\u0002.\u00198eY\u0016$\u0015\r^1DQ\u0006tw-\u001a\u000b\u0007\u0003+\t),a.\t\u0011\u0005\u001d\u0015q\u0016a\u0001\u0003?Aq!!/\u00020\u0002\u0007A0\u0001\u0003eCR\f\u0007FBAX\u0003w\tI\u0006\u0003\u0005\u0002\u0002\u0006eE\u0011AA`)\u0011\t)\"!1\t\u0011\u0005u\u0011Q\u0018a\u0001\u0003?Ac!!0\u0002<\u0005e\u0003\u0002CAd\u0001\u0001\u0006I!!&\u0002-\u0005$G\rU1si&$\u0018n\u001c8t\u0019&\u001cH/\u001a8fe\u0002B\u0011\"a3\u0001\u0005\u0004%I!!4\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0002PB!\u0011\u0011[Al\u001d\r1\u00121[\u0005\u0004\u0003+\u0014\u0011aD&bM.\f7i\u001c8ue>dG.\u001a:\n\t\u0005e\u00171\u001c\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014(bAAk\u0005!A\u0011q\u001c\u0001!\u0002\u0013\ty-\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0003bBAr\u0001\u0011\u0005\u0011Q]\u0001\bgR\f'\u000f^;q)\t\t)\u0002C\u0004\u0002j\u0002!\t!!:\u0002#I,w-[:uKJd\u0015n\u001d;f]\u0016\u00148\u000fC\u0004\u0002n\u0002!\t!!:\u0002'\u0011,'/Z4jgR,'\u000fT5ti\u0016tWM]:\t\u000f\u0005E\b\u0001\"\u0001\u0002f\u0006A1\u000f[;uI><h\u000eC\u0004\u0002v\u0002!\t!!:\u0002CQ\u0014\u0018nZ4fe>sG.\u001b8f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0007\"\fgnZ3\t\u000f\u0005e\b\u0001\"\u0001\u0002|\u0006\t\u0002/\u0019:uSRLwN\\:J]N#\u0018\r^3\u0015\t\u0005u(Q\u0001\t\u0006\u0003\u007f\u0014\t\u0001S\u0007\u0002\t&\u0019!1\u0001#\u0003\u0007M+G\u000fC\u0004\u0003\b\u0005]\b\u0019\u0001(\u0002\u000bM$\u0018\r^3\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e\u0005\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t))\t)Ba\u0004\u0003\u0014\t]!\u0011\u0005\u0005\t\u0005#\u0011I\u00011\u0001\u0002~\u0006Q\u0001/\u0019:uSRLwN\\:\t\u000f\tU!\u0011\u0002a\u0001\u001d\u0006YA/\u0019:hKR\u001cF/\u0019;f\u0011)\u0011IB!\u0003\u0011\u0002\u0003\u0007!1D\u0001\u000fY\u0016\fG-\u001a:TK2,7\r^8s!\r1\"QD\u0005\u0004\u0005?\u0011!a\u0006)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8s\u0011)\u0011\u0019C!\u0003\u0011\u0002\u0003\u0007!QE\u0001\nG\u0006dGNY1dWN\u00042A\u0006B\u0014\u0013\r\u0011IC\u0001\u0002\n\u0007\u0006dGNY1dWNDqA!\f\u0001\t\u0013\u0011y#A\tiC:$G.Z*uCR,7\t[1oO\u0016$B\"!\u0006\u00032\tM\"q\u0007B\u001d\u0005wA\u0001\"a*\u0003,\u0001\u0007\u0011q\u0004\u0005\b\u0005k\u0011Y\u00031\u0001*\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0003\u0016\t-\u0002\u0019\u0001(\t\u0011\te!1\u0006a\u0001\u00057A\u0001Ba\t\u0003,\u0001\u0007!Q\u0005\u0005\b\u0005\u007f\u0001A\u0011BAs\u0003aIg.\u001b;jC2L'0\u001a)beRLG/[8o'R\fG/\u001a\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0003e\t7o]3siZ\u000bG.\u001b3Qe\u00164\u0018n\\;t'R\fG/Z:\u0015\u0011\u0005U!q\tB&\u0005+BqA!\u0013\u0003B\u0001\u0007\u0001*A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001B!\u0014\u0003B\u0001\u0007!qJ\u0001\u000bMJ|Wn\u0015;bi\u0016\u001c\b#BA\u0000\u0005#r\u0015b\u0001B*\t\n\u00191+Z9\t\u000f\tU!\u0011\ta\u0001\u001d\"9!\u0011\f\u0001\u0005\n\tm\u0013AG1tg&<gNU3qY&\u001c\u0017m\u001d+p!\u0006\u0014H/\u001b;j_:\u001cHCBA\u000b\u0005;\u0012y\u0006\u0003\u0005\u0002(\n]\u0003\u0019AA\u0010\u0011\u001d\u0011)Da\u0016A\u0002%BqAa\u0019\u0001\t\u0013\u0011)'\u0001\u0012j]&$\u0018.\u00197ju\u0016dU-\u00193fe\u0006sG-S:s\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\u0005\u0003+\u00119\u0007C\u0004\u0003J\t\u0005\u0004\u0019\u0001%\t\u000f\t-\u0004\u0001\"\u0001\u0003n\u00059R\r\\3di2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\t\u0003+\u0011yG!\u001d\u0003t!A\u0011q\u0015B5\u0001\u0004\ty\u0002C\u0004\u00036\t%\u0004\u0019A\u0015\t\u0011\te!\u0011\u000ea\u0001\u00057AqAa\u001e\u0001\t\u0013\u0011I(A\u000esK\u001eL7\u000f^3s)>\u0004\u0018nY\"iC:<W\rT5ti\u0016tWM\u001d\u000b\u0003\u0005w\u0002b!a\r\u00026\tu\u0004cA?\u0003\u0000%\u0019\u0011\u0011\u0006@\t\u000f\t\r\u0005\u0001\"\u0003\u0002f\u0006iB-\u001a:fO&\u001cH/\u001a:U_BL7m\u00115b]\u001e,G*[:uK:,'\u000fC\u0004\u0003\b\u0002!\tA!#\u0002?I,w-[:uKJ\u0004\u0016M\u001d;ji&|gn\u00115b]\u001e,G*[:uK:,'\u000f\u0006\u0003\u0002\u0016\t-\u0005\u0002CAT\u0005\u000b\u0003\r!a\b\t\u000f\t=\u0005\u0001\"\u0001\u0003\u0012\u0006\tC-\u001a:fO&\u001cH/\u001a:QCJ$\u0018\u000e^5p]\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feR!!1\u0013BM!\u0015I!QSAL\u0013\r\u00119J\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005\u001d&Q\u0012a\u0001\u0003?AqA!(\u0001\t\u0013\u0011I(A\u000esK\u001eL7\u000f^3s\t\u0016dW\r^3U_BL7\rT5ti\u0016tWM\u001d\u0005\b\u0005C\u0003A\u0011BAs\u0003u!WM]3hSN$XM\u001d#fY\u0016$X\rV8qS\u000ed\u0015n\u001d;f]\u0016\u0014\bb\u0002BS\u0001\u0011%!qU\u0001%O\u0016$H*Z1eKJL5O]!oI\u0016\u0003xn\u00195PeRC'o\\<Fq\u000e,\u0007\u000f^5p]R1!\u0011\u0016BX\u0005c\u00032A\u0006BV\u0013\r\u0011iK\u0001\u0002\u001c\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u0011\u0005\u001d&1\u0015a\u0001\u0003?AqA!\u000e\u0003$\u0002\u0007\u0011\u0006C\u0005\u00036\u0002\t\n\u0011\"\u0001\u00038\u0006a\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012\u001aTC\u0001B]U\u0011\u0011YBa/,\u0005\tu\u0006\u0003\u0002B`\u0005\u0013l!A!1\u000b\t\t\r'QY\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa2\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0017\u0014\tMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba4\u0001#\u0003%\tA!5\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u001b\u0016\u0005\u0005K\u0011Y\f")
public class PartitionStateMachine
implements Logging {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int kafka$controller$PartitionStateMachine$$controllerId;
    private final ZkClient kafka$controller$PartitionStateMachine$$zkClient;
    private final Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final TopicChangeListener topicChangeListener;
    private final DeleteTopicsListener deleteTopicsListener;
    private final Map<String, AddPartitionsListener> addPartitionsListener;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    public int kafka$controller$PartitionStateMachine$$controllerId() {
        return this.kafka$controller$PartitionStateMachine$$controllerId;
    }

    public ZkClient kafka$controller$PartitionStateMachine$$zkClient() {
        return this.kafka$controller$PartitionStateMachine$$zkClient;
    }

    public Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState() {
        return this.kafka$controller$PartitionStateMachine$$partitionState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private TopicChangeListener topicChangeListener() {
        return this.topicChangeListener;
    }

    private DeleteTopicsListener deleteTopicsListener() {
        return this.deleteTopicsListener;
    }

    private Map<String, AddPartitionsListener> addPartitionsListener() {
        return this.addPartitionsListener;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started partition state machine with initial state -> ").append((Object)this.$outer.kafka$controller$PartitionStateMachine$$partitionState().toString()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
        if (this.kafka$controller$PartitionStateMachine$$controller.config().deleteTopicEnable()) {
            this.registerDeleteTopicListener();
        }
    }

    public void deregisterListeners() {
        this.deregisterTopicChangeListener();
        this.addPartitionsListener().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final void apply(Tuple2<String, AddPartitionsListener> x0$1) {
                Tuple2<String, AddPartitionsListener> tuple2 = x0$1;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    AddPartitionsListener listener = (AddPartitionsListener)tuple2._2();
                    this.$outer.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), listener);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.addPartitionsListener().clear();
        if (this.kafka$controller$PartitionStateMachine$$controller.config().deleteTopicEnable()) {
            this.deregisterDeleteTopicListener();
        }
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.kafka$controller$PartitionStateMachine$$partitionState().clear();
        this.deregisterListeners();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped partition state machine";
            }
        });
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.kafka$controller$PartitionStateMachine$$partitionState().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> check$ifrefutable$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> x$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        boolean bl = !this.$outer.kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion(topicAndPartition.topic());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final void apply(Tuple2<TopicAndPartition, PartitionState> x$2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$2;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        PartitionState partitionState = (PartitionState)tuple2._2();
                        if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                            this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, this.$outer.kafka$controller$PartitionStateMachine$$controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while moving some partitions to the online state";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.kafka$controller$PartitionStateMachine$$partitionState().filter((Function1)new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final PartitionState state$1;

            public final boolean apply(Tuple2<TopicAndPartition, PartitionState> p) {
                Object object = p._2();
                PartitionState partitionState = this.state$1;
                return !(object != null ? !object.equals(partitionState) : partitionState != null);
            }
            {
                this.state$1 = state$1;
            }
        })).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        this.info((Function0<String>)new Serializable(this, partitions, targetState){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final PartitionState targetState$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.partitions$1.mkString(",")}));
            }
            {
                this.partitions$1 = partitions$1;
                this.targetState$1 = targetState$1;
            }
        });
        try {
            this.brokerRequestBatch().newBatch();
            partitions.foreach((Function1)new Serializable(this, targetState, leaderSelector, callbacks){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final PartitionState targetState$1;
                private final PartitionLeaderSelector leaderSelector$1;
                private final Callbacks callbacks$1;

                public final void apply(TopicAndPartition topicAndPartition) {
                    this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), this.targetState$1, this.leaderSelector$1, this.callbacks$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetState$1 = targetState$1;
                    this.leaderSelector$1 = leaderSelector$1;
                    this.callbacks$1 = callbacks$1;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void kafka$controller$PartitionStateMachine$$handleStateChange(String topic, int partition, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, targetState})));
        PartitionState currState = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NonExistentPartition$ apply() {
                return NonExistentPartition$.MODULE$;
            }
        });
        try {
            PartitionState partitionState = targetState;
            if (NewPartition$.MODULE$.equals(partitionState)) {
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                this.assignReplicasToPartitions(topic, partition);
                this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                String assignedReplicas = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState, assignedReplicas){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionStateMachine $outer;
                    private final PartitionState targetState$2;
                    private final TopicAndPartition topicAndPartition$1;
                    private final PartitionState currState$1;
                    private final String assignedReplicas$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s with assigned replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2, this.assignedReplicas$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$2 = targetState$2;
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.currState$1 = currState$1;
                        this.assignedReplicas$1 = assignedReplicas$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else if (OnlinePartition$.MODULE$.equals(partitionState)) {
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                PartitionState partitionState2 = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition);
                if (NewPartition$.MODULE$.equals(partitionState2)) {
                    this.initializeLeaderAndIsrForPartition(topicAndPartition);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (OfflinePartition$.MODULE$.equals(partitionState2)) {
                    this.electLeaderForPartition(topic, partition, leaderSelector);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (OnlinePartition$.MODULE$.equals(partitionState2)) {
                    this.electLeaderForPartition(topic, partition, leaderSelector);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                int leader = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState, leader){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionStateMachine $outer;
                    private final PartitionState targetState$2;
                    private final TopicAndPartition topicAndPartition$1;
                    private final PartitionState currState$1;
                    private final int leader$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to %s with leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2, BoxesRunTime.boxToInteger((int)this.leader$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$2 = targetState$2;
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.currState$1 = currState$1;
                        this.leader$1 = leader$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else if (OfflinePartition$.MODULE$.equals(partitionState)) {
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionStateMachine $outer;
                    private final PartitionState targetState$2;
                    private final TopicAndPartition topicAndPartition$1;
                    private final PartitionState currState$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$2 = targetState$2;
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.currState$1 = currState$1;
                    }
                });
                this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!NonExistentPartition$.MODULE$.equals(partitionState)) throw new MatchError((Object)partitionState);
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionStateMachine $outer;
                    private final PartitionState targetState$2;
                    private final TopicAndPartition topicAndPartition$1;
                    private final PartitionState currState$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$2 = targetState$2;
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.currState$1 = currState$1;
                    }
                });
                this.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, targetState, topicAndPartition, currState){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final PartitionState targetState$2;
                private final TopicAndPartition topicAndPartition$1;
                private final PartitionState currState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetState$2 = targetState$2;
                    this.topicAndPartition$1 = topicAndPartition$1;
                    this.currState$1 = currState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> check$ifrefutable$2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Option<PartitionState> apply(Tuple2<TopicAndPartition, Seq<Object>> x$3) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2;
                block2: {
                    Option option;
                    block8: {
                        Option option2;
                        block7: {
                            TopicAndPartition topicPartition;
                            block3: {
                                boolean bl;
                                block6: {
                                    Option option3;
                                    block5: {
                                        block4: {
                                            tuple2 = x$3;
                                            if (tuple2 == null) break block2;
                                            topicPartition = (TopicAndPartition)tuple2._1();
                                            option = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicPartition);
                                            if (!(option instanceof Some)) break block3;
                                            Some some = (Some)option;
                                            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            bl = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderIsrAndEpoch.leaderAndIsr().leader()));
                                            if (!bl) break block4;
                                            option3 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)OnlinePartition$.MODULE$);
                                            break block5;
                                        }
                                        if (bl) break block6;
                                        option3 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)OfflinePartition$.MODULE$);
                                    }
                                    option2 = option3;
                                    break block7;
                                }
                                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            }
                            if (!None$.MODULE$.equals(option)) break block8;
                            option2 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put((Object)topicPartition, (Object)NewPartition$.MODULE$);
                        }
                        Option option4 = option2;
                        return option4;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> fromStates, PartitionState targetState) {
        if (fromStates.contains(this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, fromStates.mkString(","), targetState}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)topicAndPartition)}))).toString());
    }

    private void assignReplicasToPartitions(String topic, int partition) {
        Seq<Object> assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), topic, partition);
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic, partition)), assignedReplicas));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        Seq replicaAssignment = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
        Seq liveAssignedReplicas = (Seq)replicaAssignment.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final boolean apply(int r) {
                return this.apply$mcZI$sp(r);
            }

            public boolean apply$mcZI$sp(int r) {
                return this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)r));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int n = liveAssignedReplicas.size();
        switch (n) {
            default: {
                this.debug((Function0<String>)new Serializable(this, topicAndPartition, liveAssignedReplicas){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$2;
                    private final Seq liveAssignedReplicas$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Live assigned replicas for partition %s are: [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2, this.liveAssignedReplicas$1}));
                    }
                    {
                        this.topicAndPartition$2 = topicAndPartition$2;
                        this.liveAssignedReplicas$1 = liveAssignedReplicas$1;
                    }
                });
                int leader = BoxesRunTime.unboxToInt((Object)liveAssignedReplicas.head());
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, (List<Object>)liveAssignedReplicas.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
                this.debug((Function0<String>)new Serializable(this, topicAndPartition, leaderIsrAndControllerEpoch){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$2;
                    private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Initializing leader and isr for partition %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2, this.leaderIsrAndControllerEpoch$1}));
                    }
                    {
                        this.topicAndPartition$2 = topicAndPartition$2;
                        this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch$1;
                    }
                });
                try {
                    ZkUtils$.MODULE$.createPersistentPath(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderIsrAndControllerEpoch.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()));
                    this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                    return;
                }
                catch (ZkNodeExistsException zkNodeExistsException) {
                    LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topicAndPartition.topic(), topicAndPartition.partition()).get();
                    String failMsg2 = new StringOps(Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndEpoch.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}));
                    this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PartitionStateMachine $outer;
                        private final String failMsg$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$2).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.failMsg$2 = failMsg$2;
                        }
                    });
                    throw new StateChangeFailedException(failMsg2);
                }
            }
            case 0: 
        }
        String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, replicaAssignment.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
        this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final String failMsg$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$1).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.failMsg$1 = failMsg$1;
            }
        });
        throw new StateChangeFailedException(failMsg);
    }

    /*
     * WARNING - void declaration
     */
    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final TopicAndPartition topicAndPartition$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), this.topicAndPartition$3}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        });
        try {
            Seq replicasForThisPartition;
            ObjectRef newLeaderAndIsr;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2;
                block7: {
                    Tuple2<Object, Object> tuple22;
                    boolean zookeeperPathUpdateSucceeded = false;
                    newLeaderAndIsr = ObjectRef.create(null);
                    replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
                    while (true) {
                        void var10_6;
                        Tuple2.mcZI.sp sp2;
                        Tuple2 tuple23;
                        if (zookeeperPathUpdateSucceeded) break block6;
                        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                        LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                        int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                        if (controllerEpoch > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String failMsg = new StringOps(Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ PartitionStateMachine $outer;
                                private final String failMsg$3;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$3).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.failMsg$3 = failMsg$3;
                                }
                            });
                            throw new StateChangeFailedException(failMsg);
                        }
                        tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                        if (tuple2 == null) break block7;
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)leaderAndIsr, (Object)replicas);
                        LeaderAndIsr leaderAndIsr2 = (LeaderAndIsr)tuple24._1();
                        Seq replicas2 = (Seq)tuple24._2();
                        tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.kafka$controller$PartitionStateMachine$$zkClient(), topic, partition, leaderAndIsr2, this.kafka$controller$PartitionStateMachine$$controller.epoch(), currentLeaderAndIsr.zkVersion());
                        if (tuple22 == null) break;
                        boolean updateSucceeded = tuple22._1$mcZ$sp();
                        int newVersion = tuple22._2$mcI$sp();
                        Tuple2.mcZI.sp sp3 = sp2 = new Tuple2.mcZI.sp(updateSucceeded, newVersion);
                        boolean updateSucceeded2 = sp3._1$mcZ$sp();
                        int newVersion2 = sp3._2$mcI$sp();
                        var10_6.elem = leaderAndIsr2;
                        ((LeaderAndIsr)var10_6.elem).zkVersion_$eq(newVersion2);
                        boolean bl = updateSucceeded2;
                        Seq seq = replicas2;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr.elem, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topicAndPartition, newLeaderAndIsr){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final TopicAndPartition topicAndPartition$3;
                private final ObjectRef newLeaderAndIsr$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)((LeaderAndIsr)this.newLeaderAndIsr$1.elem).leader()), this.topicAndPartition$3}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicAndPartition$3 = topicAndPartition$3;
                    this.newLeaderAndIsr$1 = newLeaderAndIsr$1;
                }
            });
            Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (Throwable throwable) {
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, throwable.getMessage()}));
            this.stateChangeLogger().error((Function0<String>)new Serializable(this, failMsg){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final String failMsg$4;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)this.failMsg$4).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.failMsg$4 = failMsg$4;
                }
            });
            throw new StateChangeFailedException(failMsg, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
            // empty catch block
        }
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("After leader election, leader cache is updated to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> l) {
                        return new Tuple2(l._1(), l._2());
                    }
                }, Map$.MODULE$.canBuildFrom())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private java.util.List<String> registerTopicChangeListener() {
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), this.topicChangeListener());
    }

    private void deregisterTopicChangeListener() {
        this.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), this.topicChangeListener());
    }

    public void registerPartitionChangeListener(String topic) {
        this.addPartitionsListener().put((Object)topic, (Object)new AddPartitionsListener(this, topic));
        this.kafka$controller$PartitionStateMachine$$zkClient().subscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply((Object)topic));
    }

    public Option<AddPartitionsListener> deregisterPartitionChangeListener(String topic) {
        this.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply((Object)topic));
        return this.addPartitionsListener().remove((Object)topic);
    }

    private java.util.List<String> registerDeleteTopicListener() {
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), this.deleteTopicsListener());
    }

    private void deregisterDeleteTopicListener() {
        this.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), this.deleteTopicsListener());
    }

    /*
     * WARNING - void declaration
     */
    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topic, partition);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
            return leaderIsrAndControllerEpoch;
        }
        if (None$.MODULE$.equals(option)) {
            void var3_3;
            String failMsg = new StringOps(Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3, this.kafka$controller$PartitionStateMachine$$partitionState().apply((Object)var3_3)}));
            throw new StateChangeFailedException(failMsg);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController controller) {
        this.kafka$controller$PartitionStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.kafka$controller$PartitionStateMachine$$controllerId = controller.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkClient = this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        this.kafka$controller$PartitionStateMachine$$partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.topicChangeListener = new TopicChangeListener();
        this.deleteTopicsListener = new DeleteTopicsListener();
        this.addPartitionsListener = Map$.MODULE$.empty();
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId())).append((Object)"]: ").toString());
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            TopicChangeListener topicChangeListener = this;
            synchronized (topicChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        @Override
        public void handleChildChange(String parentPath, java.util.List<String> children) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, parentPath, children){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicChangeListener $outer;
                public final String parentPath$1;
                public final java.util.List children$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$hasStarted().get()) {
                        try {
                            this.$outer.debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ TopicChangeListener$$anonfun$handleChildChange$1 $outer;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Topic change listener fired for path %s with children %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.$outer.children$1).mkString(",")}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            scala.collection.immutable.Set currentChildren = JavaConversions$.MODULE$.asScalaBuffer(this.children$1).toSet();
                            scala.collection.immutable.Set newTopics = (scala.collection.immutable.Set)currentChildren.$minus$minus(this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                            Set deletedTopics = (Set)this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().$minus$minus((GenTraversableOnce)currentChildren);
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics_$eq((Set<String>)currentChildren);
                            Map<TopicAndPartition, Seq<Object>> addedPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)newTopics.toSeq());
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment_$eq((Map<TopicAndPartition, Seq<Object>>)((Map)this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, deletedTopics){
                                public static final long serialVersionUID = 0L;
                                private final Set deletedTopics$1;

                                public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                                    return !this.deletedTopics$1.contains((Object)((TopicAndPartition)p._1()).topic());
                                }
                                {
                                    this.deletedTopics$1 = deletedTopics$1;
                                }
                            })));
                            this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq(addedPartitionReplicaAssignment);
                            this.$outer.info((Function0<String>)new Serializable(this, newTopics, deletedTopics, addedPartitionReplicaAssignment){
                                public static final long serialVersionUID = 0L;
                                private final scala.collection.immutable.Set newTopics$1;
                                private final Set deletedTopics$1;
                                private final Map addedPartitionReplicaAssignment$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("New topics: [%s], deleted topics: [%s], new partition replica assignment [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopics$1, this.deletedTopics$1, this.addedPartitionReplicaAssignment$1}));
                                }
                                {
                                    this.newTopics$1 = newTopics$1;
                                    this.deletedTopics$1 = deletedTopics$1;
                                    this.addedPartitionReplicaAssignment$1 = addedPartitionReplicaAssignment$1;
                                }
                            });
                            if (newTopics.size() > 0) {
                                this.$outer.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewTopicCreation((Set<String>)newTopics, (Set<TopicAndPartition>)addedPartitionReplicaAssignment.keySet().toSet());
                            }
                        }
                        catch (Throwable throwable) {
                            this.$outer.error((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Error while handling new topic";
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable){
                                public static final long serialVersionUID = 0L;
                                private final Throwable e$3;

                                public final Throwable apply() {
                                    return this.e$3;
                                }
                                {
                                    this.e$3 = e$3;
                                }
                            });
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parentPath$1 = parentPath$1;
                    this.children$1 = children$1;
                }
            });
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public TopicChangeListener() {
            if (PartitionStateMachine.this == null) {
                throw null;
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[TopicChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DeleteTopicsListener
    implements IZkChildListener,
    Logging {
        private final ZkClient zkClient;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            DeleteTopicsListener deleteTopicsListener = this;
            synchronized (deleteTopicsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public ZkClient zkClient() {
            return this.zkClient;
        }

        @Override
        public void handleChildChange(String parentPath, java.util.List<String> children) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, children){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeleteTopicsListener $outer;
                private final java.util.List children$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ObjectRef topicsToBeDeleted = ObjectRef.create((Object)JavaConversions$.MODULE$.asScalaBuffer(this.children$2).toSet());
                    this.$outer.debug((Function0<String>)new Serializable(this, topicsToBeDeleted){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef topicsToBeDeleted$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Delete topics listener fired for topics %s to be deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((scala.collection.immutable.Set)this.topicsToBeDeleted$1.elem).mkString(",")}));
                        }
                        {
                            this.topicsToBeDeleted$1 = topicsToBeDeleted$1;
                        }
                    });
                    scala.collection.immutable.Set nonExistentTopics = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                        public final boolean apply(String t) {
                            return !this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().contains((Object)t);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (nonExistentTopics.size() > 0) {
                        this.$outer.warn((Function0<String>)new Serializable(this, nonExistentTopics){
                            public static final long serialVersionUID = 0L;
                            private final scala.collection.immutable.Set nonExistentTopics$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Ignoring request to delete non-existing topics ").append((Object)this.nonExistentTopics$1.mkString(",")).toString();
                            }
                            {
                                this.nonExistentTopics$1 = nonExistentTopics$1;
                            }
                        });
                        nonExistentTopics.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                            public final void apply(String topic) {
                                ZkUtils$.MODULE$.deletePathRecursive(this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().zkClient(), ZkUtils$.MODULE$.getDeleteTopicPath(topic));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    topicsToBeDeleted.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicsToBeDeleted.elem).$minus$minus((GenTraversableOnce)nonExistentTopics);
                    if (((scala.collection.immutable.Set)topicsToBeDeleted.elem).size() > 0) {
                        this.$outer.info((Function0<String>)new Serializable(this, topicsToBeDeleted){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef topicsToBeDeleted$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Starting topic deletion for topics ").append((Object)((scala.collection.immutable.Set)this.topicsToBeDeleted$1.elem).mkString(",")).toString();
                            }
                            {
                                this.topicsToBeDeleted$1 = topicsToBeDeleted$1;
                            }
                        });
                        ((scala.collection.immutable.Set)topicsToBeDeleted.elem).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeleteTopicsListener$$anonfun$handleChildChange$2 $outer;

                            public final void apply(String topic) {
                                boolean preferredReplicaElectionInProgress = ((SetLike)this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsUndergoingPreferredReplicaElection().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(TopicAndPartition x$6) {
                                        return x$6.topic();
                                    }
                                }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                                boolean partitionReassignmentInProgress = ((SetLike)this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionsBeingReassigned().keySet().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(TopicAndPartition x$7) {
                                        return x$7.topic();
                                    }
                                }, Set$.MODULE$.canBuildFrom())).contains((Object)topic);
                                if (preferredReplicaElectionInProgress || partitionReassignmentInProgress) {
                                    this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().enqueueTopicsForDeletion((Set<String>)((scala.collection.immutable.Set)topicsToBeDeleted.elem));
                    }
                }

                public /* synthetic */ DeleteTopicsListener kafka$controller$PartitionStateMachine$DeleteTopicsListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.children$2 = children$2;
                }
            });
        }

        public void handleDataDeleted(String dataPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public DeleteTopicsListener() {
            if (PartitionStateMachine.this == null) {
                throw null;
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[DeleteTopicsListener on ").append((Object)BoxesRunTime.boxToInteger((int)PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
            this.zkClient = PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class AddPartitionsListener
    implements IZkDataListener,
    Logging {
        public final String kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic;
        public final /* synthetic */ PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            AddPartitionsListener addPartitionsListener = this;
            synchronized (addPartitionsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        @Override
        public void handleDataChange(String dataPath, Object data) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new Serializable(this, dataPath, data){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AddPartitionsListener $outer;
                public final String dataPath$1;
                public final Object data$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    try {
                        this.$outer.info((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ AddPartitionsListener$$anonfun$handleDataChange$1 $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Add Partition triggered ").append((Object)this.$outer.data$1.toString()).append((Object)" for path ").append((Object)this.$outer.dataPath$1).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        Map<TopicAndPartition, Seq<Object>> partitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic})));
                        Map partitionsToBeAdded = (Map)partitionReplicaAssignment.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ AddPartitionsListener$$anonfun$handleDataChange$1 $outer;

                            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                                return !this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().contains(p._1());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.deleteTopicManager().isTopicQueuedUpForDeletion(this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic)) {
                            this.$outer.error((Function0<String>)new Serializable(this, partitionsToBeAdded){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ AddPartitionsListener$$anonfun$handleDataChange$1 $outer;
                                private final Map partitionsToBeAdded$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Skipping adding partitions %s for topic %s since it is currently being deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.partitionsToBeAdded$1.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(Tuple2<TopicAndPartition, Seq<Object>> x$8) {
                                            return ((TopicAndPartition)x$8._1()).partition();
                                        }
                                    }, Iterable$.MODULE$.canBuildFrom())).mkString(","), this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$anonfun$$$outer().kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.partitionsToBeAdded$1 = partitionsToBeAdded$1;
                                }
                            });
                        } else if (partitionsToBeAdded.size() > 0) {
                            this.$outer.info((Function0<String>)new Serializable(this, partitionsToBeAdded){
                                public static final long serialVersionUID = 0L;
                                private final Map partitionsToBeAdded$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("New partitions to be added %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeAdded$1}));
                                }
                                {
                                    this.partitionsToBeAdded$1 = partitionsToBeAdded$1;
                                }
                            });
                            this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewPartitionCreation((Set<TopicAndPartition>)partitionsToBeAdded.keySet().toSet());
                        }
                    }
                    catch (Throwable throwable) {
                        this.$outer.error((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ AddPartitionsListener$$anonfun$handleDataChange$1 $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Error while handling add partitions for data path ").append((Object)this.$outer.dataPath$1).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$4;

                            public final Throwable apply() {
                                return this.e$4;
                            }
                            {
                                this.e$4 = e$4;
                            }
                        });
                    }
                }

                public /* synthetic */ AddPartitionsListener kafka$controller$PartitionStateMachine$AddPartitionsListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dataPath$1 = dataPath$1;
                    this.data$1 = data$1;
                }
            });
        }

        @Override
        public void handleDataDeleted(String parentPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer() {
            return this.$outer;
        }

        public AddPartitionsListener(PartitionStateMachine $outer, String topic) {
            this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic = topic;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[AddPartitionsListener on ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

