/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

class OptionValidator {
    OptionValidator() {
    }

    static void validateOption(String opt2) throws IllegalArgumentException {
        if (opt2 == null) {
            return;
        }
        if (opt2.length() == 1) {
            char ch = opt2.charAt(0);
            if (!OptionValidator.isValidOpt(ch)) {
                throw new IllegalArgumentException("illegal option value '" + ch + "'");
            }
        } else {
            char[] chars = opt2.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (OptionValidator.isValidChar(chars[i])) continue;
                throw new IllegalArgumentException("opt contains illegal character value '" + chars[i] + "'");
            }
        }
    }

    private static boolean isValidOpt(char c) {
        return OptionValidator.isValidChar(c) || c == ' ' || c == '?' || c == '@';
    }

    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }
}

