/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import java.nio.ByteBuffer;
import org.apache.spark.examples.streaming.KinesisWordCountProducerASL$;
import org.apache.spark.examples.streaming.KinesisWordCountProducerASL$$anonfun$generate$1$;
import org.apache.spark.examples.streaming.StreamingExamples$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class KinesisWordCountProducerASL$ {
    public static final KinesisWordCountProducerASL$ MODULE$;

    static {
        new KinesisWordCountProducerASL$();
    }

    public void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: KinesisWordCountProducerASL <stream-name> <endpoint-url> <records-per-sec> <words-per-record>");
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
            Tuple4 tuple4;
            String stream = (String)((SeqLike)option.get()).apply(0);
            String endpoint = (String)((SeqLike)option.get()).apply(1);
            String recordsPerSecond = (String)((SeqLike)option.get()).apply(2);
            String wordsPerRecord = (String)((SeqLike)option.get()).apply(3);
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)stream, (Object)endpoint, (Object)recordsPerSecond, (Object)wordsPerRecord);
            String stream2 = (String)tuple42._1();
            String endpoint2 = (String)tuple42._2();
            String recordsPerSecond2 = (String)tuple42._3();
            String wordsPerRecord2 = (String)tuple42._4();
            Seq<Tuple2<Object, Object>> totals = this.generate(stream2, endpoint2, new StringOps(Predef$.MODULE$.augmentString(recordsPerSecond2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(wordsPerRecord2)).toInt());
            Predef$.MODULE$.println((Object)"Totals");
            totals.foreach((Function1)new Serializable(){

                public final void apply(Tuple2<Object, Object> total) {
                    Predef$.MODULE$.println((Object)total.toString());
                }
            });
            return;
        }
        throw new MatchError((Object)stringArray);
    }

    public Seq<Tuple2<Object, Object>> generate(String stream, String endpoint, int recordsPerSecond, int wordsPerRecord) {
        int MaxRandomInts = 10;
        AmazonKinesisClient kinesisClient = new AmazonKinesisClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        kinesisClient.setEndpoint(endpoint);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Putting records onto stream ", " and endpoint ", " at a rate of"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stream, endpoint}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " records per second and ", " words per record"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)recordsPerSecond), BoxesRunTime.boxToInteger((int)wordsPerRecord)}))).toString());
        int[] totals = new int[MaxRandomInts];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)new Serializable(stream, recordsPerSecond, wordsPerRecord, MaxRandomInts, kinesisClient, totals){
            public final String stream$1;
            private final int recordsPerSecond$1;
            public final int wordsPerRecord$1;
            public final int MaxRandomInts$1;
            public final AmazonKinesisClient kinesisClient$1;
            public final int[] totals$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.recordsPerSecond$1).map((Function1)new Serializable(this){
                    private final /* synthetic */ anonfun.generate.1 $outer;

                    public final void apply(int recordNum) {
                        this.apply$mcVI$sp(recordNum);
                    }

                    public void apply$mcVI$sp(int recordNum) {
                        String data = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.$outer.wordsPerRecord$1).map((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun$generate$1$$anonfun$2 $outer;

                            public final String apply(int x) {
                                int randomInt = Random$.MODULE$.nextInt(this.$outer.org$apache$spark$examples$streaming$KinesisWordCountProducerASL$$anonfun$$anonfun$$$outer().MaxRandomInts$1);
                                this.$outer.org$apache$spark$examples$streaming$KinesisWordCountProducerASL$$anonfun$$anonfun$$$outer().totals$1[randomInt] = this.$outer.org$apache$spark$examples$streaming$KinesisWordCountProducerASL$$anonfun$$anonfun$$$outer().totals$1[randomInt] + 1;
                                return ((Object)BoxesRunTime.boxToInteger((int)randomInt)).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ");
                        String partitionKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionKey-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)recordNum)}));
                        PutRecordRequest putRecordRequest = new PutRecordRequest().withStreamName(this.$outer.stream$1).withPartitionKey(partitionKey).withData(ByteBuffer.wrap(data.getBytes()));
                        PutRecordResult putRecordResult = this.$outer.kinesisClient$1.putRecord(putRecordRequest);
                    }

                    public /* synthetic */ anonfun.generate.1 org$apache$spark$examples$streaming$KinesisWordCountProducerASL$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Thread.sleep(1000L);
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Sent ").append((Object)BoxesRunTime.boxToInteger((int)this.recordsPerSecond$1)).append((Object)" records").toString());
            }
            {
                this.stream$1 = stream$1;
                this.recordsPerSecond$1 = recordsPerSecond$1;
                this.wordsPerRecord$1 = wordsPerRecord$1;
                this.MaxRandomInts$1 = MaxRandomInts$1;
                this.kinesisClient$1 = kinesisClient$1;
                this.totals$1 = totals$1;
            }
        });
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), MaxRandomInts - 1).zip((GenIterable)Predef$.MODULE$.wrapIntArray(totals), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private KinesisWordCountProducerASL$() {
        MODULE$ = this;
    }
}

