/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.types.ShutdownReason;
import com.amazonaws.services.kinesis.model.Record;
import java.util.List;
import org.apache.spark.Logging;
import org.apache.spark.streaming.kinesis.KinesisCheckpointState;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c!B\u0001\u0003\u0001\ta!AF&j]\u0016\u001c\u0018n\u001d*fG>\u0014H\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005\r!\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u0016IA\u0011abE\u0007\u0002\u001f)\u0011\u0001#E\u0001\u0005Y\u0006twMC\u0001\u0013\u0003\u0011Q\u0017M^1\n\u0005Qy!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0017E5\tqC\u0003\u0002\u00193\u0005Q\u0011N\u001c;fe\u001a\f7-Z:\u000b\u0005iY\u0012!D2mS\u0016tG\u000f\\5ce\u0006\u0014\u0018P\u0003\u0002\u00049)\u0011QDH\u0001\tg\u0016\u0014h/[2fg*\u0011q\u0004I\u0001\nC6\f'p\u001c8boNT\u0011!I\u0001\u0004G>l\u0017BA\u0012\u0018\u0005AI%+Z2pe\u0012\u0004&o\\2fgN|'\u000f\u0005\u0002&M5\ta!\u0003\u0002(\r\t9Aj\\4hS:<\u0007\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0011I,7-Z5wKJ\u001c\u0001\u0001\u0005\u0002-[5\t!!\u0003\u0002/\u0005\ty1*\u001b8fg&\u001c(+Z2fSZ,'\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003!9xN]6fe&#\u0007C\u0001\u001a9\u001d\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]\"\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u001f\rDWmY6q_&tGo\u0015;bi\u0016\u0004\"\u0001\f \n\u0005}\u0012!AF&j]\u0016\u001c\u0018n]\"iK\u000e\\\u0007o\\5oiN#\u0018\r^3\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\u0011\u0019E)\u0012$\u0011\u00051\u0002\u0001\"B\u0015A\u0001\u0004Y\u0003\"\u0002\u0019A\u0001\u0004\t\u0004\"\u0002\u001fA\u0001\u0004i\u0004\"\u0003%\u0001\u0001\u0004\u0005\r\u0011\"\u0001J\u0003\u001d\u0019\b.\u0019:e\u0013\u0012,\u0012!\r\u0005\n\u0017\u0002\u0001\r\u00111A\u0005\u00021\u000b1b\u001d5be\u0012LEm\u0018\u0013fcR\u0011Q\n\u0015\t\u0003g9K!a\u0014\u001b\u0003\tUs\u0017\u000e\u001e\u0005\b#*\u000b\t\u00111\u00012\u0003\rAH%\r\u0005\u0007'\u0002\u0001\u000b\u0015B\u0019\u0002\u0011MD\u0017M\u001d3JI\u0002BQ!\u0016\u0001\u0005BY\u000b!\"\u001b8ji&\fG.\u001b>f)\tiu\u000bC\u0003I)\u0002\u0007\u0011\u0007C\u0003Z\u0001\u0011\u0005#,\u0001\bqe>\u001cWm]:SK\u000e|'\u000fZ:\u0015\u00075[\u0016\u000eC\u0003]1\u0002\u0007Q,A\u0003cCR\u001c\u0007\u000eE\u0002_C\u000el\u0011a\u0018\u0006\u0003AF\tA!\u001e;jY&\u0011!m\u0018\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002eO6\tQM\u0003\u0002g7\u0005)Qn\u001c3fY&\u0011\u0001.\u001a\u0002\u0007%\u0016\u001cwN\u001d3\t\u000b)D\u0006\u0019A6\u0002\u0019\rDWmY6q_&tG/\u001a:\u0011\u0005Ya\u0017BA7\u0018\u0005qI%+Z2pe\u0012\u0004&o\\2fgN|'o\u00115fG.\u0004x.\u001b8uKJDQa\u001c\u0001\u0005BA\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0004\u001bF\u0014\b\"\u00026o\u0001\u0004Y\u0007\"B:o\u0001\u0004!\u0018A\u0002:fCN|g\u000e\u0005\u0002vq6\taO\u0003\u0002x3\u0005)A/\u001f9fg&\u0011\u0011P\u001e\u0002\u000f'\",H\u000fZ8x]J+\u0017m]8o\u000f\u0019Y(\u0001#\u0001\u0003y\u000612*\u001b8fg&\u001c(+Z2pe\u0012\u0004&o\\2fgN|'\u000f\u0005\u0002-{\u001a1\u0011A\u0001E\u0001\u0005y\u001c2!`@%!\r\u0019\u0014\u0011A\u0005\u0004\u0003\u0007!$AB!osJ+g\r\u0003\u0004B{\u0012\u0005\u0011q\u0001\u000b\u0002y\"9\u00111B?\u0005\u0002\u00055\u0011a\u0003:fiJL(+\u00198e_6,B!a\u0004\u0002\u0016QA\u0011\u0011CA\u0014\u0003c\tY\u0004\u0005\u0003\u0002\u0014\u0005UA\u0002\u0001\u0003\t\u0003/\tIA1\u0001\u0002\u001a\t\tA+\u0005\u0003\u0002\u001c\u0005\u0005\u0002cA\u001a\u0002\u001e%\u0019\u0011q\u0004\u001b\u0003\u000f9{G\u000f[5oOB\u00191'a\t\n\u0007\u0005\u0015BGA\u0002B]fD\u0011\"!\u000b\u0002\n\u0011\u0005\r!a\u000b\u0002\u0015\u0015D\bO]3tg&|g\u000eE\u00034\u0003[\t\t\"C\u0002\u00020Q\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\t\u0003g\tI\u00011\u0001\u00026\u0005qa.^7SKR\u0014\u0018.Z:MK\u001a$\bcA\u001a\u00028%\u0019\u0011\u0011\b\u001b\u0003\u0007%sG\u000f\u0003\u0005\u0002>\u0005%\u0001\u0019AA\u001b\u0003Ai\u0017\r\u001f\"bG.|eMZ'jY2L7\u000f\u000b\u0003\u0002\n\u0005\u0005\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dC'\u0001\u0006b]:|G/\u0019;j_:LA!a\u0013\u0002F\t9A/Y5me\u0016\u001c\u0007")
public class KinesisRecordProcessor
implements IRecordProcessor,
Logging {
    public final KinesisReceiver org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$receiver;
    public final String org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId;
    public final KinesisCheckpointState org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState;
    private String shardId;
    private transient Logger org$apache$spark$Logging$$log_;

    public static <T> T retryRandom(Function0<T> function0, int n, int n2) {
        return KinesisRecordProcessor$.MODULE$.retryRandom(function0, n, n2);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String shardId() {
        return this.shardId;
    }

    public void shardId_$eq(String x$1) {
        this.shardId = x$1;
    }

    public void initialize(String shardId) {
        this.logInfo((Function0<String>)new Serializable(this, shardId){
            private final /* synthetic */ KinesisRecordProcessor $outer;
            private final String shardId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialize:  Initializing workerId ", " with shardId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId, this.shardId$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shardId$1 = shardId$1;
            }
        });
        this.shardId_$eq(shardId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processRecords(List<Record> batch, IRecordProcessorCheckpointer checkpointer) {
        if (this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$receiver.isStopped()) {
            this.logInfo((Function0<String>)new Serializable(this){
                private final /* synthetic */ KinesisRecordProcessor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped:  The Spark KinesisReceiver has stopped for workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" and shardId ", ".  No more records will be processed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.shardId()}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        try {
            JavaConversions$.MODULE$.asScalaBuffer(batch).foreach((Function1)new Serializable(this){
                private final /* synthetic */ KinesisRecordProcessor $outer;

                public final void apply(Record record) {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$receiver.store(record.getData().array());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.logDebug((Function0<String>)new Serializable(this, batch){
                private final /* synthetic */ KinesisRecordProcessor $outer;
                private final List batch$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stored:  Worker ", " stored ", " records for shardId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId, BoxesRunTime.boxToInteger((int)this.batch$1.size()), this.$outer.shardId()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batch$1 = batch$1;
                }
            });
            if (!this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState.shouldCheckpoint()) return;
            KinesisRecordProcessor$.MODULE$.retryRandom(new Serializable(this, checkpointer){
                private final IRecordProcessorCheckpointer checkpointer$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.checkpointer$1.checkpoint();
                }
                {
                    this.checkpointer$1 = checkpointer$1;
                }
            }, 4, 100);
            this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState.advanceCheckpoint();
            this.logDebug((Function0<String>)new Serializable(this, batch){
                private final /* synthetic */ KinesisRecordProcessor $outer;
                private final List batch$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint:  WorkerId ", " completed checkpoint of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId, BoxesRunTime.boxToInteger((int)this.batch$1.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" records for shardId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.shardId()}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batch$1 = batch$1;
                }
            });
            this.logDebug((Function0<String>)new Serializable(this){
                private final /* synthetic */ KinesisRecordProcessor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint:  Next checkpoint is at "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " for shardId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState.checkpointClock().currentTime()), this.$outer.shardId()}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)new Serializable(this){
                private final /* synthetic */ KinesisRecordProcessor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception:  WorkerId ", " encountered and exception while storing "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId}))).append((Object)" or checkpointing a batch for workerId $workerId and shardId $shardId.").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, throwable);
            throw throwable;
        }
    }

    public void shutdown(IRecordProcessorCheckpointer checkpointer, ShutdownReason reason) {
        this.logInfo((Function0<String>)new Serializable(this, reason){
            private final /* synthetic */ KinesisRecordProcessor $outer;
            private final ShutdownReason reason$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shutdown:  Shutting down workerId ", " with reason ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId, this.reason$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.reason$1 = reason$1;
            }
        });
        ShutdownReason shutdownReason = reason;
        if (ShutdownReason.TERMINATE.equals(shutdownReason)) {
            BoxedUnit boxedUnit = (BoxedUnit)KinesisRecordProcessor$.MODULE$.retryRandom(new Serializable(this, checkpointer){
                private final IRecordProcessorCheckpointer checkpointer$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.checkpointer$2.checkpoint();
                }
                {
                    this.checkpointer$2 = checkpointer$2;
                }
            }, 4, 100);
        } else if (ShutdownReason.ZOMBIE.equals(shutdownReason)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public KinesisRecordProcessor(KinesisReceiver receiver, String workerId, KinesisCheckpointState checkpointState) {
        this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$receiver = receiver;
        this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$workerId = workerId;
        this.org$apache$spark$streaming$kinesis$KinesisRecordProcessor$$checkpointState = checkpointState;
        Logging.class.$init$((Logging)this);
    }
}

