/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.KinesisUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class KinesisWordCountASL$
implements Logging {
    public static final KinesisWordCountASL$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new KinesisWordCountASL$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("\n          |Usage: KinesisWordCount <stream-name> <endpoint-url>\n          |    <stream-name> is the name of the Kinesis stream\n          |    <endpoint-url> is the endpoint of the Kinesis service\n          |                   (e.g. https://kinesis.us-east-1.amazonaws.com)\n        ")).stripMargin());
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            int numShards;
            Tuple2 tuple2;
            String streamName = (String)((SeqLike)option.get()).apply(0);
            String endpointUrl = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)streamName, (Object)endpointUrl);
            String streamName2 = (String)tuple22._1();
            String endpointUrl2 = (String)tuple22._2();
            AmazonKinesisClient kinesisClient = new AmazonKinesisClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
            kinesisClient.setEndpoint(endpointUrl2);
            int numStreams = numShards = kinesisClient.describeStream(streamName2).getStreamDescription().getShards().size();
            Duration batchInterval = Milliseconds$.MODULE$.apply(2000L);
            SparkConf sparkConfig = new SparkConf().setAppName("KinesisWordCount");
            StreamingContext ssc = new StreamingContext(sparkConfig, batchInterval);
            Duration kinesisCheckpointInterval = batchInterval;
            IndexedSeq kinesisStreams = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numStreams).map((Function1)new Serializable(streamName2, endpointUrl2, ssc, kinesisCheckpointInterval){
                private final String streamName$1;
                private final String endpointUrl$1;
                private final StreamingContext ssc$1;
                private final Duration kinesisCheckpointInterval$1;

                public final ReceiverInputDStream<byte[]> apply(int i) {
                    return KinesisUtils$.MODULE$.createStream(this.ssc$1, this.streamName$1, this.endpointUrl$1, this.kinesisCheckpointInterval$1, InitialPositionInStream.LATEST, StorageLevel$.MODULE$.MEMORY_AND_DISK_2());
                }
                {
                    this.streamName$1 = streamName$1;
                    this.endpointUrl$1 = endpointUrl$1;
                    this.ssc$1 = ssc$1;
                    this.kinesisCheckpointInterval$1 = kinesisCheckpointInterval$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            DStream unionStreams = ssc.union((Seq)kinesisStreams, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            DStream words = unionStreams.flatMap((Function1)new Serializable(){

                public final WrappedArray<String> apply(byte[] byteArray) {
                    return Predef$.MODULE$.wrapRefArray((Object[])new String(byteArray).split(" "));
                }
            }, ClassTag$.MODULE$.apply(String.class));
            DStream wordCounts = DStream$.MODULE$.toPairDStreamFunctions(words.map((Function1)new Serializable(){

                public final Tuple2<String, Object> apply(String word) {
                    return new Tuple2((Object)word, (Object)BoxesRunTime.boxToInteger((int)1));
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(){

                public final int apply(int x$2, int x$3) {
                    return this.apply$mcIII$sp(x$2, x$3);
                }

                public int apply$mcIII$sp(int x$2, int x$3) {
                    return x$2 + x$3;
                }
            });
            wordCounts.print();
            ssc.start();
            ssc.awaitTermination();
            return;
        }
        throw new MatchError((Object)stringArray);
    }

    private KinesisWordCountASL$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

