/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import java.util.UUID;
import org.apache.spark.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.kinesis.KinesisCheckpointState;
import org.apache.spark.streaming.kinesis.KinesisCheckpointState$;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor;
import org.apache.spark.streaming.kinesis.SerializableAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ub!B\u0001\u0003\u0001\ta!aD&j]\u0016\u001c\u0018n\u001d*fG\u0016Lg/\u001a:\u000b\u0005\r!\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u001d!\rq\u0011cE\u0007\u0002\u001f)\u0011\u0001\u0003B\u0001\te\u0016\u001cW-\u001b<fe&\u0011!c\u0004\u0002\t%\u0016\u001cW-\u001b<feB\u0019AcF\r\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011Q!\u0011:sCf\u0004\"\u0001\u0006\u000e\n\u0005m)\"\u0001\u0002\"zi\u0016\u0004\"!\b\u0010\u000e\u0003\u0019I!a\b\u0004\u0003\u000f1{wmZ5oO\"A\u0011\u0005\u0001B\u0001B\u0003%1%A\u0004baBt\u0015-\\3\u0004\u0001A\u0011Ae\n\b\u0003)\u0015J!AJ\u000b\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003MUA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IaI\u0001\u000bgR\u0014X-Y7OC6,\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u0017\u0015tG\r]8j]R,&\u000f\u001c\u0005\t_\u0001\u0011\t\u0011)A\u0005G\u0005Q!/Z4j_:t\u0015-\\3\t\u0011E\u0002!\u0011!Q\u0001\nI\nq#\u001b8ji&\fG\u000eU8tSRLwN\\%o'R\u0014X-Y7\u0011\u0005M\nU\"\u0001\u001b\u000b\u0005U2\u0014AB<pe.,'O\u0003\u00028q\u0005\u0019A.\u001b2\u000b\u0005eR\u0014!D2mS\u0016tG\u000f\\5ce\u0006\u0014\u0018P\u0003\u0002\u0004w)\u0011A(P\u0001\tg\u0016\u0014h/[2fg*\u0011ahP\u0001\nC6\f'p\u001c8boNT\u0011\u0001Q\u0001\u0004G>l\u0017B\u0001\"5\u0005]Ie.\u001b;jC2\u0004vn]5uS>t\u0017J\\*ue\u0016\fW\u000e\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0003I\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197\u0011\u0005\u0019;U\"\u0001\u0003\n\u0005!#!\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u0013)\u0003!\u0011!Q\u0001\n-\u000b\u0016\u0001D:u_J\fw-\u001a'fm\u0016d\u0007C\u0001'P\u001b\u0005i%B\u0001(\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001U'\u0003\u0019M#xN]1hK2+g/\u001a7\n\u0005)\u000b\u0002\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\u0002)\u0005<8o\u0011:fI\u0016tG/[1mg>\u0003H/[8o!\r!RkV\u0005\u0003-V\u0011aa\u00149uS>t\u0007C\u0001-Z\u001b\u0005\u0011\u0011B\u0001.\u0003\u0005i\u0019VM]5bY&T\u0018M\u00197f\u0003^\u001b6I]3eK:$\u0018.\u00197t\u0011\u0015a\u0006\u0001\"\u0001^\u0003\u0019a\u0014N\\5u}QIal\u00181bE\u000e$WM\u001a\t\u00031\u0002AQ!I.A\u0002\rBQaK.A\u0002\rBQ!L.A\u0002\rBQaL.A\u0002\rBQ!M.A\u0002IBQ\u0001R.A\u0002\u0015CQAS.A\u0002-CQaU.A\u0002QCq\u0001\u001b\u0001A\u0002\u0013%\u0011.\u0001\u0005x_J\\WM]%e+\u0005\u0019\u0003bB6\u0001\u0001\u0004%I\u0001\\\u0001\ro>\u00148.\u001a:JI~#S-\u001d\u000b\u0003[B\u0004\"\u0001\u00068\n\u0005=,\"\u0001B+oSRDq!\u001d6\u0002\u0002\u0003\u00071%A\u0002yIEBaa\u001d\u0001!B\u0013\u0019\u0013!C<pe.,'/\u00133!\u0011\u001d)\u0004\u00011A\u0005\nU,\u0012A\u001e\t\u0003g]L!\u0001\u001f\u001b\u0003\r]{'o[3s\u0011\u001dQ\b\u00011A\u0005\nm\f!b^8sW\u0016\u0014x\fJ3r)\tiG\u0010C\u0004rs\u0006\u0005\t\u0019\u0001<\t\ry\u0004\u0001\u0015)\u0003w\u0003\u001d9xN]6fe\u0002B\u0011\"!\u0001\u0001\u0001\u0004%I!a\u0001\u0002\u0019]|'o[3s)\"\u0014X-\u00193\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0010\u0005!!.\u0019<b\u0013\u0011\t\u0019\"!\u0003\u0003\rQC'/Z1e\u0011%\t9\u0002\u0001a\u0001\n\u0013\tI\"\u0001\tx_J\\WM\u001d+ie\u0016\fGm\u0018\u0013fcR\u0019Q.a\u0007\t\u0013E\f)\"!AA\u0002\u0005\u0015\u0001\u0002CA\u0010\u0001\u0001\u0006K!!\u0002\u0002\u001b]|'o[3s)\"\u0014X-\u00193!\u0011\u001d\t\u0019\u0003\u0001C!\u0003K\tqa\u001c8Ti\u0006\u0014H\u000fF\u0001n\u0011\u001d\tI\u0003\u0001C!\u0003K\taa\u001c8Ti>\u0004\bbBA\u0017\u0001\u0011%\u0011qF\u0001\u001ee\u0016\u001cx\u000e\u001c<f\u0003^\u001b6I]3eK:$\u0018.\u00197t!J|g/\u001b3feR\u0011\u0011\u0011\u0007\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011qG\u001f\u0002\t\u0005,H\u000f[\u0005\u0005\u0003w\t)D\u0001\fB/N\u001b%/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s\u0001")
public class KinesisReceiver
extends Receiver<byte[]>
implements Logging {
    private final String appName;
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final InitialPositionInStream initialPositionInStream;
    public final Duration org$apache$spark$streaming$kinesis$KinesisReceiver$$checkpointInterval;
    private final Option<SerializableAWSCredentials> awsCredentialsOption;
    private String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    private Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    private Thread workerThread;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = x$1;
    }

    public Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(Worker x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = x$1;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    public void onStart() {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(new StringBuilder().append((Object)Utils$.MODULE$.localHostName()).append((Object)":").append((Object)UUID.randomUUID()).toString());
        AWSCredentialsProvider awsCredProvider = this.resolveAWSCredentialsProvider();
        KinesisClientLibConfiguration kinesisClientLibConfiguration = new KinesisClientLibConfiguration(this.appName, this.streamName, awsCredProvider, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).withKinesisEndpoint(this.endpointUrl).withInitialPositionInStream(this.initialPositionInStream).withTaskBackoffTimeMillis(500L).withRegionName(this.regionName);
        IRecordProcessorFactory recordProcessorFactory = new IRecordProcessorFactory(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public IRecordProcessor createProcessor() {
                return new KinesisRecordProcessor(this.$outer, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId(), new KinesisCheckpointState(this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$checkpointInterval, KinesisCheckpointState$.MODULE$.$lessinit$greater$default$2()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(new Worker(recordProcessorFactory, kinesisClientLibConfiguration));
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().run();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.restart("Error running the KCL worker in Receiver", e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.workerThread().setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kinesis Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId())})));
        this.workerThread().setDaemon(true);
        this.workerThread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisReceiver $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started receiver with workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void onStop() {
        if (this.workerThread() != null) {
            if (this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() != null) {
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().shutdown();
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(null);
            }
            this.workerThread().join();
            this.workerThread_$eq(null);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisReceiver $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped receiver for workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(null);
    }

    private AWSCredentialsProvider resolveAWSCredentialsProvider() {
        Option<SerializableAWSCredentials> option;
        block4: {
            Object object;
            block3: {
                block2: {
                    option = this.awsCredentialsOption;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    SerializableAWSCredentials awsCredentials = (SerializableAWSCredentials)some.x();
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Using provided AWS credentials";
                        }
                    });
                    object = new AWSCredentialsProvider(this, awsCredentials){
                        private final SerializableAWSCredentials awsCredentials$1;

                        public AWSCredentials getCredentials() {
                            return this.awsCredentials$1;
                        }

                        public void refresh() {
                        }
                        {
                            this.awsCredentials$1 = awsCredentials$1;
                        }
                    };
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Using DefaultAWSCredentialsProviderChain";
                    }
                });
                object = new DefaultAWSCredentialsProviderChain();
            }
            return object;
        }
        throw new MatchError(option);
    }

    public KinesisReceiver(String appName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, Option<SerializableAWSCredentials> awsCredentialsOption) {
        this.appName = appName;
        this.streamName = streamName;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPositionInStream = initialPositionInStream;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$checkpointInterval = checkpointInterval;
        this.awsCredentialsOption = awsCredentialsOption;
        super(storageLevel);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = null;
        this.workerThread = null;
    }
}

