/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ShutdownException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import org.apache.spark.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KinesisRecordProcessor$
implements Logging {
    public static final KinesisRecordProcessor$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new KinesisRecordProcessor$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public <T> T retryRandom(Function0<T> expression, int numRetriesLeft, int maxBackOffMillis) {
        Try try_;
        block4: {
            Throwable throwable;
            Throwable e;
            while (true) {
                if ((try_ = Try$.MODULE$.apply(expression)) instanceof Success) {
                    Object x;
                    Success success = (Success)try_;
                    Object object = x = success.value();
                    return (T)object;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                e = failure.exception();
                throwable = e;
                boolean bl = throwable instanceof ThrottlingException ? true : throwable instanceof KinesisClientLibDependencyException;
                if (!bl || numRetriesLeft <= 1) break;
                int backOffMillis = Random$.MODULE$.nextInt(maxBackOffMillis);
                Thread.sleep(backOffMillis);
                this.logError((Function0<String>)new Serializable(backOffMillis){
                    public static final long serialVersionUID = 0L;
                    private final int backOffMillis$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retryable Exception:  Random backOffMillis=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.backOffMillis$1)}));
                    }
                    {
                        this.backOffMillis$1 = backOffMillis$1;
                    }
                }, e);
                --numRetriesLeft;
            }
            if (throwable instanceof ShutdownException) {
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ShutdownException:  Caught shutdown exception, skipping checkpoint."})).s((Seq)Nil$.MODULE$);
                    }
                }, e);
                throw e;
            }
            if (throwable instanceof InvalidStateException) {
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"InvalidStateException:  Cannot save checkpoint to the DynamoDB table used"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" by the Amazon Kinesis Client Library.  Table likely doesn't exist."})).s((Seq)Nil$.MODULE$)).toString();
                    }
                }, e);
                throw e;
            }
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected, non-retryable exception."})).s((Seq)Nil$.MODULE$);
                }
            }, e);
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    private KinesisRecordProcessor$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

