/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.SerializableAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class KinesisUtils$ {
    public static final KinesisUtils$ MODULE$;

    static {
        new KinesisUtils$();
    }

    public ReceiverInputDStream<byte[]> createStream(StreamingContext ssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel) {
        return (ReceiverInputDStream)ssc.withNamedScope("kinesis stream", (Function0)new Serializable(ssc, kinesisAppName, streamName, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$1;
            private final String kinesisAppName$1;
            private final String streamName$1;
            private final String endpointUrl$1;
            private final String regionName$1;
            private final InitialPositionInStream initialPositionInStream$1;
            private final Duration checkpointInterval$1;
            private final StorageLevel storageLevel$1;

            public final ReceiverInputDStream<byte[]> apply() {
                return this.ssc$1.receiverStream((Receiver)new KinesisReceiver(this.kinesisAppName$1, this.streamName$1, this.endpointUrl$1, KinesisUtils$.MODULE$.org$apache$spark$streaming$kinesis$KinesisUtils$$validateRegion(this.regionName$1), this.initialPositionInStream$1, this.checkpointInterval$1, this.storageLevel$1, (Option<SerializableAWSCredentials>)None$.MODULE$), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            }
            {
                this.ssc$1 = ssc$1;
                this.kinesisAppName$1 = kinesisAppName$1;
                this.streamName$1 = streamName$1;
                this.endpointUrl$1 = endpointUrl$1;
                this.regionName$1 = regionName$1;
                this.initialPositionInStream$1 = initialPositionInStream$1;
                this.checkpointInterval$1 = checkpointInterval$1;
                this.storageLevel$1 = storageLevel$1;
            }
        });
    }

    public ReceiverInputDStream<byte[]> createStream(StreamingContext ssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey) {
        return ssc.receiverStream((Receiver)new KinesisReceiver(kinesisAppName, streamName, endpointUrl, this.org$apache$spark$streaming$kinesis$KinesisUtils$$validateRegion(regionName), initialPositionInStream, checkpointInterval, storageLevel, (Option<SerializableAWSCredentials>)new Some((Object)new SerializableAWSCredentials(awsAccessKeyId, awsSecretKey))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public ReceiverInputDStream<byte[]> createStream(StreamingContext ssc, String streamName, String endpointUrl, Duration checkpointInterval, InitialPositionInStream initialPositionInStream, StorageLevel storageLevel) {
        return ssc.receiverStream((Receiver)new KinesisReceiver(ssc.sc().appName(), streamName, endpointUrl, this.getRegionByEndpoint(endpointUrl), initialPositionInStream, checkpointInterval, storageLevel, (Option<SerializableAWSCredentials>)None$.MODULE$), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), kinesisAppName, streamName, endpointUrl, regionName, initialPositionInStream, checkpointInterval, storageLevel, awsAccessKeyId, awsSecretKey), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String streamName, String endpointUrl, Duration checkpointInterval, InitialPositionInStream initialPositionInStream, StorageLevel storageLevel) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), streamName, endpointUrl, checkpointInterval, initialPositionInStream, storageLevel), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private String getRegionByEndpoint(String endpointUrl) {
        return RegionUtils.getRegionByEndpoint((String)endpointUrl).getName();
    }

    public String org$apache$spark$streaming$kinesis$KinesisUtils$$validateRegion(String regionName) {
        return (String)Option$.MODULE$.apply((Object)RegionUtils.getRegion((String)regionName)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Region x$1) {
                return x$1.getName();
            }
        }).getOrElse((Function0)new Serializable(regionName){
            public static final long serialVersionUID = 0L;
            private final String regionName$2;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Region name '", "' is not valid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.regionName$2})));
            }
            {
                this.regionName$2 = regionName$2;
            }
        });
    }

    private KinesisUtils$() {
        MODULE$ = this;
    }
}

