/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SerializableAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005=b!B\u0001\u0003\u0001\ta!aE&j]\u0016\u001c\u0018n]%oaV$Hi\u0015;sK\u0006l'BA\u0002\u0005\u0003\u001dY\u0017N\\3tSNT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001c\u0001\b\u0012'5\tqB\u0003\u0002\u0011\t\u00059Am\u001d;sK\u0006l\u0017B\u0001\n\u0010\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0019AcF\r\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011Q!\u0011:sCf\u0004\"\u0001\u0006\u000e\n\u0005m)\"\u0001\u0002\"zi\u0016D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0005?N\u001c8m\u0001\u0001\u0011\u0005\u0001\nS\"\u0001\u0003\n\u0005\t\"!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=uQ\taB\u0005\u0005\u0002\u0015K%\u0011a%\u0006\u0002\niJ\fgn]5f]RD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\u000bgR\u0014X-Y7OC6,\u0007C\u0001\u0016.\u001d\t!2&\u0003\u0002-+\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\rM#(/\u001b8h\u0015\taS\u0003\u0003\u00052\u0001\t\u0005\t\u0015!\u0003*\u0003-)g\u000e\u001a9pS:$XK\u001d7\t\u0011M\u0002!\u0011!Q\u0001\n%\n!B]3hS>tg*Y7f\u0011!)\u0004A!A!\u0002\u00131\u0014aF5oSRL\u0017\r\u001c)pg&$\u0018n\u001c8J]N#(/Z1n!\t9T)D\u00019\u0015\tI$(\u0001\u0004x_J\\WM\u001d\u0006\u0003wq\n1\u0001\\5c\u0015\tid(A\u0007dY&,g\u000e\u001e7jEJ\f'/\u001f\u0006\u0003\u0007}R!\u0001Q!\u0002\u0011M,'O^5dKNT!AQ\"\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"\u0001#\u0002\u0007\r|W.\u0003\u0002Gq\t9\u0012J\\5uS\u0006d\u0007k\\:ji&|g.\u00138TiJ,\u0017-\u001c\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005S\u0005\t2\r[3dWB|\u0017N\u001c;BaBt\u0015-\\3\t\u0011)\u0003!\u0011!Q\u0001\n-\u000b!c\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bYB\u0011\u0001\u0005T\u0005\u0003\u001b\u0012\u0011\u0001\u0002R;sCRLwN\u001c\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\u0006a1\u000f^8sC\u001e,G*\u001a<fYB\u0011\u0011\u000bV\u0007\u0002%*\u00111KB\u0001\bgR|'/Y4f\u0013\t)&K\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000e\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0003Q\two]\"sK\u0012,g\u000e^5bYN|\u0005\u000f^5p]B\u0019A#W.\n\u0005i+\"AB(qi&|g\u000e\u0005\u0002];6\t!!\u0003\u0002_\u0005\tQ2+\u001a:jC2L'0\u00192mK\u0006;6k\u0011:fI\u0016tG/[1mg\")\u0001\r\u0001C\u0001C\u00061A(\u001b8jiz\"\"BY2eK\u001a<\u0007.\u001b6l!\ta\u0006\u0001C\u0003\u001e?\u0002\u0007q\u0004C\u0003)?\u0002\u0007\u0011\u0006C\u00032?\u0002\u0007\u0011\u0006C\u00034?\u0002\u0007\u0011\u0006C\u00036?\u0002\u0007a\u0007C\u0003I?\u0002\u0007\u0011\u0006C\u0003K?\u0002\u00071\nC\u0003P?\u0002\u0007\u0001\u000bC\u0003X?\u0002\u0007\u0001\f\u0003\u0004n\u0001\u0011\u0005CA\\\u0001\u000fGJ,\u0017\r^3CY>\u001c7N\u0015#E)\ryWO\u001f\t\u0004aN\u001cR\"A9\u000b\u0005I4\u0011a\u0001:eI&\u0011A/\u001d\u0002\u0004%\u0012#\u0005\"\u0002<m\u0001\u00049\u0018\u0001\u0002;j[\u0016\u0004\"\u0001\t=\n\u0005e$!\u0001\u0002+j[\u0016DQa\u001f7A\u0002q\f!B\u00197pG.LeNZ8t!\u0015i\u00181BA\t\u001d\rq\u0018q\u0001\b\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019AH\u0001\u0007yI|w\u000e\u001e \n\u0003YI1!!\u0003\u0016\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0004\u0002\u0010\t\u00191+Z9\u000b\u0007\u0005%Q\u0003\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\u0002B\u0001\ng\u000eDW\rZ;mKJLA!a\u0007\u0002\u0016\t\t\"+Z2fSZ,GM\u00117pG.LeNZ8\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u0005Yq-\u001a;SK\u000e,\u0017N^3s)\t\t\u0019\u0003E\u0003\u0002&\u0005-2#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0003\u0002\u0011I,7-Z5wKJLA!!\f\u0002(\tA!+Z2fSZ,'\u000f")
public class KinesisInputDStream
extends ReceiverInputDStream<byte[]> {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final InitialPositionInStream initialPositionInStream;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final StorageLevel storageLevel;
    private final Option<SerializableAWSCredentials> awsCredentialsOption;

    public RDD<byte[]> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        Object object;
        boolean allBlocksHaveRanges = ((IterableLike)blockInfos.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(ReceivedBlockInfo x$1) {
                return x$1.metadataOption();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Object> x$2) {
                return x$2.nonEmpty();
            }
        });
        if (allBlocksHaveRanges) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BlockId apply(ReceivedBlockInfo x$3) {
                    return x$3.blockId();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            SequenceNumberRanges[] seqNumRanges = (SequenceNumberRanges[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceNumberRanges apply(ReceivedBlockInfo x$4) {
                    return (SequenceNumberRanges)x$4.metadataOption().get();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ReceivedBlockInfo x$5) {
                    return x$5.isBlockIdValid();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
            this.logDebug((Function0)new Serializable(this, time, seqNumRanges){
                public static final long serialVersionUID = 0L;
                private final Time time$1;
                private final SequenceNumberRanges[] seqNumRanges$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating KinesisBackedBlockRDD for ", " with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.time$1, BoxesRunTime.boxToInteger((int)this.seqNumRanges$1.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"seq number ranges: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.seqNumRanges$1).mkString(", ")}))).toString();
                }
                {
                    this.time$1 = time$1;
                    this.seqNumRanges$1 = seqNumRanges$1;
                }
            });
            object = new KinesisBackedBlockRDD(this.context().sc(), this.regionName, this.endpointUrl, blockIds, seqNumRanges, isBlockIdValid, (int)this.ssc().graph().batchDuration().milliseconds(), this.awsCredentialsOption);
        } else {
            this.logWarning((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Kinesis sequence number information was not present with some block metadata, it may not be possible to recover from failures";
                }
            });
            object = super.createBlockRDD(time, blockInfos);
        }
        return object;
    }

    public Receiver<byte[]> getReceiver() {
        return new KinesisReceiver(this.streamName, this.endpointUrl, this.regionName, this.initialPositionInStream, this.checkpointAppName, this.checkpointInterval, this.storageLevel, this.awsCredentialsOption);
    }

    public KinesisInputDStream(StreamingContext _ssc, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Option<SerializableAWSCredentials> awsCredentialsOption) {
        this.streamName = streamName2;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPositionInStream = initialPositionInStream;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.storageLevel = storageLevel;
        this.awsCredentialsOption = awsCredentialsOption;
        super(_ssc, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }
}

