/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SerializableAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!B\u0001\u0003\u0001\ta!aE&j]\u0016\u001c\u0018n]%oaV$Hi\u0015;sK\u0006l'BA\u0002\u0005\u0003\u001dY\u0017N\\3tSNT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0016\u0005512C\u0001\u0001\u000f!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\bIN$(/Z1n\u0013\t\u0019\u0002C\u0001\u000bSK\u000e,\u0017N^3s\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0003+Ya\u0001\u0001B\u0003\u0018\u0001\t\u0007\u0011DA\u0001U\u0007\u0001\t\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001B0tg\u000e\u0004\"AJ\u0014\u000e\u0003\u0011I!\u0001\u000b\u0003\u0003!M#(/Z1nS:<7i\u001c8uKb$\bFA\u0012+!\tY2&\u0003\u0002-9\tIAO]1og&,g\u000e\u001e\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u0005Q1\u000f\u001e:fC6t\u0015-\\3\u0011\u0005A\u001adBA\u000e2\u0013\t\u0011D$\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a\u001d\u0011!9\u0004A!A!\u0002\u0013y\u0013aC3oIB|\u0017N\u001c;Ve2D\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IaL\u0001\u000be\u0016<\u0017n\u001c8OC6,\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002/%t\u0017\u000e^5bYB{7/\u001b;j_:Len\u0015;sK\u0006l\u0007CA\u001fL\u001b\u0005q$BA A\u0003\u00199xN]6fe*\u0011\u0011IQ\u0001\u0004Y&\u0014'BA\"E\u00035\u0019G.[3oi2L'M]1ss*\u00111!\u0012\u0006\u0003\r\u001e\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003\u0011&\u000b\u0011\"Y7bu>t\u0017m^:\u000b\u0003)\u000b1aY8n\u0013\taeHA\fJ]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[\"Aa\n\u0001B\u0001B\u0003%q&A\tdQ\u0016\u001c7\u000e]8j]R\f\u0005\u000f\u001d(b[\u0016D\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!U\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0005\u0002'%&\u00111\u000b\u0002\u0002\t\tV\u0014\u0018\r^5p]\"AQ\u000b\u0001B\u0001B\u0003%a+\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u0002X56\t\u0001L\u0003\u0002Z\r\u000591\u000f^8sC\u001e,\u0017BA.Y\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011!i\u0006A!A!\u0002\u0013q\u0016AD7fgN\fw-\u001a%b]\u0012dWM\u001d\t\u00057}\u000bG#\u0003\u0002a9\tIa)\u001e8di&|g.\r\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I\u0012\u000bQ!\\8eK2L!AZ2\u0003\rI+7m\u001c:e\u0011!A\u0007A!A!\u0002\u0013I\u0017\u0001F1xg\u000e\u0013X\rZ3oi&\fGn](qi&|g\u000eE\u0002\u001cU2L!a\u001b\u000f\u0003\r=\u0003H/[8o!\tig.D\u0001\u0003\u0013\ty'A\u0001\u000eTKJL\u0017\r\\5{C\ndW-Q,T\u0007J,G-\u001a8uS\u0006d7\u000f\u0003\u0005r\u0001\t\r\t\u0015a\u0003s\u0003))g/\u001b3f]\u000e,G%\r\t\u0004gZ$R\"\u0001;\u000b\u0005Ud\u0012a\u0002:fM2,7\r^\u0005\u0003oR\u0014\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006s\u0002!\tA_\u0001\u0007y%t\u0017\u000e\u001e \u0015'mtx0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0015\u0005ql\bcA7\u0001)!)\u0011\u000f\u001fa\u0002e\")A\u0005\u001fa\u0001K!)a\u0006\u001fa\u0001_!)q\u0007\u001fa\u0001_!)\u0011\b\u001fa\u0001_!)1\b\u001fa\u0001y!)a\n\u001fa\u0001_!)\u0001\u000b\u001fa\u0001#\")Q\u000b\u001fa\u0001-\")Q\f\u001fa\u0001=\")\u0001\u000e\u001fa\u0001S\"A\u00111\u0003\u0001\u0005B\u0011\t)\"\u0001\bde\u0016\fG/\u001a\"m_\u000e\\'\u000b\u0012#\u0015\r\u0005]\u00111EA\u0017!\u0015\tI\"a\b\u0015\u001b\t\tYBC\u0002\u0002\u001e\u0019\t1A\u001d3e\u0013\u0011\t\t#a\u0007\u0003\u0007I#E\t\u0003\u0005\u0002&\u0005E\u0001\u0019AA\u0014\u0003\u0011!\u0018.\\3\u0011\u0007\u0019\nI#C\u0002\u0002,\u0011\u0011A\u0001V5nK\"A\u0011qFA\t\u0001\u0004\t\t$\u0001\u0006cY>\u001c7.\u00138g_N\u0004b!a\r\u0002D\u0005%c\u0002BA\u001b\u0003\u007fqA!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wA\u0012A\u0002\u001fs_>$h(C\u0001\u001e\u0013\r\t\t\u0005H\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)%a\u0012\u0003\u0007M+\u0017OC\u0002\u0002Bq\u0001B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f\"\u0011!C:dQ\u0016$W\u000f\\3s\u0013\u0011\t\u0019&!\u0014\u0003#I+7-Z5wK\u0012\u0014En\\2l\u0013:4w\u000eC\u0004\u0002X\u0001!\t%!\u0017\u0002\u0017\u001d,GOU3dK&4XM\u001d\u000b\u0003\u00037\u0002R!!\u0018\u0002dQi!!a\u0018\u000b\u0007\u0005\u0005D!\u0001\u0005sK\u000e,\u0017N^3s\u0013\u0011\t)'a\u0018\u0003\u0011I+7-Z5wKJ\u0004")
public class KinesisInputDStream<T>
extends ReceiverInputDStream<T> {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final InitialPositionInStream initialPositionInStream;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final StorageLevel storageLevel;
    private final Function1<Record, T> messageHandler;
    private final Option<SerializableAWSCredentials> awsCredentialsOption;
    private final ClassTag<T> evidence$1;

    public RDD<T> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        Object object;
        boolean allBlocksHaveRanges = ((IterableLike)blockInfos.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(ReceivedBlockInfo x$1) {
                return x$1.metadataOption();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Object> x$2) {
                return x$2.nonEmpty();
            }
        });
        if (allBlocksHaveRanges) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BlockId apply(ReceivedBlockInfo x$3) {
                    return x$3.blockId();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            SequenceNumberRanges[] seqNumRanges = (SequenceNumberRanges[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceNumberRanges apply(ReceivedBlockInfo x$4) {
                    return (SequenceNumberRanges)x$4.metadataOption().get();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ReceivedBlockInfo x$5) {
                    return x$5.isBlockIdValid();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
            this.logDebug((Function0)new Serializable(this, time, seqNumRanges){
                public static final long serialVersionUID = 0L;
                private final Time time$1;
                private final SequenceNumberRanges[] seqNumRanges$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating KinesisBackedBlockRDD for ", " with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.time$1, BoxesRunTime.boxToInteger((int)this.seqNumRanges$1.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"seq number ranges: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.seqNumRanges$1).mkString(", ")}))).toString();
                }
                {
                    void var3_3;
                    this.time$1 = time$1;
                    this.seqNumRanges$1 = var3_3;
                }
            });
            object = new KinesisBackedBlockRDD<T>(this.context().sc(), this.regionName, this.endpointUrl, blockIds, seqNumRanges, isBlockIdValid, (int)this.ssc().graph().batchDuration().milliseconds(), this.messageHandler, this.awsCredentialsOption, this.evidence$1);
        } else {
            this.logWarning((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Kinesis sequence number information was not present with some block metadata, it may not be possible to recover from failures";
                }
            });
            object = super.createBlockRDD(time, blockInfos);
        }
        return object;
    }

    public Receiver<T> getReceiver() {
        return new KinesisReceiver<T>(this.streamName, this.endpointUrl, this.regionName, this.initialPositionInStream, this.checkpointAppName, this.checkpointInterval, this.storageLevel, this.messageHandler, this.awsCredentialsOption);
    }

    public KinesisInputDStream(StreamingContext _ssc, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, Option<SerializableAWSCredentials> awsCredentialsOption, ClassTag<T> evidence$1) {
        this.streamName = streamName2;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPositionInStream = initialPositionInStream;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.storageLevel = storageLevel;
        this.messageHandler = messageHandler;
        this.awsCredentialsOption = awsCredentialsOption;
        this.evidence$1 = evidence$1;
        super(_ssc, evidence$1);
    }
}

