/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.model.Record;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer;
import org.apache.spark.streaming.kinesis.KinesisCheckpointer$;
import org.apache.spark.streaming.kinesis.KinesisRecordProcessor;
import org.apache.spark.streaming.kinesis.SequenceNumberRange;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SerializableAWSCredentials;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015gAB\u0001\u0003\u0001\ta!OA\bLS:,7/[:SK\u000e,\u0017N^3s\u0015\t\u0019A!A\u0004lS:,7/[:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WCA\u0007\u0017'\r\u0001ab\t\t\u0004\u001fI!R\"\u0001\t\u000b\u0005E!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\n\u0005M\u0001\"\u0001\u0003*fG\u0016Lg/\u001a:\u0011\u0005U1B\u0002\u0001\u0003\u0006/\u0001\u0011\r!\u0007\u0002\u0002)\u000e\u0001\u0011C\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0011\n\u0005\tb\"aA!osB\u0011A%J\u0007\u0002\r%\u0011aE\u0002\u0002\b\u0019><w-\u001b8h\u0011!A\u0003A!b\u0001\n\u0003I\u0013AC:ue\u0016\fWNT1nKV\t!\u0006\u0005\u0002,]9\u00111\u0004L\u0005\u0003[q\ta\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q\u0006\b\u0005\te\u0001\u0011\t\u0011)A\u0005U\u0005Y1\u000f\u001e:fC6t\u0015-\\3!\u0011!!\u0004A!A!\u0002\u0013Q\u0013aC3oIB|\u0017N\u001c;Ve2D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IAK\u0001\u000be\u0016<\u0017n\u001c8OC6,\u0007\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002/%t\u0017\u000e^5bYB{7/\u001b;j_:Len\u0015;sK\u0006l\u0007C\u0001\u001eI\u001b\u0005Y$B\u0001\u001f>\u0003\u00199xN]6fe*\u0011ahP\u0001\u0004Y&\u0014'B\u0001!B\u00035\u0019G.[3oi2L'M]1ss*\u00111A\u0011\u0006\u0003\u0007\u0012\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003\u000b\u001a\u000b\u0011\"Y7bu>t\u0017m^:\u000b\u0003\u001d\u000b1aY8n\u0013\tI5HA\fJ]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[\"A1\n\u0001B\u0001B\u0003%!&A\tdQ\u0016\u001c7\u000e]8j]R\f\u0005\u000f\u001d(b[\u0016D\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IAT\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0005\u0002P!6\tA!\u0003\u0002R\t\tAA)\u001e:bi&|g\u000eC\u0005T\u0001\t\u0005\t\u0015!\u0003U5\u0006a1\u000f^8sC\u001e,G*\u001a<fYB\u0011Q\u000bW\u0007\u0002-*\u0011qKB\u0001\bgR|'/Y4f\u0013\tIfK\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G.\u0003\u0002T%!AA\f\u0001B\u0001B\u0003%Q,\u0001\bnKN\u001c\u0018mZ3IC:$G.\u001a:\u0011\tmq\u0006\rF\u0005\u0003?r\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r\f\u0015!B7pI\u0016d\u0017BA3c\u0005\u0019\u0011VmY8sI\"Aq\r\u0001B\u0001B\u0003%\u0001.\u0001\u000bboN\u001c%/\u001a3f]RL\u0017\r\\:PaRLwN\u001c\t\u00047%\\\u0017B\u00016\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011A.\\\u0007\u0002\u0005%\u0011aN\u0001\u0002\u001b'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z!X'\u000e\u0013X\rZ3oi&\fGn\u001d\u0005\u0006a\u0002!\t!]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015I\u001cH/\u001e<xqfT8\u0010E\u0002m\u0001QAQ\u0001K8A\u0002)BQ\u0001N8A\u0002)BQAN8A\u0002)BQ\u0001O8A\u0002eBQaS8A\u0002)BQ!T8A\u00029CQaU8A\u0002QCQ\u0001X8A\u0002uCQaZ8A\u0002!Dq! \u0001A\u0002\u0013%\u0011&\u0001\u0005x_J\\WM]%e\u0011!y\b\u00011A\u0005\n\u0005\u0005\u0011\u0001D<pe.,'/\u00133`I\u0015\fH\u0003BA\u0002\u0003\u0013\u00012aGA\u0003\u0013\r\t9\u0001\b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\fy\f\t\u00111\u0001+\u0003\rAH%\r\u0005\b\u0003\u001f\u0001\u0001\u0015)\u0003+\u0003%9xN]6fe&#\u0007\u0005\u000b\u0003\u0002\u000e\u0005M\u0001cA\u000e\u0002\u0016%\u0019\u0011q\u0003\u000f\u0003\u0011Y|G.\u0019;jY\u0016D\u0001\u0002\u0010\u0001A\u0002\u0013%\u00111D\u000b\u0003\u0003;\u00012AOA\u0010\u0013\r\t\tc\u000f\u0002\u0007/>\u00148.\u001a:\t\u0013\u0005\u0015\u0002\u00011A\u0005\n\u0005\u001d\u0012AC<pe.,'o\u0018\u0013fcR!\u00111AA\u0015\u0011)\tY!a\t\u0002\u0002\u0003\u0007\u0011Q\u0004\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002\u001e\u00059qo\u001c:lKJ\u0004\u0003\u0006BA\u0016\u0003'A\u0011\"a\r\u0001\u0001\u0004%I!!\u000e\u0002\u0019]|'o[3s)\"\u0014X-\u00193\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0005Y\u0006twM\u0003\u0002\u0002B\u0005!!.\u0019<b\u0013\u0011\t)%a\u000f\u0003\rQC'/Z1e\u0011%\tI\u0005\u0001a\u0001\n\u0013\tY%\u0001\tx_J\\WM\u001d+ie\u0016\fGm\u0018\u0013fcR!\u00111AA'\u0011)\tY!a\u0012\u0002\u0002\u0003\u0007\u0011q\u0007\u0005\t\u0003#\u0002\u0001\u0015)\u0003\u00028\u0005iqo\u001c:lKJ$\u0006N]3bI\u0002BC!a\u0014\u0002\u0014!I\u0011q\u000b\u0001A\u0002\u0013%\u0011\u0011L\u0001\u000fE2|7m[$f]\u0016\u0014\u0018\r^8s+\t\tY\u0006E\u0002\u0010\u0003;J1!a\u0018\u0011\u00059\u0011En\\2l\u000f\u0016tWM]1u_JD\u0011\"a\u0019\u0001\u0001\u0004%I!!\u001a\u0002%\tdwnY6HK:,'/\u0019;pe~#S-\u001d\u000b\u0005\u0003\u0007\t9\u0007\u0003\u0006\u0002\f\u0005\u0005\u0014\u0011!a\u0001\u00037B\u0001\"a\u001b\u0001A\u0003&\u00111L\u0001\u0010E2|7m[$f]\u0016\u0014\u0018\r^8sA!\"\u0011\u0011NA\n\u0011%\t\t\b\u0001b\u0001\n\u0013\t\u0019(\u0001\u000etKFtU/\u001c*b]\u001e,7/\u00138DkJ\u0014XM\u001c;CY>\u001c7.\u0006\u0002\u0002vA1\u0011qOAA\u0003\u000bk!!!\u001f\u000b\t\u0005m\u0014QP\u0001\b[V$\u0018M\u00197f\u0015\r\ty\bH\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAB\u0003s\u00121\"\u0011:sCf\u0014UO\u001a4feB\u0019A.a\"\n\u0007\u0005%%AA\nTKF,XM\\2f\u001dVl'-\u001a:SC:<W\r\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0011BA;\u0003m\u0019X-\u001d(v[J\u000bgnZ3t\u0013:\u001cUO\u001d:f]R\u0014En\\2lA!I\u0011\u0011\u0013\u0001C\u0002\u0013%\u00111S\u0001\u0016E2|7m[%e)>\u001cV-\u001d(v[J\u000bgnZ3t+\t\t)\n\u0005\u0005\u0002\u0018\u0006\u0005\u0016QUAV\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015AC2p]\u000e,(O]3oi*!\u0011qTA \u0003\u0011)H/\u001b7\n\t\u0005\r\u0016\u0011\u0014\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcA+\u0002(&\u0019\u0011\u0011\u0016,\u0003\u001bM#(/Z1n\u00052|7m[%e!\ra\u0017QV\u0005\u0004\u0003_\u0013!\u0001F*fcV,gnY3Ok6\u0014WM\u001d*b]\u001e,7\u000f\u0003\u0005\u00024\u0002\u0001\u000b\u0011BAK\u0003Y\u0011Gn\\2l\u0013\u0012$vnU3r\u001dVl'+\u00198hKN\u0004\u0003\"CA\\\u0001\u0001\u0007I\u0011BA]\u0003MY\u0017N\\3tSN\u001c\u0005.Z2la>Lg\u000e^3s+\t\tY\fE\u0002m\u0003{K1!a0\u0003\u0005MY\u0015N\\3tSN\u001c\u0005.Z2la>Lg\u000e^3s\u0011%\t\u0019\r\u0001a\u0001\n\u0013\t)-A\flS:,7/[:DQ\u0016\u001c7\u000e]8j]R,'o\u0018\u0013fcR!\u00111AAd\u0011)\tY!!1\u0002\u0002\u0003\u0007\u00111\u0018\u0005\t\u0003\u0017\u0004\u0001\u0015)\u0003\u0002<\u0006!2.\u001b8fg&\u001c8\t[3dWB|\u0017N\u001c;fe\u0002BC!!3\u0002\u0014!I\u0011\u0011\u001b\u0001C\u0002\u0013%\u00111[\u0001\u001cg\"\f'\u000fZ%e)>d\u0015\r^3tiN#xN]3e'\u0016\fh*^7\u0016\u0005\u0005U\u0007CBAL\u0003CS#\u0006\u0003\u0005\u0002Z\u0002\u0001\u000b\u0011BAk\u0003q\u0019\b.\u0019:e\u0013\u0012$v\u000eT1uKN$8\u000b^8sK\u0012\u001cV-\u001d(v[\u0002Bq!!8\u0001\t\u0003\ny.A\u0004p]N#\u0018M\u001d;\u0015\u0005\u0005\r\u0001bBAr\u0001\u0011\u0005\u0013q\\\u0001\u0007_:\u001cFo\u001c9\t\u0011\u0005\u001d\b\u0001\"\u0001\u0003\u0003S\f!\"\u00193e%\u0016\u001cwN\u001d3t)\u0019\t\u0019!a;\u0002p\"9\u0011Q^As\u0001\u0004Q\u0013aB:iCJ$\u0017\n\u001a\u0005\t\u0003c\f)\u000f1\u0001\u0002t\u00069!/Z2pe\u0012\u001c\b#BA{\u0003o\u0004WBAAO\u0013\u0011\tI0!(\u0003\t1K7\u000f\u001e\u0005\t\u0003{\u0004A\u0011\u0001\u0002\u0002\u0000\u0006Yr-\u001a;MCR,7\u000f^*fc:+X\u000eV8DQ\u0016\u001c7\u000e]8j]R$BA!\u0001\u0003\u0004A\u00191$\u001b\u0016\t\u000f\u00055\u00181 a\u0001U!9!q\u0001\u0001\u0005\u0002\t%\u0011aD:fi\u000eCWmY6q_&tG/\u001a:\u0015\r\u0005\r!1\u0002B\u0007\u0011\u001d\tiO!\u0002A\u0002)B\u0001Ba\u0004\u0003\u0006\u0001\u0007!\u0011C\u0001\rG\",7m\u001b9pS:$XM\u001d\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)\u0019!qC \u0002\u0015%tG/\u001a:gC\u000e,7/\u0003\u0003\u0003\u001c\tU!\u0001H%SK\u000e|'\u000f\u001a)s_\u000e,7o]8s\u0007\",7m\u001b9pS:$XM\u001d\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0003I\u0011X-\\8wK\u000eCWmY6q_&tG/\u001a:\u0015\r\u0005\r!1\u0005B\u0013\u0011\u001d\tiO!\bA\u0002)B\u0001Ba\u0004\u0003\u001e\u0001\u0007!\u0011\u0003\u0005\b\u0005S\u0001A\u0011\u0002B\u0016\u0003I\u0011X-\\3nE\u0016\u0014\u0018\t\u001a3fIJ\u000bgnZ3\u0015\t\u0005\r!Q\u0006\u0005\t\u0005_\u00119\u00031\u0001\u0002\u0006\u0006)!/\u00198hK\"9!1\u0007\u0001\u0005\n\tU\u0012!\b4j]\u0006d\u0017N_3SC:<Wm\u001d$pe\u000e+(O]3oi\ncwnY6\u0015\t\u0005\r!q\u0007\u0005\t\u0005s\u0011\t\u00041\u0001\u0002&\u00069!\r\\8dW&#\u0007b\u0002B\u001f\u0001\u0011%!qH\u0001\u0015gR|'/\u001a\"m_\u000e\\w+\u001b;i%\u0006tw-Z:\u0015\r\u0005\r!\u0011\tB\"\u0011!\u0011IDa\u000fA\u0002\u0005\u0015\u0006\u0002\u0003B#\u0005w\u0001\rAa\u0012\u0002\u0017\u0005\u0014(/Y=Ck\u001a4WM\u001d\t\u0006\u0003o\n\t\t\u0006\u0005\b\u0005\u0017\u0002A\u0011\u0002B'\u0003u\u0011Xm]8mm\u0016\fukU\"sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014HC\u0001B(!\u0011\u0011\tFa\u0016\u000e\u0005\tM#b\u0001B+\t\u0006!\u0011-\u001e;i\u0013\u0011\u0011IFa\u0015\u0003-\u0005;6k\u0011:fI\u0016tG/[1mgB\u0013xN^5eKJ4aA!\u0018\u0001\t\t}#!F$f]\u0016\u0014\u0018\r^3e\u00052|7m\u001b%b]\u0012dWM]\n\u0007\u00057\u0012\tGa\u001a\u0011\u0007m\u0011\u0019'C\u0002\u0003fq\u0011a!\u00118z%\u00164\u0007cA\b\u0003j%\u0019!1\u000e\t\u0003-\tcwnY6HK:,'/\u0019;pe2K7\u000f^3oKJDq\u0001\u001dB.\t\u0003\u0011y\u0007\u0006\u0002\u0003rA!!1\u000fB.\u001b\u0005\u0001\u0001\u0002\u0003B<\u00057\"\tA!\u001f\u0002\u0013=t\u0017\t\u001a3ECR\fGCBA\u0002\u0005w\u0012y\bC\u0004\u0003~\tU\u0004\u0019\u0001\u0011\u0002\t\u0011\fG/\u0019\u0005\b\u0005\u0003\u0013)\b1\u0001!\u0003!iW\r^1eCR\f\u0007\u0002\u0003BC\u00057\"\tAa\"\u0002\u001f=tw)\u001a8fe\u0006$XM\u00117pG.$B!a\u0001\u0003\n\"A!\u0011\bBB\u0001\u0004\t)\u000b\u0003\u0005\u0003\u000e\nmC\u0011\u0001BH\u0003-yg\u000eU;tQ\ncwnY6\u0015\r\u0005\r!\u0011\u0013BJ\u0011!\u0011IDa#A\u0002\u0005\u0015\u0006\u0002\u0003B#\u0005\u0017\u0003\rA!&1\t\t]%1\u0014\t\u0007\u0003o\n\tI!'\u0011\u0007U\u0011Y\nB\u0006\u0003\u001e\nM\u0015\u0011!A\u0001\u0006\u0003I\"aA0%c!A!\u0011\u0015B.\t\u0003\u0011\u0019+A\u0004p]\u0016\u0013(o\u001c:\u0015\r\u0005\r!Q\u0015BU\u0011\u001d\u00119Ka(A\u0002)\nq!\\3tg\u0006<W\r\u0003\u0005\u0003,\n}\u0005\u0019\u0001BW\u0003%!\bN]8xC\ndW\r\u0005\u0003\u00030\n}f\u0002\u0002BY\u0005wsAAa-\u0003:6\u0011!Q\u0017\u0006\u0004\u0005oC\u0012A\u0002\u001fs_>$h(C\u0001\u001e\u0013\r\u0011i\fH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tMa1\u0003\u0013QC'o\\<bE2,'b\u0001B_9\u0001")
public class KinesisReceiver<T>
extends Receiver<T>
implements Logging {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final InitialPositionInStream initialPositionInStream;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final Function1<Record, T> messageHandler;
    private final Option<SerializableAWSCredentials> awsCredentialsOption;
    private volatile String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    private volatile Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    private volatile Thread workerThread;
    private volatile BlockGenerator blockGenerator;
    private final ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock;
    private final ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges;
    private volatile KinesisCheckpointer kinesisCheckpointer;
    private final ConcurrentHashMap<String, String> org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String streamName() {
        return this.streamName;
    }

    public String org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(String x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = x$1;
    }

    public Worker org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker;
    }

    private void org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(Worker x$1) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = x$1;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    private void blockGenerator_$eq(BlockGenerator x$1) {
        this.blockGenerator = x$1;
    }

    private ArrayBuffer<SequenceNumberRange> seqNumRangesInCurrentBlock() {
        return this.seqNumRangesInCurrentBlock;
    }

    public ConcurrentHashMap<StreamBlockId, SequenceNumberRanges> org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges;
    }

    private KinesisCheckpointer kinesisCheckpointer() {
        return this.kinesisCheckpointer;
    }

    private void kinesisCheckpointer_$eq(KinesisCheckpointer x$1) {
        this.kinesisCheckpointer = x$1;
    }

    public ConcurrentHashMap<String, String> org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum() {
        return this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum;
    }

    public void onStart() {
        this.blockGenerator_$eq(this.supervisor().createBlockGenerator((BlockGeneratorListener)new GeneratedBlockHandler()));
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(new StringBuilder().append((Object)Utils$.MODULE$.localHostName()).append((Object)":").append((Object)UUID.randomUUID()).toString());
        this.kinesisCheckpointer_$eq(new KinesisCheckpointer(this, this.checkpointInterval, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId(), KinesisCheckpointer$.MODULE$.$lessinit$greater$default$4()));
        AWSCredentialsProvider awsCredProvider = this.resolveAWSCredentialsProvider();
        KinesisClientLibConfiguration kinesisClientLibConfiguration = new KinesisClientLibConfiguration(this.checkpointAppName, this.streamName(), awsCredProvider, this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()).withKinesisEndpoint(this.endpointUrl).withInitialPositionInStream(this.initialPositionInStream).withTaskBackoffTimeMillis(500L).withRegionName(this.regionName);
        IRecordProcessorFactory recordProcessorFactory = new IRecordProcessorFactory(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public IRecordProcessor createProcessor() {
                return new KinesisRecordProcessor<T>(this.$outer, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(new Worker(recordProcessorFactory, kinesisClientLibConfiguration));
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ KinesisReceiver $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().run();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.$outer.restart("Error running the KCL worker in Receiver", e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges().clear();
        this.blockGenerator().start();
        this.workerThread().setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kinesis Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId())})));
        this.workerThread().setDaemon(true);
        this.workerThread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisReceiver $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started receiver with workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void onStop() {
        if (this.workerThread() != null) {
            if (this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker() != null) {
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker().shutdown();
                this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker_$eq(null);
            }
            this.workerThread().join();
            this.workerThread_$eq(null);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KinesisReceiver $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped receiver for workerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId_$eq(null);
        if (this.kinesisCheckpointer() != null) {
            this.kinesisCheckpointer().shutdown();
            this.kinesisCheckpointer_$eq(null);
        }
    }

    public void addRecords(String shardId, List<Record> records) {
        if (records.size() > 0) {
            Iterator dataIterator = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(records.iterator()).asScala()).map(this.messageHandler);
            SequenceNumberRange metadata = new SequenceNumberRange(this.streamName(), shardId, records.get(0).getSequenceNumber(), records.get(records.size() - 1).getSequenceNumber());
            this.blockGenerator().addMultipleDataWithCallback(dataIterator, (Object)metadata);
        }
    }

    public Option<String> getLatestSeqNumToCheckpoint(String shardId) {
        return Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum().get(shardId));
    }

    public void setCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kinesis Checkpointer not initialized!";
            }
        });
        this.kinesisCheckpointer().setCheckpointer(shardId, checkpointer);
    }

    public void removeCheckpointer(String shardId, IRecordProcessorCheckpointer checkpointer) {
        Predef$.MODULE$.assert(this.kinesisCheckpointer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kinesis Checkpointer not initialized!";
            }
        });
        this.kinesisCheckpointer().removeCheckpointer(shardId, checkpointer);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange(SequenceNumberRange range) {
        this.seqNumRangesInCurrentBlock().$plus$eq((Object)range);
    }

    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(StreamBlockId blockId) {
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges().put(blockId, new SequenceNumberRanges((Seq<SequenceNumberRange>)Predef$.MODULE$.wrapRefArray((Object[])this.seqNumRangesInCurrentBlock().toArray(ClassTag$.MODULE$.apply(SequenceNumberRange.class)))));
        this.seqNumRangesInCurrentBlock().clear();
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KinesisReceiver $outer;
            private final StreamBlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated block ", " has ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, this.$outer.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
            }
        });
    }

    /*
     * Exception decompiling
     */
    public void org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(StreamBlockId blockId, ArrayBuffer<T> arrayBuffer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 179->192)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AWSCredentialsProvider resolveAWSCredentialsProvider() {
        Option<SerializableAWSCredentials> option;
        block4: {
            Object object;
            block3: {
                block2: {
                    option = this.awsCredentialsOption;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    SerializableAWSCredentials awsCredentials = (SerializableAWSCredentials)some.x();
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Using provided AWS credentials";
                        }
                    });
                    object = new AWSCredentialsProvider(this, awsCredentials){
                        private final SerializableAWSCredentials awsCredentials$1;

                        public AWSCredentials getCredentials() {
                            return this.awsCredentials$1;
                        }

                        public void refresh() {
                        }
                        {
                            this.awsCredentials$1 = awsCredentials$1;
                        }
                    };
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Using DefaultAWSCredentialsProviderChain";
                    }
                });
                object = new DefaultAWSCredentialsProviderChain();
            }
            return object;
        }
        throw new MatchError(option);
    }

    public KinesisReceiver(String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, String checkpointAppName, Duration checkpointInterval, StorageLevel storageLevel, Function1<Record, T> messageHandler, Option<SerializableAWSCredentials> awsCredentialsOption) {
        this.streamName = streamName2;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPositionInStream = initialPositionInStream;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this.messageHandler = messageHandler;
        this.awsCredentialsOption = awsCredentialsOption;
        super(storageLevel);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$workerId = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$worker = null;
        this.workerThread = null;
        this.blockGenerator = null;
        this.seqNumRangesInCurrentBlock = new ArrayBuffer();
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$blockIdToSeqNumRanges = new ConcurrentHashMap();
        this.kinesisCheckpointer = null;
        this.org$apache$spark$streaming$kinesis$KinesisReceiver$$shardIdToLatestStoredSeqNum = new ConcurrentHashMap();
    }

    public class GeneratedBlockHandler
    implements BlockGeneratorListener {
        public void onAddData(Object data, Object metadata) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$rememberAddedRange((SequenceNumberRange)metadata);
        }

        public void onGenerateBlock(StreamBlockId blockId) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$finalizeRangesForCurrentBlock(blockId);
        }

        public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().org$apache$spark$streaming$kinesis$KinesisReceiver$$storeBlockWithRanges(blockId, arrayBuffer);
        }

        public void onError(String message, Throwable throwable) {
            this.org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer().reportError(message, throwable);
        }

        public /* synthetic */ KinesisReceiver org$apache$spark$streaming$kinesis$KinesisReceiver$GeneratedBlockHandler$$$outer() {
            return KinesisReceiver.this;
        }

        public GeneratedBlockHandler() {
            if (KinesisReceiver.this == null) {
                throw null;
            }
        }
    }
}

