/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.DefaultCredentials$;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations$;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEe!B\u0001\u0003\u0001\ta!aE&j]\u0016\u001c\u0018n]%oaV$Hi\u0015;sK\u0006l'BA\u0002\u0005\u0003\u001dY\u0017N\\3tSNT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0016\u0005512C\u0001\u0001\u000f!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\bIN$(/Z1n\u0013\t\u0019\u0002C\u0001\u000bSK\u000e,\u0017N^3s\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0003+Ya\u0001\u0001B\u0003\u0018\u0001\t\u0007\u0011DA\u0001U\u0007\u0001\t\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001B0tg\u000e\u0004\"AJ\u0014\u000e\u0003\u0011I!\u0001\u000b\u0003\u0003!M#(/Z1nS:<7i\u001c8uKb$\b\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011A\u0016\u0002\u0015M$(/Z1n\u001d\u0006lW-F\u0001-!\ti\u0003G\u0004\u0002\u001c]%\u0011q\u0006H\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u000209!AA\u0007\u0001B\u0001B\u0003%A&A\u0006tiJ,\u0017-\u001c(b[\u0016\u0004\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u0016\u0002\u0017\u0015tG\r]8j]R,&\u000f\u001c\u0005\tq\u0001\u0011\t\u0011)A\u0005Y\u0005aQM\u001c3q_&tG/\u0016:mA!A!\b\u0001BC\u0002\u0013\u00051&\u0001\u0006sK\u001eLwN\u001c(b[\u0016D\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\fe\u0016<\u0017n\u001c8OC6,\u0007\u0005\u0003\u0005?\u0001\t\u0015\r\u0011\"\u0001@\u0003]Ig.\u001b;jC2\u0004vn]5uS>t\u0017J\\*ue\u0016\fW.F\u0001A!\t\tu*D\u0001C\u0015\t\u0019E)\u0001\u0004x_J\\WM\u001d\u0006\u0003\u000b\u001a\u000b1\u0001\\5c\u0015\t9\u0005*A\u0007dY&,g\u000e\u001e7jEJ\f'/\u001f\u0006\u0003\u0007%S!AS&\u0002\u0011M,'O^5dKNT!\u0001T'\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"\u0001(\u0002\u0007\r|W.\u0003\u0002Q\u0005\n9\u0012J\\5uS\u0006d\u0007k\\:ji&|g.\u00138TiJ,\u0017-\u001c\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0001\u0006A\u0012N\\5uS\u0006d\u0007k\\:ji&|g.\u00138TiJ,\u0017-\u001c\u0011\t\u0011Q\u0003!Q1A\u0005\u0002-\n\u0011c\u00195fG.\u0004x.\u001b8u\u0003B\u0004h*Y7f\u0011!1\u0006A!A!\u0002\u0013a\u0013AE2iK\u000e\\\u0007o\\5oi\u0006\u0003\bOT1nK\u0002B\u0001\u0002\u0017\u0001\u0003\u0006\u0004%\t!W\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG.F\u0001[!\t13,\u0003\u0002]\t\tAA)\u001e:bi&|g\u000e\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003[\u0003M\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197!\u0011!\u0001\u0007A!b\u0001\n\u0003\t\u0017!D0ti>\u0014\u0018mZ3MKZ,G.F\u0001c!\t\u0019g-D\u0001e\u0015\t)g!A\u0004ti>\u0014\u0018mZ3\n\u0005\u001d$'\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00022\u0002\u001d}\u001bHo\u001c:bO\u0016dUM^3mA!A1\u000e\u0001BC\u0002\u0013\u0005A.\u0001\bnKN\u001c\u0018mZ3IC:$G.\u001a:\u0016\u00035\u0004Ba\u00078q)%\u0011q\u000e\b\u0002\n\rVt7\r^5p]F\u0002\"!\u001d;\u000e\u0003IT!a\u001d%\u0002\u000b5|G-\u001a7\n\u0005U\u0014(A\u0002*fG>\u0014H\r\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003n\u0003=iWm]:bO\u0016D\u0015M\u001c3mKJ\u0004\u0003\u0002C=\u0001\u0005\u000b\u0007I\u0011\u0001>\u0002\u0019-Lg.Z:jg\u000e\u0013X\rZ:\u0016\u0003m\u0004\"\u0001`?\u000e\u0003\tI!A \u0002\u0003'M\u0003\u0018M]6B/N\u001b%/\u001a3f]RL\u0017\r\\:\t\u0013\u0005\u0005\u0001A!A!\u0002\u0013Y\u0018!D6j]\u0016\u001c\u0018n]\"sK\u0012\u001c\b\u0005\u0003\u0006\u0002\u0006\u0001\u0011)\u0019!C\u0001\u0003\u000f\tQ\u0002Z=oC6|GIQ\"sK\u0012\u001cXCAA\u0005!\u0011Y\u00121B>\n\u0007\u00055AD\u0001\u0004PaRLwN\u001c\u0005\u000b\u0003#\u0001!\u0011!Q\u0001\n\u0005%\u0011A\u00043z]\u0006lw\u000e\u0012\"De\u0016$7\u000f\t\u0005\u000b\u0003+\u0001!Q1A\u0005\u0002\u0005\u001d\u0011aD2m_V$w+\u0019;dQ\u000e\u0013X\rZ:\t\u0015\u0005e\u0001A!A!\u0002\u0013\tI!\u0001\tdY>,HmV1uG\"\u001c%/\u001a3tA!Q\u0011Q\u0004\u0001\u0003\u0004\u0003\u0006Y!a\b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0003\u0002\"\u0005\u001dB#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u000f\u0002\u000fI,g\r\\3di&!\u0011\u0011FA\u0012\u0005!\u0019E.Y:t)\u0006<\u0007bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0007y%t\u0017\u000e\u001e \u00155\u0005E\u0012qGA\u001d\u0003w\ti$a\u0010\u0002B\u0005\r\u0013QIA$\u0003\u0013\nY%!\u0014\u0015\t\u0005M\u0012Q\u0007\t\u0004y\u0002!\u0002\u0002CA\u000f\u0003W\u0001\u001d!a\b\t\r\u0011\nY\u00031\u0001&\u0011\u0019Q\u00131\u0006a\u0001Y!1a'a\u000bA\u00021BaAOA\u0016\u0001\u0004a\u0003B\u0002 \u0002,\u0001\u0007\u0001\t\u0003\u0004U\u0003W\u0001\r\u0001\f\u0005\u00071\u0006-\u0002\u0019\u0001.\t\r\u0001\fY\u00031\u0001c\u0011\u0019Y\u00171\u0006a\u0001[\"1\u00110a\u000bA\u0002mD\u0001\"!\u0002\u0002,\u0001\u0007\u0011\u0011\u0002\u0005\t\u0003+\tY\u00031\u0001\u0002\n!A\u0011\u0011\u000b\u0001\u0005B\u0011\t\u0019&\u0001\bde\u0016\fG/\u001a\"m_\u000e\\'\u000b\u0012#\u0015\r\u0005U\u0013\u0011MA6!\u0015\t9&!\u0018\u0015\u001b\t\tIFC\u0002\u0002\\\u0019\t1A\u001d3e\u0013\u0011\ty&!\u0017\u0003\u0007I#E\t\u0003\u0005\u0002d\u0005=\u0003\u0019AA3\u0003\u0011!\u0018.\\3\u0011\u0007\u0019\n9'C\u0002\u0002j\u0011\u0011A\u0001V5nK\"A\u0011QNA(\u0001\u0004\ty'\u0001\u0006cY>\u001c7.\u00138g_N\u0004b!!\u001d\u0002\u0002\u0006\u001de\u0002BA:\u0003{rA!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003sB\u0012A\u0002\u001fs_>$h(C\u0001\u001e\u0013\r\ty\bH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019)!\"\u0003\u0007M+\u0017OC\u0002\u0002\u0000q\u0001B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0004\u0003\u001b#\u0011!C:dQ\u0016$W\u000f\\3s\u0013\u0011\t\t*a#\u0003#I+7-Z5wK\u0012\u0014En\\2l\u0013:4w\u000eC\u0004\u0002\u0016\u0002!\t%a&\u0002\u0017\u001d,GOU3dK&4XM\u001d\u000b\u0003\u00033\u0003R!a'\u0002\"Ri!!!(\u000b\u0007\u0005}E!\u0001\u0005sK\u000e,\u0017N^3s\u0013\u0011\t\u0019+!(\u0003\u0011I+7-Z5wKJ<q!a*\u0003\u0011\u0003\tI+A\nLS:,7/[:J]B,H\u000fR*ue\u0016\fW\u000eE\u0002}\u0003W3a!\u0001\u0002\t\u0002\u000556CBAV\u0003_\u000b)\fE\u0002\u001c\u0003cK1!a-\u001d\u0005\u0019\te.\u001f*fMB\u00191$a.\n\u0007\u0005eFD\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0002.\u0005-F\u0011AA_)\t\tIKB\u0004\u0002B\u0006-\u0006!a1\u0003\u000f\t+\u0018\u000e\u001c3feN!\u0011qXAX\u0011!\ti#a0\u0005\u0002\u0005\u001dGCAAe!\u0011\tY-a0\u000e\u0005\u0005-\u0006BCAh\u0003\u007f\u0003\r\u0011\"\u0003\u0002R\u0006\u00012\u000f\u001e:fC6LgnZ\"p]R,\u0007\u0010^\u000b\u0003\u0003'\u0004BaGA\u0006K!Q\u0011q[A`\u0001\u0004%I!!7\u0002)M$(/Z1nS:<7i\u001c8uKb$x\fJ3r)\u0011\tY.!9\u0011\u0007m\ti.C\u0002\u0002`r\u0011A!\u00168ji\"Q\u00111]Ak\u0003\u0003\u0005\r!a5\u0002\u0007a$\u0013\u0007C\u0005\u0002h\u0006}\u0006\u0015)\u0003\u0002T\u0006\t2\u000f\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\u0011\t\u0013)\ny\f1A\u0005\n\u0005-XCAAw!\u0011Y\u00121\u0002\u0017\t\u0015\u0005E\u0018q\u0018a\u0001\n\u0013\t\u00190\u0001\btiJ,\u0017-\u001c(b[\u0016|F%Z9\u0015\t\u0005m\u0017Q\u001f\u0005\u000b\u0003G\fy/!AA\u0002\u00055\b\u0002\u0003\u001b\u0002@\u0002\u0006K!!<\t\u0013Q\u000by\f1A\u0005\n\u0005-\bBCA\u007f\u0003\u007f\u0003\r\u0011\"\u0003\u0002\u0000\u0006)2\r[3dWB|\u0017N\u001c;BaBt\u0015-\\3`I\u0015\fH\u0003BAn\u0005\u0003A!\"a9\u0002|\u0006\u0005\t\u0019AAw\u0011!1\u0016q\u0018Q!\n\u00055\b\"\u0003\u001c\u0002@\u0002\u0007I\u0011BAv\u0011)\u0011I!a0A\u0002\u0013%!1B\u0001\u0010K:$\u0007o\\5oiV\u0013Hn\u0018\u0013fcR!\u00111\u001cB\u0007\u0011)\t\u0019Oa\u0002\u0002\u0002\u0003\u0007\u0011Q\u001e\u0005\tq\u0005}\u0006\u0015)\u0003\u0002n\"I!(a0A\u0002\u0013%\u00111\u001e\u0005\u000b\u0005+\ty\f1A\u0005\n\t]\u0011A\u0004:fO&|gNT1nK~#S-\u001d\u000b\u0005\u00037\u0014I\u0002\u0003\u0006\u0002d\nM\u0011\u0011!a\u0001\u0003[D\u0001\u0002PA`A\u0003&\u0011Q\u001e\u0005\n}\u0005}\u0006\u0019!C\u0005\u0005?)\"A!\t\u0011\tm\tY\u0001\u0011\u0005\u000b\u0005K\ty\f1A\u0005\n\t\u001d\u0012aG5oSRL\u0017\r\u001c)pg&$\u0018n\u001c8J]N#(/Z1n?\u0012*\u0017\u000f\u0006\u0003\u0002\\\n%\u0002BCAr\u0005G\t\t\u00111\u0001\u0003\"!A!+a0!B\u0013\u0011\t\u0003C\u0005Y\u0003\u007f\u0003\r\u0011\"\u0003\u00030U\u0011!\u0011\u0007\t\u00057\u0005-!\f\u0003\u0006\u00036\u0005}\u0006\u0019!C\u0005\u0005o\tac\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY~#S-\u001d\u000b\u0005\u00037\u0014I\u0004\u0003\u0006\u0002d\nM\u0012\u0011!a\u0001\u0005cA\u0001BXA`A\u0003&!\u0011\u0007\u0005\u000b\u0005\u007f\ty\f1A\u0005\n\t\u0005\u0013\u0001D:u_J\fw-\u001a'fm\u0016dWC\u0001B\"!\u0011Y\u00121\u00022\t\u0015\t\u001d\u0013q\u0018a\u0001\n\u0013\u0011I%\u0001\tti>\u0014\u0018mZ3MKZ,Gn\u0018\u0013fcR!\u00111\u001cB&\u0011)\t\u0019O!\u0012\u0002\u0002\u0003\u0007!1\t\u0005\n\u0005\u001f\ny\f)Q\u0005\u0005\u0007\nQb\u001d;pe\u0006<W\rT3wK2\u0004\u0003B\u0003B*\u0003\u007f\u0003\r\u0011\"\u0003\u0002\b\u0005!2.\u001b8fg&\u001c8I]3egB\u0013xN^5eKJD!Ba\u0016\u0002@\u0002\u0007I\u0011\u0002B-\u0003aY\u0017N\\3tSN\u001c%/\u001a3t!J|g/\u001b3fe~#S-\u001d\u000b\u0005\u00037\u0014Y\u0006\u0003\u0006\u0002d\nU\u0013\u0011!a\u0001\u0003\u0013A\u0011Ba\u0018\u0002@\u0002\u0006K!!\u0003\u0002+-Lg.Z:jg\u000e\u0013X\rZ:Qe>4\u0018\u000eZ3sA!Q!1MA`\u0001\u0004%I!a\u0002\u0002+\u0011Lh.Y7p\t\n\u001b%/\u001a3t!J|g/\u001b3fe\"Q!qMA`\u0001\u0004%IA!\u001b\u00023\u0011Lh.Y7p\t\n\u001b%/\u001a3t!J|g/\u001b3fe~#S-\u001d\u000b\u0005\u00037\u0014Y\u0007\u0003\u0006\u0002d\n\u0015\u0014\u0011!a\u0001\u0003\u0013A\u0011Ba\u001c\u0002@\u0002\u0006K!!\u0003\u0002-\u0011Lh.Y7p\t\n\u001b%/\u001a3t!J|g/\u001b3fe\u0002B!Ba\u001d\u0002@\u0002\u0007I\u0011BA\u0004\u0003]\u0019Gn\\;e/\u0006$8\r[\"sK\u0012\u001c\bK]8wS\u0012,'\u000f\u0003\u0006\u0003x\u0005}\u0006\u0019!C\u0005\u0005s\n1d\u00197pk\u0012<\u0016\r^2i\u0007J,Gm\u001d)s_ZLG-\u001a:`I\u0015\fH\u0003BAn\u0005wB!\"a9\u0003v\u0005\u0005\t\u0019AA\u0005\u0011%\u0011y(a0!B\u0013\tI!\u0001\rdY>,HmV1uG\"\u001c%/\u001a3t!J|g/\u001b3fe\u0002B\u0001\"a4\u0002@\u0012\u0005!1\u0011\u000b\u0005\u0003\u0013\u0014)\tC\u0004\u0003\b\n\u0005\u0005\u0019A\u0013\u0002\u0007M\u001c8\r\u0003\u0005\u0002P\u0006}F\u0011\u0001BF)\u0011\tIM!$\t\u0011\t=%\u0011\u0012a\u0001\u0005#\u000bAA[:tGB!!1\u0013BO\u001b\t\u0011)J\u0003\u0003\u0003\u0018\ne\u0015\u0001\u00026bm\u0006T1Aa'\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005?\u0013)J\u0001\u000bKCZ\f7\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\u0005\bU\u0005}F\u0011\u0001BR)\u0011\tIM!*\t\r)\u0012\t\u000b1\u0001-\u0011\u001d!\u0016q\u0018C\u0001\u0005S#B!!3\u0003,\"9!Q\u0016BT\u0001\u0004a\u0013aB1qa:\u000bW.\u001a\u0005\bm\u0005}F\u0011\u0001BY)\u0011\tIMa-\t\u000f\tU&q\u0016a\u0001Y\u0005\u0019QO\u001d7\t\u000fi\ny\f\"\u0001\u0003:R!\u0011\u0011\u001aB^\u0011\u0019Q$q\u0017a\u0001Y!9a(a0\u0005\u0002\t}F\u0003BAe\u0005\u0003DqAa1\u0003>\u0002\u0007\u0001)A\bj]&$\u0018.\u00197Q_NLG/[8o\u0011\u001dA\u0016q\u0018C\u0001\u0005\u000f$B!!3\u0003J\"9!1\u001aBc\u0001\u0004Q\u0016\u0001C5oi\u0016\u0014h/\u00197\t\u0011\t}\u0012q\u0018C\u0001\u0005\u001f$B!!3\u0003R\"9!q\bBg\u0001\u0004\u0011\u0007\u0002\u0003Bk\u0003\u007f#\tAa6\u0002%-Lg.Z:jg\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0005\u0003\u0013\u0014I\u000eC\u0004\u0003\\\nM\u0007\u0019A>\u0002\u0017\r\u0014X\rZ3oi&\fGn\u001d\u0005\t\u0005?\fy\f\"\u0001\u0003b\u0006\u0019B-\u001f8b[>$%i\u0011:fI\u0016tG/[1mgR!\u0011\u0011\u001aBr\u0011\u001d\u0011YN!8A\u0002mD\u0001Ba:\u0002@\u0012\u0005!\u0011^\u0001\u0016G2|W\u000fZ,bi\u000eD7I]3eK:$\u0018.\u00197t)\u0011\tIMa;\t\u000f\tm'Q\u001da\u0001w\"A!q^A`\t\u0003\u0011\t0A\fck&dGmV5uQ6+7o]1hK\"\u000bg\u000e\u001a7feV!!1\u001fB~)\u0011\u0011)pa\u0001\u0015\t\t](Q \t\u0005y\u0002\u0011I\u0010E\u0002\u0016\u0005w$aa\u0006Bw\u0005\u0004I\u0002B\u0003B\u0000\u0005[\f\t\u0011q\u0001\u0004\u0002\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\r\u0005\u0005\u0012q\u0005B}\u0011!\u0019)A!<A\u0002\r\u001d\u0011a\u00025b]\u0012dWM\u001d\t\u000679\u0004(\u0011 \u0005\t\u0007\u0017\ty\f\"\u0001\u0004\u000e\u0005)!-^5mIR\u00111q\u0002\t\u0005y\u0002\u0019\t\u0002E\u0003\u001c\u0007'\u00199\"C\u0002\u0004\u0016q\u0011Q!\u0011:sCf\u00042aGB\r\u0013\r\u0019Y\u0002\b\u0002\u0005\u0005f$X\r\u0003\u0005\u0004 \u0005}F\u0011BB\u0011\u0003A9W\r\u001e*fcVL'/\u001a3QCJ\fW.\u0006\u0003\u0004$\r\u001dBCBB\u0013\u0007S\u0019y\u0003E\u0002\u0016\u0007O!aaFB\u000f\u0005\u0004I\u0002\u0002CB\u0016\u0007;\u0001\ra!\f\u0002\u000bA\f'/Y7\u0011\u000bm\tYa!\n\t\u000f\rE2Q\u0004a\u0001Y\u0005I\u0001/\u0019:b[:\u000bW.\u001a\u0015\u0005\u0003\u007f\u001b)\u0004\u0005\u0003\u00048\r\rc\u0002BB\u001d\u0007\u007fi!aa\u000f\u000b\u0007\rub!\u0001\u0006b]:|G/\u0019;j_:LAa!\u0011\u0004<\u0005\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\u0019)ea\u0012\u0003\u0011\u00153x\u000e\u001c<j]\u001eTAa!\u0011\u0004<!A11JAV\t\u0003\u0019i%A\u0004ck&dG-\u001a:\u0016\u0005\u0005%\u0007\"CB)\u0003W#\tAAB*\u0003U!WMZ1vYRlUm]:bO\u0016D\u0015M\u001c3mKJ$Ba!\u0005\u0004V!91qKB(\u0001\u0004\u0001\u0018A\u0002:fG>\u0014H\r\u0003\u0006\u0004\\\u0005-&\u0019!C\u0001\u0005-\nA\u0004R#G\u0003VcEkX&J\u001d\u0016\u001b\u0016jU0F\u001d\u0012\u0003v*\u0013(U?V\u0013F\n\u0003\u0005\u0004`\u0005-\u0006\u0015!\u0003-\u0003u!UIR!V\u0019R{6*\u0013(F'&\u001bv,\u0012(E!>Ke\nV0V%2\u0003\u0003BCB2\u0003W\u0013\r\u0011\"\u0001\u0003W\u0005YB)\u0012$B+2#vlS%O\u000bNK5k\u0018*F\u000f&{ej\u0018(B\u001b\u0016C\u0001ba\u001a\u0002,\u0002\u0006I\u0001L\u0001\u001d\t\u00163\u0015)\u0016'U?.Ke*R*J'~\u0013ViR%P\u001d~s\u0015)T#!\u0011)\u0019Y'a+C\u0002\u0013\u0005!aP\u0001#\t\u00163\u0015)\u0016'U?&s\u0015\nV%B\u0019~\u0003vjU%U\u0013>su,\u0013(`'R\u0013V)Q'\t\u0011\r=\u00141\u0016Q\u0001\n\u0001\u000b1\u0005R#G\u0003VcEkX%O\u0013RK\u0015\tT0Q\u001fNKE+S(O?&sul\u0015+S\u000b\u0006k\u0005\u0005\u0003\u0006\u0004t\u0005-&\u0019!C\u0001\u0005\u0005\fQ\u0003R#G\u0003VcEkX*U\u001fJ\u000bu)R0M\u000bZ+E\n\u0003\u0005\u0004x\u0005-\u0006\u0015!\u0003c\u0003Y!UIR!V\u0019R{6\u000bV(S\u0003\u001e+u\fT#W\u000b2\u0003\u0003BCB>\u0003W\u000b\t\u0011\"\u0003\u0004~\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019y\b\u0005\u0003\u0004\u0002\u000e%UBABB\u0015\u0011\u0019)ia\"\u0002\t1\fgn\u001a\u0006\u0003\u0005/KAaa#\u0004\u0004\n1qJ\u00196fGRDC!a+\u00046!\"\u0011QUB\u001b\u0001")
public class KinesisInputDStream<T>
extends ReceiverInputDStream<T> {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final InitialPositionInStream initialPositionInStream;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final StorageLevel _storageLevel;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private final ClassTag<T> evidence$1;

    public static Builder builder() {
        return KinesisInputDStream$.MODULE$.builder();
    }

    public String streamName() {
        return this.streamName;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    public InitialPositionInStream initialPositionInStream() {
        return this.initialPositionInStream;
    }

    public String checkpointAppName() {
        return this.checkpointAppName;
    }

    public Duration checkpointInterval() {
        return this.checkpointInterval;
    }

    public StorageLevel _storageLevel() {
        return this._storageLevel;
    }

    public Function1<Record, T> messageHandler() {
        return this.messageHandler;
    }

    public SparkAWSCredentials kinesisCreds() {
        return this.kinesisCreds;
    }

    public Option<SparkAWSCredentials> dynamoDBCreds() {
        return this.dynamoDBCreds;
    }

    public Option<SparkAWSCredentials> cloudWatchCreds() {
        return this.cloudWatchCreds;
    }

    public RDD<T> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        Object object;
        boolean allBlocksHaveRanges = ((IterableLike)blockInfos.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(ReceivedBlockInfo x$1) {
                return x$1.metadataOption();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Object> x$2) {
                return x$2.nonEmpty();
            }
        });
        if (allBlocksHaveRanges) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BlockId apply(ReceivedBlockInfo x$3) {
                    return x$3.blockId();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            SequenceNumberRanges[] seqNumRanges = (SequenceNumberRanges[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceNumberRanges apply(ReceivedBlockInfo x$4) {
                    return (SequenceNumberRanges)x$4.metadataOption().get();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ReceivedBlockInfo x$5) {
                    return x$5.isBlockIdValid();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
            this.logDebug((Function0)new Serializable(this, time, seqNumRanges){
                public static final long serialVersionUID = 0L;
                private final Time time$1;
                private final SequenceNumberRanges[] seqNumRanges$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating KinesisBackedBlockRDD for ", " with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.time$1, BoxesRunTime.boxToInteger((int)this.seqNumRanges$1.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"seq number ranges: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.seqNumRanges$1).mkString(", ")}))).toString();
                }
                {
                    void var3_3;
                    this.time$1 = time$1;
                    this.seqNumRanges$1 = var3_3;
                }
            });
            object = new KinesisBackedBlockRDD<T>(this.context().sc(), this.regionName(), this.endpointUrl(), blockIds, seqNumRanges, isBlockIdValid, this.messageHandler(), this.kinesisCreds(), KinesisReadConfigurations$.MODULE$.apply(this.ssc()), this.evidence$1);
        } else {
            this.logWarning((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Kinesis sequence number information was not present with some block metadata, it may not be possible to recover from failures";
                }
            });
            object = super.createBlockRDD(time, blockInfos);
        }
        return object;
    }

    public Receiver<T> getReceiver() {
        return new KinesisReceiver<T>(this.streamName(), this.endpointUrl(), this.regionName(), this.initialPositionInStream(), this.checkpointAppName(), this.checkpointInterval(), this._storageLevel(), this.messageHandler(), this.kinesisCreds(), this.dynamoDBCreds(), this.cloudWatchCreds());
    }

    public KinesisInputDStream(StreamingContext _ssc, String streamName2, String endpointUrl, String regionName, InitialPositionInStream initialPositionInStream, String checkpointAppName, Duration checkpointInterval, StorageLevel _storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds, ClassTag<T> evidence$1) {
        this.streamName = streamName2;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPositionInStream = initialPositionInStream;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this._storageLevel = _storageLevel;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        this.evidence$1 = evidence$1;
        super(_ssc, evidence$1);
    }

    @InterfaceStability.Evolving
    public static class Builder {
        private Option<StreamingContext> streamingContext = None$.MODULE$;
        private Option<String> streamName = None$.MODULE$;
        private Option<String> checkpointAppName = None$.MODULE$;
        private Option<String> endpointUrl = None$.MODULE$;
        private Option<String> regionName = None$.MODULE$;
        private Option<InitialPositionInStream> initialPositionInStream = None$.MODULE$;
        private Option<Duration> checkpointInterval = None$.MODULE$;
        private Option<StorageLevel> storageLevel = None$.MODULE$;
        private Option<SparkAWSCredentials> kinesisCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> dynamoDBCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> cloudWatchCredsProvider = None$.MODULE$;

        private Option<StreamingContext> streamingContext() {
            return this.streamingContext;
        }

        private void streamingContext_$eq(Option<StreamingContext> x$1) {
            this.streamingContext = x$1;
        }

        private Option<String> streamName() {
            return this.streamName;
        }

        private void streamName_$eq(Option<String> x$1) {
            this.streamName = x$1;
        }

        private Option<String> checkpointAppName() {
            return this.checkpointAppName;
        }

        private void checkpointAppName_$eq(Option<String> x$1) {
            this.checkpointAppName = x$1;
        }

        private Option<String> endpointUrl() {
            return this.endpointUrl;
        }

        private void endpointUrl_$eq(Option<String> x$1) {
            this.endpointUrl = x$1;
        }

        private Option<String> regionName() {
            return this.regionName;
        }

        private void regionName_$eq(Option<String> x$1) {
            this.regionName = x$1;
        }

        private Option<InitialPositionInStream> initialPositionInStream() {
            return this.initialPositionInStream;
        }

        private void initialPositionInStream_$eq(Option<InitialPositionInStream> x$1) {
            this.initialPositionInStream = x$1;
        }

        private Option<Duration> checkpointInterval() {
            return this.checkpointInterval;
        }

        private void checkpointInterval_$eq(Option<Duration> x$1) {
            this.checkpointInterval = x$1;
        }

        private Option<StorageLevel> storageLevel() {
            return this.storageLevel;
        }

        private void storageLevel_$eq(Option<StorageLevel> x$1) {
            this.storageLevel = x$1;
        }

        private Option<SparkAWSCredentials> kinesisCredsProvider() {
            return this.kinesisCredsProvider;
        }

        private void kinesisCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.kinesisCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> dynamoDBCredsProvider() {
            return this.dynamoDBCredsProvider;
        }

        private void dynamoDBCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.dynamoDBCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> cloudWatchCredsProvider() {
            return this.cloudWatchCredsProvider;
        }

        private void cloudWatchCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.cloudWatchCredsProvider = x$1;
        }

        public Builder streamingContext(StreamingContext ssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)ssc));
            return this;
        }

        public Builder streamingContext(JavaStreamingContext jssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)jssc.ssc()));
            return this;
        }

        public Builder streamName(String streamName2) {
            this.streamName_$eq((Option<String>)Option$.MODULE$.apply((Object)streamName2));
            return this;
        }

        public Builder checkpointAppName(String appName) {
            this.checkpointAppName_$eq((Option<String>)Option$.MODULE$.apply((Object)appName));
            return this;
        }

        public Builder endpointUrl(String url) {
            this.endpointUrl_$eq((Option<String>)Option$.MODULE$.apply((Object)url));
            return this;
        }

        public Builder regionName(String regionName) {
            this.regionName_$eq((Option<String>)Option$.MODULE$.apply((Object)regionName));
            return this;
        }

        public Builder initialPositionInStream(InitialPositionInStream initialPosition) {
            this.initialPositionInStream_$eq((Option<InitialPositionInStream>)Option$.MODULE$.apply((Object)initialPosition));
            return this;
        }

        public Builder checkpointInterval(Duration interval) {
            this.checkpointInterval_$eq((Option<Duration>)Option$.MODULE$.apply((Object)interval));
            return this;
        }

        public Builder storageLevel(StorageLevel storageLevel) {
            this.storageLevel_$eq((Option<StorageLevel>)Option$.MODULE$.apply((Object)storageLevel));
            return this;
        }

        public Builder kinesisCredentials(SparkAWSCredentials credentials) {
            this.kinesisCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder dynamoDBCredentials(SparkAWSCredentials credentials) {
            this.dynamoDBCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder cloudWatchCredentials(SparkAWSCredentials credentials) {
            this.cloudWatchCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public <T> KinesisInputDStream<T> buildWithMessageHandler(Function1<Record, T> handler, ClassTag<T> evidence$2) {
            StreamingContext ssc = this.getRequiredParam(this.streamingContext(), "streamingContext");
            return new KinesisInputDStream<T>(ssc, this.getRequiredParam(this.streamName(), "streamName"), (String)this.endpointUrl().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_ENDPOINT_URL();
                }
            }), (String)this.regionName().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_REGION_NAME();
                }
            }), (InitialPositionInStream)this.initialPositionInStream().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final InitialPositionInStream apply() {
                    return KinesisInputDStream$.MODULE$.DEFAULT_INITIAL_POSITION_IN_STREAM();
                }
            }), this.getRequiredParam(this.checkpointAppName(), "checkpointAppName"), (Duration)this.checkpointInterval().getOrElse((Function0)new Serializable(this, ssc){
                public static final long serialVersionUID = 0L;
                private final StreamingContext ssc$1;

                public final Duration apply() {
                    return this.ssc$1.graph().batchDuration();
                }
                {
                    this.ssc$1 = ssc$1;
                }
            }), (StorageLevel)this.storageLevel().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final StorageLevel apply() {
                    return KinesisInputDStream$.MODULE$.DEFAULT_STORAGE_LEVEL();
                }
            }), (Function1)ssc.sc().clean(handler, ssc.sc().clean$default$2()), (SparkAWSCredentials)this.kinesisCredsProvider().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final DefaultCredentials$ apply() {
                    return DefaultCredentials$.MODULE$;
                }
            }), this.dynamoDBCredsProvider(), this.cloudWatchCredsProvider(), evidence$2);
        }

        public KinesisInputDStream<byte[]> build() {
            return this.buildWithMessageHandler((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(Record record) {
                    return KinesisInputDStream$.MODULE$.defaultMessageHandler(record);
                }
            }, (ClassTag)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        }

        private <T> T getRequiredParam(Option<T> param, String paramName) {
            return (T)param.getOrElse((Function0)new Serializable(this, paramName){
                public static final long serialVersionUID = 0L;
                private final String paramName$1;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No value provided for required parameter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.paramName$1})));
                }
                {
                    this.paramName$1 = paramName$1;
                }
            });
        }
    }
}

