/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import java.nio.ByteBuffer;
import org.apache.spark.examples.streaming.KinesisWordProducerASL$;
import org.apache.spark.examples.streaming.KinesisWordProducerASL$$anonfun$generate$1$;
import org.apache.spark.examples.streaming.StreamingExamples$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class KinesisWordProducerASL$ {
    public static final KinesisWordProducerASL$ MODULE$;

    static {
        new KinesisWordProducerASL$();
    }

    public void main(String[] args) {
        if (args.length != 4) {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("\n          |Usage: KinesisWordProducerASL <stream-name> <endpoint-url> <records-per-sec>\n          |                              <words-per-record>\n          |\n          |    <stream-name> is the name of the Kinesis stream\n          |    <endpoint-url> is the endpoint of the Kinesis service\n          |                   (e.g. https://kinesis.us-east-1.amazonaws.com)\n          |    <records-per-sec> is the rate of records per second to put onto the stream\n          |    <words-per-record> is the number of words per record\n          |\n        ")).stripMargin());
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
            Tuple4 tuple4;
            String stream = (String)((SeqLike)option.get()).apply(0);
            String endpoint = (String)((SeqLike)option.get()).apply(1);
            String recordsPerSecond = (String)((SeqLike)option.get()).apply(2);
            String wordsPerRecord = (String)((SeqLike)option.get()).apply(3);
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)stream, (Object)endpoint, (Object)recordsPerSecond, (Object)wordsPerRecord);
            String stream2 = (String)tuple42._1();
            String endpoint2 = (String)tuple42._2();
            String recordsPerSecond2 = (String)tuple42._3();
            String wordsPerRecord2 = (String)tuple42._4();
            Seq<Tuple2<String, Object>> totals = this.generate(stream2, endpoint2, new StringOps(Predef$.MODULE$.augmentString(recordsPerSecond2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(wordsPerRecord2)).toInt());
            Predef$.MODULE$.println((Object)"Totals for the words sent");
            totals.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, Object> x$5) {
                    Predef$.MODULE$.println(x$5);
                }
            });
            return;
        }
        throw new MatchError((Object)stringArray);
    }

    public Seq<Tuple2<String, Object>> generate(String stream, String endpoint, int recordsPerSecond, int wordsPerRecord) {
        List randomWords = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark", "you", "are", "my", "father"}));
        Map totals = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        AmazonKinesisClient kinesisClient = new AmazonKinesisClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        kinesisClient.setEndpoint(endpoint);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Putting records onto stream ", " and endpoint ", " at a rate of"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stream, endpoint}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " records per second and ", " words per record"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)recordsPerSecond), BoxesRunTime.boxToInteger((int)wordsPerRecord)}))).toString());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)new Serializable(stream, recordsPerSecond, wordsPerRecord, randomWords, totals, kinesisClient){
            public static final long serialVersionUID = 0L;
            public final String stream$1;
            private final int recordsPerSecond$1;
            public final int wordsPerRecord$1;
            public final List randomWords$1;
            public final Map totals$1;
            public final AmazonKinesisClient kinesisClient$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.recordsPerSecond$1).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.generate.1 $outer;

                    public final void apply(int recordNum) {
                        this.apply$mcVI$sp(recordNum);
                    }

                    public void apply$mcVI$sp(int recordNum) {
                        String data = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.$outer.wordsPerRecord$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$generate$1$$anonfun$2 $outer;

                            /*
                             * WARNING - void declaration
                             */
                            public final String apply(int x) {
                                void var3_3;
                                int randomWordIdx = Random$.MODULE$.nextInt(this.$outer.org$apache$spark$examples$streaming$KinesisWordProducerASL$$anonfun$$anonfun$$$outer().randomWords$1.size());
                                String randomWord = (String)this.$outer.org$apache$spark$examples$streaming$KinesisWordProducerASL$$anonfun$$anonfun$$$outer().randomWords$1.apply(randomWordIdx);
                                this.$outer.org$apache$spark$examples$streaming$KinesisWordProducerASL$$anonfun$$anonfun$$$outer().totals$1.update((Object)randomWord, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$spark$examples$streaming$KinesisWordProducerASL$$anonfun$$anonfun$$$outer().totals$1.getOrElse((Object)randomWord, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return 0;
                                    }
                                })) + 1)));
                                return var3_3;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ");
                        String partitionKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionKey-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)recordNum)}));
                        PutRecordRequest putRecordRequest = new PutRecordRequest().withStreamName(this.$outer.stream$1).withPartitionKey(partitionKey).withData(ByteBuffer.wrap(data.getBytes()));
                        PutRecordResult putRecordResult = this.$outer.kinesisClient$1.putRecord(putRecordRequest);
                    }

                    public /* synthetic */ anonfun.generate.1 org$apache$spark$examples$streaming$KinesisWordProducerASL$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                BoxedUnit records = BoxedUnit.UNIT;
                Thread.sleep(1000L);
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Sent ").append((Object)BoxesRunTime.boxToInteger((int)this.recordsPerSecond$1)).append((Object)" records").toString());
            }
            {
                this.stream$1 = stream$1;
                this.recordsPerSecond$1 = recordsPerSecond$1;
                this.wordsPerRecord$1 = wordsPerRecord$1;
                this.randomWords$1 = randomWords$1;
                this.totals$1 = totals$1;
                this.kinesisClient$1 = kinesisClient$1;
            }
        });
        return (Seq)totals.toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$6) {
                return (String)x$6._1();
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }

    private KinesisWordProducerASL$() {
        MODULE$ = this;
    }
}

