/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.KinesisUtils$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0005\u001b\tA2*\u001b8fg&\u001cX\u000b^5mgBKH\u000f[8o\u0011\u0016d\u0007/\u001a:\u000b\u0005\r!\u0011aB6j]\u0016\u001c\u0018n\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000bi\u0001A\u0011A\u000e\u00025\u001d,G/\u00138ji&\fG\u000eU8tSRLwN\\%o'R\u0014X-Y7\u0015\u0005qi\u0003CA\u000f,\u001b\u0005q\"BA\u0010!\u0003\u00199xN]6fe*\u0011\u0011EI\u0001\u0004Y&\u0014'BA\u0012%\u00035\u0019G.[3oi2L'M]1ss*\u00111!\n\u0006\u0003M\u001d\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003Q%\n\u0011\"Y7bu>t\u0017m^:\u000b\u0003)\n1aY8n\u0013\tacDA\fJ]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[\")a&\u0007a\u0001_\u00059\u0012N\\5uS\u0006d\u0007k\\:ji&|g.\u00138TiJ,\u0017-\u001c\t\u0003\u001fAJ!!\r\t\u0003\u0007%sG\u000fC\u00034\u0001\u0011\u0005A'\u0001\u0007de\u0016\fG/Z*ue\u0016\fW\u000e\u0006\b6\u0007\"\u000b6+V,Y=\u001aD'\u000e\u001c8\u0011\u0007YZT(D\u00018\u0015\tA\u0014(\u0001\u0003kCZ\f'B\u0001\u001e\u0005\u0003\r\t\u0007/[\u0005\u0003y]\u0012\u0001DS1wCJ+7-Z5wKJLe\u000e];u\tN#(/Z1n!\rya\bQ\u0005\u0003\u007fA\u0011Q!\u0011:sCf\u0004\"aD!\n\u0005\t\u0003\"\u0001\u0002\"zi\u0016DQ\u0001\u0012\u001aA\u0002\u0015\u000bAA[:tGB\u0011aGR\u0005\u0003\u000f^\u0012ACS1wCN#(/Z1nS:<7i\u001c8uKb$\b\"B%3\u0001\u0004Q\u0015AD6j]\u0016\u001c\u0018n]!qa:\u000bW.\u001a\t\u0003\u0017:s!a\u0004'\n\u00055\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014\t\t\u000bI\u0013\u0004\u0019\u0001&\u0002\u0015M$(/Z1n\u001d\u0006lW\rC\u0003Ue\u0001\u0007!*A\u0006f]\u0012\u0004x.\u001b8u+Jd\u0007\"\u0002,3\u0001\u0004Q\u0015A\u0003:fO&|gNT1nK\")aF\ra\u0001_!)\u0011L\ra\u00015\u0006\u00112\r[3dWB|\u0017N\u001c;J]R,'O^1m!\tYF,D\u0001\u0005\u0013\tiFA\u0001\u0005EkJ\fG/[8o\u0011\u0015y&\u00071\u0001a\u00031\u0019Ho\u001c:bO\u0016dUM^3m!\t\tG-D\u0001c\u0015\t\u0019g!A\u0004ti>\u0014\u0018mZ3\n\u0005\u0015\u0014'\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\"B43\u0001\u0004Q\u0015AD1xg\u0006\u001b7-Z:t\u0017\u0016L\u0018\n\u001a\u0005\u0006SJ\u0002\rAS\u0001\rC^\u001c8+Z2sKR\\U-\u001f\u0005\u0006WJ\u0002\rAS\u0001\u0011gR\u001c\u0018i]:v[\u0016\u0014v\u000e\\3Be:DQ!\u001c\u001aA\u0002)\u000bab\u001d;t'\u0016\u001c8/[8o\u001d\u0006lW\rC\u0003pe\u0001\u0007!*A\u0007tiN,\u0005\u0010^3s]\u0006d\u0017\n\u001a\u0005\u0006c\u0002!IA]\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0006;8o\u0011:fIN$2a\u001d<x!\tyA/\u0003\u0002v!\t!QK\\5u\u0011\u00159\u0007\u000f1\u0001K\u0011\u0015I\u0007\u000f1\u0001K\u0001")
public class KinesisUtilsPythonHelper {
    public InitialPositionInStream getInitialPositionInStream(int initialPositionInStream) {
        InitialPositionInStream initialPositionInStream2;
        int n = initialPositionInStream;
        switch (n) {
            default: {
                throw new IllegalArgumentException("Illegal InitialPositionInStream. Please use InitialPositionInStream.LATEST or InitialPositionInStream.TRIM_HORIZON");
            }
            case 1: {
                initialPositionInStream2 = InitialPositionInStream.TRIM_HORIZON;
                break;
            }
            case 0: {
                initialPositionInStream2 = InitialPositionInStream.LATEST;
            }
        }
        return initialPositionInStream2;
    }

    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String kinesisAppName, String streamName2, String endpointUrl, String regionName, int initialPositionInStream, Duration checkpointInterval, StorageLevel storageLevel, String awsAccessKeyId, String awsSecretKey, String stsAssumeRoleArn, String stsSessionName, String stsExternalId) {
        Object object;
        if (!(stsAssumeRoleArn != null && stsSessionName != null && stsExternalId != null || stsAssumeRoleArn == null && stsSessionName == null && stsExternalId == null)) {
            throw new IllegalArgumentException("stsAssumeRoleArn, stsSessionName, and stsExternalId must all be defined or all be null");
        }
        if (stsAssumeRoleArn == null || stsSessionName == null || stsExternalId == null) {
            this.validateAwsCreds(awsAccessKeyId, awsSecretKey);
            object = awsAccessKeyId == null && awsSecretKey == null ? KinesisUtils$.MODULE$.createStream(jssc, kinesisAppName, streamName2, endpointUrl, regionName, this.getInitialPositionInStream(initialPositionInStream), checkpointInterval, storageLevel) : KinesisUtils$.MODULE$.createStream(jssc, kinesisAppName, streamName2, endpointUrl, regionName, this.getInitialPositionInStream(initialPositionInStream), checkpointInterval, storageLevel, awsAccessKeyId, awsSecretKey);
        } else {
            this.validateAwsCreds(awsAccessKeyId, awsSecretKey);
            object = JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(KinesisUtils$.MODULE$.createStream(jssc.ssc(), kinesisAppName, streamName2, endpointUrl, regionName, this.getInitialPositionInStream(initialPositionInStream), checkpointInterval, storageLevel, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(Record x$7) {
                    return KinesisInputDStream$.MODULE$.defaultMessageHandler(x$7);
                }
            }, awsAccessKeyId, awsSecretKey, stsAssumeRoleArn, stsSessionName, stsExternalId, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        }
        return object;
    }

    private void validateAwsCreds(String awsAccessKeyId, String awsSecretKey) {
        if (awsAccessKeyId == null && awsSecretKey != null) {
            throw new IllegalArgumentException("awsSecretKey is set but awsAccessKeyId is null");
        }
        if (awsAccessKeyId != null && awsSecretKey == null) {
            throw new IllegalArgumentException("awsAccessKeyId is set but awsSecretKey is null");
        }
    }
}

