/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;

public final class KinesisReadConfigurations$
implements Serializable {
    public static KinesisReadConfigurations$ MODULE$;
    private final String RETRY_MAX_ATTEMPTS_KEY;
    private final String RETRY_WAIT_TIME_KEY;
    private final int DEFAULT_MAX_RETRIES;
    private final String DEFAULT_RETRY_WAIT_TIME;
    private final int DEFAULT_RETRY_TIMEOUT;

    static {
        new KinesisReadConfigurations$();
    }

    public KinesisReadConfigurations apply() {
        return new KinesisReadConfigurations(this.DEFAULT_MAX_RETRIES(), JavaUtils.timeStringAsMs((String)this.DEFAULT_RETRY_WAIT_TIME()), this.DEFAULT_RETRY_TIMEOUT());
    }

    public KinesisReadConfigurations apply(StreamingContext ssc) {
        return new KinesisReadConfigurations(ssc.sc().getConf().getInt(this.RETRY_MAX_ATTEMPTS_KEY(), this.DEFAULT_MAX_RETRIES()), JavaUtils.timeStringAsMs((String)ssc.sc().getConf().get(this.RETRY_WAIT_TIME_KEY(), this.DEFAULT_RETRY_WAIT_TIME())), ssc.graph().batchDuration().milliseconds());
    }

    public String RETRY_MAX_ATTEMPTS_KEY() {
        return this.RETRY_MAX_ATTEMPTS_KEY;
    }

    public String RETRY_WAIT_TIME_KEY() {
        return this.RETRY_WAIT_TIME_KEY;
    }

    public int DEFAULT_MAX_RETRIES() {
        return this.DEFAULT_MAX_RETRIES;
    }

    public String DEFAULT_RETRY_WAIT_TIME() {
        return this.DEFAULT_RETRY_WAIT_TIME;
    }

    public int DEFAULT_RETRY_TIMEOUT() {
        return this.DEFAULT_RETRY_TIMEOUT;
    }

    public KinesisReadConfigurations apply(int maxRetries, long retryWaitTimeMs, long retryTimeoutMs) {
        return new KinesisReadConfigurations(maxRetries, retryWaitTimeMs, retryTimeoutMs);
    }

    public Option<Tuple3<Object, Object, Object>> unapply(KinesisReadConfigurations x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.maxRetries()), (Object)BoxesRunTime.boxToLong((long)x$0.retryWaitTimeMs()), (Object)BoxesRunTime.boxToLong((long)x$0.retryTimeoutMs())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KinesisReadConfigurations$() {
        MODULE$ = this;
        this.RETRY_MAX_ATTEMPTS_KEY = "spark.streaming.kinesis.retry.maxAttempts";
        this.RETRY_WAIT_TIME_KEY = "spark.streaming.kinesis.retry.waitTime";
        this.DEFAULT_MAX_RETRIES = 3;
        this.DEFAULT_RETRY_WAIT_TIME = "100ms";
        this.DEFAULT_RETRY_TIMEOUT = 10000;
    }
}

