/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.kinesis.DefaultCredentials$;
import org.apache.spark.streaming.kinesis.KinesisBackedBlockRDD;
import org.apache.spark.streaming.kinesis.KinesisInitialPosition;
import org.apache.spark.streaming.kinesis.KinesisInitialPositions;
import org.apache.spark.streaming.kinesis.KinesisInputDStream$;
import org.apache.spark.streaming.kinesis.KinesisReadConfigurations$;
import org.apache.spark.streaming.kinesis.KinesisReceiver;
import org.apache.spark.streaming.kinesis.SequenceNumberRanges;
import org.apache.spark.streaming.kinesis.SparkAWSCredentials;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r}h!B7o\u00019D\bBCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011\u0011\u0006\u0001\u0003\u0006\u0004%\t!a\u000b\t\u0015\u0005\r\u0003A!A!\u0002\u0013\ti\u0003\u0003\u0006\u0002F\u0001\u0011)\u0019!C\u0001\u0003WA!\"a\u0012\u0001\u0005\u0003\u0005\u000b\u0011BA\u0017\u0011)\tI\u0005\u0001BC\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003\u0017\u0002!\u0011!Q\u0001\n\u00055\u0002BCA'\u0001\t\u0015\r\u0011\"\u0001\u0002P!Q\u0011\u0011\f\u0001\u0003\u0002\u0003\u0006I!!\u0015\t\u0015\u0005m\u0003A!b\u0001\n\u0003\tY\u0003\u0003\u0006\u0002^\u0001\u0011\t\u0011)A\u0005\u0003[A!\"a\u0018\u0001\u0005\u000b\u0007I\u0011AA1\u0011)\tI\u0007\u0001B\u0001B\u0003%\u00111\r\u0005\u000b\u0003W\u0002!Q1A\u0005\u0002\u00055\u0004BCA>\u0001\t\u0005\t\u0015!\u0003\u0002p!Q\u0011Q\u0010\u0001\u0003\u0006\u0004%\t!a \t\u0015\u0005\u0005\u0006A!A!\u0002\u0013\t\t\t\u0003\u0006\u0002$\u0002\u0011)\u0019!C\u0001\u0003KC!\"!,\u0001\u0005\u0003\u0005\u000b\u0011BAT\u0011)\ty\u000b\u0001BC\u0002\u0013\u0005\u0011\u0011\u0017\u0005\u000b\u0003s\u0003!\u0011!Q\u0001\n\u0005M\u0006BCA^\u0001\t\u0015\r\u0011\"\u0001\u00022\"Q\u0011Q\u0018\u0001\u0003\u0002\u0003\u0006I!a-\t\u0015\u0005}\u0006A!b\u0001\n\u0003\t\t\r\u0003\u0006\u0002T\u0002\u0011\t\u0011)A\u0005\u0003\u0007D!\"!6\u0001\u0005\u000b\u0007I\u0011AAl\u0011)\ty\u000e\u0001B\u0001B\u0003%\u0011\u0011\u001c\u0005\u000b\u0003C\u0004!1!Q\u0001\f\u0005\r\bbBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\t\u0005+\u0001A\u0011\t9\u0003\u0018!9!\u0011\u000b\u0001\u0005B\tMsa\u0002B1]\"\u0005!1\r\u0004\u0007[:D\tA!\u001a\t\u000f\u0005=\u0018\u0005\"\u0001\u0003t\u00191!QO\u0011\u0001\u0005oBq!a<$\t\u0003\u0011I\bC\u0005\u0003\u0000\r\u0002\r\u0011\"\u0003\u0003\u0002\"I!QQ\u0012A\u0002\u0013%!q\u0011\u0005\t\u0005'\u001b\u0003\u0015)\u0003\u0003\u0004\"I\u0011\u0011F\u0012A\u0002\u0013%!Q\u0013\u0005\n\u00053\u001b\u0003\u0019!C\u0005\u00057C\u0001\"a\u0011$A\u0003&!q\u0013\u0005\n\u00037\u001a\u0003\u0019!C\u0005\u0005+C\u0011Ba($\u0001\u0004%IA!)\t\u0011\u0005u3\u0005)Q\u0005\u0005/C\u0011\"!\u0012$\u0001\u0004%IA!&\t\u0013\t\u00156\u00051A\u0005\n\t\u001d\u0006\u0002CA$G\u0001\u0006KAa&\t\u0013\u0005%3\u00051A\u0005\n\tU\u0005\"\u0003BVG\u0001\u0007I\u0011\u0002BW\u0011!\tYe\tQ!\n\t]\u0005\"CA'G\u0001\u0007I\u0011\u0002BY\u0011%\u0011)l\ta\u0001\n\u0013\u00119\f\u0003\u0005\u0002Z\r\u0002\u000b\u0015\u0002BZ\u0011%\tyf\ta\u0001\n\u0013\u0011Y\fC\u0005\u0003@\u000e\u0002\r\u0011\"\u0003\u0003B\"A\u0011\u0011N\u0012!B\u0013\u0011i\fC\u0005\u0003F\u000e\u0002\r\u0011\"\u0003\u0003H\"I!1Z\u0012A\u0002\u0013%!Q\u001a\u0005\t\u0005#\u001c\u0003\u0015)\u0003\u0003J\"I!1[\u0012A\u0002\u0013%\u0011\u0011\u0017\u0005\n\u0005+\u001c\u0003\u0019!C\u0005\u0005/D\u0001Ba7$A\u0003&\u00111\u0017\u0005\n\u0005;\u001c\u0003\u0019!C\u0005\u0003cC\u0011Ba8$\u0001\u0004%IA!9\t\u0011\t\u00158\u0005)Q\u0005\u0003gC\u0011Ba:$\u0001\u0004%I!!-\t\u0013\t%8\u00051A\u0005\n\t-\b\u0002\u0003BxG\u0001\u0006K!a-\t\u0013\u0005}6\u00051A\u0005\n\tE\b\"\u0003B{G\u0001\u0007I\u0011\u0002B|\u0011!\t\u0019n\tQ!\n\tM\b\"CAkG\u0001\u0007I\u0011\u0002B~\u0011%\u0011yp\ta\u0001\n\u0013\u0019\t\u0001\u0003\u0005\u0002`\u000e\u0002\u000b\u0015\u0002B\u007f\u0011\u001d\u0011yh\tC\u0001\u0007\u000bAqAa $\t\u0003\u0019Y\u0001C\u0004\u0002*\r\"\ta!\t\t\u000f\u0005m3\u0005\"\u0001\u0004&!9\u0011QI\u0012\u0005\u0002\r-\u0002bBA%G\u0011\u00051\u0011\u0007\u0005\b\u0003\u001b\u001aC\u0011AB\u001b\u0011\u001d\u0019Id\tC\u0001\u0007wAq!a\u0018$\t\u0003\u0019\u0019\u0007C\u0004\u0003F\u000e\"\ta!\u001b\t\u000f\r54\u0005\"\u0001\u0004p!91QO\u0012\u0005\u0002\r]\u0004bBB>G\u0011\u00051Q\u0010\u0005\b\u0003\u007f\u001bC\u0011ABA\u0011\u001d\t)n\tC\u0001\u0007\u000bCqa!#$\t\u0003\u0019Y\tC\u0004\u0004$\u000e\"\ta!*\t\u000f\rU6\u0005\"\u0003\u00048\"91\u0011Z\u0011\u0005\u0002\r-\u0007\u0002CBgC\u0011\u0005ana4\t\u0015\rU\u0017E1A\u0005\u00029\fY\u0003\u0003\u0005\u0004X\u0006\u0002\u000b\u0011BA\u0017\u0011)\u0019I.\tb\u0001\n\u0003q\u00171\u0006\u0005\t\u00077\f\u0003\u0015!\u0003\u0002.!Q1Q\\\u0011C\u0002\u0013\u0005a.a\u0014\t\u0011\r}\u0017\u0005)A\u0005\u0003#B!b!9\"\u0005\u0004%\tA\\A7\u0011!\u0019\u0019/\tQ\u0001\n\u0005=\u0004BCBsC\t\u0007I\u0011\u00018\u0002B\"A1q]\u0011!\u0002\u0013\t\u0019\r\u0003\u0006\u0004j\u0006\u0012\r\u0011\"\u0001o\u0003/D\u0001ba;\"A\u0003%\u0011\u0011\u001c\u0005\n\u0007[\f\u0013\u0011!C\u0005\u0007_\u00141cS5oKNL7/\u00138qkR$5\u000b\u001e:fC6T!a\u001c9\u0002\u000f-Lg.Z:jg*\u0011\u0011O]\u0001\ngR\u0014X-Y7j]\u001eT!a\u001d;\u0002\u000bM\u0004\u0018M]6\u000b\u0005U4\u0018AB1qC\u000eDWMC\u0001x\u0003\ry'oZ\u000b\u0004s\u0006\u00151C\u0001\u0001{!\u0011Yh0!\u0001\u000e\u0003qT!! 9\u0002\u000f\u0011\u001cHO]3b[&\u0011q\u0010 \u0002\u0015%\u0016\u001cW-\u001b<fe&s\u0007/\u001e;E'R\u0014X-Y7\u0011\t\u0005\r\u0011Q\u0001\u0007\u0001\t\u001d\t9\u0001\u0001b\u0001\u0003\u0017\u0011\u0011\u0001V\u0002\u0001#\u0011\ti!!\u0007\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q!!a\u0005\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005]\u0011\u0011\u0003\u0002\b\u001d>$\b.\u001b8h!\u0011\ty!a\u0007\n\t\u0005u\u0011\u0011\u0003\u0002\u0004\u0003:L\u0018\u0001B0tg\u000e\u0004B!a\t\u0002&5\t\u0001/C\u0002\u0002(A\u0014\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0002\u0015M$(/Z1n\u001d\u0006lW-\u0006\u0002\u0002.A!\u0011qFA\u001f\u001d\u0011\t\t$!\u000f\u0011\t\u0005M\u0012\u0011C\u0007\u0003\u0003kQA!a\u000e\u0002\n\u00051AH]8pizJA!a\u000f\u0002\u0012\u00051\u0001K]3eK\u001aLA!a\u0010\u0002B\t11\u000b\u001e:j]\u001eTA!a\u000f\u0002\u0012\u0005Y1\u000f\u001e:fC6t\u0015-\\3!\u0003-)g\u000e\u001a9pS:$XK\u001d7\u0002\u0019\u0015tG\r]8j]R,&\u000f\u001c\u0011\u0002\u0015I,w-[8o\u001d\u0006lW-A\u0006sK\u001eLwN\u001c(b[\u0016\u0004\u0013aD5oSRL\u0017\r\u001c)pg&$\u0018n\u001c8\u0016\u0005\u0005E\u0003\u0003BA*\u0003+j\u0011A\\\u0005\u0004\u0003/r'AF&j]\u0016\u001c\u0018n]%oSRL\u0017\r\u001c)pg&$\u0018n\u001c8\u0002!%t\u0017\u000e^5bYB{7/\u001b;j_:\u0004\u0013!E2iK\u000e\\\u0007o\\5oi\u0006\u0003\bOT1nK\u0006\u00112\r[3dWB|\u0017N\u001c;BaBt\u0015-\\3!\u0003I\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197\u0016\u0005\u0005\r\u0004\u0003BA\u0012\u0003KJ1!a\u001aq\u0005!!UO]1uS>t\u0017aE2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2\u0004\u0013!D0ti>\u0014\u0018mZ3MKZ,G.\u0006\u0002\u0002pA!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002vI\fqa\u001d;pe\u0006<W-\u0003\u0003\u0002z\u0005M$\u0001D*u_J\fw-\u001a'fm\u0016d\u0017AD0ti>\u0014\u0018mZ3MKZ,G\u000eI\u0001\u000f[\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s+\t\t\t\t\u0005\u0005\u0002\u0010\u0005\r\u0015qQA\u0001\u0013\u0011\t))!\u0005\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BAE\u0003;k!!a#\u000b\t\u00055\u0015qR\u0001\u0006[>$W\r\u001c\u0006\u0004_\u0006E%\u0002BAJ\u0003+\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0005\u0003/\u000bI*A\u0005b[\u0006TxN\\1xg*\u0011\u00111T\u0001\u0004G>l\u0017\u0002BAP\u0003\u0017\u0013aAU3d_J$\u0017aD7fgN\fw-\u001a%b]\u0012dWM\u001d\u0011\u0002\u0019-Lg.Z:jg\u000e\u0013X\rZ:\u0016\u0005\u0005\u001d\u0006\u0003BA*\u0003SK1!a+o\u0005M\u0019\u0006/\u0019:l\u0003^\u001b6I]3eK:$\u0018.\u00197t\u00035Y\u0017N\\3tSN\u001c%/\u001a3tA\u0005iA-\u001f8b[>$%i\u0011:fIN,\"!a-\u0011\r\u0005=\u0011QWAT\u0013\u0011\t9,!\u0005\u0003\r=\u0003H/[8o\u00039!\u0017P\\1n_\u0012\u00135I]3eg\u0002\nqb\u00197pk\u0012<\u0016\r^2i\u0007J,Gm]\u0001\u0011G2|W\u000fZ,bi\u000eD7I]3eg\u0002\nA\"\\3ue&\u001c7\u000fT3wK2,\"!a1\u0011\t\u0005\u0015\u0017qZ\u0007\u0003\u0003\u000fTA!!3\u0002L\u0006Q\u0011N\u001c;fe\u001a\f7-Z:\u000b\t\u00055\u0017qR\u0001\b[\u0016$(/[2t\u0013\u0011\t\t.a2\u0003\u00195+GO]5dg2+g/\u001a7\u0002\u001b5,GO]5dg2+g/\u001a7!\u0003aiW\r\u001e:jGN,e.\u00192mK\u0012$\u0015.\\3og&|gn]\u000b\u0003\u00033\u0004b!a\f\u0002\\\u00065\u0012\u0002BAo\u0003\u0003\u00121aU3u\u0003eiW\r\u001e:jGN,e.\u00192mK\u0012$\u0015.\\3og&|gn\u001d\u0011\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002f\u0006-\u0018\u0011A\u0007\u0003\u0003OTA!!;\u0002\u0012\u00059!/\u001a4mK\u000e$\u0018\u0002BAw\u0003O\u0014\u0001b\u00117bgN$\u0016mZ\u0001\u0007y%t\u0017\u000e\u001e \u0015=\u0005M\u0018\u0011`A~\u0003{\fyP!\u0001\u0003\u0004\t\u0015!q\u0001B\u0005\u0005\u0017\u0011iAa\u0004\u0003\u0012\tMA\u0003BA{\u0003o\u0004R!a\u0015\u0001\u0003\u0003Aq!!9\u001e\u0001\b\t\u0019\u000fC\u0004\u0002 u\u0001\r!!\t\t\u000f\u0005%R\u00041\u0001\u0002.!9\u0011QI\u000fA\u0002\u00055\u0002bBA%;\u0001\u0007\u0011Q\u0006\u0005\b\u0003\u001bj\u0002\u0019AA)\u0011\u001d\tY&\ba\u0001\u0003[Aq!a\u0018\u001e\u0001\u0004\t\u0019\u0007C\u0004\u0002lu\u0001\r!a\u001c\t\u000f\u0005uT\u00041\u0001\u0002\u0002\"9\u00111U\u000fA\u0002\u0005\u001d\u0006bBAX;\u0001\u0007\u00111\u0017\u0005\b\u0003wk\u0002\u0019AAZ\u0011\u001d\ty,\ba\u0001\u0003\u0007Dq!!6\u001e\u0001\u0004\tI.\u0001\bde\u0016\fG/\u001a\"m_\u000e\\'\u000b\u0012#\u0015\r\te!Q\u0005B\u0018!\u0019\u0011YB!\t\u0002\u00025\u0011!Q\u0004\u0006\u0004\u0005?\u0011\u0018a\u0001:eI&!!1\u0005B\u000f\u0005\r\u0011F\t\u0012\u0005\b\u0005Oq\u0002\u0019\u0001B\u0015\u0003\u0011!\u0018.\\3\u0011\t\u0005\r\"1F\u0005\u0004\u0005[\u0001(\u0001\u0002+j[\u0016DqA!\r\u001f\u0001\u0004\u0011\u0019$\u0001\u0006cY>\u001c7.\u00138g_N\u0004bA!\u000e\u0003@\t\u0015c\u0002\u0002B\u001c\u0005wqA!a\r\u0003:%\u0011\u00111C\u0005\u0005\u0005{\t\t\"A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0005#1\t\u0002\u0004'\u0016\f(\u0002\u0002B\u001f\u0003#\u0001BAa\u0012\u0003N5\u0011!\u0011\n\u0006\u0004\u0005\u0017\u0002\u0018!C:dQ\u0016$W\u000f\\3s\u0013\u0011\u0011yE!\u0013\u0003#I+7-Z5wK\u0012\u0014En\\2l\u0013:4w.A\u0006hKR\u0014VmY3jm\u0016\u0014HC\u0001B+!\u0019\u00119F!\u0018\u0002\u00025\u0011!\u0011\f\u0006\u0004\u00057\u0002\u0018\u0001\u0003:fG\u0016Lg/\u001a:\n\t\t}#\u0011\f\u0002\t%\u0016\u001cW-\u001b<fe\u0006\u00192*\u001b8fg&\u001c\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0019\u00111K\u0011\u0014\u000b\u0005\u00129G!\u001c\u0011\t\u0005=!\u0011N\u0005\u0005\u0005W\n\tB\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003\u001f\u0011y'\u0003\u0003\u0003r\u0005E!\u0001D*fe&\fG.\u001b>bE2,GC\u0001B2\u0005\u001d\u0011U/\u001b7eKJ\u001c2a\tB4)\t\u0011Y\bE\u0002\u0003~\rj\u0011!I\u0001\u0011gR\u0014X-Y7j]\u001e\u001cuN\u001c;fqR,\"Aa!\u0011\r\u0005=\u0011QWA\u0011\u0003Q\u0019HO]3b[&twmQ8oi\u0016DHo\u0018\u0013fcR!!\u0011\u0012BH!\u0011\tyAa#\n\t\t5\u0015\u0011\u0003\u0002\u0005+:LG\u000fC\u0005\u0003\u0012\u001a\n\t\u00111\u0001\u0003\u0004\u0006\u0019\u0001\u0010J\u0019\u0002#M$(/Z1nS:<7i\u001c8uKb$\b%\u0006\u0002\u0003\u0018B1\u0011qBA[\u0003[\tab\u001d;sK\u0006lg*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0003\n\nu\u0005\"\u0003BIS\u0005\u0005\t\u0019\u0001BL\u0003U\u0019\u0007.Z2la>Lg\u000e^!qa:\u000bW.Z0%KF$BA!#\u0003$\"I!\u0011\u0013\u0017\u0002\u0002\u0003\u0007!qS\u0001\u0010K:$\u0007o\\5oiV\u0013Hn\u0018\u0013fcR!!\u0011\u0012BU\u0011%\u0011\tjLA\u0001\u0002\u0004\u00119*\u0001\bsK\u001eLwN\u001c(b[\u0016|F%Z9\u0015\t\t%%q\u0016\u0005\n\u0005#\u0013\u0014\u0011!a\u0001\u0005/+\"Aa-\u0011\r\u0005=\u0011QWA)\u0003MIg.\u001b;jC2\u0004vn]5uS>tw\fJ3r)\u0011\u0011II!/\t\u0013\tEU'!AA\u0002\tMVC\u0001B_!\u0019\ty!!.\u0002d\u000512\r[3dWB|\u0017N\u001c;J]R,'O^1m?\u0012*\u0017\u000f\u0006\u0003\u0003\n\n\r\u0007\"\u0003BIq\u0005\u0005\t\u0019\u0001B_\u00031\u0019Ho\u001c:bO\u0016dUM^3m+\t\u0011I\r\u0005\u0004\u0002\u0010\u0005U\u0016qN\u0001\u0011gR|'/Y4f\u0019\u00164X\r\\0%KF$BA!#\u0003P\"I!\u0011S\u001e\u0002\u0002\u0003\u0007!\u0011Z\u0001\u000egR|'/Y4f\u0019\u00164X\r\u001c\u0011\u0002)-Lg.Z:jg\u000e\u0013X\rZ:Qe>4\u0018\u000eZ3s\u0003aY\u0017N\\3tSN\u001c%/\u001a3t!J|g/\u001b3fe~#S-\u001d\u000b\u0005\u0005\u0013\u0013I\u000eC\u0005\u0003\u0012z\n\t\u00111\u0001\u00024\u0006)2.\u001b8fg&\u001c8I]3egB\u0013xN^5eKJ\u0004\u0013!\u00063z]\u0006lw\u000e\u0012\"De\u0016$7\u000f\u0015:pm&$WM]\u0001\u001aIft\u0017-\\8E\u0005\u000e\u0013X\rZ:Qe>4\u0018\u000eZ3s?\u0012*\u0017\u000f\u0006\u0003\u0003\n\n\r\b\"\u0003BI\u0003\u0006\u0005\t\u0019AAZ\u0003Y!\u0017P\\1n_\u0012\u00135I]3egB\u0013xN^5eKJ\u0004\u0013aF2m_V$w+\u0019;dQ\u000e\u0013X\rZ:Qe>4\u0018\u000eZ3s\u0003m\u0019Gn\\;e/\u0006$8\r[\"sK\u0012\u001c\bK]8wS\u0012,'o\u0018\u0013fcR!!\u0011\u0012Bw\u0011%\u0011\t\nRA\u0001\u0002\u0004\t\u0019,\u0001\rdY>,HmV1uG\"\u001c%/\u001a3t!J|g/\u001b3fe\u0002*\"Aa=\u0011\r\u0005=\u0011QWAb\u0003AiW\r\u001e:jGNdUM^3m?\u0012*\u0017\u000f\u0006\u0003\u0003\n\ne\b\"\u0003BI\u000f\u0006\u0005\t\u0019\u0001Bz+\t\u0011i\u0010\u0005\u0004\u0002\u0010\u0005U\u0016\u0011\\\u0001\u001d[\u0016$(/[2t\u000b:\f'\r\\3e\t&lWM\\:j_:\u001cx\fJ3r)\u0011\u0011Iia\u0001\t\u0013\tE%*!AA\u0002\tuH\u0003\u0002B>\u0007\u000fAqa!\u0003M\u0001\u0004\t\t#A\u0002tg\u000e$BAa\u001f\u0004\u000e!91qB'A\u0002\rE\u0011\u0001\u00026tg\u000e\u0004Baa\u0005\u0004\u001e5\u00111Q\u0003\u0006\u0005\u0007/\u0019I\"\u0001\u0003kCZ\f'bAB\u000ea\u0006\u0019\u0011\r]5\n\t\r}1Q\u0003\u0002\u0015\u0015\u00064\u0018m\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0015\t\tm41\u0005\u0005\b\u0003Sq\u0005\u0019AA\u0017)\u0011\u0011Yha\n\t\u000f\r%r\n1\u0001\u0002.\u00059\u0011\r\u001d9OC6,G\u0003\u0002B>\u0007[Aqaa\fQ\u0001\u0004\ti#A\u0002ve2$BAa\u001f\u00044!9\u0011\u0011J)A\u0002\u00055B\u0003\u0002B>\u0007oAq!!\u0014S\u0001\u0004\t\t&A\fj]&$\u0018.\u00197Q_NLG/[8o\u0013:\u001cFO]3b[R!!1PB\u001f\u0011\u001d\tie\u0015a\u0001\u0007\u007f\u0001Ba!\u0011\u0004P5\u001111\t\u0006\u0005\u0007\u000b\u001a9%\u0001\u0004x_J\\WM\u001d\u0006\u0005\u0007\u0013\u001aY%A\u0002mS\nTAa!\u0014\u0002\u0010\u0006i1\r\\5f]Rd\u0017N\u0019:befLAa!\u0015\u0004D\t9\u0012J\\5uS\u0006d\u0007k\\:ji&|g.\u00138TiJ,\u0017-\u001c\u0015\b'\u000eU31LB0!\u0011\tyaa\u0016\n\t\re\u0013\u0011\u0003\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAB/\u0003q*8/\u001a\u0011j]&$\u0018.\u00197Q_NLG/[8oQ%t\u0017\u000e^5bYB{7/\u001b;j_:T\u0004eS5oKNL7/\u00138ji&\fG\u000eU8tSRLwN\\\u0015\"\u0005\r\u0005\u0014!\u0002\u001a/g9\u0002D\u0003\u0002B>\u0007KBqaa\u001aU\u0001\u0004\t\u0019'\u0001\u0005j]R,'O^1m)\u0011\u0011Yha\u001b\t\u000f\t\u0015W\u000b1\u0001\u0002p\u0005\u00112.\u001b8fg&\u001c8I]3eK:$\u0018.\u00197t)\u0011\u0011Yh!\u001d\t\u000f\rMd\u000b1\u0001\u0002(\u0006Y1M]3eK:$\u0018.\u00197t\u0003M!\u0017P\\1n_\u0012\u00135I]3eK:$\u0018.\u00197t)\u0011\u0011Yh!\u001f\t\u000f\rMt\u000b1\u0001\u0002(\u0006)2\r\\8vI^\u000bGo\u00195De\u0016$WM\u001c;jC2\u001cH\u0003\u0002B>\u0007\u007fBqaa\u001dY\u0001\u0004\t9\u000b\u0006\u0003\u0003|\r\r\u0005bBA`3\u0002\u0007\u00111\u0019\u000b\u0005\u0005w\u001a9\tC\u0004\u0002Vj\u0003\r!!7\u0002/\t,\u0018\u000e\u001c3XSRDW*Z:tC\u001e,\u0007*\u00198eY\u0016\u0014X\u0003BBG\u0007+#Baa$\u0004\u001eR!1\u0011SBL!\u0015\t\u0019\u0006ABJ!\u0011\t\u0019a!&\u0005\u000f\u0005\u001d1L1\u0001\u0002\f!I1\u0011T.\u0002\u0002\u0003\u000f11T\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004CBAs\u0003W\u001c\u0019\nC\u0004\u0004 n\u0003\ra!)\u0002\u000f!\fg\u000e\u001a7feBA\u0011qBAB\u0003\u000f\u001b\u0019*A\u0003ck&dG\r\u0006\u0002\u0004(B)\u00111\u000b\u0001\u0004*B1\u0011qBBV\u0007_KAa!,\u0002\u0012\t)\u0011I\u001d:bsB!\u0011qBBY\u0013\u0011\u0019\u0019,!\u0005\u0003\t\tKH/Z\u0001\u0011O\u0016$(+Z9vSJ,G\rU1sC6,Ba!/\u0004>R111XB`\u0007\u000b\u0004B!a\u0001\u0004>\u00129\u0011qA/C\u0002\u0005-\u0001bBBa;\u0002\u000711Y\u0001\u0006a\u0006\u0014\u0018-\u001c\t\u0007\u0003\u001f\t)la/\t\u000f\r\u001dW\f1\u0001\u0002.\u0005I\u0001/\u0019:b[:\u000bW.Z\u0001\bEVLG\u000eZ3s+\t\u0011Y(A\u000beK\u001a\fW\u000f\u001c;NKN\u001c\u0018mZ3IC:$G.\u001a:\u0015\t\r%6\u0011\u001b\u0005\b\u0007'|\u0006\u0019AAD\u0003\u0019\u0011XmY8sI\u0006aB)\u0012$B+2#vlS%O\u000bNK5kX#O\tB{\u0015J\u0014+`+Jc\u0015!\b#F\r\u0006+F\nV0L\u0013:+5+S*`\u000b:#\u0005kT%O)~+&\u000b\u0014\u0011\u00027\u0011+e)Q+M)~[\u0015JT#T\u0013N{&+R$J\u001f:{f*Q'F\u0003q!UIR!V\u0019R{6*\u0013(F'&\u001bvLU#H\u0013>suLT!N\u000b\u0002\n\u0001\u0004R#G\u0003VcEkX%O\u0013RK\u0015\tT0Q\u001fNKE+S(O\u0003e!UIR!V\u0019R{\u0016JT%U\u0013\u0006cu\fU(T\u0013RKuJ\u0014\u0011\u0002+\u0011+e)Q+M)~\u001bFk\u0014*B\u000f\u0016{F*\u0012,F\u0019\u00061B)\u0012$B+2#vl\u0015+P%\u0006;Ui\u0018'F-\u0016c\u0005%A\u000bE\u000b\u001a\u000bU\u000b\u0014+`\u001b\u0016#&+S\"T?2+e+\u0012'\u0002-\u0011+e)Q+M)~kU\t\u0016*J\u0007N{F*\u0012,F\u0019\u0002\n!\u0005R#G\u0003VcEkX'F)JK5iU0F\u001d\u0006\u0013E*\u0012#`\t&kUIT*J\u001f:\u001b\u0016a\t#F\r\u0006+F\nV0N\u000bR\u0013\u0016jQ*`\u000b:\u000b%\tT#E?\u0012KU*\u0012(T\u0013>s5\u000bI\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004rB!11_B~\u001b\t\u0019)P\u0003\u0003\u0004x\u000ee\u0018\u0001\u00027b]\u001eT!aa\u0006\n\t\ru8Q\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class KinesisInputDStream<T>
extends ReceiverInputDStream<T> {
    private final String streamName;
    private final String endpointUrl;
    private final String regionName;
    private final KinesisInitialPosition initialPosition;
    private final String checkpointAppName;
    private final Duration checkpointInterval;
    private final StorageLevel _storageLevel;
    private final Function1<Record, T> messageHandler;
    private final SparkAWSCredentials kinesisCreds;
    private final Option<SparkAWSCredentials> dynamoDBCreds;
    private final Option<SparkAWSCredentials> cloudWatchCreds;
    private final MetricsLevel metricsLevel;
    private final Set<String> metricsEnabledDimensions;
    private final ClassTag<T> evidence$1;

    public static Builder builder() {
        return KinesisInputDStream$.MODULE$.builder();
    }

    public String streamName() {
        return this.streamName;
    }

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public String regionName() {
        return this.regionName;
    }

    public KinesisInitialPosition initialPosition() {
        return this.initialPosition;
    }

    public String checkpointAppName() {
        return this.checkpointAppName;
    }

    public Duration checkpointInterval() {
        return this.checkpointInterval;
    }

    public StorageLevel _storageLevel() {
        return this._storageLevel;
    }

    public Function1<Record, T> messageHandler() {
        return this.messageHandler;
    }

    public SparkAWSCredentials kinesisCreds() {
        return this.kinesisCreds;
    }

    public Option<SparkAWSCredentials> dynamoDBCreds() {
        return this.dynamoDBCreds;
    }

    public Option<SparkAWSCredentials> cloudWatchCreds() {
        return this.cloudWatchCreds;
    }

    public MetricsLevel metricsLevel() {
        return this.metricsLevel;
    }

    public Set<String> metricsEnabledDimensions() {
        return this.metricsEnabledDimensions;
    }

    public RDD<T> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        boolean allBlocksHaveRanges = ((IterableLike)blockInfos.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.metadataOption(), Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        if (allBlocksHaveRanges) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.blockId(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            SequenceNumberRanges[] seqNumRanges = (SequenceNumberRanges[])((TraversableOnce)blockInfos.map((Function1 & Serializable & scala.Serializable)x$4 -> (SequenceNumberRanges)x$4.metadataOption().get(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SequenceNumberRanges.class));
            boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isBlockIdValid()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Creating KinesisBackedBlockRDD for ").append(time).append(" with ").append(seqNumRanges.length).append(" ").append("seq number ranges: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])seqNumRanges)).mkString(", ")).append(" ").toString());
            return new KinesisBackedBlockRDD<T>(this.context().sc(), this.regionName(), this.endpointUrl(), blockIds, seqNumRanges, isBlockIdValid, this.messageHandler(), this.kinesisCreds(), KinesisReadConfigurations$.MODULE$.apply(this.ssc()), this.evidence$1);
        }
        this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Kinesis sequence number information was not present with some block metadata, it may not be possible to recover from failures");
        return super.createBlockRDD(time, blockInfos);
    }

    public Receiver<T> getReceiver() {
        return new KinesisReceiver<T>(this.streamName(), this.endpointUrl(), this.regionName(), this.initialPosition(), this.checkpointAppName(), this.checkpointInterval(), this._storageLevel(), this.messageHandler(), this.kinesisCreds(), this.dynamoDBCreds(), this.cloudWatchCreds(), this.metricsLevel(), this.metricsEnabledDimensions());
    }

    public KinesisInputDStream(StreamingContext _ssc, String streamName, String endpointUrl, String regionName, KinesisInitialPosition initialPosition, String checkpointAppName, Duration checkpointInterval, StorageLevel _storageLevel, Function1<Record, T> messageHandler, SparkAWSCredentials kinesisCreds, Option<SparkAWSCredentials> dynamoDBCreds, Option<SparkAWSCredentials> cloudWatchCreds, MetricsLevel metricsLevel, Set<String> metricsEnabledDimensions, ClassTag<T> evidence$1) {
        this.streamName = streamName;
        this.endpointUrl = endpointUrl;
        this.regionName = regionName;
        this.initialPosition = initialPosition;
        this.checkpointAppName = checkpointAppName;
        this.checkpointInterval = checkpointInterval;
        this._storageLevel = _storageLevel;
        this.messageHandler = messageHandler;
        this.kinesisCreds = kinesisCreds;
        this.dynamoDBCreds = dynamoDBCreds;
        this.cloudWatchCreds = cloudWatchCreds;
        this.metricsLevel = metricsLevel;
        this.metricsEnabledDimensions = metricsEnabledDimensions;
        this.evidence$1 = evidence$1;
        super(_ssc, evidence$1);
    }

    public static class Builder {
        private Option<StreamingContext> streamingContext = None$.MODULE$;
        private Option<String> streamName = None$.MODULE$;
        private Option<String> checkpointAppName = None$.MODULE$;
        private Option<String> endpointUrl = None$.MODULE$;
        private Option<String> regionName = None$.MODULE$;
        private Option<KinesisInitialPosition> initialPosition = None$.MODULE$;
        private Option<Duration> checkpointInterval = None$.MODULE$;
        private Option<StorageLevel> storageLevel = None$.MODULE$;
        private Option<SparkAWSCredentials> kinesisCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> dynamoDBCredsProvider = None$.MODULE$;
        private Option<SparkAWSCredentials> cloudWatchCredsProvider = None$.MODULE$;
        private Option<MetricsLevel> metricsLevel = None$.MODULE$;
        private Option<Set<String>> metricsEnabledDimensions = None$.MODULE$;

        private Option<StreamingContext> streamingContext() {
            return this.streamingContext;
        }

        private void streamingContext_$eq(Option<StreamingContext> x$1) {
            this.streamingContext = x$1;
        }

        private Option<String> streamName() {
            return this.streamName;
        }

        private void streamName_$eq(Option<String> x$1) {
            this.streamName = x$1;
        }

        private Option<String> checkpointAppName() {
            return this.checkpointAppName;
        }

        private void checkpointAppName_$eq(Option<String> x$1) {
            this.checkpointAppName = x$1;
        }

        private Option<String> endpointUrl() {
            return this.endpointUrl;
        }

        private void endpointUrl_$eq(Option<String> x$1) {
            this.endpointUrl = x$1;
        }

        private Option<String> regionName() {
            return this.regionName;
        }

        private void regionName_$eq(Option<String> x$1) {
            this.regionName = x$1;
        }

        private Option<KinesisInitialPosition> initialPosition() {
            return this.initialPosition;
        }

        private void initialPosition_$eq(Option<KinesisInitialPosition> x$1) {
            this.initialPosition = x$1;
        }

        private Option<Duration> checkpointInterval() {
            return this.checkpointInterval;
        }

        private void checkpointInterval_$eq(Option<Duration> x$1) {
            this.checkpointInterval = x$1;
        }

        private Option<StorageLevel> storageLevel() {
            return this.storageLevel;
        }

        private void storageLevel_$eq(Option<StorageLevel> x$1) {
            this.storageLevel = x$1;
        }

        private Option<SparkAWSCredentials> kinesisCredsProvider() {
            return this.kinesisCredsProvider;
        }

        private void kinesisCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.kinesisCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> dynamoDBCredsProvider() {
            return this.dynamoDBCredsProvider;
        }

        private void dynamoDBCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.dynamoDBCredsProvider = x$1;
        }

        private Option<SparkAWSCredentials> cloudWatchCredsProvider() {
            return this.cloudWatchCredsProvider;
        }

        private void cloudWatchCredsProvider_$eq(Option<SparkAWSCredentials> x$1) {
            this.cloudWatchCredsProvider = x$1;
        }

        private Option<MetricsLevel> metricsLevel() {
            return this.metricsLevel;
        }

        private void metricsLevel_$eq(Option<MetricsLevel> x$1) {
            this.metricsLevel = x$1;
        }

        private Option<Set<String>> metricsEnabledDimensions() {
            return this.metricsEnabledDimensions;
        }

        private void metricsEnabledDimensions_$eq(Option<Set<String>> x$1) {
            this.metricsEnabledDimensions = x$1;
        }

        public Builder streamingContext(StreamingContext ssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)ssc));
            return this;
        }

        public Builder streamingContext(JavaStreamingContext jssc) {
            this.streamingContext_$eq((Option<StreamingContext>)Option$.MODULE$.apply((Object)jssc.ssc()));
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName_$eq((Option<String>)Option$.MODULE$.apply((Object)streamName));
            return this;
        }

        public Builder checkpointAppName(String appName) {
            this.checkpointAppName_$eq((Option<String>)Option$.MODULE$.apply((Object)appName));
            return this;
        }

        public Builder endpointUrl(String url) {
            this.endpointUrl_$eq((Option<String>)Option$.MODULE$.apply((Object)url));
            return this;
        }

        public Builder regionName(String regionName) {
            this.regionName_$eq((Option<String>)Option$.MODULE$.apply((Object)regionName));
            return this;
        }

        public Builder initialPosition(KinesisInitialPosition initialPosition) {
            this.initialPosition_$eq((Option<KinesisInitialPosition>)Option$.MODULE$.apply((Object)initialPosition));
            return this;
        }

        public Builder initialPositionInStream(InitialPositionInStream initialPosition) {
            this.initialPosition_$eq((Option<KinesisInitialPosition>)Option$.MODULE$.apply((Object)KinesisInitialPositions.fromKinesisInitialPosition(initialPosition)));
            return this;
        }

        public Builder checkpointInterval(Duration interval) {
            this.checkpointInterval_$eq((Option<Duration>)Option$.MODULE$.apply((Object)interval));
            return this;
        }

        public Builder storageLevel(StorageLevel storageLevel) {
            this.storageLevel_$eq((Option<StorageLevel>)Option$.MODULE$.apply((Object)storageLevel));
            return this;
        }

        public Builder kinesisCredentials(SparkAWSCredentials credentials) {
            this.kinesisCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder dynamoDBCredentials(SparkAWSCredentials credentials) {
            this.dynamoDBCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder cloudWatchCredentials(SparkAWSCredentials credentials) {
            this.cloudWatchCredsProvider_$eq((Option<SparkAWSCredentials>)Option$.MODULE$.apply((Object)credentials));
            return this;
        }

        public Builder metricsLevel(MetricsLevel metricsLevel) {
            this.metricsLevel_$eq((Option<MetricsLevel>)Option$.MODULE$.apply((Object)metricsLevel));
            return this;
        }

        public Builder metricsEnabledDimensions(Set<String> metricsEnabledDimensions) {
            this.metricsEnabledDimensions_$eq((Option<Set<String>>)Option$.MODULE$.apply(metricsEnabledDimensions));
            return this;
        }

        public <T> KinesisInputDStream<T> buildWithMessageHandler(Function1<Record, T> handler, ClassTag<T> evidence$2) {
            StreamingContext ssc = this.getRequiredParam(this.streamingContext(), "streamingContext");
            return new KinesisInputDStream<T>(ssc, this.getRequiredParam(this.streamName(), "streamName"), (String)this.endpointUrl().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_ENDPOINT_URL()), (String)this.regionName().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_KINESIS_REGION_NAME()), (KinesisInitialPosition)this.initialPosition().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_INITIAL_POSITION()), this.getRequiredParam(this.checkpointAppName(), "checkpointAppName"), (Duration)this.checkpointInterval().getOrElse((Function0 & Serializable & scala.Serializable)() -> ssc.graph().batchDuration()), (StorageLevel)this.storageLevel().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_STORAGE_LEVEL()), (Function1)ssc.sc().clean(handler, ssc.sc().clean$default$2()), (SparkAWSCredentials)this.kinesisCredsProvider().getOrElse((Function0 & Serializable & scala.Serializable)() -> DefaultCredentials$.MODULE$), this.dynamoDBCredsProvider(), this.cloudWatchCredsProvider(), (MetricsLevel)this.metricsLevel().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_METRICS_LEVEL()), (Set<String>)((Set)this.metricsEnabledDimensions().getOrElse((Function0 & Serializable & scala.Serializable)() -> KinesisInputDStream$.MODULE$.DEFAULT_METRICS_ENABLED_DIMENSIONS())), evidence$2);
        }

        public KinesisInputDStream<byte[]> build() {
            return this.buildWithMessageHandler((Function1 & Serializable & scala.Serializable)record -> KinesisInputDStream$.MODULE$.defaultMessageHandler((Record)record), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        }

        private <T> T getRequiredParam(Option<T> param, String paramName) {
            return (T)param.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(41).append("No value provided for required parameter ").append(paramName).toString());
            });
        }
    }
}

