/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.Checkpoint$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005uc!B\u0001\u0003\u0001\tQ!\u0001E\"iK\u000e\\\u0007o\\5oi^\u0013\u0018\u000e^3s\u0015\t\u0019A!A\u0005tiJ,\u0017-\\5oO*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0014\u001b\u0005!\u0011B\u0001\u000b\u0005\u0005\u001daunZ4j]\u001eD\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\rU>\u0014w)\u001a8fe\u0006$xN]\u0002\u0001!\tIB$D\u0001\u001b\u0015\tY\"!A\u0005tG\",G-\u001e7fe&\u0011QD\u0007\u0002\r\u0015>\u0014w)\u001a8fe\u0006$xN\u001d\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005!1m\u001c8g!\t\u0011\u0012%\u0003\u0002#\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005i1\r[3dWB|\u0017N\u001c;ESJ\u0004\"AJ\u0015\u000f\u000519\u0013B\u0001\u0015\u000e\u0003\u0019\u0001&/\u001a3fM&\u0011!f\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!j\u0001\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u00020g5\t\u0001G\u0003\u0002 c)\u0011!GB\u0001\u0007Q\u0006$wn\u001c9\n\u0005Q\u0002$!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u00037\u0001\u0011\u0005q'\u0001\u0004=S:LGO\u0010\u000b\u0006qiZD(\u0010\t\u0003s\u0001i\u0011A\u0001\u0005\u0006-U\u0002\r\u0001\u0007\u0005\u0006?U\u0002\r\u0001\t\u0005\u0006IU\u0002\r!\n\u0005\u0006[U\u0002\rA\f\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001A\u00031i\u0015\tW0B)R+U\n\u0015+T+\u0005\t\u0005C\u0001\u0007C\u0013\t\u0019UBA\u0002J]RDa!\u0012\u0001!\u0002\u0013\t\u0015!D'B1~\u000bE\u000bV#N!R\u001b\u0006\u0005C\u0004H\u0001\t\u0007I\u0011\u0001%\u0002\u0011\u0015DXmY;u_J,\u0012!\u0013\t\u0003\u0015Fk\u0011a\u0013\u0006\u0003\u00196\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqu*\u0001\u0003vi&d'\"\u0001)\u0002\t)\fg/Y\u0005\u0003%.\u0013q\"\u0012=fGV$xN]*feZL7-\u001a\u0005\u0007)\u0002\u0001\u000b\u0011B%\u0002\u0013\u0015DXmY;u_J\u0004\u0003b\u0002,\u0001\u0005\u0004%\taV\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037\u0012\t!![8\n\u0005uS&\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0011\u0019y\u0006\u0001)A\u00051\u0006\t2m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0011\t\u000f\u0005\u0004\u0001\u0019!C\u0005E\u000691\u000f^8qa\u0016$W#A2\u0011\u00051!\u0017BA3\u000e\u0005\u001d\u0011un\u001c7fC:Dqa\u001a\u0001A\u0002\u0013%\u0001.A\u0006ti>\u0004\b/\u001a3`I\u0015\fHCA5m!\ta!.\u0003\u0002l\u001b\t!QK\\5u\u0011\u001dig-!AA\u0002\r\f1\u0001\u001f\u00132\u0011\u0019y\u0007\u0001)Q\u0005G\u0006A1\u000f^8qa\u0016$\u0007\u0005C\u0005r\u0001\u0001\u0007\t\u0019!C\u0005e\u0006\u0019am]0\u0016\u0003M\u0004\"\u0001^<\u000e\u0003UT!A^\u0019\u0002\u0005\u0019\u001c\u0018B\u0001=v\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\nu\u0002\u0001\r\u00111A\u0005\nm\fqAZ:`?\u0012*\u0017\u000f\u0006\u0002jy\"9Q._A\u0001\u0002\u0004\u0019\bB\u0002@\u0001A\u0003&1/\u0001\u0003gg~\u0003cABA\u0001\u0001\u0001\t\u0019A\u0001\fDQ\u0016\u001c7\u000e]8j]R<&/\u001b;f\u0011\u0006tG\r\\3s'\u0015y\u0018QAA\t!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006\u001f\u0006!A.\u00198h\u0013\u0011\ty!!\u0003\u0003\r=\u0013'.Z2u!\u0011\t9!a\u0005\n\t\u0005U\u0011\u0011\u0002\u0002\t%Vtg.\u00192mK\"Q\u0011\u0011D@\u0003\u0002\u0003\u0006I!a\u0007\u0002\u001d\rDWmY6q_&tG\u000fV5nKB\u0019\u0011(!\b\n\u0007\u0005}!A\u0001\u0003US6,\u0007BCA\u0012\u007f\n\u0005\t\u0015!\u0003\u0002&\u0005)!-\u001f;fgB)A\"a\n\u0002,%\u0019\u0011\u0011F\u0007\u0003\u000b\u0005\u0013(/Y=\u0011\u00071\ti#C\u0002\u000205\u0011AAQ=uK\"1ag C\u0001\u0003g!b!!\u000e\u0002:\u0005m\u0002cAA\u001c\u007f6\t\u0001\u0001\u0003\u0005\u0002\u001a\u0005E\u0002\u0019AA\u000e\u0011!\t\u0019#!\rA\u0002\u0005\u0015\u0002bBA \u007f\u0012\u0005\u0011\u0011I\u0001\u0004eVtG#A5\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005)qO]5uKR\u0019\u0011.!\u0013\t\u0011\u0005-\u00131\ta\u0001\u0003\u001b\n!b\u00195fG.\u0004x.\u001b8u!\rI\u0014qJ\u0005\u0004\u0003#\u0012!AC\"iK\u000e\\\u0007o\\5oi\"9\u0011Q\u000b\u0001\u0005\u0002\u0005\u0005\u0013\u0001B:u_BDQA\u001e\u0001\u0005\nIDq!a\u0017\u0001\t\u0013\t\t%A\u0003sKN,G\u000f")
public class CheckpointWriter
implements Logging {
    public final JobGenerator org$apache$spark$streaming$CheckpointWriter$$jobGenerator;
    public final String org$apache$spark$streaming$CheckpointWriter$$checkpointDir;
    private final Configuration hadoopConf;
    private final int MAX_ATTEMPTS;
    private final ExecutorService executor;
    private final CompressionCodec compressionCodec;
    private boolean org$apache$spark$streaming$CheckpointWriter$$stopped;
    private FileSystem fs_;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int MAX_ATTEMPTS() {
        return this.MAX_ATTEMPTS;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public CompressionCodec compressionCodec() {
        return this.compressionCodec;
    }

    public boolean org$apache$spark$streaming$CheckpointWriter$$stopped() {
        return this.org$apache$spark$streaming$CheckpointWriter$$stopped;
    }

    private void org$apache$spark$streaming$CheckpointWriter$$stopped_$eq(boolean x$1) {
        this.org$apache$spark$streaming$CheckpointWriter$$stopped = x$1;
    }

    private FileSystem fs_() {
        return this.fs_;
    }

    private void fs__$eq(FileSystem x$1) {
        this.fs_ = x$1;
    }

    public void write(Checkpoint checkpoint) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream zos = this.compressionCodec().compressedOutputStream((OutputStream)bos);
        ObjectOutputStream oos = new ObjectOutputStream(zos);
        oos.writeObject(checkpoint);
        oos.close();
        bos.close();
        try {
            this.executor().execute(new CheckpointWriteHandler(this, checkpoint.checkpointTime(), bos.toByteArray()));
            this.logDebug((Function0<String>)new Serializable(this, checkpoint){
                public static final long serialVersionUID = 0L;
                private final Checkpoint checkpoint$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Submitted checkpoint of time ").append((Object)this.checkpoint$1.checkpointTime()).append((Object)" writer queue").toString();
                }
                {
                    this.checkpoint$1 = checkpoint$1;
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Could not submit checkpoint task to the thread pool executor";
                }
            }, rejectedExecutionException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        CheckpointWriter checkpointWriter = this;
        synchronized (checkpointWriter) {
            if (this.org$apache$spark$streaming$CheckpointWriter$$stopped()) {
                return;
            }
            this.org$apache$spark$streaming$CheckpointWriter$$stopped_$eq(true);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : checkpointWriter
            this.executor().shutdown();
        }
        long startTime = System.currentTimeMillis();
        boolean terminated = this.executor().awaitTermination(10L, TimeUnit.SECONDS);
        long endTime = System.currentTimeMillis();
        this.logInfo((Function0<String>)new Serializable(this, startTime, terminated, endTime){
            public static final long serialVersionUID = 0L;
            private final long startTime$2;
            private final boolean terminated$1;
            private final long endTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"CheckpointWriter executor terminated ? ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.terminated$1)).append((Object)", waited for ").append((Object)BoxesRunTime.boxToLong((long)(this.endTime$1 - this.startTime$2))).append((Object)" ms.").toString();
            }
            {
                this.startTime$2 = startTime$2;
                this.terminated$1 = terminated$1;
                this.endTime$1 = endTime$1;
            }
        });
    }

    public synchronized FileSystem org$apache$spark$streaming$CheckpointWriter$$fs() {
        if (this.fs_() == null) {
            this.fs__$eq(new Path(this.org$apache$spark$streaming$CheckpointWriter$$checkpointDir).getFileSystem(this.hadoopConf));
        }
        return this.fs_();
    }

    public synchronized void org$apache$spark$streaming$CheckpointWriter$$reset() {
        this.fs__$eq(null);
    }

    public CheckpointWriter(JobGenerator jobGenerator, SparkConf conf, String checkpointDir, Configuration hadoopConf) {
        this.org$apache$spark$streaming$CheckpointWriter$$jobGenerator = jobGenerator;
        this.org$apache$spark$streaming$CheckpointWriter$$checkpointDir = checkpointDir;
        this.hadoopConf = hadoopConf;
        Logging.class.$init$((Logging)this);
        this.MAX_ATTEMPTS = 3;
        this.executor = Executors.newFixedThreadPool(1);
        this.compressionCodec = CompressionCodec$.MODULE$.createCodec(conf);
        this.org$apache$spark$streaming$CheckpointWriter$$stopped = false;
    }

    public class CheckpointWriteHandler
    implements Runnable {
        public final Time org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$checkpointTime;
        public final byte[] org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$bytes;
        public final /* synthetic */ CheckpointWriter $outer;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            IntRef attempts = new IntRef(0);
            long startTime = System.currentTimeMillis();
            Path tempFile = new Path(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$checkpointDir, "temp");
            Path checkpointFile = Checkpoint$.MODULE$.checkpointFile(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$checkpointDir, this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$checkpointTime);
            Path backupFile = Checkpoint$.MODULE$.checkpointBackupFile(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$checkpointDir, this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$checkpointTime);
            if (attempts.elem < this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().MAX_ATTEMPTS() && !this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$stopped()) {
                ++attempts.elem;
                {
                    Seq<Path> allCheckpointFiles;
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logInfo((Function0<String>)new Serializable(this, checkpointFile){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CheckpointWriteHandler $outer;
                        private final Path checkpointFile$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Saving checkpoint for time ").append((Object)this.$outer.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$checkpointTime).append((Object)" to file '").append((Object)this.checkpointFile$1).append((Object)"'").toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.checkpointFile$1 = checkpointFile$1;
                        }
                    });
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs().delete(tempFile, true);
                    FSDataOutputStream fos = this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs().create(tempFile);
                    fos.write(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$bytes);
                    fos.close();
                    if (this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs().exists(checkpointFile)) {
                        this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs().delete(backupFile, true);
                        if (!this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs().rename(checkpointFile, backupFile)) {
                            this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logWarning((Function0<String>)new Serializable(this, checkpointFile, backupFile){
                                public static final long serialVersionUID = 0L;
                                private final Path checkpointFile$1;
                                private final Path backupFile$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Could not rename ").append((Object)this.checkpointFile$1).append((Object)" to ").append((Object)this.backupFile$1).toString();
                                }
                                {
                                    this.checkpointFile$1 = checkpointFile$1;
                                    this.backupFile$1 = backupFile$1;
                                }
                            });
                        }
                    }
                    if (!this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs().rename(tempFile, checkpointFile)) {
                        this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logWarning((Function0<String>)new Serializable(this, tempFile, checkpointFile){
                            public static final long serialVersionUID = 0L;
                            private final Path tempFile$1;
                            private final Path checkpointFile$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Could not rename ").append((Object)this.tempFile$1).append((Object)" to ").append((Object)this.checkpointFile$1).toString();
                            }
                            {
                                this.tempFile$1 = tempFile$1;
                                this.checkpointFile$1 = checkpointFile$1;
                            }
                        });
                    }
                    if ((allCheckpointFiles = Checkpoint$.MODULE$.getCheckpointFiles(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$checkpointDir, this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs())).size() > 4) {
                        ((IterableLike)allCheckpointFiles.take(allCheckpointFiles.size() - 10)).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ CheckpointWriteHandler $outer;

                            public final boolean apply(Path file) {
                                this.$outer.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logInfo((Function0<String>)new Serializable(this, file){
                                    public static final long serialVersionUID = 0L;
                                    private final Path file$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Deleting ").append((Object)this.file$1).toString();
                                    }
                                    {
                                        this.file$1 = file$1;
                                    }
                                });
                                return this.$outer.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs().delete(file, true);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    long finishTime = System.currentTimeMillis();
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logInfo((Function0<String>)new Serializable(this, startTime, checkpointFile, finishTime){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CheckpointWriteHandler $outer;
                        private final long startTime$1;
                        private final Path checkpointFile$1;
                        private final long finishTime$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Checkpoint for time ").append((Object)this.$outer.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$checkpointTime).append((Object)" saved to file '").append((Object)this.checkpointFile$1).append((Object)"', took ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$bytes.length)).append((Object)" bytes and ").append((Object)BoxesRunTime.boxToLong((long)(this.finishTime$1 - this.startTime$1))).append((Object)" ms").toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.startTime$1 = startTime$1;
                            this.checkpointFile$1 = checkpointFile$1;
                            this.finishTime$1 = finishTime$1;
                        }
                    });
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$jobGenerator.onCheckpointCompletion(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$checkpointTime);
                    return;
                }
            }
            this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logWarning((Function0<String>)new Serializable(this, checkpointFile){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CheckpointWriteHandler $outer;
                private final Path checkpointFile$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Could not write checkpoint for time ").append((Object)this.$outer.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$checkpointTime).append((Object)" to file ").append((Object)this.checkpointFile$1).append((Object)"'").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.checkpointFile$1 = checkpointFile$1;
                }
            });
        }

        public /* synthetic */ CheckpointWriter org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer() {
            return this.$outer;
        }

        public CheckpointWriteHandler(CheckpointWriter $outer, Time checkpointTime, byte[] bytes) {
            this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$checkpointTime = checkpointTime;
            this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$bytes = bytes;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

