/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.spark.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.NetworkInputDStream;
import org.apache.spark.streaming.scheduler.Job;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUb!B\u0001\u0003\u0005\tQ!\u0001\u0004#TiJ,\u0017-\\$sCBD'BA\u0002\u0005\u0003%\u0019HO]3b[&twM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\u0011\u00011\"\u0005\u000b\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\ta!#\u0003\u0002\u0014\u001b\ta1+\u001a:jC2L'0\u00192mKB\u0011QCF\u0007\u0002\t%\u0011q\u0003\u0002\u0002\b\u0019><w-\u001b8h\u0011\u0015I\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u000f\u0011\u0005u\u0001Q\"\u0001\u0002\t\u000f}\u0001!\u0019!C\u0005A\u0005a\u0011N\u001c9viN#(/Z1ngV\t\u0011\u0005E\u0002#O%j\u0011a\t\u0006\u0003I\u0015\nq!\\;uC\ndWM\u0003\u0002'\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005!\u001a#aC!se\u0006L()\u001e4gKJ\u0004$A\u000b\u001a\u0011\u0007-r\u0003'D\u0001-\u0015\ti#!A\u0004egR\u0014X-Y7\n\u0005=b#\u0001D%oaV$Hi\u0015;sK\u0006l\u0007CA\u00193\u0019\u0001!\u0011b\r\u001b\u0002\u0002\u0003\u0005)\u0011\u0001\u001c\u0003\u0007}#\u0013\u0007\u0003\u00046\u0001\u0001\u0006I!I\u0001\u000eS:\u0004X\u000f^*ue\u0016\fWn\u001d\u0011\u0012\u0005]R\u0004C\u0001\u00079\u0013\tITBA\u0004O_RD\u0017N\\4\u0011\u00051Y\u0014B\u0001\u001f\u000e\u0005\r\te.\u001f\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u00035yW\u000f\u001e9viN#(/Z1ngV\t\u0001\tE\u0002#O\u0005\u0003$A\u0011$\u0011\u0007-\u001aU)\u0003\u0002EY\t9Ai\u0015;sK\u0006l\u0007CA\u0019G\t%9\u0005*!A\u0001\u0002\u000b\u0005aGA\u0002`IIBa!\u0013\u0001!\u0002\u0013\u0001\u0015AD8viB,Ho\u0015;sK\u0006l7\u000f\t\u0005\b\u0017\u0002\u0001\r\u0011\"\u0001M\u0003A\u0011X-\\3nE\u0016\u0014H)\u001e:bi&|g.F\u0001N!\tib*\u0003\u0002P\u0005\tAA)\u001e:bi&|g\u000eC\u0004R\u0001\u0001\u0007I\u0011\u0001*\u0002)I,W.Z7cKJ$UO]1uS>tw\fJ3r)\t\u0019f\u000b\u0005\u0002\r)&\u0011Q+\u0004\u0002\u0005+:LG\u000fC\u0004X!\u0006\u0005\t\u0019A'\u0002\u0007a$\u0013\u0007\u0003\u0004Z\u0001\u0001\u0006K!T\u0001\u0012e\u0016lW-\u001c2fe\u0012+(/\u0019;j_:\u0004\u0003bB.\u0001\u0001\u0004%\t\u0001X\u0001\u0015G\",7m\u001b9pS:$\u0018J\u001c)s_\u001e\u0014Xm]:\u0016\u0003u\u0003\"\u0001\u00040\n\u0005}k!a\u0002\"p_2,\u0017M\u001c\u0005\bC\u0002\u0001\r\u0011\"\u0001c\u0003a\u0019\u0007.Z2la>Lg\u000e^%o!J|wM]3tg~#S-\u001d\u000b\u0003'\u000eDqa\u00161\u0002\u0002\u0003\u0007Q\f\u0003\u0004f\u0001\u0001\u0006K!X\u0001\u0016G\",7m\u001b9pS:$\u0018J\u001c)s_\u001e\u0014Xm]:!\u0011\u001d9\u0007\u00011A\u0005\u0002!\f\u0001B_3s_RKW.Z\u000b\u0002SB\u0011QD[\u0005\u0003W\n\u0011A\u0001V5nK\"9Q\u000e\u0001a\u0001\n\u0003q\u0017\u0001\u0004>fe>$\u0016.\\3`I\u0015\fHCA*p\u0011\u001d9F.!AA\u0002%Da!\u001d\u0001!B\u0013I\u0017!\u0003>fe>$\u0016.\\3!\u0011\u001d\u0019\b\u00011A\u0005\u0002!\f\u0011b\u001d;beR$\u0016.\\3\t\u000fU\u0004\u0001\u0019!C\u0001m\u0006i1\u000f^1siRKW.Z0%KF$\"aU<\t\u000f]#\u0018\u0011!a\u0001S\"1\u0011\u0010\u0001Q!\n%\f!b\u001d;beR$\u0016.\\3!\u0011\u001dY\b\u00011A\u0005\u00021\u000bQBY1uG\"$UO]1uS>t\u0007bB?\u0001\u0001\u0004%\tA`\u0001\u0012E\u0006$8\r\u001b#ve\u0006$\u0018n\u001c8`I\u0015\fHCA*\u0000\u0011\u001d9F0!AA\u00025Cq!a\u0001\u0001A\u0003&Q*\u0001\bcCR\u001c\u0007\u000eR;sCRLwN\u001c\u0011\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u0005)1\u000f^1siR\u00191+a\u0003\t\u000f\u00055\u0011Q\u0001a\u0001S\u0006!A/[7f\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tqA]3ti\u0006\u0014H\u000fF\u0002T\u0003+Aq!!\u0004\u0002\u0010\u0001\u0007\u0011\u000eC\u0004\u0002\u001a\u0001!\t!a\u0007\u0002\tM$x\u000e\u001d\u000b\u0002'\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012AC:fi\u000e{g\u000e^3yiR\u00191+a\t\t\u0011\u0005\u0015\u0012Q\u0004a\u0001\u0003O\t1a]:d!\ri\u0012\u0011F\u0005\u0004\u0003W\u0011!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011\u001d\ty\u0003\u0001C\u0001\u0003c\t\u0001c]3u\u0005\u0006$8\r\u001b#ve\u0006$\u0018n\u001c8\u0015\u0007M\u000b\u0019\u0004C\u0004\u00026\u00055\u0002\u0019A'\u0002\u0011\u0011,(/\u0019;j_:Dq!!\u000f\u0001\t\u0003\tY$\u0001\u0005sK6,WNY3s)\r\u0019\u0016Q\b\u0005\b\u0003k\t9\u00041\u0001N\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007\na\"\u00193e\u0013:\u0004X\u000f^*ue\u0016\fW\u000eF\u0002T\u0003\u000bB\u0001\"a\u0012\u0002@\u0001\u0007\u0011\u0011J\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\r\u0003\u0002L\u0005=\u0003\u0003B\u0016/\u0003\u001b\u00022!MA(\t-\t\t&!\u0012\u0002\u0002\u0003\u0005)\u0011\u0001\u001c\u0003\u0007}#3\u0007C\u0004\u0002V\u0001!\t!a\u0016\u0002\u001f\u0005$GmT;uaV$8\u000b\u001e:fC6$2aUA-\u0011!\tY&a\u0015A\u0002\u0005u\u0013\u0001D8viB,Ho\u0015;sK\u0006l\u0007\u0007BA0\u0003G\u0002BaK\"\u0002bA\u0019\u0011'a\u0019\u0005\u0017\u0005\u0015\u0014\u0011LA\u0001\u0002\u0003\u0015\tA\u000e\u0002\u0004?\u0012\"\u0004bBA5\u0001\u0011\u0005\u00111N\u0001\u0010O\u0016$\u0018J\u001c9viN#(/Z1ngR\u0011\u0011Q\u000e\t\u0005\u0019\u0005=\u0014&C\u0002\u0002r5\u0011Q!\u0011:sCfDq!!\u001e\u0001\t\u0003\t9(\u0001\thKR|U\u000f\u001e9viN#(/Z1ngR\u0011\u0011\u0011\u0010\t\u0005\u0019\u0005=\u0014\tC\u0004\u0002~\u0001!\t!a \u0002-\u001d,GOT3uo>\u00148.\u00138qkR\u001cFO]3b[N$\"!!!\u0011\u000b1\ty'a!1\t\u0005\u0015\u0015Q\u0012\t\u0006W\u0005\u001d\u00151R\u0005\u0004\u0003\u0013c#a\u0005(fi^|'o[%oaV$Hi\u0015;sK\u0006l\u0007cA\u0019\u0002\u000e\u0012Y\u0011qRAI\u0003\u0003\u0005\tQ!\u00017\u0005\ryFE\u000e\u0005\u000b\u0003'\u000bY(!A\u0001\u0002\u0005U\u0015\u0001\u0003\u0013b]>tg-\u001e8\f\u0001!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0015\u0001D4f]\u0016\u0014\u0018\r^3K_\n\u001cH\u0003BAO\u0003\u0003\u0004b!a(\u00020\u0006Uf\u0002BAQ\u0003WsA!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003OS\u0012A\u0002\u001fs_>$h(C\u0001\u000f\u0013\r\ti+D\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t,a-\u0003\u0007M+\u0017OC\u0002\u0002.6\u0001B!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w\u0013\u0011!C:dQ\u0016$W\u000f\\3s\u0013\u0011\ty,!/\u0003\u0007){'\rC\u0004\u0002\u000e\u0005]\u0005\u0019A5\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\u0006i1\r\\3be6+G/\u00193bi\u0006$2aUAe\u0011\u001d\ti!a1A\u0002%Dq!!4\u0001\t\u0003\ty-\u0001\u000bva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u000b\u0004'\u0006E\u0007bBA\u0007\u0003\u0017\u0004\r!\u001b\u0005\b\u0003+\u0004A\u0011AAl\u0003M\u0019G.Z1s\u0007\",7m\u001b9pS:$H)\u0019;b)\r\u0019\u0016\u0011\u001c\u0005\b\u0003\u001b\t\u0019\u000e1\u0001j\u0011\u001d\ti\u000e\u0001C\u0001\u00037\tQC]3ti>\u0014Xm\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018\rC\u0004\u0002b\u0002!\t!a\u0007\u0002\u0011Y\fG.\u001b3bi\u0016Dq!!:\u0001\t\u0013\t9/A\u0006xe&$Xm\u00142kK\u000e$HcA*\u0002j\"A\u00111^Ar\u0001\u0004\ti/A\u0002p_N\u0004B!a<\u0002z6\u0011\u0011\u0011\u001f\u0006\u0005\u0003g\f)0\u0001\u0002j_*\u0011\u0011q_\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002|\u0006E(AE(cU\u0016\u001cGoT;uaV$8\u000b\u001e:fC6Dc!a9\u0002\u0000\nU\u0001#\u0002\u0007\u0003\u0002\t\u0015\u0011b\u0001B\u0002\u001b\t1A\u000f\u001b:poN\u00042!\rB\u0004\t\u001d\u0011I\u0001\u0001b\u0001\u0005\u0017\u0011\u0011\u0001V\t\u0004o\t5\u0001\u0003\u0002B\b\u0005#q1\u0001DAV\u0013\u0011\u0011\u0019\"a-\u0003\u0013QC'o\\<bE2,7E\u0001B\f!\u0011\tyO!\u0007\n\t\tm\u0011\u0011\u001f\u0002\f\u0013>+\u0005pY3qi&|g\u000eC\u0004\u0003 \u0001!IA!\t\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG\u000fF\u0002T\u0005GA\u0001B!\n\u0003\u001e\u0001\u0007!qE\u0001\u0004_&\u001c\b\u0003BAx\u0005SIAAa\u000b\u0002r\n\trJ\u00196fGRLe\u000e];u'R\u0014X-Y7)\r\tu!q\u0006B\u000b!\u0015a!\u0011\u0001B\u0019!\r\t$1\u0007\u0003\b\u0005\u0013\u0001!\u0019\u0001B\u0006\u0001")
public final class DStreamGraph
implements Serializable,
Logging {
    private final ArrayBuffer<InputDStream<?>> inputStreams;
    private final ArrayBuffer<DStream<?>> outputStreams;
    private Duration rememberDuration;
    private boolean checkpointInProgress;
    private Time zeroTime;
    private Time startTime;
    private Duration batchDuration;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private ArrayBuffer<InputDStream<?>> inputStreams() {
        return this.inputStreams;
    }

    private ArrayBuffer<DStream<?>> outputStreams() {
        return this.outputStreams;
    }

    public Duration rememberDuration() {
        return this.rememberDuration;
    }

    public void rememberDuration_$eq(Duration x$1) {
        this.rememberDuration = x$1;
    }

    public boolean checkpointInProgress() {
        return this.checkpointInProgress;
    }

    public void checkpointInProgress_$eq(boolean x$1) {
        this.checkpointInProgress = x$1;
    }

    public Time zeroTime() {
        return this.zeroTime;
    }

    public void zeroTime_$eq(Time x$1) {
        this.zeroTime = x$1;
    }

    public Time startTime() {
        return this.startTime;
    }

    public void startTime_$eq(Time x$1) {
        this.startTime = x$1;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public void batchDuration_$eq(Duration x$1) {
        this.batchDuration = x$1;
    }

    public synchronized void start(Time time) {
        if (this.zeroTime() == null) {
            this.zeroTime_$eq(time);
            this.startTime_$eq(time);
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DStreamGraph $outer;

                public final void apply(DStream<?> x$1) {
                    x$1.initialize(this.$outer.zeroTime());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DStreamGraph $outer;

                public final void apply(DStream<?> x$2) {
                    x$2.remember(this.$outer.rememberDuration());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(DStream<?> x$3) {
                    x$3.validate();
                }
            });
            this.inputStreams().par().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(InputDStream<?> x$4) {
                    x$4.start();
                }
            });
            return;
        }
        throw new Exception("DStream graph computation already started");
    }

    public synchronized void restart(Time time) {
        this.startTime_$eq(time);
    }

    public synchronized void stop() {
        this.inputStreams().par().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(InputDStream<?> x$5) {
                x$5.stop();
            }
        });
    }

    public synchronized void setContext(StreamingContext ssc) {
        this.outputStreams().foreach((Function1)new Serializable(this, ssc){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$1;

            public final void apply(DStream<?> x$6) {
                x$6.setContext(this.ssc$1);
            }
            {
                this.ssc$1 = ssc$1;
            }
        });
    }

    public synchronized void setBatchDuration(Duration duration) {
        if (this.batchDuration() == null) {
            this.batchDuration_$eq(duration);
            return;
        }
        throw new Exception(new StringBuilder().append((Object)"Batch duration already set as ").append((Object)this.batchDuration()).append((Object)". cannot set it again.").toString());
    }

    public synchronized void remember(Duration duration) {
        if (this.rememberDuration() == null) {
            this.rememberDuration_$eq(duration);
            return;
        }
        throw new Exception(new StringBuilder().append((Object)"Remember duration already set as ").append((Object)this.batchDuration()).append((Object)". cannot set it again.").toString());
    }

    public void addInputStream(InputDStream<?> inputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            inputStream.setGraph(this);
            this.inputStreams().$plus$eq(inputStream);
            return;
        }
    }

    public void addOutputStream(DStream<?> outputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            outputStream.setGraph(this);
            this.outputStreams().$plus$eq(outputStream);
            return;
        }
    }

    public synchronized InputDStream<?>[] getInputStreams() {
        return (InputDStream[])this.inputStreams().toArray(ClassTag$.MODULE$.apply(InputDStream.class));
    }

    public synchronized DStream<?>[] getOutputStreams() {
        return (DStream[])this.outputStreams().toArray(ClassTag$.MODULE$.apply(DStream.class));
    }

    public synchronized NetworkInputDStream<?>[] getNetworkInputStreams() {
        return (NetworkInputDStream[])((TraversableOnce)((TraversableLike)this.inputStreams().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InputDStream<?> x$7) {
                return x$7 instanceof NetworkInputDStream;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NetworkInputDStream<?> apply(InputDStream<?> x$8) {
                return (NetworkInputDStream)x$8;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(NetworkInputDStream.class));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Seq<Job> generateJobs(Time time) {
        void var2_4;
        Object object;
        this.logDebug((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Generating jobs for time ").append((Object)this.time$1).toString();
            }
            {
                this.time$1 = time$1;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            object = this.outputStreams().flatMap((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$1;

                public final Iterable<Job> apply(DStream<?> outputStream) {
                    return Option$.MODULE$.option2Iterable(outputStream.generateJob(this.time$1));
                }
                {
                    this.time$1 = time$1;
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom());
        }
        ArrayBuffer jobs = (ArrayBuffer)object;
        this.logDebug((Function0<String>)new Serializable(this, time, jobs){
            public static final long serialVersionUID = 0L;
            private final Time time$1;
            private final ArrayBuffer jobs$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Generated ").append((Object)BoxesRunTime.boxToInteger((int)this.jobs$1.length())).append((Object)" jobs for time ").append((Object)this.time$1).toString();
            }
            {
                this.time$1 = time$1;
                this.jobs$1 = jobs$1;
            }
        });
        return var2_4;
    }

    public void clearMetadata(Time time) {
        this.logDebug((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Clearing metadata for time ").append((Object)this.time$2).toString();
            }
            {
                this.time$2 = time$2;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final void apply(DStream<?> x$9) {
                    x$9.clearMetadata(this.time$2);
                }
                {
                    this.time$2 = time$2;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logDebug((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleared old metadata for time ").append((Object)this.time$2).toString();
                }
                {
                    this.time$2 = time$2;
                }
            });
            return;
        }
    }

    public void updateCheckpointData(Time time) {
        this.logInfo((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$3;

            public final String apply() {
                return new StringBuilder().append((Object)"Updating checkpoint data for time ").append((Object)this.time$3).toString();
            }
            {
                this.time$3 = time$3;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$3;

                public final void apply(DStream<?> x$10) {
                    x$10.updateCheckpointData(this.time$3);
                }
                {
                    this.time$3 = time$3;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$3;

                public final String apply() {
                    return new StringBuilder().append((Object)"Updated checkpoint data for time ").append((Object)this.time$3).toString();
                }
                {
                    this.time$3 = time$3;
                }
            });
            return;
        }
    }

    public void clearCheckpointData(Time time) {
        this.logInfo((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$4;

            public final String apply() {
                return new StringBuilder().append((Object)"Clearing checkpoint data for time ").append((Object)this.time$4).toString();
            }
            {
                this.time$4 = time$4;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$4;

                public final void apply(DStream<?> x$11) {
                    x$11.clearCheckpointData(this.time$4);
                }
                {
                    this.time$4 = time$4;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$4;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleared checkpoint data for time ").append((Object)this.time$4).toString();
                }
                {
                    this.time$4 = time$4;
                }
            });
            return;
        }
    }

    public void restoreCheckpointData() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Restoring checkpoint data";
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(DStream<?> x$12) {
                    x$12.restoreCheckpointData();
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Restored checkpoint data";
                }
            });
            return;
        }
    }

    public synchronized void validate() {
        Predef$.MODULE$.assert(this.batchDuration() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Batch duration has not been set";
            }
        });
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])this.getOutputStreams()).size() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No output streams registered, so nothing to execute";
            }
        });
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DStreamGraph.writeObject used";
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.checkpointInProgress_$eq(true);
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Enabled checkpoint mode";
                }
            });
            oos.defaultWriteObject();
            this.checkpointInProgress_$eq(false);
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disabled checkpoint mode";
                }
            });
            return;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DStreamGraph.readObject used";
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.checkpointInProgress_$eq(true);
            ois.defaultReadObject();
            this.checkpointInProgress_$eq(false);
            return;
        }
    }

    public DStreamGraph() {
        Logging.class.$init$((Logging)this);
        this.inputStreams = new ArrayBuffer();
        this.outputStreams = new ArrayBuffer();
        this.rememberDuration = null;
        this.checkpointInProgress = false;
        this.zeroTime = null;
        this.startTime = null;
        this.batchDuration = null;
    }
}

