/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Interval$;
import org.apache.spark.streaming.Time;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4Q!\u0001\u0002\u0001\u0005)\u0011\u0001\"\u00138uKJ4\u0018\r\u001c\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\"\u0001A\u0006\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g\u0011!\u0011\u0002A!b\u0001\n\u0003!\u0012!\u00032fO&tG+[7f\u0007\u0001)\u0012!\u0006\t\u0003-]i\u0011AA\u0005\u00031\t\u0011A\u0001V5nK\"A!\u0004\u0001B\u0001B\u0003%Q#\u0001\u0006cK\u001eLg\u000eV5nK\u0002B\u0001\u0002\b\u0001\u0003\u0006\u0004%\t\u0001F\u0001\bK:$G+[7f\u0011!q\u0002A!A!\u0002\u0013)\u0012\u0001C3oIRKW.\u001a\u0011\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\r\u00113\u0005\n\t\u0003-\u0001AQAE\u0010A\u0002UAQ\u0001H\u0010A\u0002UAQ\u0001\t\u0001\u0005\u0002\u0019\"2AI\u0014-\u0011\u0015AS\u00051\u0001*\u0003\u001d\u0011WmZ5o\u001bN\u0004\"\u0001\u0004\u0016\n\u0005-j!\u0001\u0002'p]\u001eDQ!L\u0013A\u0002%\nQ!\u001a8e\u001bNDQa\f\u0001\u0005\u0002A\n\u0001\u0002Z;sCRLwN\u001c\u000b\u0002cA\u0011aCM\u0005\u0003g\t\u0011\u0001\u0002R;sCRLwN\u001c\u0005\u0006k\u0001!\tAN\u0001\u0006IAdWo\u001d\u000b\u0003E]BQ\u0001\u000f\u001bA\u0002E\nA\u0001^5nK\")!\b\u0001C\u0001w\u00051A%\\5okN$\"A\t\u001f\t\u000baJ\u0004\u0019A\u0019\t\u000by\u0002A\u0011A \u0002\u000b\u0011bWm]:\u0015\u0005\u0001\u001b\u0005C\u0001\u0007B\u0013\t\u0011UBA\u0004C_>dW-\u00198\t\u000b\u0011k\u0004\u0019\u0001\u0012\u0002\tQD\u0017\r\u001e\u0005\u0006\r\u0002!\taR\u0001\tI1,7o\u001d\u0013fcR\u0011\u0001\t\u0013\u0005\u0006\t\u0016\u0003\rA\t\u0005\u0006\u0015\u0002!\taS\u0001\tI\u001d\u0014X-\u0019;feR\u0011\u0001\t\u0014\u0005\u0006\t&\u0003\rA\t\u0005\u0006\u001d\u0002!\taT\u0001\fI\u001d\u0014X-\u0019;fe\u0012*\u0017\u000f\u0006\u0002A!\")A)\u0014a\u0001E!)!\u000b\u0001C!'\u0006AAo\\*ue&tw\rF\u0001U!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003mC:<'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013aa\u0015;sS:<wAB/\u0003\u0011\u0003\u0011a,\u0001\u0005J]R,'O^1m!\t1rL\u0002\u0004\u0002\u0005!\u0005!\u0001Y\n\u0003?.AQ\u0001I0\u0005\u0002\t$\u0012A\u0018\u0005\u0006I~#\t!Z\u0001\u0010GV\u0014(/\u001a8u\u0013:$XM\u001d<bYR\u0011!E\u001a\u0005\u0006_\r\u0004\r!\r")
public class Interval {
    private final Time beginTime;
    private final Time endTime;

    public static Interval currentInterval(Duration duration) {
        return Interval$.MODULE$.currentInterval(duration);
    }

    public Time beginTime() {
        return this.beginTime;
    }

    public Time endTime() {
        return this.endTime;
    }

    public Duration duration() {
        return this.endTime().$minus(this.beginTime());
    }

    public Interval $plus(Duration time) {
        return new Interval(this.beginTime().$plus(time), this.endTime().$plus(time));
    }

    public Interval $minus(Duration time) {
        return new Interval(this.beginTime().$minus(time), this.endTime().$minus(time));
    }

    public boolean $less(Interval that) {
        Duration duration = this.duration();
        Duration duration2 = that.duration();
        if (!(duration != null ? !((Object)duration).equals(duration2) : duration2 != null)) {
            return this.endTime().$less(that.endTime());
        }
        throw new Exception(new StringBuilder().append((Object)"Comparing two intervals with different durations [").append((Object)this).append((Object)", ").append((Object)that).append((Object)"]").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean $less$eq(Interval that) {
        if (this.$less(that)) return true;
        Interval interval = this;
        Interval interval2 = that;
        if (interval != null) {
            if (!interval.equals(interval2)) return false;
            return true;
        }
        if (interval2 == null) return true;
        return false;
    }

    public boolean $greater(Interval that) {
        return !this.$less$eq(that);
    }

    public boolean $greater$eq(Interval that) {
        return !this.$less(that);
    }

    public String toString() {
        return new StringBuilder().append((Object)"[").append((Object)this.beginTime()).append((Object)", ").append((Object)this.endTime()).append((Object)"]").toString();
    }

    public Interval(Time beginTime, Time endTime) {
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public Interval(long beginMs, long endMs) {
        this(new Time(beginMs), new Time(endMs));
    }
}

