/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.ErrorReported;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobCompleted;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.apache.spark.streaming.scheduler.JobScheduler$;
import org.apache.spark.streaming.scheduler.JobScheduler$$anonfun$start$1$;
import org.apache.spark.streaming.scheduler.JobSchedulerEvent;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobStarted;
import org.apache.spark.streaming.scheduler.NetworkInputTracker;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg!B\u0001\u0003\u0001\u0011a!\u0001\u0004&pEN\u001b\u0007.\u001a3vY\u0016\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!Q1A\u0005\u0002i\t1a]:d\u0007\u0001)\u0012a\u0007\t\u00039ui\u0011\u0001B\u0005\u0003=\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011\u0001\u0002!\u0011!Q\u0001\nm\tAa]:dA!)!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000ba\t\u0003\u0019A\u000e\t\u000f!\u0002!\u0019!C\u0005S\u00059!n\u001c2TKR\u001cX#\u0001\u0016\u0011\t-\u0012DgN\u0007\u0002Y)\u0011QFL\u0001\u000bG>t7-\u001e:sK:$(BA\u00181\u0003\u0011)H/\u001b7\u000b\u0003E\nAA[1wC&\u00111\u0007\f\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001\u000f6\u0013\t1DA\u0001\u0003US6,\u0007CA\u00139\u0013\tI$A\u0001\u0004K_\n\u001cV\r\u001e\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u0016\u0002\u0011)|'mU3ug\u0002Bq!\u0010\u0001C\u0002\u0013%a(A\tok6\u001cuN\\2veJ,g\u000e\u001e&pEN,\u0012a\u0010\t\u0003\u001d\u0001K!!Q\b\u0003\u0007%sG\u000f\u0003\u0004D\u0001\u0001\u0006IaP\u0001\u0013]Vl7i\u001c8dkJ\u0014XM\u001c;K_\n\u001c\b\u0005C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u0011\u0015DXmY;u_J,\u0012a\u0012\t\u0003W!K!!\u0013\u0017\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016Daa\u0013\u0001!\u0002\u00139\u0015!C3yK\u000e,Ho\u001c:!\u0011\u001di\u0005A1A\u0005\n9\u000bAB[8c\u000f\u0016tWM]1u_J,\u0012a\u0014\t\u0003KAK!!\u0015\u0002\u0003\u0019){'mR3oKJ\fGo\u001c:\t\rM\u0003\u0001\u0015!\u0003P\u00035QwNY$f]\u0016\u0014\u0018\r^8sA!9Q\u000b\u0001b\u0001\n\u00031\u0016!B2m_\u000e\\W#A,\u0011\u0005aSV\"A-\u000b\u0005=\"\u0011BA.Z\u0005\u0015\u0019En\\2l\u0011\u0019i\u0006\u0001)A\u0005/\u000611\r\\8dW\u0002Bqa\u0018\u0001C\u0002\u0013\u0005\u0001-A\u0006mSN$XM\\3s\u0005V\u001cX#A1\u0011\u0005\u0015\u0012\u0017BA2\u0003\u0005Q\u0019FO]3b[&tw\rT5ti\u0016tWM\u001d\"vg\"1Q\r\u0001Q\u0001\n\u0005\fA\u0002\\5ti\u0016tWM\u001d\"vg\u0002Bqa\u001a\u0001A\u0002\u0013\u0005\u0001.A\noKR<xN]6J]B,H\u000f\u0016:bG.,'/F\u0001j!\t)#.\u0003\u0002l\u0005\t\u0019b*\u001a;x_J\\\u0017J\u001c9viR\u0013\u0018mY6fe\"9Q\u000e\u0001a\u0001\n\u0003q\u0017a\u00068fi^|'o[%oaV$HK]1dW\u0016\u0014x\fJ3r)\ty'\u000f\u0005\u0002\u000fa&\u0011\u0011o\u0004\u0002\u0005+:LG\u000fC\u0004tY\u0006\u0005\t\u0019A5\u0002\u0007a$\u0013\u0007\u0003\u0004v\u0001\u0001\u0006K![\u0001\u0015]\u0016$xo\u001c:l\u0013:\u0004X\u000f\u001e+sC\u000e\\WM\u001d\u0011\t\u000f]\u0004\u0001\u0019!C\u0005q\u0006QQM^3oi\u0006\u001bGo\u001c:\u0016\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003y\fA!Y6lC&\u0019\u0011\u0011A>\u0003\u0011\u0005\u001bGo\u001c:SK\u001aD\u0011\"!\u0002\u0001\u0001\u0004%I!a\u0002\u0002\u001d\u00154XM\u001c;BGR|'o\u0018\u0013fcR\u0019q.!\u0003\t\u0011M\f\u0019!!AA\u0002eDq!!\u0004\u0001A\u0003&\u00110A\u0006fm\u0016tG/Q2u_J\u0004\u0003bBA\t\u0001\u0011\u0005\u00111C\u0001\u0006gR\f'\u000f\u001e\u000b\u0002_\"9\u0011q\u0003\u0001\u0005\u0002\u0005M\u0011\u0001B:u_BDq!a\u0007\u0001\t\u0003\ti\"A\u0004sk:TuNY:\u0015\u000b=\fy\"a\t\t\u000f\u0005\u0005\u0012\u0011\u0004a\u0001i\u0005!A/[7f\u0011!\t)#!\u0007A\u0002\u0005\u001d\u0012\u0001\u00026pEN\u0004b!!\u000b\u0002:\u0005}b\u0002BA\u0016\u0003kqA!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cI\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\r\t9dD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY$!\u0010\u0003\u0007M+\u0017OC\u0002\u00028=\u00012!JA!\u0013\r\t\u0019E\u0001\u0002\u0004\u0015>\u0014\u0007bBA$\u0001\u0011\u0005\u0011\u0011J\u0001\u0010O\u0016$\b+\u001a8eS:<G+[7fgR\u0011\u00111\n\t\u0006\u0003S\tI\u0004\u000e\u0005\b\u0003\u001f\u0002A\u0011AA)\u0003-\u0011X\r]8si\u0016\u0013(o\u001c:\u0015\u000b=\f\u0019&!\u001a\t\u0011\u0005U\u0013Q\na\u0001\u0003/\n1!\\:h!\u0011\tI&a\u0018\u000f\u00079\tY&C\u0002\u0002^=\ta\u0001\u0015:fI\u00164\u0017\u0002BA1\u0003G\u0012aa\u0015;sS:<'bAA/\u001f!A\u0011qMA'\u0001\u0004\tI'A\u0001f!\u0011\tI#a\u001b\n\t\u00055\u0014Q\b\u0002\n)\"\u0014xn^1cY\u0016Dq!!\u001d\u0001\t\u0013\t\u0019(\u0001\u0007qe>\u001cWm]:Fm\u0016tG\u000fF\u0002p\u0003kB\u0001\"a\u001e\u0002p\u0001\u0007\u0011\u0011P\u0001\u0006KZ,g\u000e\u001e\t\u0004K\u0005m\u0014bAA?\u0005\t\t\"j\u001c2TG\",G-\u001e7fe\u00163XM\u001c;\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\u0006q\u0001.\u00198eY\u0016TuNY*uCJ$HcA8\u0002\u0006\"A\u0011qQA@\u0001\u0004\ty$A\u0002k_\nDq!a#\u0001\t\u0013\ti)A\niC:$G.\u001a&pE\u000e{W\u000e\u001d7fi&|g\u000eF\u0002p\u0003\u001fC\u0001\"a\"\u0002\n\u0002\u0007\u0011q\b\u0005\b\u0003'\u0003A\u0011BAK\u0003-A\u0017M\u001c3mK\u0016\u0013(o\u001c:\u0015\u000b=\f9*!'\t\u0011\u0005U\u0013\u0011\u0013a\u0001\u0003/B\u0001\"a\u001a\u0002\u0012\u0002\u0007\u0011\u0011\u000e\u0004\u0007\u0003;\u0003A!a(\u0003\u0015){'\rS1oI2,'o\u0005\u0004\u0002\u001c\u0006\u0005\u0016Q\u0016\t\u0005\u0003G\u000bI+\u0004\u0002\u0002&*\u0019\u0011q\u0015\u0019\u0002\t1\fgnZ\u0005\u0005\u0003W\u000b)K\u0001\u0004PE*,7\r\u001e\t\u0005\u0003G\u000by+\u0003\u0003\u00022\u0006\u0015&\u0001\u0003*v]:\f'\r\\3\t\u0017\u0005\u001d\u00151\u0014B\u0001B\u0003%\u0011q\b\u0005\bE\u0005mE\u0011AA\\)\u0011\tI,!0\u0011\t\u0005m\u00161T\u0007\u0002\u0001!A\u0011qQA[\u0001\u0004\ty\u0004\u0003\u0005\u0002B\u0006mE\u0011AA\n\u0003\r\u0011XO\u001c")
public class JobScheduler
implements Logging {
    private final StreamingContext ssc;
    private final ConcurrentHashMap<Time, JobSet> jobSets;
    private final int numConcurrentJobs;
    private final ExecutorService org$apache$spark$streaming$scheduler$JobScheduler$$executor;
    private final JobGenerator jobGenerator;
    private final Clock clock;
    private final StreamingListenerBus listenerBus;
    private NetworkInputTracker networkInputTracker;
    private ActorRef org$apache$spark$streaming$scheduler$JobScheduler$$eventActor;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    private ConcurrentHashMap<Time, JobSet> jobSets() {
        return this.jobSets;
    }

    private int numConcurrentJobs() {
        return this.numConcurrentJobs;
    }

    public ExecutorService org$apache$spark$streaming$scheduler$JobScheduler$$executor() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$executor;
    }

    private JobGenerator jobGenerator() {
        return this.jobGenerator;
    }

    public Clock clock() {
        return this.clock;
    }

    public StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public NetworkInputTracker networkInputTracker() {
        return this.networkInputTracker;
    }

    public void networkInputTracker_$eq(NetworkInputTracker x$1) {
        this.networkInputTracker = x$1;
    }

    public ActorRef org$apache$spark$streaming$scheduler$JobScheduler$$eventActor() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventActor;
    }

    private void org$apache$spark$streaming$scheduler$JobScheduler$$eventActor_$eq(ActorRef x$1) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventActor = x$1;
    }

    public synchronized void start() {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventActor() == null) {
            this.org$apache$spark$streaming$scheduler$JobScheduler$$eventActor_$eq(this.ssc().env().actorSystem().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobScheduler $outer;

                public final $anonfun$start$1$$anon$1 apply() {
                    return new Actor(this){
                        private final /* synthetic */ $anonfun$start$1 $outer;
                        private final ActorContext context;
                        private final ActorRef self;

                        public ActorContext context() {
                            return this.context;
                        }

                        public final ActorRef self() {
                            return this.self;
                        }

                        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
                            this.context = x$1;
                        }

                        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
                            this.self = x$1;
                        }

                        public final ActorRef sender() {
                            return Actor.class.sender((Actor)this);
                        }

                        public SupervisorStrategy supervisorStrategy() {
                            return Actor.class.supervisorStrategy((Actor)this);
                        }

                        public void preStart() throws Exception {
                            Actor.class.preStart((Actor)this);
                        }

                        public void postStop() throws Exception {
                            Actor.class.postStop((Actor)this);
                        }

                        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
                            Actor.class.preRestart((Actor)this, (Throwable)reason, message);
                        }

                        public void postRestart(Throwable reason) throws Exception {
                            Actor.class.postRestart((Actor)this, (Throwable)reason);
                        }

                        public void unhandled(Object message) {
                            Actor.class.unhandled((Actor)this, (Object)message);
                        }

                        public PartialFunction<Object, BoxedUnit> receive() {
                            return new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$start$1$$anon$1 $outer;

                                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    Object object;
                                    A1 A1 = x1;
                                    if (A1 instanceof JobSchedulerEvent) {
                                        JobSchedulerEvent jobSchedulerEvent = (JobSchedulerEvent)A1;
                                        this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$anonfun$$anon$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$anonfun$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(jobSchedulerEvent);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x1);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Object x1) {
                                    Object object = x1;
                                    boolean bl = object instanceof JobSchedulerEvent;
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            };
                        }

                        public /* synthetic */ $anonfun$start$1 org$apache$spark$streaming$scheduler$JobScheduler$$anonfun$$anon$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            Actor.class.$init$((Actor)this);
                        }
                    };
                }

                public /* synthetic */ JobScheduler org$apache$spark$streaming$scheduler$JobScheduler$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, ClassTag$.MODULE$.apply(Actor.class)), "JobScheduler"));
            this.listenerBus().start();
            this.networkInputTracker_$eq(new NetworkInputTracker(this.ssc()));
            this.networkInputTracker().start();
            Thread.sleep(1000L);
            this.jobGenerator().start();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "JobScheduler started";
                }
            });
            return;
        }
        throw new SparkException("JobScheduler already started");
    }

    public synchronized void stop() {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventActor() != null) {
            this.jobGenerator().stop();
            this.networkInputTracker().stop();
            this.org$apache$spark$streaming$scheduler$JobScheduler$$executor().shutdown();
            Object object = this.org$apache$spark$streaming$scheduler$JobScheduler$$executor().awaitTermination(2L, TimeUnit.SECONDS) ? BoxedUnit.UNIT : this.org$apache$spark$streaming$scheduler$JobScheduler$$executor().shutdownNow();
            this.listenerBus().stop();
            this.ssc().env().actorSystem().stop(this.org$apache$spark$streaming$scheduler$JobScheduler$$eventActor());
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "JobScheduler stopped";
                }
            });
        }
    }

    public void runJobs(Time time, Seq<Job> jobs) {
        if (jobs.isEmpty()) {
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"No jobs added for time ").append((Object)this.time$1).toString();
                }
                {
                    this.time$1 = time$1;
                }
            });
        } else {
            JobSet jobSet = new JobSet(time, jobs);
            this.jobSets().put(time, jobSet);
            jobSet.jobs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobScheduler $outer;

                public final void apply(Job job) {
                    this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$executor().execute(new JobHandler(this.$outer, job));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Added jobs for time ").append((Object)this.time$1).toString();
                }
                {
                    this.time$1 = time$1;
                }
            });
        }
    }

    public Seq<Time> getPendingTimes() {
        return JavaConversions$.MODULE$.asScalaSet(this.jobSets().keySet()).toSeq();
    }

    public void reportError(String msg, Throwable e) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobScheduler$$eventActor());
        ErrorReported x$1 = new ErrorReported(msg, e);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(JobSchedulerEvent event) {
        block5: {
            try {
                JobSchedulerEvent jobSchedulerEvent = event;
                if (jobSchedulerEvent instanceof JobStarted) {
                    JobStarted jobStarted = (JobStarted)jobSchedulerEvent;
                    Job job = jobStarted.job();
                    this.handleJobStart(job);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof JobCompleted) {
                    JobCompleted jobCompleted = (JobCompleted)jobSchedulerEvent;
                    Job job = jobCompleted.job();
                    this.handleJobCompletion(job);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof ErrorReported) {
                    ErrorReported errorReported = (ErrorReported)jobSchedulerEvent;
                    String m = errorReported.msg();
                    Throwable e = errorReported.e();
                    this.handleError(m, e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError((Object)jobSchedulerEvent);
            }
            catch (Throwable throwable) {
                this.reportError("Error in job scheduler", throwable);
            }
        }
    }

    private void handleJobStart(Job job) {
        JobSet jobSet = this.jobSets().get(job.time());
        if (!jobSet.hasStarted()) {
            this.listenerBus().post(new StreamingListenerBatchStarted(jobSet.toBatchInfo()));
        }
        jobSet.handleJobStart(job);
        this.logInfo((Function0<String>)new Serializable(this, job, jobSet){
            public static final long serialVersionUID = 0L;
            private final Job job$1;
            private final JobSet jobSet$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Starting job ").append((Object)this.job$1.id()).append((Object)" from job set of time ").append((Object)this.jobSet$1.time()).toString();
            }
            {
                this.job$1 = job$1;
                this.jobSet$1 = jobSet$1;
            }
        });
        SparkEnv$.MODULE$.set(this.ssc().env());
    }

    private void handleJobCompletion(Job job) {
        Try<?> try_;
        block7: {
            block6: {
                block5: {
                    BoxedUnit boxedUnit;
                    try_ = job.result();
                    if (!(try_ instanceof Success)) break block5;
                    JobSet jobSet = this.jobSets().get(job.time());
                    jobSet.handleJobCompletion(job);
                    this.logInfo((Function0<String>)new Serializable(this, job, jobSet){
                        public static final long serialVersionUID = 0L;
                        private final Job job$2;
                        private final JobSet jobSet$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Finished job ").append((Object)this.job$2.id()).append((Object)" from job set of time ").append((Object)this.jobSet$2.time()).toString();
                        }
                        {
                            this.job$2 = job$2;
                            this.jobSet$2 = jobSet$2;
                        }
                    });
                    if (jobSet.hasCompleted()) {
                        this.jobSets().remove(jobSet.time());
                        this.jobGenerator().onBatchCompletion(jobSet.time());
                        this.logInfo((Function0<String>)new Serializable(this, jobSet){
                            public static final long serialVersionUID = 0L;
                            private final JobSet jobSet$2;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Total delay: %.3f s for time %s (execution: %.3f s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)this.jobSet$2.totalDelay() / 1000.0)), this.jobSet$2.time().toString(), BoxesRunTime.boxToDouble((double)((double)this.jobSet$2.processingDelay() / 1000.0))}));
                            }
                            {
                                this.jobSet$2 = jobSet$2;
                            }
                        });
                        this.listenerBus().post(new StreamingListenerBatchCompleted(jobSet.toBatchInfo()));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block6;
                }
                if (!(try_ instanceof Failure)) break block7;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.reportError(new StringBuilder().append((Object)"Error running job ").append((Object)job).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(try_);
    }

    private void handleError(String msg, Throwable e) {
        this.logError((Function0<String>)new Serializable(this, msg){
            public static final long serialVersionUID = 0L;
            private final String msg$1;

            public final String apply() {
                return this.msg$1;
            }
            {
                this.msg$1 = msg$1;
            }
        }, e);
        this.ssc().waiter().notifyError(e);
    }

    public JobScheduler(StreamingContext ssc) {
        this.ssc = ssc;
        Logging.class.$init$((Logging)this);
        this.jobSets = new ConcurrentHashMap();
        this.numConcurrentJobs = ssc.conf().getInt("spark.streaming.concurrentJobs", 1);
        this.org$apache$spark$streaming$scheduler$JobScheduler$$executor = Executors.newFixedThreadPool(this.numConcurrentJobs());
        this.jobGenerator = new JobGenerator(this);
        this.clock = this.jobGenerator().clock();
        this.listenerBus = new StreamingListenerBus();
        this.networkInputTracker = null;
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventActor = null;
    }

    public class JobHandler
    implements Runnable {
        private final Job job;
        public final /* synthetic */ JobScheduler $outer;

        @Override
        public void run() {
            ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventActor());
            JobStarted x$3 = new JobStarted(this.job);
            ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
            qual$2.$bang((Object)x$3, x$4);
            this.job.run();
            ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventActor());
            JobCompleted x$5 = new JobCompleted(this.job);
            ActorRef x$6 = qual$3.$bang$default$2((Object)x$5);
            qual$3.$bang((Object)x$5, x$6);
        }

        public /* synthetic */ JobScheduler org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer() {
            return this.$outer;
        }

        public JobHandler(JobScheduler $outer, Job job) {
            this.job = job;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

