/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.NetworkInputDStream;
import org.apache.spark.streaming.dstream.NetworkReceiver;
import org.apache.spark.streaming.dstream.StopReceiver$;
import org.apache.spark.streaming.scheduler.AddBlocks;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.NetworkInputTracker$;
import org.apache.spark.streaming.scheduler.NetworkInputTracker$NetworkInputTrackerActor$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.util.AkkaUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u0001\u0003\u0001\u0011a!a\u0005(fi^|'o[%oaV$HK]1dW\u0016\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!\u0011!Q\u0001\ni\t1a]:d\u0007\u0001\u0001\"a\u0007\u000f\u000e\u0003\u0011I!!\b\u0003\u0003!M#(/Z1nS:<7i\u001c8uKb$\b\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"GA\u0011!\u0005A\u0007\u0002\u0005!)\u0001D\ba\u00015!9Q\u0005\u0001b\u0001\n\u00031\u0013a\u00058fi^|'o[%oaV$8\u000b\u001e:fC6\u001cX#A\u0014\u0011\u00079A#&\u0003\u0002*\u001f\t)\u0011I\u001d:bsB\u00121f\r\t\u0004Y=\nT\"A\u0017\u000b\u00059\"\u0011a\u00023tiJ,\u0017-\\\u0005\u0003a5\u00121CT3uo>\u00148.\u00138qkR$5\u000b\u001e:fC6\u0004\"AM\u001a\r\u0001\u0011IA\u0007AA\u0001\u0002\u0003\u0015\ta\u000f\u0002\u0004?\u00122\u0014B\u0001\u001c8\u0003!!\u0013M\\8oMVt\u0017B\u0001\u001d:\u0003Y9W\r\u001e(fi^|'o[%oaV$8\u000b\u001e:fC6\u001c\u0018B\u0001\u001e\u0005\u00051!5\u000b\u001e:fC6<%/\u00199i#\tat\b\u0005\u0002\u000f{%\u0011ah\u0004\u0002\b\u001d>$\b.\u001b8h!\tq\u0001)\u0003\u0002B\u001f\t\u0019\u0011I\\=\t\r\r\u0003\u0001\u0015!\u0003(\u0003QqW\r^<pe.Le\u000e];u'R\u0014X-Y7tA!9Q\t\u0001b\u0001\n\u00031\u0015!\u00068fi^|'o[%oaV$8\u000b\u001e:fC6l\u0015\r]\u000b\u0002\u000fB\u0012\u0001*\u0016\t\u0005\u0013:\u00036+D\u0001K\u0015\tYE*A\u0005j[6,H/\u00192mK*\u0011QjD\u0001\u000bG>dG.Z2uS>t\u0017BA(K\u0005\ri\u0015\r\u001d\t\u0003\u001dEK!AU\b\u0003\u0007%sG\u000fE\u0002-_Q\u0003\"AM+\u0005\u0013Q2\u0016\u0011!A\u0001\u0006\u0003Y\u0004BB,\u0001A\u0003%q)\u0001\foKR<xN]6J]B,Ho\u0015;sK\u0006lW*\u00199!\u0011\u001dI\u0006A1A\u0005\u0002i\u000b\u0001C]3dK&4XM]#yK\u000e,Ho\u001c:\u0016\u0003m\u0003\"\u0001X/\u000e\u0003\u00011AA\u0018\u0001\u0001?\n\u0001\"+Z2fSZ,'/\u0012=fGV$xN]\n\u0003;\u0002\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\t1\fgn\u001a\u0006\u0002K\u0006!!.\u0019<b\u0013\t9'M\u0001\u0004UQJ,\u0017\r\u001a\u0005\u0006?u#\t!\u001b\u000b\u00027\"91.\u0018b\u0001\n\u0003a\u0017aA3omV\tQ\u000e\u0005\u0002\u0015]&\u0011qN\u0002\u0002\t'B\f'o[#om\"1\u0011/\u0018Q\u0001\n5\fA!\u001a8wA!)1/\u0018C!i\u0006\u0019!/\u001e8\u0015\u0003U\u0004\"A\u0004<\n\u0005]|!\u0001B+oSRDQ!_/\u0005\u0002Q\fab\u001d;beR\u0014VmY3jm\u0016\u00148\u000fC\u0003|;\u0012\u0005A/A\u0007ti>\u0004(+Z2fSZ,'o\u001d\u0005\u0007{\u0002\u0001\u000b\u0011B.\u0002#I,7-Z5wKJ,\u00050Z2vi>\u0014\b\u0005\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u00031\u0011XmY3jm\u0016\u0014\u0018J\u001c4p+\t\t\u0019\u0001E\u0004\u0002\u0006\u0005-\u0001+a\u0004\u000e\u0005\u0005\u001d!bAA\u0005\u0019\u00069Q.\u001e;bE2,\u0017\u0002BA\u0007\u0003\u000f\u0011q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\u0005e\u0011\u0001B1lW\u0006LA!!\b\u0002\u0014\tA\u0011i\u0019;peJ+g\r\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0002\u00035\u0011XmY3jm\u0016\u0014\u0018J\u001c4pA!I\u0011Q\u0005\u0001C\u0002\u0013\u0005\u0011qE\u0001\u0011e\u0016\u001cW-\u001b<fI\ncwnY6JIN,\"!!\u000b\u0011\u000f\u0005\u0015\u00111\u0002)\u0002,A1\u0011QAA\u0017\u0003cIA!a\f\u0002\b\t)\u0011+^3vKB!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028\u0019\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002<\u0005U\"a\u0002\"m_\u000e\\\u0017\n\u001a\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002*\u0005\t\"/Z2fSZ,GM\u00117pG.LEm\u001d\u0011\t\u0013\u0005\r\u0003A1A\u0005\u0002\u0005\u0015\u0013a\u0002;j[\u0016|W\u000f^\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0005ekJ\fG/[8o\u0015\r\t\tfD\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA+\u0003\u0017\u0012aBR5oSR,G)\u001e:bi&|g\u000e\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA$\u0003!!\u0018.\\3pkR\u0004\u0003\"CA\u000b\u0001\u0001\u0007I\u0011AA/+\t\ty\u0001C\u0005\u0002b\u0001\u0001\r\u0011\"\u0001\u0002d\u0005I\u0011m\u0019;pe~#S-\u001d\u000b\u0004k\u0006\u0015\u0004BCA4\u0003?\n\t\u00111\u0001\u0002\u0010\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005-\u0004\u0001)Q\u0005\u0003\u001f\ta!Y2u_J\u0004\u0003\"CA8\u0001\u0001\u0007I\u0011AA9\u0003-\u0019WO\u001d:f]R$\u0016.\\3\u0016\u0005\u0005M\u0004cA\u000e\u0002v%\u0019\u0011q\u000f\u0003\u0003\tQKW.\u001a\u0005\n\u0003w\u0002\u0001\u0019!C\u0001\u0003{\nqbY;se\u0016tG\u000fV5nK~#S-\u001d\u000b\u0004k\u0006}\u0004BCA4\u0003s\n\t\u00111\u0001\u0002t!A\u00111\u0011\u0001!B\u0013\t\u0019(\u0001\u0007dkJ\u0014XM\u001c;US6,\u0007\u0005\u0003\u0004\u0002\b\u0002!\t\u0001^\u0001\u0006gR\f'\u000f\u001e\u0005\u0007\u0003\u0017\u0003A\u0011\u0001;\u0002\tM$x\u000e\u001d\u0005\b\u0003\u001f\u0003A\u0011AAI\u0003-9W\r\u001e\"m_\u000e\\\u0017\nZ:\u0015\r\u0005M\u0015QSAM!\u0011q\u0001&!\r\t\u000f\u0005]\u0015Q\u0012a\u0001!\u0006Q!/Z2fSZ,'/\u00133\t\u0011\u0005m\u0015Q\u0012a\u0001\u0003g\nA\u0001^5nK\u001a1\u0011q\u0014\u0001\u0005\u0003C\u0013\u0001DT3uo>\u00148.\u00138qkR$&/Y2lKJ\f5\r^8s'\u0015\ti*DAR!\u0011\t\t\"!*\n\t\u0005\u001d\u00161\u0003\u0002\u0006\u0003\u000e$xN\u001d\u0005\b?\u0005uE\u0011AAV)\t\ti\u000bE\u0002]\u0003;C\u0001\"!-\u0002\u001e\u0012\u0005\u00111W\u0001\be\u0016\u001cW-\u001b<f+\t\t)\fE\u0003\u000f\u0003o{T/C\u0002\u0002:>\u0011q\u0002U1si&\fGNR;oGRLwN\u001c")
public class NetworkInputTracker
implements Logging {
    public final StreamingContext org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc;
    private final NetworkInputDStream<?>[] networkInputStreams;
    private final Map<Object, NetworkInputDStream<Object>> networkInputStreamMap;
    private final ReceiverExecutor receiverExecutor;
    private final HashMap<Object, ActorRef> receiverInfo;
    private final HashMap<Object, Queue<BlockId>> receivedBlockIds;
    private final FiniteDuration timeout;
    private ActorRef actor;
    private Time currentTime;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public NetworkInputDStream<?>[] networkInputStreams() {
        return this.networkInputStreams;
    }

    public Map<Object, NetworkInputDStream<Object>> networkInputStreamMap() {
        return this.networkInputStreamMap;
    }

    public ReceiverExecutor receiverExecutor() {
        return this.receiverExecutor;
    }

    public HashMap<Object, ActorRef> receiverInfo() {
        return this.receiverInfo;
    }

    public HashMap<Object, Queue<BlockId>> receivedBlockIds() {
        return this.receivedBlockIds;
    }

    public FiniteDuration timeout() {
        return this.timeout;
    }

    public ActorRef actor() {
        return this.actor;
    }

    public void actor_$eq(ActorRef x$1) {
        this.actor = x$1;
    }

    public Time currentTime() {
        return this.currentTime;
    }

    public void currentTime_$eq(Time x$1) {
        this.currentTime = x$1;
    }

    public void start() {
        if (this.actor() == null) {
            if (!Predef$.MODULE$.refArrayOps((Object[])this.networkInputStreams()).isEmpty()) {
                this.actor_$eq(this.org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc.env().actorSystem().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NetworkInputTracker $outer;

                    public final NetworkInputTrackerActor apply() {
                        return this.$outer.new NetworkInputTrackerActor();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(NetworkInputTrackerActor.class)), "NetworkInputTracker"));
                this.receiverExecutor().start();
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "NetworkInputTracker started";
                    }
                });
            }
            return;
        }
        throw new SparkException("NetworkInputTracker already started");
    }

    public void stop() {
        if (!Predef$.MODULE$.refArrayOps((Object[])this.networkInputStreams()).isEmpty() && this.actor() != null) {
            this.receiverExecutor().interrupt();
            this.receiverExecutor().stopReceivers();
            this.org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc.env().actorSystem().stop(this.actor());
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "NetworkInputTracker stopped";
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized BlockId[] getBlockIds(int receiverId, Time time) {
        Queue queue;
        HashMap<Object, Queue<BlockId>> hashMap = this.receivedBlockIds();
        // MONITORENTER : hashMap
        Object object = this.receivedBlockIds().getOrElse((Object)BoxesRunTime.boxToInteger((int)receiverId), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Queue<BlockId> apply() {
                return new Queue();
            }
        });
        // MONITOREXIT : hashMap
        Queue queue2 = queue = (Queue)object;
        // MONITORENTER : queue2
        scala.collection.mutable.Seq seq = queue.dequeueAll((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BlockId x) {
                return true;
            }
        });
        // MONITOREXIT : queue2
        scala.collection.mutable.Seq result = seq;
        this.logInfo((Function0<String>)new Serializable(this, receiverId, result){
            public static final long serialVersionUID = 0L;
            private final int receiverId$1;
            private final scala.collection.mutable.Seq result$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Stream ").append((Object)BoxesRunTime.boxToInteger((int)this.receiverId$1)).append((Object)" received ").append((Object)BoxesRunTime.boxToInteger((int)this.result$1.size())).append((Object)" blocks").toString();
            }
            {
                this.receiverId$1 = receiverId$1;
                this.result$1 = result$1;
            }
        });
        return (BlockId[])result.toArray(ClassTag$.MODULE$.apply(BlockId.class));
    }

    public NetworkInputTracker(StreamingContext ssc) {
        this.org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc = ssc;
        Logging.class.$init$((Logging)this);
        this.networkInputStreams = ssc.graph().getNetworkInputStreams();
        this.networkInputStreamMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.networkInputStreams()).map((Function1)new $anonfun$1(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))));
        this.receiverExecutor = new ReceiverExecutor();
        this.receiverInfo = new HashMap();
        this.receivedBlockIds = new HashMap();
        this.timeout = AkkaUtils$.MODULE$.askTimeout(ssc.conf());
        this.actor = null;
        this.currentTime = null;
    }

    public class ReceiverExecutor
    extends Thread {
        private final SparkEnv env;

        public SparkEnv env() {
            return this.env;
        }

        @Override
        public void run() {
            try {
                SparkEnv$.MODULE$.set(this.env());
                this.startReceivers();
            }
            catch (InterruptedException interruptedException) {
                this.org$apache$spark$streaming$scheduler$NetworkInputTracker$ReceiverExecutor$$$outer().logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "ReceiverExecutor interrupted";
                    }
                });
            }
            finally {
                this.stopReceivers();
            }
        }

        public void startReceivers() {
            RDD rDD;
            NetworkReceiver[] receivers = (NetworkReceiver[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$NetworkInputTracker$ReceiverExecutor$$$outer().networkInputStreams()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final NetworkReceiver<?> apply(NetworkInputDStream<?> nis) {
                    void var2_2;
                    NetworkReceiver<?> rcvr = nis.getReceiver();
                    rcvr.setStreamId(nis.id());
                    return var2_2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NetworkReceiver.class)));
            boolean hasLocationPreferences = BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(NetworkReceiver<?> x$1) {
                    return x$1.getLocationPreference().isDefined();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()))).reduce((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(boolean x$2, boolean x$3) {
                    return x$2 && x$3;
                }
            }));
            if (hasLocationPreferences) {
                Tuple2[] receiversWithPreferences = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<NetworkReceiver<Object>, Seq<String>> apply(NetworkReceiver<?> r) {
                        return new Tuple2(r, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{r.getLocationPreference().toString()})));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                rDD = this.org$apache$spark$streaming$scheduler$NetworkInputTracker$ReceiverExecutor$$$outer().org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receiversWithPreferences), ClassTag$.MODULE$.apply(NetworkReceiver.class));
            } else {
                rDD = this.org$apache$spark$streaming$scheduler$NetworkInputTracker$ReceiverExecutor$$$outer().org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receivers), Predef$.MODULE$.refArrayOps((Object[])receivers).size(), ClassTag$.MODULE$.apply(NetworkReceiver.class));
            }
            RDD tempRDD = rDD;
            Serializable startReceiver = new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterator<NetworkReceiver<?>> iterator) {
                    if (iterator.hasNext()) {
                        ((NetworkReceiver)iterator.next()).start();
                        return;
                    }
                    throw new Exception("Could not start receiver as details not found.");
                }
            };
            Object object = this.org$apache$spark$streaming$scheduler$NetworkInputTracker$ReceiverExecutor$$$outer().org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc.sparkContext().isLocal() ? BoxedUnit.UNIT : SparkContext$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$NetworkInputTracker$ReceiverExecutor$$$outer().org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(int x) {
                    return new Tuple2.mcII.sp(x, 1);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).reduceByKey((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$4, int x$5) {
                    return this.apply$mcIII$sp(x$4, x$5);
                }

                public int apply$mcIII$sp(int x$4, int x$5) {
                    return x$4 + x$5;
                }
            }, 20).collect();
            this.org$apache$spark$streaming$scheduler$NetworkInputTracker$ReceiverExecutor$$$outer().org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc.sparkContext().runJob(tempRDD, (Function1)startReceiver, ClassTag$.MODULE$.Unit());
        }

        public void stopReceivers() {
            this.org$apache$spark$streaming$scheduler$NetworkInputTracker$ReceiverExecutor$$$outer().receiverInfo().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ActorRef x$6) {
                    ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(x$6);
                    StopReceiver$ x$7 = StopReceiver$.MODULE$;
                    ActorRef x$8 = qual$1.$bang$default$2((Object)((Object)x$7));
                    qual$1.$bang((Object)((Object)x$7), x$8);
                }
            });
        }

        public /* synthetic */ NetworkInputTracker org$apache$spark$streaming$scheduler$NetworkInputTracker$ReceiverExecutor$$$outer() {
            return NetworkInputTracker.this;
        }

        public ReceiverExecutor() {
            if (NetworkInputTracker.this == null) {
                throw new NullPointerException();
            }
            this.env = NetworkInputTracker.this.org$apache$spark$streaming$scheduler$NetworkInputTracker$$ssc.env();
        }
    }

    public class NetworkInputTrackerActor
    implements Actor {
        private final ActorContext context;
        private final ActorRef self;

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public final ActorRef sender() {
            return Actor.class.sender((Actor)this);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.class.supervisorStrategy((Actor)this);
        }

        public void preStart() throws Exception {
            Actor.class.preStart((Actor)this);
        }

        public void postStop() throws Exception {
            Actor.class.postStop((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.class.preRestart((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.class.postRestart((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.class.unhandled((Actor)this, (Object)message);
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NetworkInputTrackerActor $outer;

                /*
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver = (RegisterReceiver)A1;
                        int streamId = registerReceiver.streamId();
                        ActorRef receiverActor = registerReceiver.receiverActor();
                        if (!this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().networkInputStreamMap().contains((Object)BoxesRunTime.boxToInteger((int)streamId))) throw new Exception(new StringBuilder().append((Object)"Register received for unexpected id ").append((Object)BoxesRunTime.boxToInteger((int)streamId)).toString());
                        this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().receiverInfo().$plus$eq(new Tuple2((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)receiverActor));
                        this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().logInfo((Function0<String>)new Serializable(this, streamId){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ NetworkInputTrackerActor$$anonfun$receive$1 $outer;
                            private final int streamId$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Registered receiver for network stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$1)).append((Object)" from ").append((Object)this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$anonfun$$$outer().sender().path().address()).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.streamId$1 = streamId$1;
                            }
                        });
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    } else if (A1 instanceof AddBlocks) {
                        Queue tmp;
                        Object object22;
                        AddBlocks addBlocks = (AddBlocks)A1;
                        int streamId = addBlocks.streamId();
                        Seq<BlockId> blockIds = addBlocks.blockIds();
                        Object metadata = addBlocks.metadata();
                        HashMap<Object, Queue<BlockId>> hashMap = this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().receivedBlockIds();
                        synchronized (hashMap) {
                            Object object3 = this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().receivedBlockIds().contains((Object)BoxesRunTime.boxToInteger((int)streamId)) ? BoxedUnit.UNIT : this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().receivedBlockIds().$plus$eq(new Tuple2((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)new Queue()));
                            object22 = this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().receivedBlockIds().apply((Object)BoxesRunTime.boxToInteger((int)streamId));
                        }
                        Queue queue = tmp = (Queue)object22;
                        synchronized (queue) {
                            tmp.$plus$plus$eq(blockIds);
                            // MONITOREXIT @DISABLED, blocks:[1, 3, 9, 10] lbl29 : MonitorExitStatement: MONITOREXIT : var15_15
                            ((DStream)this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().networkInputStreamMap().apply((Object)BoxesRunTime.boxToInteger((int)streamId))).addMetadata(metadata);
                            object = BoxedUnit.UNIT;
                            return (B1)object;
                        }
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver.streamId();
                        String msg = deregisterReceiver.msg();
                        this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().receiverInfo().$minus$eq((Object)BoxesRunTime.boxToInteger((int)streamId));
                        this.$outer.org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer().logError((Function0<String>)new Serializable(this, streamId, msg){
                            public static final long serialVersionUID = 0L;
                            private final int streamId$2;
                            private final String msg$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"De-registered receiver for network stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$2)).append((Object)" with message ").append((Object)this.msg$1).toString();
                            }
                            {
                                this.streamId$2 = streamId$2;
                                this.msg$1 = msg$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof RegisterReceiver ? true : (object instanceof AddBlocks ? true : object instanceof DeregisterReceiver);
                    return bl;
                }

                public /* synthetic */ NetworkInputTrackerActor org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
        }

        public /* synthetic */ NetworkInputTracker org$apache$spark$streaming$scheduler$NetworkInputTracker$NetworkInputTrackerActor$$$outer() {
            return NetworkInputTracker.this;
        }

        public NetworkInputTrackerActor() {
            if (NetworkInputTracker.this == null) {
                throw new NullPointerException();
            }
            Actor.class.$init$((Actor)this);
        }
    }
}

