/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Milliseconds$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.util.FileGeneratingThread;
import org.apache.spark.streaming.util.TestOutputStream;
import org.apache.spark.streaming.util.TestOutputStream$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

public final class MasterFailureTest$
implements Logging {
    public static final MasterFailureTest$ MODULE$;
    private volatile boolean killed;
    private volatile int killCount;
    private volatile boolean setupCalled;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new MasterFailureTest$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public boolean killed() {
        return this.killed;
    }

    public void killed_$eq(boolean x$1) {
        this.killed = x$1;
    }

    public int killCount() {
        return this.killCount;
    }

    public void killCount_$eq(int x$1) {
        this.killCount = x$1;
    }

    public boolean setupCalled() {
        return this.setupCalled;
    }

    public void setupCalled_$eq(boolean x$1) {
        this.setupCalled = x$1;
    }

    public void main(String[] args) {
        if (Predef$.MODULE$.refArrayOps((Object[])args).size() < 2) {
            Predef$.MODULE$.println((Object)"Usage: MasterFailureTest <local/HDFS directory> <# batches> [<batch size in milliseconds>]");
            System.exit(1);
        }
        String directory = args[0];
        int numBatches = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        Duration batchDuration = Predef$.MODULE$.refArrayOps((Object[])args).size() > 2 ? Milliseconds$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt()) : Seconds$.MODULE$.apply(1L);
        Predef$.MODULE$.println((Object)"\n\n========================= MAP TEST =========================\n\n");
        this.testMap(directory, numBatches, batchDuration);
        Predef$.MODULE$.println((Object)"\n\n================= UPDATE-STATE-BY-KEY TEST =================\n\n");
        this.testUpdateStateByKey(directory, numBatches, batchDuration);
        Predef$.MODULE$.println((Object)"\n\nSUCCESS\n\n");
    }

    public void testMap(String directory, int numBatches, Duration batchDuration) {
        scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBatches).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$1) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
        Range.Inclusive expectedOutput = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBatches);
        Serializable operation = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DStream<Object> apply(DStream<String> st) {
                return st.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$2) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
                    }
                }, ClassTag$.MODULE$.Int());
            }
        };
        Seq output2 = this.testOperation(directory, batchDuration, (Seq<String>)input, (Function1)operation, (Seq)expectedOutput, (ClassTag)ClassTag$.MODULE$.Int());
        this.logInfo((Function0<String>)new Serializable(expectedOutput){
            public static final long serialVersionUID = 0L;
            private final Range.Inclusive expectedOutput$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Expected output, size = ").append((Object)BoxesRunTime.boxToInteger((int)this.expectedOutput$1.size())).toString();
            }
            {
                this.expectedOutput$1 = expectedOutput$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(expectedOutput){
            public static final long serialVersionUID = 0L;
            private final Range.Inclusive expectedOutput$1;

            public final String apply() {
                return this.expectedOutput$1.mkString("[", ",", "]");
            }
            {
                this.expectedOutput$1 = expectedOutput$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(output2){
            public static final long serialVersionUID = 0L;
            private final Seq output$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Output, size = ").append((Object)BoxesRunTime.boxToInteger((int)this.output$1.size())).toString();
            }
            {
                this.output$1 = output$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(output2){
            public static final long serialVersionUID = 0L;
            private final Seq output$1;

            public final String apply() {
                return this.output$1.mkString("[", ",", "]");
            }
            {
                this.output$1 = output$1;
            }
        });
        Set set = ((TraversableOnce)output2.distinct()).toSet();
        Set set2 = expectedOutput.toSet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null));
    }

    public void testUpdateStateByKey(String directory, int numBatches, Duration batchDuration) {
        scala.collection.immutable.Seq input = ((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBatches).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), i).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int x$3) {
                        return "a";
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ");
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
        IndexedSeq expectedOutput = (IndexedSeq)((TraversableLike)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)numBatches)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long i) {
                return this.apply$mcJJ$sp(i);
            }

            public long apply$mcJJ$sp(long i) {
                return BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)i)).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long x$4, long x$5) {
                        return this.apply$mcJJJ$sp(x$4, x$5);
                    }

                    public long apply$mcJJJ$sp(long x$4, long x$5) {
                        return x$4 + x$5;
                    }
                }));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(long j) {
                return new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)j));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Serializable operation = new Serializable(batchDuration){
            public static final long serialVersionUID = 0L;
            private final Duration batchDuration$1;

            public final DStream<Tuple2<String, Object>> apply(DStream<String> st) {
                Serializable updateFunc = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Some<Object> apply(Seq<Object> values, Option<Object> state) {
                        return new Some((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)values.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(long x$6, long x$7) {
                                return this.apply$mcJJJ$sp(x$6, x$7);
                            }

                            public long apply$mcJJJ$sp(long x$6, long x$7) {
                                return x$6 + x$7;
                            }
                        })) + BoxesRunTime.unboxToLong((Object)state.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        })))));
                    }
                };
                return StreamingContext$.MODULE$.toPairDStreamFunctions(st.flatMap(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WrappedArray<String> apply(String x$8) {
                        return Predef$.MODULE$.wrapRefArray((Object[])x$8.split(" "));
                    }
                }, ClassTag$.MODULE$.apply(String.class)).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(String x) {
                        return new Tuple2((Object)x, (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long()).updateStateByKey(updateFunc, ClassTag$.MODULE$.Long()).checkpoint(this.batchDuration$1.$times(5));
            }
            {
                this.batchDuration$1 = batchDuration$1;
            }
        };
        Seq output2 = this.testOperation(directory, batchDuration, (Seq<String>)input, (Function1)operation, (Seq)expectedOutput, (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
        this.logInfo((Function0<String>)new Serializable(expectedOutput){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq expectedOutput$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Expected output, size = ").append((Object)BoxesRunTime.boxToInteger((int)this.expectedOutput$2.size())).append((Object)"\n").append((Object)this.expectedOutput$2).toString();
            }
            {
                this.expectedOutput$2 = expectedOutput$2;
            }
        });
        this.logInfo((Function0<String>)new Serializable(output2){
            public static final long serialVersionUID = 0L;
            private final Seq output$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Output, size = ").append((Object)BoxesRunTime.boxToInteger((int)this.output$2.size())).append((Object)"\n").append((Object)this.output$2).toString();
            }
            {
                this.output$2 = output$2;
            }
        });
        output2.foreach((Function1)new Serializable(expectedOutput){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq expectedOutput$2;

            public final void apply(Tuple2<String, Object> o) {
                Predef$.MODULE$.assert(this.expectedOutput$2.contains(o), (Function0)new Serializable(this, o){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 o$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Expected value ").append((Object)this.o$1).append((Object)" not found").toString();
                    }
                    {
                        this.o$1 = o$1;
                    }
                });
            }
            {
                this.expectedOutput$2 = expectedOutput$2;
            }
        });
        Predef$.MODULE$.assert(BoxesRunTime.equals((Object)output2.last(), (Object)expectedOutput.last()));
    }

    public <T> Seq<T> testOperation(String directory, Duration batchDuration, Seq<String> input, Function1<DStream<String>, DStream<T>> operation, Seq<T> expectedOutput, ClassTag<T> evidence$1) {
        Set set = ((TraversableOnce)expectedOutput.distinct()).toSet();
        Set set2 = expectedOutput.toSet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null));
        this.reset();
        String uuid = UUID.randomUUID().toString();
        Path rootDir = new Path(directory, uuid);
        FileSystem fs = rootDir.getFileSystem(new Configuration());
        Path checkpointDir = new Path(rootDir, "checkpoint");
        Path testDir = new Path(rootDir, "test");
        fs.mkdirs(checkpointDir);
        fs.mkdirs(testDir);
        StreamingContext ssc = StreamingContext$.MODULE$.getOrCreate(checkpointDir.toString(), (Function0<StreamingContext>)new Serializable(batchDuration, operation, evidence$1, checkpointDir, testDir){
            public static final long serialVersionUID = 0L;
            private final Duration batchDuration$2;
            private final Function1 operation$1;
            private final ClassTag evidence$1$1;
            private final Path checkpointDir$1;
            private final Path testDir$1;

            public final StreamingContext apply() {
                return MasterFailureTest$.MODULE$.org$apache$spark$streaming$util$MasterFailureTest$$setupStreams(this.batchDuration$2, this.operation$1, this.checkpointDir$1, this.testDir$1, this.evidence$1$1);
            }
            {
                this.batchDuration$2 = batchDuration$2;
                this.operation$1 = operation$1;
                this.evidence$1$1 = evidence$1$1;
                this.checkpointDir$1 = checkpointDir$1;
                this.testDir$1 = testDir$1;
            }
        }, StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4());
        Predef$.MODULE$.assert(this.setupCalled(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setup was not called in the first call to StreamingContext.getOrCreate";
            }
        });
        FileGeneratingThread fileGeneratingThread = new FileGeneratingThread(input, testDir, batchDuration.milliseconds());
        fileGeneratingThread.start();
        Object lastExpectedOutput = expectedOutput.last();
        long maxTimeToRun = (long)expectedOutput.size() * batchDuration.milliseconds() * 2L;
        Seq<Object> mergedOutput = this.runStreams(ssc, lastExpectedOutput, maxTimeToRun, evidence$1);
        fileGeneratingThread.join();
        fs.delete(checkpointDir, true);
        fs.delete(testDir, true);
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Finished test after ").append((Object)BoxesRunTime.boxToInteger((int)MasterFailureTest$.MODULE$.killCount())).append((Object)" failures").toString();
            }
        });
        return mergedOutput;
    }

    public <T> StreamingContext org$apache$spark$streaming$util$MasterFailureTest$$setupStreams(Duration batchDuration, Function1<DStream<String>, DStream<T>> operation, Path checkpointDir, Path testDir, ClassTag<T> evidence$2) {
        this.setupCalled_$eq(true);
        System.clearProperty("spark.driver.port");
        StreamingContext ssc = new StreamingContext("local[4]", "MasterFailureTest", batchDuration, null, (Seq<String>)Nil$.MODULE$, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        ssc.checkpoint(checkpointDir.toString());
        DStream<String> inputStream = ssc.textFileStream(testDir.toString());
        DStream operatedStream = (DStream)operation.apply(inputStream);
        TestOutputStream outputStream = new TestOutputStream(operatedStream, TestOutputStream$.MODULE$.$lessinit$greater$default$2(), evidence$2);
        outputStream.register();
        return ssc;
    }

    /*
     * Exception decompiling
     */
    private <T> Seq<T> runStreams(StreamingContext ssc_, T lastExpectedOutput, long maxTimeToRun, ClassTag<T> evidence$3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 395->526)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> void verifyOutput(Seq<T> output2, Seq<T> expectedOutput, ClassTag<T> evidence$4) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), expectedOutput.size() - 1).foreach$mVc$sp((Function1)new Serializable(expectedOutput){
            public static final long serialVersionUID = 0L;
            private final Seq expectedOutput$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Predef$.MODULE$.assert(!BoxesRunTime.equals((Object)this.expectedOutput$3.apply(i), (Object)this.expectedOutput$3.apply(i + 1)), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Expected output has consecutive duplicate sequence of values";
                    }
                });
            }
            {
                this.expectedOutput$3 = expectedOutput$3;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Expected output, size = ").append((Object)BoxesRunTime.boxToInteger((int)expectedOutput.size())).toString());
        Predef$.MODULE$.println((Object)expectedOutput.mkString("[", ",", "]"));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Output, size = ").append((Object)BoxesRunTime.boxToInteger((int)output2.size())).toString());
        Predef$.MODULE$.println((Object)output2.mkString("[", ",", "]"));
        output2.foreach((Function1)new Serializable(expectedOutput){
            public static final long serialVersionUID = 0L;
            private final Seq expectedOutput$3;

            public final void apply(T o) {
                Predef$.MODULE$.assert(this.expectedOutput$3.contains(o), (Function0)new Serializable(this, o){
                    public static final long serialVersionUID = 0L;
                    private final Object o$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Expected value ").append(this.o$2).append((Object)" not found").toString();
                    }
                    {
                        this.o$2 = o$2;
                    }
                });
            }
            {
                this.expectedOutput$3 = expectedOutput$3;
            }
        });
    }

    private void reset() {
        this.killed_$eq(false);
        this.killCount_$eq(0);
        this.setupCalled_$eq(false);
    }

    public final ArrayBuffer org$apache$spark$streaming$util$MasterFailureTest$$output$4(ArrayBuffer outputBuffer$1) {
        return (ArrayBuffer)outputBuffer$1.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<T> apply(Seq<T> x) {
                return x;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
    }

    private MasterFailureTest$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.killed = false;
        this.killCount = 0;
        this.setupCalled = false;
    }
}

