/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001A4Q!\u0001\u0002\u0001\t1\u0011qCU1uK2KW.\u001b;fI>+H\u000f];u'R\u0014X-Y7\u000b\u0005\r!\u0011\u0001B;uS2T!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001C\u0001\b\u0014\u001b\u0005y!B\u0001\t\u0012\u0003\tIwNC\u0001\u0013\u0003\u0011Q\u0017M^1\n\u0005Qy!\u0001D(viB,Ho\u0015;sK\u0006l\u0007\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011B\u0007\u0002\u0007=,Ho\u0001\u0001\t\u0011e\u0001!\u0011!Q\u0001\ni\t1BY=uKN\u0004VM]*fGB\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t\u0019\u0011J\u001c;\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\r\u0019SE\n\t\u0003I\u0001i\u0011A\u0001\u0005\u0006-\u0001\u0002\r!\u0004\u0005\u00063\u0001\u0002\rA\u0007\u0005\bQ\u0001\u0011\r\u0011\"\u0001*\u00035\u0019\u0016LT\"`\u0013:#VI\u0015,B\u0019V\t!\u0006\u0005\u0002\u001cW%\u0011A\u0006\b\u0002\u0005\u0019>tw\r\u0003\u0004/\u0001\u0001\u0006IAK\u0001\u000f'fs5iX%O)\u0016\u0013f+\u0011'!\u0011\u001d\u0001\u0004A1A\u0005\u0002E\n!b\u0011%V\u001d.{6+\u0013.F+\u0005Q\u0002BB\u001a\u0001A\u0003%!$A\u0006D\u0011Vs5jX*J5\u0016\u0003\u0003bB\u001b\u0001\u0001\u0004%\t!K\u0001\rY\u0006\u001cHoU=oGRKW.\u001a\u0005\bo\u0001\u0001\r\u0011\"\u00019\u0003Aa\u0017m\u001d;Ts:\u001cG+[7f?\u0012*\u0017\u000f\u0006\u0002:yA\u00111DO\u0005\u0003wq\u0011A!\u00168ji\"9QHNA\u0001\u0002\u0004Q\u0013a\u0001=%c!1q\b\u0001Q!\n)\nQ\u0002\\1tiNKhn\u0019+j[\u0016\u0004\u0003bB!\u0001\u0001\u0004%\t!K\u0001\u0016Ef$Xm],sSR$XM\\*j]\u000e,7+\u001f8d\u0011\u001d\u0019\u0005\u00011A\u0005\u0002\u0011\u000b\u0011DY=uKN<&/\u001b;uK:\u001c\u0016N\\2f'ft7m\u0018\u0013fcR\u0011\u0011(\u0012\u0005\b{\t\u000b\t\u00111\u0001+\u0011\u00199\u0005\u0001)Q\u0005U\u00051\"-\u001f;fg^\u0013\u0018\u000e\u001e;f]NKgnY3Ts:\u001c\u0007\u0005C\u0003J\u0001\u0011\u0005#*A\u0003xe&$X\r\u0006\u0002:\u0017\")A\n\u0013a\u00015\u0005\t!\rC\u0003J\u0001\u0011\u0005c\n\u0006\u0002:\u001f\")\u0001+\u0014a\u0001#\u0006)!-\u001f;fgB\u00191D\u0015+\n\u0005Mc\"!B!se\u0006L\bCA\u000eV\u0013\t1FD\u0001\u0003CsR,\u0007\"B%\u0001\t\u000bBF\u0003B\u001dZ5rCQ\u0001U,A\u0002ECQaW,A\u0002i\taa\u001c4gg\u0016$\b\"B/X\u0001\u0004Q\u0012A\u00027f]\u001e$\b\u000e\u000b\u0002X?B\u0011\u0001mY\u0007\u0002C*\u0011!\rH\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00013b\u0005\u001d!\u0018-\u001b7sK\u000eDQA\u001a\u0001\u0005B\u001d\fQA\u001a7vg\"$\u0012!\u000f\u0005\u0006S\u0002!\teZ\u0001\u0006G2|7/\u001a\u0005\u0006W\u0002!I\u0001\\\u0001\fo\u0006LG\u000fV8Xe&$X\r\u0006\u0002:[\")aN\u001ba\u00015\u0005Aa.^7CsR,7\u000f\u000b\u0002k?\u0002")
public class RateLimitedOutputStream
extends OutputStream {
    private final OutputStream out;
    private final int bytesPerSec;
    private final long SYNC_INTERVAL;
    private final int CHUNK_SIZE;
    private long lastSyncTime;
    private long bytesWrittenSinceSync;

    public long SYNC_INTERVAL() {
        return this.SYNC_INTERVAL;
    }

    public int CHUNK_SIZE() {
        return this.CHUNK_SIZE;
    }

    public long lastSyncTime() {
        return this.lastSyncTime;
    }

    public void lastSyncTime_$eq(long x$1) {
        this.lastSyncTime = x$1;
    }

    public long bytesWrittenSinceSync() {
        return this.bytesWrittenSinceSync;
    }

    public void bytesWrittenSinceSync_$eq(long x$1) {
        this.bytesWrittenSinceSync = x$1;
    }

    @Override
    public void write(int b) {
        this.waitToWrite(1);
        this.out.write(b);
    }

    @Override
    public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public final void write(byte[] bytes, int offset, int length) {
        int writeSize;
        while ((writeSize = package$.MODULE$.min(length - offset, this.CHUNK_SIZE())) > 0) {
            this.waitToWrite(writeSize);
            this.out.write(bytes, offset, writeSize);
            offset += writeSize;
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    /*
     * WARNING - void declaration
     */
    private void waitToWrite(int numBytes) {
        while (true) {
            void var5_3;
            long now = System.nanoTime();
            long elapsedSecs = TimeUnit.SECONDS.convert(package$.MODULE$.max(now - this.lastSyncTime(), 1L), TimeUnit.NANOSECONDS);
            double rate = (double)this.bytesWrittenSinceSync() / (double)elapsedSecs;
            if (rate < (double)this.bytesPerSec) {
                BoxedUnit boxedUnit;
                this.bytesWrittenSinceSync_$eq(this.bytesWrittenSinceSync() + (long)numBytes);
                if (now > this.lastSyncTime() + this.SYNC_INTERVAL()) {
                    this.lastSyncTime_$eq(now);
                    this.bytesWrittenSinceSync_$eq(numBytes);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            long sleepTime = TimeUnit.MILLISECONDS.convert(this.bytesWrittenSinceSync() / (long)this.bytesPerSec - var5_3, TimeUnit.SECONDS);
            if (sleepTime <= 0L) continue;
            Thread.sleep(sleepTime);
        }
    }

    public RateLimitedOutputStream(OutputStream out, int bytesPerSec) {
        this.out = out;
        this.bytesPerSec = bytesPerSec;
        this.SYNC_INTERVAL = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
        this.CHUNK_SIZE = 8192;
        this.lastSyncTime = System.nanoTime();
        this.bytesWrittenSinceSync = 0L;
    }
}

