/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import org.apache.spark.streaming.util.Clock;
import org.apache.spark.streaming.util.RecurringTimer$;
import scala.Function1;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Y4Q!\u0001\u0002\u0001\t1\u0011aBU3dkJ\u0014\u0018N\\4US6,'O\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001aD\u0001\u0002\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\u0006G2|7m[\u0002\u0001+\u00059\u0002C\u0001\r\u001a\u001b\u0005\u0011\u0011B\u0001\u000e\u0003\u0005\u0015\u0019En\\2l\u0011!a\u0002A!A!\u0002\u00139\u0012AB2m_\u000e\\\u0007\u0005\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0001 \u0003\u0019\u0001XM]5pIV\t\u0001\u0005\u0005\u0002\u000fC%\u0011!e\u0004\u0002\u0005\u0019>tw\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003!\u0003\u001d\u0001XM]5pI\u0002B\u0001B\n\u0001\u0003\u0006\u0004%\taJ\u0001\tG\u0006dGNY1dWV\t\u0001\u0006\u0005\u0003\u000fS\u0001Z\u0013B\u0001\u0016\u0010\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\u000fY%\u0011Qf\u0004\u0002\u0005+:LG\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u0003)\u0003%\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0004=S:LGO\u0010\u000b\u0005gQ*d\u0007\u0005\u0002\u0019\u0001!)A\u0003\ra\u0001/!)a\u0004\ra\u0001A!)a\u0005\ra\u0001Q!9\u0001\b\u0001b\u0001\n\u0013I\u0014A\u0002;ie\u0016\fG-F\u0001;!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0003mC:<'\"A \u0002\t)\fg/Y\u0005\u0003\u0003r\u0012a\u0001\u00165sK\u0006$\u0007BB\"\u0001A\u0003%!(A\u0004uQJ,\u0017\r\u001a\u0011\t\u000f\u0015\u0003\u0001\u0019!C\u0005?\u0005Aa.\u001a=u)&lW\rC\u0004H\u0001\u0001\u0007I\u0011\u0002%\u0002\u00199,\u0007\u0010\u001e+j[\u0016|F%Z9\u0015\u0005-J\u0005b\u0002&G\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004B\u0002'\u0001A\u0003&\u0001%A\u0005oKb$H+[7fA!)a\n\u0001C\u0001\u001f\u0006aq-\u001a;Ti\u0006\u0014H\u000fV5nKR\t\u0001\u0005C\u0003R\u0001\u0011\u0005!+\u0001\bhKR\u0014Vm\u001d;beR$\u0016.\\3\u0015\u0005\u0001\u001a\u0006\"\u0002+Q\u0001\u0004\u0001\u0013!E8sS\u001eLg.\u00197Ti\u0006\u0014H\u000fV5nK\")a\u000b\u0001C\u0001/\u0006)1\u000f^1siR\u0011\u0001\u0005\u0017\u0005\u00063V\u0003\r\u0001I\u0001\ngR\f'\u000f\u001e+j[\u0016DQA\u0016\u0001\u0005\u0002=CQ\u0001\u0018\u0001\u0005\u0002u\u000bAa\u001d;paR\t1\u0006C\u0003`\u0001\u0011%Q,\u0001\u0003m_>\u0004xAB1\u0003\u0011\u0003!!-\u0001\bSK\u000e,(O]5oORKW.\u001a:\u0011\u0005a\u0019gAB\u0001\u0003\u0011\u0003!Am\u0005\u0002d\u001b!)\u0011g\u0019C\u0001MR\t!\rC\u0003iG\u0012\u0005\u0011.\u0001\u0003nC&tGCA\u0016k\u0011\u0015Yw\r1\u0001m\u0003\u0011\t'oZ:\u0011\u00079iw.\u0003\u0002o\u001f\t)\u0011I\u001d:bsB\u0011\u0001o\u001d\b\u0003\u001dEL!A]\b\u0002\rA\u0013X\rZ3g\u0013\t!XO\u0001\u0004TiJLgn\u001a\u0006\u0003e>\u0001")
public class RecurringTimer {
    private final Clock clock;
    private final long period;
    private final Function1<Object, BoxedUnit> callback;
    private final Thread thread;
    private long nextTime;

    public static void main(String[] stringArray) {
        RecurringTimer$.MODULE$.main(stringArray);
    }

    public Clock clock() {
        return this.clock;
    }

    public long period() {
        return this.period;
    }

    public Function1<Object, BoxedUnit> callback() {
        return this.callback;
    }

    private Thread thread() {
        return this.thread;
    }

    private long nextTime() {
        return this.nextTime;
    }

    private void nextTime_$eq(long x$1) {
        this.nextTime = x$1;
    }

    public long getStartTime() {
        return (long)(package$.MODULE$.floor((double)this.clock().currentTime() / (double)this.period()) + 1.0) * this.period();
    }

    public long getRestartTime(long originalStartTime) {
        long gap = this.clock().currentTime() - originalStartTime;
        return ((long)package$.MODULE$.floor((double)gap / (double)this.period()) + 1L) * this.period() + originalStartTime;
    }

    public long start(long startTime) {
        this.nextTime_$eq(startTime);
        this.thread().start();
        return this.nextTime();
    }

    public long start() {
        return this.start(this.getStartTime());
    }

    public void stop() {
        this.thread().interrupt();
    }

    public void org$apache$spark$streaming$util$RecurringTimer$$loop() {
        try {
            while (true) {
                this.clock().waitTillTime(this.nextTime());
                this.callback().apply$mcVJ$sp(this.nextTime());
                this.nextTime_$eq(this.nextTime() + this.period());
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public RecurringTimer(Clock clock, long period, Function1<Object, BoxedUnit> callback) {
        this.clock = clock;
        this.period = period;
        this.callback = callback;
        this.thread = new $anon$1(this);
        this.nextTime = 0L;
    }
}

