/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.BatchInfo;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobSet$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg!B\u0001\u0003\u0001\u0012a!A\u0002&pEN+GO\u0003\u0002\u0004\t\u0005I1o\u00195fIVdWM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u0014-A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"A\u0004\u000b\n\u0005Uy!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001d]I!\u0001G\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011i\u0001!Q3A\u0005\u0002q\tA\u0001^5nK\u000e\u0001Q#A\u000f\u0011\u0005yyR\"\u0001\u0003\n\u0005\u0001\"!\u0001\u0002+j[\u0016D\u0001B\t\u0001\u0003\u0012\u0003\u0006I!H\u0001\u0006i&lW\r\t\u0005\tI\u0001\u0011)\u001a!C\u0001K\u0005!!n\u001c2t+\u00051\u0003cA\u00140e9\u0011\u0001&\f\b\u0003S1j\u0011A\u000b\u0006\u0003Wm\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u00059z\u0011a\u00029bG.\fw-Z\u0005\u0003aE\u00121aU3r\u0015\tqs\u0002\u0005\u00024i5\t!!\u0003\u00026\u0005\t\u0019!j\u001c2\t\u0011]\u0002!\u0011#Q\u0001\n\u0019\nQA[8cg\u0002BQ!\u000f\u0001\u0005\u0002i\na\u0001P5oSRtDcA\u001e={A\u00111\u0007\u0001\u0005\u00065a\u0002\r!\b\u0005\u0006Ia\u0002\rA\n\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u00039IgnY8na2,G/\u001a&pEN,\u0012!\u0011\t\u0004\u0005\u001e\u0013T\"A\"\u000b\u0005\u0011+\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\r>\t!bY8mY\u0016\u001cG/[8o\u0013\tA5IA\u0004ICND7+\u001a;\t\r)\u0003\u0001\u0015!\u0003B\u0003=IgnY8na2,G/\u001a&pEN\u0004\u0003b\u0002'\u0001\u0005\u0004%I!T\u0001\u000fgV\u0014W.[:tS>tG+[7f+\u0005q\u0005C\u0001\bP\u0013\t\u0001vB\u0001\u0003M_:<\u0007B\u0002*\u0001A\u0003%a*A\btk\nl\u0017n]:j_:$\u0016.\\3!\u0011\u001d!\u0006\u00011A\u0005\n5\u000b1\u0003\u001d:pG\u0016\u001c8/\u001b8h'R\f'\u000f\u001e+j[\u0016DqA\u0016\u0001A\u0002\u0013%q+A\fqe>\u001cWm]:j]\u001e\u001cF/\u0019:u)&lWm\u0018\u0013fcR\u0011\u0001l\u0017\t\u0003\u001deK!AW\b\u0003\tUs\u0017\u000e\u001e\u0005\b9V\u000b\t\u00111\u0001O\u0003\rAH%\r\u0005\u0007=\u0002\u0001\u000b\u0015\u0002(\u0002)A\u0014xnY3tg&twm\u0015;beR$\u0016.\\3!\u0011\u001d\u0001\u0007\u00011A\u0005\n5\u000b\u0011\u0003\u001d:pG\u0016\u001c8/\u001b8h\u000b:$G+[7f\u0011\u001d\u0011\u0007\u00011A\u0005\n\r\fQ\u0003\u001d:pG\u0016\u001c8/\u001b8h\u000b:$G+[7f?\u0012*\u0017\u000f\u0006\u0002YI\"9A,YA\u0001\u0002\u0004q\u0005B\u00024\u0001A\u0003&a*\u0001\nqe>\u001cWm]:j]\u001e,e\u000e\u001a+j[\u0016\u0004\u0003\"\u00025\u0001\t\u0003I\u0017A\u00045b]\u0012dWMS8c'R\f'\u000f\u001e\u000b\u00031*DQa[4A\u0002I\n1A[8c\u0011\u0015i\u0007\u0001\"\u0001o\u0003MA\u0017M\u001c3mK*{'mQ8na2,G/[8o)\tAv\u000eC\u0003lY\u0002\u0007!\u0007C\u0003r\u0001\u0011\u0005!/\u0001\u0006iCN\u001cF/\u0019:uK\u0012,\u0012a\u001d\t\u0003\u001dQL!!^\b\u0003\u000f\t{w\u000e\\3b]\")q\u000f\u0001C\u0001e\u0006a\u0001.Y:D_6\u0004H.\u001a;fI\")\u0011\u0010\u0001C\u0001\u001b\u0006y\u0001O]8dKN\u001c\u0018N\\4EK2\f\u0017\u0010C\u0003|\u0001\u0011\u0005Q*\u0001\u0006u_R\fG\u000eR3mCfDQ! \u0001\u0005\u0002y\f1\u0002^8CCR\u001c\u0007.\u00138g_V\tq\u0010E\u00024\u0003\u0003I1!a\u0001\u0003\u0005%\u0011\u0015\r^2i\u0013:4w\u000eC\u0005\u0002\b\u0001\t\t\u0011\"\u0001\u0002\n\u0005!1m\u001c9z)\u0015Y\u00141BA\u0007\u0011!Q\u0012Q\u0001I\u0001\u0002\u0004i\u0002\u0002\u0003\u0013\u0002\u0006A\u0005\t\u0019\u0001\u0014\t\u0013\u0005E\u0001!%A\u0005\u0002\u0005M\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003+Q3!HA\fW\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0012\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0012Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0016\u0001E\u0005I\u0011AA\u0017\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\f+\u0007\u0019\n9\u0002C\u0005\u00024\u0001\t\t\u0011\"\u0011\u00026\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u000e\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005!A.\u00198h\u0015\t\t\t%\u0001\u0003kCZ\f\u0017\u0002BA#\u0003w\u0011aa\u0015;sS:<\u0007\"CA%\u0001\u0005\u0005I\u0011AA&\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0005E\u0002\u000f\u0003\u001fJ1!!\u0015\u0010\u0005\rIe\u000e\u001e\u0005\n\u0003+\u0002\u0011\u0011!C\u0001\u0003/\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002Z\u0005}\u0003c\u0001\b\u0002\\%\u0019\u0011QL\b\u0003\u0007\u0005s\u0017\u0010C\u0005]\u0003'\n\t\u00111\u0001\u0002N!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013QM\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\r\t\u0007\u0003S\nY'!\u0017\u000e\u0003\u0015K1!!\u001cF\u0005!IE/\u001a:bi>\u0014\b\"CA9\u0001\u0005\u0005I\u0011AA:\u0003!\u0019\u0017M\\#rk\u0006dGcA:\u0002v!IA,a\u001c\u0002\u0002\u0003\u0007\u0011\u0011\f\u0005\n\u0003s\u0002\u0011\u0011!C!\u0003w\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u001bB\u0011\"a \u0001\u0003\u0003%\t%!!\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000e\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001d\u0015AB3rk\u0006d7\u000fF\u0002t\u0003\u0013C\u0011\u0002XAB\u0003\u0003\u0005\r!!\u0017\b\u0015\u00055%!!A\t\u0002\u0011\ty)\u0001\u0004K_\n\u001cV\r\u001e\t\u0004g\u0005Ee!C\u0001\u0003\u0003\u0003E\t\u0001BAJ'\u0015\t\t*!&\u0017!\u001d\t9*!(\u001eMmj!!!'\u000b\u0007\u0005mu\"A\u0004sk:$\u0018.\\3\n\t\u0005}\u0015\u0011\u0014\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB\u001d\u0002\u0012\u0012\u0005\u00111\u0015\u000b\u0003\u0003\u001fC!\"a \u0002\u0012\u0006\u0005IQIAA\u0011)\tI+!%\u0002\u0002\u0013\u0005\u00151V\u0001\u0006CB\u0004H.\u001f\u000b\u0006w\u00055\u0016q\u0016\u0005\u00075\u0005\u001d\u0006\u0019A\u000f\t\r\u0011\n9\u000b1\u0001'\u0011)\t\u0019,!%\u0002\u0002\u0013\u0005\u0015QW\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9,a1\u0011\u000b9\tI,!0\n\u0007\u0005mvB\u0001\u0004PaRLwN\u001c\t\u0006\u001d\u0005}VDJ\u0005\u0004\u0003\u0003|!A\u0002+va2,'\u0007C\u0005\u0002F\u0006E\u0016\u0011!a\u0001w\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005%\u0017\u0011SA\u0001\n\u0013\tY-A\u0006sK\u0006$'+Z:pYZ,GCAAg!\u0011\tI$a4\n\t\u0005E\u00171\b\u0002\u0007\u001f\nTWm\u0019;")
public class JobSet
implements Product,
Serializable {
    private final Time time;
    private final Seq<Job> jobs;
    private final HashSet<Job> incompleteJobs;
    private final long submissionTime;
    private long processingStartTime;
    private long processingEndTime;

    public static Function1<Tuple2<Time, Seq<Job>>, JobSet> tupled() {
        return JobSet$.MODULE$.tupled();
    }

    public static Function1<Time, Function1<Seq<Job>, JobSet>> curried() {
        return JobSet$.MODULE$.curried();
    }

    public Time time() {
        return this.time;
    }

    public Seq<Job> jobs() {
        return this.jobs;
    }

    private HashSet<Job> incompleteJobs() {
        return this.incompleteJobs;
    }

    private long submissionTime() {
        return this.submissionTime;
    }

    private long processingStartTime() {
        return this.processingStartTime;
    }

    private void processingStartTime_$eq(long x$1) {
        this.processingStartTime = x$1;
    }

    private long processingEndTime() {
        return this.processingEndTime;
    }

    private void processingEndTime_$eq(long x$1) {
        this.processingEndTime = x$1;
    }

    public void handleJobStart(Job job) {
        if (this.processingStartTime() < 0L) {
            this.processingStartTime_$eq(System.currentTimeMillis());
        }
    }

    public void handleJobCompletion(Job job) {
        this.incompleteJobs().$minus$eq((Object)job);
        if (this.hasCompleted()) {
            this.processingEndTime_$eq(System.currentTimeMillis());
        }
    }

    public boolean hasStarted() {
        return this.processingStartTime() > 0L;
    }

    public boolean hasCompleted() {
        return this.incompleteJobs().isEmpty();
    }

    public long processingDelay() {
        return this.processingEndTime() - this.processingStartTime();
    }

    public long totalDelay() {
        return this.processingEndTime() - this.time().milliseconds();
    }

    public BatchInfo toBatchInfo() {
        return new BatchInfo(this.time(), this.submissionTime(), (Option<Object>)(this.processingStartTime() >= 0L ? new Some((Object)BoxesRunTime.boxToLong((long)this.processingStartTime())) : None$.MODULE$), (Option<Object>)(this.processingEndTime() >= 0L ? new Some((Object)BoxesRunTime.boxToLong((long)this.processingEndTime())) : None$.MODULE$));
    }

    public JobSet copy(Time time, Seq<Job> jobs) {
        return new JobSet(time, jobs);
    }

    public Time copy$default$1() {
        return this.time();
    }

    public Seq<Job> copy$default$2() {
        return this.jobs();
    }

    public String productPrefix() {
        return "JobSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.jobs();
                break;
            }
            case 0: {
                object = this.time();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JobSet;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JobSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        JobSet jobSet = (JobSet)x$1;
        Time time = this.time();
        Time time2 = jobSet.time();
        if (time == null) {
            if (time2 != null) {
                return false;
            }
        } else if (!((Object)time).equals(time2)) return false;
        Seq<Job> seq = this.jobs();
        Seq<Job> seq2 = jobSet.jobs();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!jobSet.canEqual(this)) return false;
        return true;
    }

    public JobSet(Time time, Seq<Job> jobs) {
        this.time = time;
        this.jobs = jobs;
        Product.class.$init$((Product)this);
        this.incompleteJobs = new HashSet();
        this.submissionTime = System.currentTimeMillis();
        this.processingStartTime = -1L;
        this.processingEndTime = -1L;
        ((IterableLike)jobs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Job, Object> x0$1) {
                Tuple2<Job, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Job job = (Job)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    job.setId(i);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        this.incompleteJobs().$plus$plus$eq(jobs);
    }
}

