/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.pattern.AskableActorSelection$;
import akka.util.Timeout$;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.spark.Logging;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.dstream.NetworkReceiver$BlockGenerator$;
import org.apache.spark.streaming.dstream.NetworkReceiver$BlockGenerator$Block$;
import org.apache.spark.streaming.dstream.ReportBlock;
import org.apache.spark.streaming.dstream.ReportError;
import org.apache.spark.streaming.dstream.StopReceiver;
import org.apache.spark.streaming.scheduler.AddBlocks;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.streaming.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rmd!B\u0001\u0003\u0003\u0003i!a\u0004(fi^|'o\u001b*fG\u0016Lg/\u001a:\u000b\u0005\r!\u0011a\u00023tiJ,\u0017-\u001c\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u000fMM!\u0001aD\u000b\u0019!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011\u0001CF\u0005\u0003/E\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"!\u0007\u000e\u000e\u0003\u0019I!a\u0007\u0004\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001B\u0002B\u0003-a$\u0001\u0006fm&$WM\\2fII\u00022a\b\u0012%\u001b\u0005\u0001#BA\u0011\u0012\u0003\u001d\u0011XM\u001a7fGRL!a\t\u0011\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"!\n\u0014\r\u0001\u0011)q\u0005\u0001b\u0001Q\t\tA+\u0005\u0002*YA\u0011\u0001CK\u0005\u0003WE\u0011qAT8uQ&tw\r\u0005\u0002\u0011[%\u0011a&\u0005\u0002\u0004\u0003:L\b\"\u0002\u0019\u0001\t\u0003\t\u0014A\u0002\u001fj]&$h\bF\u00013)\t\u0019T\u0007E\u00025\u0001\u0011j\u0011A\u0001\u0005\u0006;=\u0002\u001dA\b\u0005\to\u0001A)\u0019!C\tq\u0005\u0019QM\u001c<\u0016\u0003e\u0002\"!\u0007\u001e\n\u0005m2!\u0001C*qCJ\\WI\u001c<\t\u0011u\u0002\u0001\u0012!Q!\ne\nA!\u001a8wA!Aq\b\u0001EC\u0002\u0013E\u0001)A\u0003bGR|'/F\u0001B!\t\u0011e)D\u0001D\u0015\tyDIC\u0001F\u0003\u0011\t7n[1\n\u0005\u001d\u001b%\u0001C!di>\u0014(+\u001a4\t\u0011%\u0003\u0001\u0012!Q!\n\u0005\u000ba!Y2u_J\u0004\u0003\u0002C&\u0001\u0011\u000b\u0007I\u0011\u0003'\u0002\u001fI,7-Z5wS:<G\u000b\u001b:fC\u0012,\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001\\1oO*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005\u0019!\u0006N]3bI\"Aa\u000b\u0001E\u0001B\u0003&Q*\u0001\tsK\u000e,\u0017N^5oORC'/Z1eA!9\u0001\f\u0001a\u0001\n#I\u0016\u0001C:ue\u0016\fW.\u00133\u0016\u0003i\u0003\"\u0001E.\n\u0005q\u000b\"aA%oi\"9a\f\u0001a\u0001\n#y\u0016\u0001D:ue\u0016\fW.\u00133`I\u0015\fHC\u00011d!\t\u0001\u0012-\u0003\u0002c#\t!QK\\5u\u0011\u001d!W,!AA\u0002i\u000b1\u0001\u001f\u00132\u0011\u00191\u0007\u0001)Q\u00055\u0006I1\u000f\u001e:fC6LE\r\t\u0005\u0006Q\u00021\t\"[\u0001\b_:\u001cF/\u0019:u)\u0005\u0001\u0007\"B6\u0001\r#I\u0017AB8o'R|\u0007\u000fC\u0003n\u0001\u0011\u0005a.A\u000bhKRdunY1uS>t\u0007K]3gKJ,gnY3\u0015\u0003=\u00042\u0001\u00059s\u0013\t\t\u0018C\u0001\u0004PaRLwN\u001c\t\u0003gZt!\u0001\u0005;\n\u0005U\f\u0012A\u0002)sK\u0012,g-\u0003\u0002xq\n11\u000b\u001e:j]\u001eT!!^\t\t\u000bi\u0004A\u0011A5\u0002\u000bM$\u0018M\u001d;\t\u000bq\u0004A\u0011A5\u0002\tM$x\u000e\u001d\u0005\u0006}\u0002!\tb`\u0001\fgR|\u0007o\u00148FeJ|'\u000fF\u0002a\u0003\u0003Aq!a\u0001~\u0001\u0004\t)!A\u0001f!\u0011\t9!a\u0006\u000f\t\u0005%\u00111\u0003\b\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012bAA\u000b#\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\r\u00037\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005U\u0011\u0003C\u0004\u0002 \u0001!\t!!\t\u0002\u0013A,8\u000f\u001b\"m_\u000e\\G#\u00031\u0002$\u0005M\u0012qIA&\u0011!\t)#!\bA\u0002\u0005\u001d\u0012a\u00022m_\u000e\\\u0017\n\u001a\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0004\u0002\u000fM$xN]1hK&!\u0011\u0011GA\u0016\u0005\u001d\u0011En\\2l\u0013\u0012D\u0001\"!\u000e\u0002\u001e\u0001\u0007\u0011qG\u0001\fCJ\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0003\u0002:\u0005\rC%\u0004\u0002\u0002<)!\u0011QHA \u0003\u001diW\u000f^1cY\u0016T1!!\u0011\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\nYDA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bbBA%\u0003;\u0001\r\u0001L\u0001\t[\u0016$\u0018\rZ1uC\"A\u0011QJA\u000f\u0001\u0004\ty%A\u0003mKZ,G\u000e\u0005\u0003\u0002*\u0005E\u0013\u0002BA*\u0003W\u0011Ab\u0015;pe\u0006<W\rT3wK2Dq!a\b\u0001\t\u0003\t9\u0006F\u0005a\u00033\nY&a\u001b\u0002n!A\u0011QEA+\u0001\u0004\t9\u0003\u0003\u0005\u0002^\u0005U\u0003\u0019AA0\u0003\u0015\u0011\u0017\u0010^3t!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3#\u0006\u0019a.[8\n\t\u0005%\u00141\r\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBA%\u0003+\u0002\r\u0001\f\u0005\t\u0003\u001b\n)\u00061\u0001\u0002P\u00191\u0011\u0011\u000f\u0001\u0005\u0003g\u0012ACT3uo>\u00148NU3dK&4XM]!di>\u00148#BA8\u001f\u0005U\u0004c\u0001\"\u0002x%\u0019\u0011\u0011P\"\u0003\u000b\u0005\u001bGo\u001c:\t\u000fA\ny\u0007\"\u0001\u0002~Q\u0011\u0011q\u0010\t\u0005\u0003\u0003\u000by'D\u0001\u0001\u0011)\t))a\u001cC\u0002\u0013\u0005\u0011qQ\u0001\u0003SB,\u0012A\u001d\u0005\t\u0003\u0017\u000by\u0007)A\u0005e\u0006\u0019\u0011\u000e\u001d\u0011\t\u0013\u0005=\u0015q\u000eb\u0001\n\u0003I\u0016\u0001\u00029peRD\u0001\"a%\u0002p\u0001\u0006IAW\u0001\u0006a>\u0014H\u000f\t\u0005\u000b\u0003/\u000byG1A\u0005\u0002\u0005\u001d\u0015aA;sY\"A\u00111TA8A\u0003%!/\u0001\u0003ve2\u0004\u0003BCAP\u0003_\u0012\r\u0011\"\u0001\u0002\"\u00069AO]1dW\u0016\u0014XCAAR!\r\u0011\u0015QU\u0005\u0004\u0003O\u001b%AD!di>\u00148+\u001a7fGRLwN\u001c\u0005\n\u0003W\u000by\u0007)A\u0005\u0003G\u000b\u0001\u0002\u001e:bG.,'\u000f\t\u0005\u000b\u0003_\u000byG1A\u0005\u0002\u0005E\u0016a\u0002;j[\u0016|W\u000f^\u000b\u0003\u0003g\u0003B!!.\u0002@6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,\u0001\u0005ekJ\fG/[8o\u0015\r\ti,E\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAa\u0003o\u0013aBR5oSR,G)\u001e:bi&|g\u000eC\u0005\u0002F\u0006=\u0004\u0015!\u0003\u00024\u0006AA/[7f_V$\b\u0005C\u0004\u0002J\u0006=D\u0011I5\u0002\u0011A\u0014Xm\u0015;beRD\u0001\"!4\u0002p\u0011\u0005\u0013qZ\u0001\be\u0016\u001cW-\u001b<f)\t\t\t\u000eE\u0003\u0011\u0003'd\u0003-C\u0002\u0002VF\u0011q\u0002U1si&\fGNR;oGRLwN\u001c\u0005\t\u00033\u0004A\u0011\u0003\u0003\u0002\\\u0006Y1/\u001a;TiJ,\u0017-\\%e)\r\u0001\u0017Q\u001c\u0005\b\u0003?\f9\u000e1\u0001[\u0003\tIGM\u0002\u0004\u0002d\u0002\u0001\u0011Q\u001d\u0002\u000f\u00052|7m[$f]\u0016\u0014\u0018\r^8s'\u0015\t\toD\u000b\u0019\u0011-\tI/!9\u0003\u0002\u0003\u0006I!a\u0014\u0002\u0019M$xN]1hK2+g/\u001a7\t\u000fA\n\t\u000f\"\u0001\u0002nR!\u0011q^Ay!\u0011\t\t)!9\t\u0011\u0005%\u00181\u001ea\u0001\u0003\u001f2q!!>\u0002b\u0002\u000b9PA\u0003CY>\u001c7n\u0005\u0004\u0002t>\tI0\u0006\t\u0004!\u0005m\u0018bAA\u007f#\t9\u0001K]8ek\u000e$\bbCAp\u0003g\u0014)\u001a!C\u0001\u0005\u0003)\"!a\n\t\u0017\t\u0015\u00111\u001fB\tB\u0003%\u0011qE\u0001\u0004S\u0012\u0004\u0003b\u0003B\u0005\u0003g\u0014)\u001a!C\u0001\u0005\u0017\taAY;gM\u0016\u0014XCAA\u001c\u0011-\u0011y!a=\u0003\u0012\u0003\u0006I!a\u000e\u0002\u000f\t,hMZ3sA!Y\u0011\u0011JAz\u0005+\u0007I\u0011\u0001B\n+\u0005a\u0003B\u0003B\f\u0003g\u0014\t\u0012)A\u0005Y\u0005IQ.\u001a;bI\u0006$\u0018\r\t\u0005\ba\u0005MH\u0011\u0001B\u000e)!\u0011iB!\t\u0003$\t\u0015\u0002\u0003\u0002B\u0010\u0003gl!!!9\t\u0011\u0005}'\u0011\u0004a\u0001\u0003OA\u0001B!\u0003\u0003\u001a\u0001\u0007\u0011q\u0007\u0005\n\u0003\u0013\u0012I\u0002%AA\u00021B!B!\u000b\u0002t\u0006\u0005I\u0011\u0001B\u0016\u0003\u0011\u0019w\u000e]=\u0015\u0011\tu!Q\u0006B\u0018\u0005cA!\"a8\u0003(A\u0005\t\u0019AA\u0014\u0011)\u0011IAa\n\u0011\u0002\u0003\u0007\u0011q\u0007\u0005\n\u0003\u0013\u00129\u0003%AA\u00021B!B!\u000e\u0002tF\u0005I\u0011\u0001B\u001c\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u000f+\t\u0005\u001d\"1H\u0016\u0003\u0005{\u0001BAa\u0010\u0003J5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%A\u0005v]\u000eDWmY6fI*\u0019!qI\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003L\t\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q!qJAz#\u0003%\tA!\u0015\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u000b\u0016\u0005\u0003o\u0011Y\u0004\u0003\u0006\u0003X\u0005M\u0018\u0013!C\u0001\u00053\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\\)\u001aAFa\u000f\t\u0015\t}\u00131_A\u0001\n\u0003\u0012\t'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005G\u00022A\u0014B3\u0013\t9x\nC\u0005\u0003j\u0005M\u0018\u0011!C\u00013\u0006a\u0001O]8ek\u000e$\u0018I]5us\"Q!QNAz\u0003\u0003%\tAa\u001c\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019AF!\u001d\t\u0011\u0011\u0014Y'!AA\u0002iC!B!\u001e\u0002t\u0006\u0005I\u0011\tB<\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B=!\u0015\u0011YH! -\u001b\t\ty$\u0003\u0003\u0003\u0000\u0005}\"\u0001C%uKJ\fGo\u001c:\t\u0015\t\r\u00151_A\u0001\n\u0003\u0011))\u0001\u0005dC:,\u0015/^1m)\u0011\u00119I!$\u0011\u0007A\u0011I)C\u0002\u0003\fF\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005e\u0005\u0003\u000b\t\u00111\u0001-\u0011)\u0011\t*a=\u0002\u0002\u0013\u0005#1S\u0001\tQ\u0006\u001c\bnQ8eKR\t!\f\u0003\u0006\u0003\u0018\u0006M\u0018\u0011!C!\u00053\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005GB!B!(\u0002t\u0006\u0005I\u0011\tBP\u0003\u0019)\u0017/^1mgR!!q\u0011BQ\u0011!!'1TA\u0001\u0002\u0004asA\u0003BS\u0003C\f\t\u0011#\u0001\u0003(\u0006)!\t\\8dWB!!q\u0004BU\r)\t)0!9\u0002\u0002#\u0005!1V\n\u0006\u0005S\u0013i+\u0006\t\f\u0005_\u0013),a\n\u000281\u0012i\"\u0004\u0002\u00032*\u0019!1W\t\u0002\u000fI,h\u000e^5nK&!!q\u0017BY\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\ba\t%F\u0011\u0001B^)\t\u00119\u000b\u0003\u0006\u0003\u0018\n%\u0016\u0011!C#\u00053C!B!1\u0003*\u0006\u0005I\u0011\u0011Bb\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011iB!2\u0003H\n%\u0007\u0002CAp\u0005\u007f\u0003\r!a\n\t\u0011\t%!q\u0018a\u0001\u0003oA\u0011\"!\u0013\u0003@B\u0005\t\u0019\u0001\u0017\t\u0015\t5'\u0011VA\u0001\n\u0003\u0013y-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE'\u0011\u001c\t\u0005!A\u0014\u0019\u000e\u0005\u0005\u0011\u0005+\f9#a\u000e-\u0013\r\u00119.\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0015\tm'1ZA\u0001\u0002\u0004\u0011i\"A\u0002yIAB!Ba8\u0003*F\u0005I\u0011\u0001B-\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!Q!1\u001dBU#\u0003%\tA!\u0017\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIMB!Ba:\u0003*\u0006\u0005I\u0011\u0002Bu\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t-\bc\u0001(\u0003n&\u0019!q^(\u0003\r=\u0013'.Z2u\u0011)\u0011\u00190!9C\u0002\u0013\u0005!Q_\u0001\u0006G2|7m[\u000b\u0003\u0005o\u0004BA!?\u0003\u00006\u0011!1 \u0006\u0004\u0005{$\u0011\u0001B;uS2LAa!\u0001\u0003|\nY1+_:uK6\u001cEn\\2l\u0011%\u0019)!!9!\u0002\u0013\u001190\u0001\u0004dY>\u001c7\u000e\t\u0005\u000b\u0007\u0013\t\tO1A\u0005\u0002\r-\u0011!\u00042m_\u000e\\\u0017J\u001c;feZ\fG.\u0006\u0002\u0004\u000eA\u0019\u0001ca\u0004\n\u0007\rE\u0011C\u0001\u0003M_:<\u0007\"CB\u000b\u0003C\u0004\u000b\u0011BB\u0007\u00039\u0011Gn\\2l\u0013:$XM\u001d<bY\u0002B!b!\u0007\u0002b\n\u0007I\u0011AB\u000e\u0003I\u0011Gn\\2l\u0013:$XM\u001d<bYRKW.\u001a:\u0016\u0005\ru\u0001\u0003\u0002B}\u0007?IAa!\t\u0003|\nq!+Z2veJLgn\u001a+j[\u0016\u0014\b\"CB\u0013\u0003C\u0004\u000b\u0011BB\u000f\u0003M\u0011Gn\\2l\u0013:$XM\u001d<bYRKW.\u001a:!\u0011)\u0019I#!9C\u0002\u0013\u000511F\u0001\u0012E2|7m[*u_J\fw-\u001a'fm\u0016dWCAA(\u0011%\u0019y#!9!\u0002\u0013\ty%\u0001\ncY>\u001c7n\u0015;pe\u0006<W\rT3wK2\u0004\u0003BCB\u001a\u0003C\u0014\r\u0011\"\u0001\u00046\u0005\u0001\"\r\\8dWN4uN\u001d)vg\"LgnZ\u000b\u0003\u0007o\u0001ba!\u000f\u0004@\tuQBAB\u001e\u0015\u0011\til!\u0010\u000b\u0007\tu\u0018+\u0003\u0003\u0004B\rm\"AE!se\u0006L(\t\\8dW&tw-U;fk\u0016D\u0011b!\u0012\u0002b\u0002\u0006Iaa\u000e\u0002#\tdwnY6t\r>\u0014\b+^:iS:<\u0007\u0005C\u0005\u0004J\u0005\u0005(\u0019!C\u0001\u0019\u0006\u0011\"\r\\8dWB+8\u000f[5oORC'/Z1e\u0011!\u0019i%!9!\u0002\u0013i\u0015a\u00052m_\u000e\\\u0007+^:iS:<G\u000b\u001b:fC\u0012\u0004\u0003BCB)\u0003C\u0004\r\u0011\"\u0001\u0003\f\u0005i1-\u001e:sK:$()\u001e4gKJD!b!\u0016\u0002b\u0002\u0007I\u0011AB,\u0003E\u0019WO\u001d:f]R\u0014UO\u001a4fe~#S-\u001d\u000b\u0004A\u000ee\u0003\"\u00033\u0004T\u0005\u0005\t\u0019AA\u001c\u0011%\u0019i&!9!B\u0013\t9$\u0001\bdkJ\u0014XM\u001c;Ck\u001a4WM\u001d\u0011\t\ri\f\t\u000f\"\u0001j\u0011\u0019a\u0018\u0011\u001dC\u0001S\"A1QMAq\t\u0003\u00199'\u0001\u0005%a2,8\u000fJ3r)\r\u00017\u0011\u000e\u0005\b\u0007W\u001a\u0019\u00071\u0001%\u0003\ry'M\u001b\u0005\t\u0007_\n\t\u000f\"\u0003\u0004r\u0005\u0019R\u000f\u001d3bi\u0016\u001cUO\u001d:f]R\u0014UO\u001a4feR\u0019\u0001ma\u001d\t\u0011\rU4Q\u000ea\u0001\u0007\u001b\tA\u0001^5nK\"91\u0011PAq\t\u0013I\u0017!E6fKB\u0004Vo\u001d5j]\u001e\u0014En\\2lg\u0002")
public abstract class NetworkReceiver<T>
implements Serializable,
Logging {
    private SparkEnv env;
    private ActorRef actor;
    private Thread receivingThread;
    private int streamId;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    private SparkEnv env$lzycompute() {
        NetworkReceiver networkReceiver = this;
        synchronized (networkReceiver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.env = SparkEnv$.MODULE$.get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.env;
        }
    }

    private ActorRef actor$lzycompute() {
        NetworkReceiver networkReceiver = this;
        synchronized (networkReceiver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.actor = this.env().actorSystem().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NetworkReceiver $outer;

                    public final NetworkReceiverActor apply() {
                        return this.$outer.new NetworkReceiverActor();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(NetworkReceiverActor.class)), new StringBuilder().append((Object)"NetworkReceiver-").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).toString());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.actor;
        }
    }

    private Thread receivingThread$lzycompute() {
        NetworkReceiver networkReceiver = this;
        synchronized (networkReceiver) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.receivingThread = Thread.currentThread();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.receivingThread;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SparkEnv env() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.env$lzycompute() : this.env;
    }

    public ActorRef actor() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.actor$lzycompute() : this.actor;
    }

    public Thread receivingThread() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.receivingThread$lzycompute() : this.receivingThread;
    }

    public int streamId() {
        return this.streamId;
    }

    public void streamId_$eq(int x$1) {
        this.streamId = x$1;
    }

    public abstract void onStart();

    public abstract void onStop();

    public Option<String> getLocationPreference() {
        return None$.MODULE$;
    }

    public void start() {
        try {
            this.env();
            this.actor();
            this.receivingThread();
            this.onStart();
        }
        catch (Exception exception) {
            this.stopOnError(exception);
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Receiving thread interrupted";
                }
            });
        }
    }

    public void stop() {
        this.receivingThread().interrupt();
        this.onStop();
    }

    public void stopOnError(Exception e) {
        this.logError((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Error receiving data";
            }
        }, e);
        this.stop();
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.actor());
        ReportError x$1 = new ReportError(e.toString());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void pushBlock(BlockId blockId, ArrayBuffer<T> arrayBuffer, Object metadata, StorageLevel level) {
        this.env().blockManager().put(blockId, arrayBuffer, level, this.env().blockManager().put$default$4());
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.actor());
        ReportBlock x$3 = new ReportBlock(blockId, metadata);
        ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
        qual$2.$bang((Object)x$3, x$4);
    }

    public void pushBlock(BlockId blockId, ByteBuffer bytes, Object metadata, StorageLevel level) {
        this.env().blockManager().putBytes(blockId, bytes, level, this.env().blockManager().putBytes$default$4());
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.actor());
        ReportBlock x$5 = new ReportBlock(blockId, metadata);
        ActorRef x$6 = qual$3.$bang$default$2((Object)x$5);
        qual$3.$bang((Object)x$5, x$6);
    }

    public void setStreamId(int id) {
        this.streamId_$eq(id);
    }

    public NetworkReceiver(ClassTag<T> evidence$2) {
        Logging.class.$init$((Logging)this);
        this.streamId = -1;
    }

    public class BlockGenerator
    implements Serializable,
    Logging {
        private final StorageLevel storageLevel;
        private final SystemClock clock;
        private final long blockInterval;
        private final RecurringTimer blockIntervalTimer;
        private final StorageLevel blockStorageLevel;
        private final ArrayBlockingQueue<Block> blocksForPushing;
        private final Thread blockPushingThread;
        private ArrayBuffer<T> currentBuffer;
        private volatile NetworkReceiver$BlockGenerator$Block$ Block$module;
        public final /* synthetic */ NetworkReceiver $outer;
        private transient Logger org$apache$spark$Logging$$log_;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private NetworkReceiver$BlockGenerator$Block$ Block$lzycompute() {
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                if (this.Block$module != null) return this.Block$module;
                this.Block$module = new NetworkReceiver$BlockGenerator$Block$(this);
                return this.Block$module;
            }
        }

        public Logger org$apache$spark$Logging$$log_() {
            return this.org$apache$spark$Logging$$log_;
        }

        public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$Logging$$log_ = x$1;
        }

        public Logger log() {
            return Logging.class.log((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.class.logInfo((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.class.logDebug((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.class.logTrace((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.class.logWarning((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.class.logError((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.class.logError((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.class.isTraceEnabled((Logging)this);
        }

        public NetworkReceiver$BlockGenerator$Block$ Block() {
            return this.Block$module == null ? this.Block$lzycompute() : this.Block$module;
        }

        public SystemClock clock() {
            return this.clock;
        }

        public long blockInterval() {
            return this.blockInterval;
        }

        public RecurringTimer blockIntervalTimer() {
            return this.blockIntervalTimer;
        }

        public StorageLevel blockStorageLevel() {
            return this.blockStorageLevel;
        }

        public ArrayBlockingQueue<Block> blocksForPushing() {
            return this.blocksForPushing;
        }

        public Thread blockPushingThread() {
            return this.blockPushingThread;
        }

        public ArrayBuffer<T> currentBuffer() {
            return this.currentBuffer;
        }

        public void currentBuffer_$eq(ArrayBuffer<T> x$1) {
            this.currentBuffer = x$1;
        }

        public void start() {
            this.blockIntervalTimer().start();
            this.blockPushingThread().start();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Data handler started";
                }
            });
        }

        public void stop() {
            this.blockIntervalTimer().stop();
            this.blockPushingThread().interrupt();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Data handler stopped";
                }
            });
        }

        public void $plus$eq(T obj) {
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                this.currentBuffer().$plus$eq(obj);
                return;
            }
        }

        public void org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$$updateCurrentBuffer(long time) {
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                this.liftedTree1$1(time);
                return;
            }
        }

        public void org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$$keepPushingBlocks() {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Block pushing thread started";
                }
            });
            try {
                while (true) {
                    Block block = this.blocksForPushing().take();
                    this.org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$$$outer().pushBlock(block.id(), block.buffer(), block.metadata(), this.storageLevel);
                }
            }
            catch (Exception exception) {
                this.org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$$$outer().stop();
            }
            catch (InterruptedException interruptedException) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Block pushing thread interrupted";
                    }
                });
            }
        }

        public /* synthetic */ NetworkReceiver org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$$$outer() {
            return this.$outer;
        }

        private final Object liftedTree1$1(long time$1) {
            Object object;
            try {
                ArrayBuffer newBlockBuffer = this.currentBuffer();
                this.currentBuffer_$eq(new ArrayBuffer());
                if (newBlockBuffer.size() > 0) {
                    StreamBlockId blockId = new StreamBlockId(this.org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$$$outer().streamId(), time$1 - this.blockInterval());
                    Block newBlock = new Block(this, (BlockId)blockId, newBlockBuffer, this.Block().$lessinit$greater$default$3());
                    object = BoxesRunTime.boxToBoolean((boolean)this.blocksForPushing().add(newBlock));
                } else {
                    object = BoxedUnit.UNIT;
                }
            }
            catch (Exception exception) {
                this.org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$$$outer().stop();
                object = BoxedUnit.UNIT;
            }
            catch (InterruptedException interruptedException) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Block interval timer thread interrupted";
                    }
                });
                object = BoxedUnit.UNIT;
            }
            return object;
        }

        public BlockGenerator(NetworkReceiver<T> $outer, StorageLevel storageLevel) {
            this.storageLevel = storageLevel;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging.class.$init$((Logging)this);
            this.clock = new SystemClock();
            this.blockInterval = $outer.env().conf().getLong("spark.streaming.blockInterval", 200L);
            this.blockIntervalTimer = new RecurringTimer(this.clock(), this.blockInterval(), (Function1<Object, BoxedUnit>)new BlockGenerator$$anonfun$1(this));
            this.blockStorageLevel = storageLevel;
            this.blocksForPushing = new ArrayBlockingQueue(1000);
            this.blockPushingThread = new BlockGenerator$$anon$1(this);
            this.currentBuffer = new ArrayBuffer();
        }

        public class Block
        implements Product,
        Serializable {
            private final BlockId id;
            private final ArrayBuffer<T> buffer;
            private final Object metadata;
            public final /* synthetic */ BlockGenerator $outer;

            public BlockId id() {
                return this.id;
            }

            public ArrayBuffer<T> buffer() {
                return this.buffer;
            }

            public Object metadata() {
                return this.metadata;
            }

            public Block copy(BlockId id, ArrayBuffer<T> buffer, Object metadata) {
                return new Block(this.org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$Block$$$outer(), id, buffer, metadata);
            }

            public BlockId copy$default$1() {
                return this.id();
            }

            public ArrayBuffer<T> copy$default$2() {
                return this.buffer();
            }

            public Object copy$default$3() {
                return this.metadata();
            }

            public String productPrefix() {
                return "Block";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                BlockId blockId;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        blockId = this.metadata();
                        break;
                    }
                    case 1: {
                        blockId = this.buffer();
                        break;
                    }
                    case 0: {
                        blockId = this.id();
                    }
                }
                return blockId;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Block;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Block)) return false;
                if (((Block)object).org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$Block$$$outer() != this.org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$Block$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Block block = (Block)x$1;
                BlockId blockId = this.id();
                BlockId blockId2 = block.id();
                if (blockId == null) {
                    if (blockId2 != null) {
                        return false;
                    }
                } else if (!blockId.equals(blockId2)) return false;
                ArrayBuffer arrayBuffer = this.buffer();
                ArrayBuffer arrayBuffer2 = block.buffer();
                if (arrayBuffer == null) {
                    if (arrayBuffer2 != null) {
                        return false;
                    }
                } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
                if (!BoxesRunTime.equals((Object)this.metadata(), (Object)block.metadata())) return false;
                if (!block.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ BlockGenerator org$apache$spark$streaming$dstream$NetworkReceiver$BlockGenerator$Block$$$outer() {
                return this.$outer;
            }

            public Block(BlockGenerator $outer, BlockId id, ArrayBuffer<T> buffer, Object metadata) {
                this.id = id;
                this.buffer = buffer;
                this.metadata = metadata;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public class NetworkReceiverActor
    implements Actor {
        private final String ip;
        private final int port;
        private final String url;
        private final ActorSelection tracker;
        private final FiniteDuration timeout;
        private final ActorContext context;
        private final ActorRef self;

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public final ActorRef sender() {
            return Actor.class.sender((Actor)this);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.class.supervisorStrategy((Actor)this);
        }

        public void postStop() throws Exception {
            Actor.class.postStop((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.class.preRestart((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.class.postRestart((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.class.unhandled((Actor)this, (Object)message);
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public String url() {
            return this.url;
        }

        public ActorSelection tracker() {
            return this.tracker;
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        public void preStart() {
            Future future = AskableActorSelection$.MODULE$.ask$extension(akka.pattern.package$.MODULE$.ask(this.tracker()), (Object)new RegisterReceiver(this.org$apache$spark$streaming$dstream$NetworkReceiver$NetworkReceiverActor$$$outer().streamId(), this.self()), Timeout$.MODULE$.durationToTimeout(this.timeout()));
            Await$.MODULE$.result((Awaitable)future, (Duration)this.timeout());
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NetworkReceiverActor $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof ReportBlock) {
                        ReportBlock reportBlock = (ReportBlock)A1;
                        BlockId blockId = reportBlock.blockId();
                        Object metadata = reportBlock.metadata();
                        ActorSelection$.MODULE$.toScala(this.$outer.tracker()).$bang((Object)new AddBlocks(this.$outer.org$apache$spark$streaming$dstream$NetworkReceiver$NetworkReceiverActor$$$outer().streamId(), (Seq<BlockId>)Predef$.MODULE$.wrapRefArray((Object[])new BlockId[]{blockId}), metadata), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ReportError) {
                        ReportError reportError = (ReportError)A1;
                        String msg = reportError.msg();
                        ActorSelection$.MODULE$.toScala(this.$outer.tracker()).$bang((Object)new DeregisterReceiver(this.$outer.org$apache$spark$streaming$dstream$NetworkReceiver$NetworkReceiverActor$$$outer().streamId(), msg), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof StopReceiver) {
                        StopReceiver stopReceiver = (StopReceiver)A1;
                        String msg = stopReceiver.msg();
                        this.$outer.org$apache$spark$streaming$dstream$NetworkReceiver$NetworkReceiverActor$$$outer().stop();
                        ActorSelection$.MODULE$.toScala(this.$outer.tracker()).$bang((Object)new DeregisterReceiver(this.$outer.org$apache$spark$streaming$dstream$NetworkReceiver$NetworkReceiverActor$$$outer().streamId(), msg), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof ReportBlock ? true : (object instanceof ReportError ? true : object instanceof StopReceiver);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
        }

        public /* synthetic */ NetworkReceiver org$apache$spark$streaming$dstream$NetworkReceiver$NetworkReceiverActor$$$outer() {
            return NetworkReceiver.this;
        }

        public NetworkReceiverActor() {
            if (NetworkReceiver.this == null) {
                throw new NullPointerException();
            }
            Actor.class.$init$((Actor)this);
            NetworkReceiver.this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Attempting to register with tracker";
                }
            });
            this.ip = NetworkReceiver.this.env().conf().get("spark.driver.host", "localhost");
            this.port = NetworkReceiver.this.env().conf().getInt("spark.driver.port", 7077);
            this.url = new StringOps(Predef$.MODULE$.augmentString("akka.tcp://spark@%s:%s/user/NetworkInputTracker")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ip(), BoxesRunTime.boxToInteger((int)this.port())}));
            this.tracker = NetworkReceiver.this.env().actorSystem().actorSelection(this.url());
            this.timeout = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds();
        }
    }
}

