/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import org.apache.spark.Logging;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.CheckpointWriter;
import org.apache.spark.streaming.DStreamGraph;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.scheduler.ClearCheckpointData;
import org.apache.spark.streaming.scheduler.ClearMetadata;
import org.apache.spark.streaming.scheduler.DoCheckpoint;
import org.apache.spark.streaming.scheduler.GenerateJobs;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobGenerator$;
import org.apache.spark.streaming.scheduler.JobGenerator$$anonfun$start$1$;
import org.apache.spark.streaming.scheduler.JobGeneratorEvent;
import org.apache.spark.streaming.scheduler.JobScheduler;
import org.apache.spark.streaming.util.Clock;
import org.apache.spark.streaming.util.ManualClock;
import org.apache.spark.streaming.util.RecurringTimer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb!B\u0001\u0003\u0001\u0011a!\u0001\u0004&pE\u001e+g.\u001a:bi>\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!\u0011!Q\u0001\ni\tAB[8c'\u000eDW\rZ;mKJ\u001c\u0001\u0001\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\ta!j\u001c2TG\",G-\u001e7fe\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\"!\t\u0012\u0011\u0005m\u0001\u0001\"\u0002\r\u001f\u0001\u0004Q\u0002b\u0002\u0013\u0001\u0005\u0004%I!J\u0001\u0004gN\u001cW#\u0001\u0014\u0011\u0005\u001dBS\"\u0001\u0003\n\u0005%\"!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011\u0019Y\u0003\u0001)A\u0005M\u0005!1o]2!\u0011\u001di\u0003A1A\u0005\n9\nQa\u001a:ba\",\u0012a\f\t\u0003OAJ!!\r\u0003\u0003\u0019\u0011\u001bFO]3b[\u001e\u0013\u0018\r\u001d5\t\rM\u0002\u0001\u0015!\u00030\u0003\u00199'/\u00199iA!9Q\u0007\u0001b\u0001\n\u00031\u0014!B2m_\u000e\\W#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005i\"\u0011\u0001B;uS2L!\u0001P\u001d\u0003\u000b\rcwnY6\t\ry\u0002\u0001\u0015!\u00038\u0003\u0019\u0019Gn\\2lA!9\u0001\t\u0001b\u0001\n\u0013\t\u0015!\u0002;j[\u0016\u0014X#\u0001\"\u0011\u0005a\u001a\u0015B\u0001#:\u00059\u0011VmY;se&tw\rV5nKJDaA\u0012\u0001!\u0002\u0013\u0011\u0015A\u0002;j[\u0016\u0014\b\u0005\u0003\u0005I\u0001!\u0015\r\u0011\"\u0003J\u0003A\u0019\u0007.Z2la>Lg\u000e^,sSR,'/F\u0001K!\t93*\u0003\u0002M\t\t\u00012\t[3dWB|\u0017N\u001c;Xe&$XM\u001d\u0005\t\u001d\u0002A\t\u0011)Q\u0005\u0015\u0006\t2\r[3dWB|\u0017N\u001c;Xe&$XM\u001d\u0011\t\u000fA\u0003\u0001\u0019!C\u0005#\u0006QQM^3oi\u0006\u001bGo\u001c:\u0016\u0003I\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003]\u000bA!Y6lC&\u0011\u0011\f\u0016\u0002\t\u0003\u000e$xN\u001d*fM\"91\f\u0001a\u0001\n\u0013a\u0016AD3wK:$\u0018i\u0019;pe~#S-\u001d\u000b\u0003;\u0002\u0004\"A\u00040\n\u0005}{!\u0001B+oSRDq!\u0019.\u0002\u0002\u0003\u0007!+A\u0002yIEBaa\u0019\u0001!B\u0013\u0011\u0016aC3wK:$\u0018i\u0019;pe\u0002BQ!\u001a\u0001\u0005\u0002\u0019\fQa\u001d;beR$\u0012!\u0018\u0005\u0006Q\u0002!\tAZ\u0001\u0005gR|\u0007\u000fC\u0003k\u0001\u0011\u00051.A\tp]\n\u000bGo\u00195D_6\u0004H.\u001a;j_:$\"!\u00187\t\u000b5L\u0007\u0019\u00018\u0002\tQLW.\u001a\t\u0003O=L!\u0001\u001d\u0003\u0003\tQKW.\u001a\u0005\u0006e\u0002!\ta]\u0001\u0017_:\u001c\u0005.Z2la>Lg\u000e^\"p[BdW\r^5p]R\u0011Q\f\u001e\u0005\u0006[F\u0004\rA\u001c\u0005\u0006m\u0002!Ia^\u0001\raJ|7-Z:t\u000bZ,g\u000e\u001e\u000b\u0003;bDQ!_;A\u0002i\fQ!\u001a<f]R\u0004\"aG>\n\u0005q\u0014!!\u0005&pE\u001e+g.\u001a:bi>\u0014XI^3oi\")a\u0010\u0001C\u0005M\u0006q1\u000f^1si\u001aK'o\u001d;US6,\u0007BBA\u0001\u0001\u0011%a-A\u0004sKN$\u0018M\u001d;\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\u0005aq-\u001a8fe\u0006$XMS8cgR\u0019Q,!\u0003\t\r5\f\u0019\u00011\u0001o\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\tQb\u00197fCJlU\r^1eCR\fGcA/\u0002\u0012!1Q.a\u0003A\u00029Dq!!\u0006\u0001\t\u0013\t9\"A\ndY\u0016\f'o\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018\rF\u0002^\u00033Aa!\\A\n\u0001\u0004q\u0007bBA\u000f\u0001\u0011%\u0011qD\u0001\rI>\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\u0004;\u0006\u0005\u0002BB7\u0002\u001c\u0001\u0007a\u000e")
public class JobGenerator
implements Logging {
    public final JobScheduler org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler;
    private final StreamingContext ssc;
    private final DStreamGraph org$apache$spark$streaming$scheduler$JobGenerator$$graph;
    private final Clock clock;
    private final RecurringTimer timer;
    private CheckpointWriter checkpointWriter;
    private ActorRef org$apache$spark$streaming$scheduler$JobGenerator$$eventActor;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    private CheckpointWriter checkpointWriter$lzycompute() {
        JobGenerator jobGenerator = this;
        synchronized (jobGenerator) {
            if (!this.bitmap$0) {
                this.checkpointWriter = this.ssc().checkpointDuration() == null || this.ssc().checkpointDir() == null ? null : new CheckpointWriter(this, this.ssc().conf(), this.ssc().checkpointDir(), this.ssc().sparkContext().hadoopConfiguration());
                this.bitmap$0 = true;
            }
            return this.checkpointWriter;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private StreamingContext ssc() {
        return this.ssc;
    }

    public DStreamGraph org$apache$spark$streaming$scheduler$JobGenerator$$graph() {
        return this.org$apache$spark$streaming$scheduler$JobGenerator$$graph;
    }

    public Clock clock() {
        return this.clock;
    }

    private RecurringTimer timer() {
        return this.timer;
    }

    private CheckpointWriter checkpointWriter() {
        return this.bitmap$0 ? this.checkpointWriter : this.checkpointWriter$lzycompute();
    }

    public ActorRef org$apache$spark$streaming$scheduler$JobGenerator$$eventActor() {
        return this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor;
    }

    private void org$apache$spark$streaming$scheduler$JobGenerator$$eventActor_$eq(ActorRef x$1) {
        this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor = x$1;
    }

    public synchronized void start() {
        if (this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor() == null) {
            this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor_$eq(this.ssc().env().actorSystem().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobGenerator $outer;

                public final $anonfun$start$1$$anon$1 apply() {
                    return new Actor(this){
                        private final /* synthetic */ $anonfun$start$1 $outer;
                        private final ActorContext context;
                        private final ActorRef self;

                        public ActorContext context() {
                            return this.context;
                        }

                        public final ActorRef self() {
                            return this.self;
                        }

                        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
                            this.context = x$1;
                        }

                        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
                            this.self = x$1;
                        }

                        public final ActorRef sender() {
                            return Actor.class.sender((Actor)this);
                        }

                        public SupervisorStrategy supervisorStrategy() {
                            return Actor.class.supervisorStrategy((Actor)this);
                        }

                        public void preStart() throws Exception {
                            Actor.class.preStart((Actor)this);
                        }

                        public void postStop() throws Exception {
                            Actor.class.postStop((Actor)this);
                        }

                        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
                            Actor.class.preRestart((Actor)this, (Throwable)reason, message);
                        }

                        public void postRestart(Throwable reason) throws Exception {
                            Actor.class.postRestart((Actor)this, (Throwable)reason);
                        }

                        public void unhandled(Object message) {
                            Actor.class.unhandled((Actor)this, (Object)message);
                        }

                        public PartialFunction<Object, BoxedUnit> receive() {
                            return new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$start$1$$anon$1 $outer;

                                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    Object object;
                                    A1 A1 = x1;
                                    if (A1 instanceof JobGeneratorEvent) {
                                        JobGeneratorEvent jobGeneratorEvent = (JobGeneratorEvent)A1;
                                        this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$anon$$$outer().org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$$outer().logDebug((Function0<String>)new Serializable(this, jobGeneratorEvent){
                                            public static final long serialVersionUID = 0L;
                                            private final JobGeneratorEvent x2$1;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"Got event of type ").append((Object)this.x2$1.getClass().getName()).toString();
                                            }
                                            {
                                                this.x2$1 = x2$1;
                                            }
                                        });
                                        this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$anon$$$outer().org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$$outer().org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(jobGeneratorEvent);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x1);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Object x1) {
                                    Object object = x1;
                                    boolean bl = object instanceof JobGeneratorEvent;
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            };
                        }

                        public /* synthetic */ $anonfun$start$1 org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$anon$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            Actor.class.$init$((Actor)this);
                        }
                    };
                }

                public /* synthetic */ JobGenerator org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, ClassTag$.MODULE$.apply(Actor.class)), "JobGenerator"));
            if (this.ssc().isCheckpointPresent()) {
                this.restart();
            } else {
                this.startFirstTime();
            }
            return;
        }
        throw new SparkException("JobGenerator already started");
    }

    public synchronized void stop() {
        if (this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor() != null) {
            this.timer().stop();
            this.ssc().env().actorSystem().stop(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
            if (this.checkpointWriter() != null) {
                this.checkpointWriter().stop();
            }
            this.ssc().graph().stop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "JobGenerator stopped";
                }
            });
        }
    }

    public void onBatchCompletion(Time time) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
        ClearMetadata x$3 = new ClearMetadata(time);
        ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
        qual$2.$bang((Object)x$3, x$4);
    }

    public void onCheckpointCompletion(Time time) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
        ClearCheckpointData x$5 = new ClearCheckpointData(time);
        ActorRef x$6 = qual$3.$bang$default$2((Object)x$5);
        qual$3.$bang((Object)x$5, x$6);
    }

    public void org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(JobGeneratorEvent event) {
        JobGeneratorEvent jobGeneratorEvent;
        block6: {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            jobGeneratorEvent = event;
                            if (!(jobGeneratorEvent instanceof GenerateJobs)) break block2;
                            GenerateJobs generateJobs2 = (GenerateJobs)jobGeneratorEvent;
                            Time time = generateJobs2.time();
                            this.generateJobs(time);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(jobGeneratorEvent instanceof ClearMetadata)) break block4;
                        ClearMetadata clearMetadata2 = (ClearMetadata)jobGeneratorEvent;
                        Time time = clearMetadata2.time();
                        this.clearMetadata(time);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(jobGeneratorEvent instanceof DoCheckpoint)) break block5;
                    DoCheckpoint doCheckpoint2 = (DoCheckpoint)jobGeneratorEvent;
                    Time time = doCheckpoint2.time();
                    this.doCheckpoint(time);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(jobGeneratorEvent instanceof ClearCheckpointData)) break block6;
                ClearCheckpointData clearCheckpointData2 = (ClearCheckpointData)jobGeneratorEvent;
                Time time = clearCheckpointData2.time();
                this.clearCheckpointData(time);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)jobGeneratorEvent);
    }

    private void startFirstTime() {
        Time startTime = new Time(this.timer().getStartTime());
        this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().start(startTime.$minus(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().batchDuration()));
        this.timer().start(startTime.milliseconds());
        this.logInfo((Function0<String>)new Serializable(this, startTime){
            public static final long serialVersionUID = 0L;
            private final Time startTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"JobGenerator started at ").append((Object)this.startTime$1).toString();
            }
            {
                this.startTime$1 = startTime$1;
            }
        });
    }

    private void restart() {
        if (this.clock() instanceof ManualClock) {
            long lastTime = this.ssc().initialCheckpoint().checkpointTime().milliseconds();
            long jumpTime = this.ssc().sc().conf().getLong("spark.streaming.manualClock.jump", 0L);
            ((ManualClock)this.clock()).setTime(lastTime + jumpTime);
        }
        Duration batchDuration = this.ssc().graph().batchDuration();
        Time checkpointTime = this.ssc().initialCheckpoint().checkpointTime();
        Time restartTime = new Time(this.timer().getRestartTime(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().zeroTime().milliseconds()));
        Seq<Time> downTimes = checkpointTime.until(restartTime, batchDuration);
        this.logInfo((Function0<String>)new Serializable(this, downTimes){
            public static final long serialVersionUID = 0L;
            private final Seq downTimes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Batches during down time (").append((Object)BoxesRunTime.boxToInteger((int)this.downTimes$1.size())).append((Object)" batches): ").append((Object)this.downTimes$1.mkString(", ")).toString();
            }
            {
                this.downTimes$1 = downTimes$1;
            }
        });
        Time[] pendingTimes = (Time[])Predef$.MODULE$.refArrayOps((Object[])this.ssc().initialCheckpoint().pendingTimes()).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)new Serializable(this, pendingTimes){
            public static final long serialVersionUID = 0L;
            private final Time[] pendingTimes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Batches pending processing (").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.pendingTimes$1).size())).append((Object)" batches): ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.pendingTimes$1).mkString(", ")).toString();
            }
            {
                this.pendingTimes$1 = pendingTimes$1;
            }
        });
        Time[] timesToReschedule = (Time[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pendingTimes).$plus$plus(downTimes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Time.class)))).distinct()).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)new Serializable(this, timesToReschedule){
            public static final long serialVersionUID = 0L;
            private final Time[] timesToReschedule$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Batches to reschedule (").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.timesToReschedule$1).size())).append((Object)" batches): ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.timesToReschedule$1).mkString(", ")).toString();
            }
            {
                this.timesToReschedule$1 = timesToReschedule$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])timesToReschedule).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobGenerator $outer;

            public final void apply(Time time) {
                this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.runJobs(time, this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$graph().generateJobs(time));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.timer().start(restartTime.milliseconds());
        this.logInfo((Function0<String>)new Serializable(this, restartTime){
            public static final long serialVersionUID = 0L;
            private final Time restartTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"JobGenerator restarted at ").append((Object)this.restartTime$1).toString();
            }
            {
                this.restartTime$1 = restartTime$1;
            }
        });
    }

    private void generateJobs(Time time) {
        Try try_;
        block4: {
            block3: {
                block2: {
                    SparkEnv$.MODULE$.set(this.ssc().env());
                    try_ = Try$.MODULE$.apply((Function0)new $anonfun$2(this, time));
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    Seq jobs = (Seq)success.value();
                    this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.runJobs(time, (Seq<Job>)jobs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.reportError(new StringBuilder().append((Object)"Error generating jobs for time ").append((Object)time).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
            DoCheckpoint x$7 = new DoCheckpoint(time);
            ActorRef x$8 = qual$4.$bang$default$2((Object)x$7);
            qual$4.$bang((Object)x$7, x$8);
            return;
        }
        throw new MatchError((Object)try_);
    }

    private void clearMetadata(Time time) {
        this.ssc().graph().clearMetadata(time);
        ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
        DoCheckpoint x$9 = new DoCheckpoint(time);
        ActorRef x$10 = qual$5.$bang$default$2((Object)x$9);
        qual$5.$bang((Object)x$9, x$10);
    }

    private void clearCheckpointData(Time time) {
        this.ssc().graph().clearCheckpointData(time);
    }

    private synchronized void doCheckpoint(Time time) {
        if (this.checkpointWriter() != null && time.$minus(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().zeroTime()).isMultipleOf(this.ssc().checkpointDuration())) {
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Checkpointing graph for time ").append((Object)this.time$2).toString();
                }
                {
                    this.time$2 = time$2;
                }
            });
            this.ssc().graph().updateCheckpointData(time);
            this.checkpointWriter().write(new Checkpoint(this.ssc(), time));
        }
    }

    public JobGenerator(JobScheduler jobScheduler) {
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler = jobScheduler;
        Logging.class.$init$((Logging)this);
        this.ssc = jobScheduler.ssc();
        this.org$apache$spark$streaming$scheduler$JobGenerator$$graph = this.ssc().graph();
        String clockClass = this.ssc().sc().conf().get("spark.streaming.clock", "org.apache.spark.streaming.util.SystemClock");
        this.clock = (Clock)Class.forName(clockClass).newInstance();
        this.timer = new RecurringTimer(this.clock(), this.ssc().graph().batchDuration().milliseconds(), (Function1<Object, BoxedUnit>)new $anonfun$1(this));
        this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor = null;
    }
}

