/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001=3Q!\u0001\u0002\u0001\t1\u0011ACR5mK\u001e+g.\u001a:bi&tw\r\u00165sK\u0006$'BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e+A\u0011abE\u0007\u0002\u001f)\u0011\u0001#E\u0001\u0005Y\u0006twMC\u0001\u0013\u0003\u0011Q\u0017M^1\n\u0005Qy!A\u0002+ie\u0016\fG\r\u0005\u0002\u0017/5\ta!\u0003\u0002\u0019\r\t9Aj\\4hS:<\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000b%t\u0007/\u001e;\u0004\u0001A\u0019Qd\n\u0016\u000f\u0005y!cBA\u0010#\u001b\u0005\u0001#BA\u0011\u001c\u0003\u0019a$o\\8u}%\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&M\u00059\u0001/Y2lC\u001e,'\"A\u0012\n\u0005!J#aA*fc*\u0011QE\n\t\u0003W=r!\u0001L\u0017\u000e\u0003\u0019J!A\f\u0014\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]\u0019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\bi\u0016\u001cH\u000fR5s!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0002gg*\u0011\u0011\bC\u0001\u0007Q\u0006$wn\u001c9\n\u0005m2$\u0001\u0002)bi\"D\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\tS:$XM\u001d<bYB\u0011AfP\u0005\u0003\u0001\u001a\u0012A\u0001T8oO\")!\t\u0001C\u0001\u0007\u00061A(\u001b8jiz\"B\u0001\u0012$H\u0011B\u0011Q\tA\u0007\u0002\u0005!)!$\u0011a\u00019!)1'\u0011a\u0001i!)Q(\u0011a\u0001}!)!\n\u0001C!\u0017\u0006\u0019!/\u001e8\u0015\u00031\u0003\"\u0001L'\n\u000593#\u0001B+oSR\u0004")
public class FileGeneratingThread
extends Thread
implements Logging {
    public final Seq<String> org$apache$spark$streaming$util$FileGeneratingThread$$input;
    public final Path org$apache$spark$streaming$util$FileGeneratingThread$$testDir;
    public final long org$apache$spark$streaming$util$FileGeneratingThread$$interval;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @Override
    public void run() {
        File localTestDir = Files.createTempDir();
        ObjectRef fs = new ObjectRef((Object)this.org$apache$spark$streaming$util$FileGeneratingThread$$testDir.getFileSystem(new Configuration()));
        int maxTries = 3;
        try {
            Thread.sleep(5000L);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.org$apache$spark$streaming$util$FileGeneratingThread$$input.size()).foreach((Function1)new Serializable(this, localTestDir, fs, maxTries){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileGeneratingThread $outer;
                private final File localTestDir$1;
                private final ObjectRef fs$1;
                private final int maxTries$1;

                public final boolean apply(int i) {
                    return this.apply$mcZI$sp(i);
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean apply$mcZI$sp(int i) {
                    File localFile = new File(this.localTestDir$1, ((Object)BoxesRunTime.boxToInteger((int)(i + 1))).toString());
                    Path hadoopFile = new Path(this.$outer.org$apache$spark$streaming$util$FileGeneratingThread$$testDir, ((Object)BoxesRunTime.boxToInteger((int)(i + 1))).toString());
                    Path tempHadoopFile = new Path(this.$outer.org$apache$spark$streaming$util$FileGeneratingThread$$testDir, new StringBuilder().append((Object)".tmp_").append((Object)((Object)BoxesRunTime.boxToInteger((int)(i + 1))).toString()).toString());
                    FileUtils.writeStringToFile((File)localFile, (String)new StringBuilder().append((Object)((String)this.$outer.org$apache$spark$streaming$util$FileGeneratingThread$$input.apply(i)).toString()).append((Object)"\n").toString());
                    IntRef tries = new IntRef(0);
                    boolean done = false;
                    while (!done && tries.elem < this.maxTries$1) {
                        ++tries.elem;
                        {
                            ((FileSystem)this.fs$1.elem).copyFromLocalFile(new Path(localFile.toString()), tempHadoopFile);
                            ((FileSystem)this.fs$1.elem).rename(tempHadoopFile, hadoopFile);
                            done = true;
                        }
                    }
                    if (done) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this, hadoopFile){
                            public static final long serialVersionUID = 0L;
                            private final Path hadoopFile$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Generated file ").append((Object)this.hadoopFile$1).append((Object)" at ").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
                            }
                            {
                                this.hadoopFile$1 = hadoopFile$1;
                            }
                        });
                    } else {
                        this.$outer.logError((Function0<String>)new Serializable(this, hadoopFile){
                            public static final long serialVersionUID = 0L;
                            private final Path hadoopFile$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Could not generate file ").append((Object)this.hadoopFile$1).toString();
                            }
                            {
                                this.hadoopFile$1 = hadoopFile$1;
                            }
                        });
                    }
                    Thread.sleep(this.$outer.org$apache$spark$streaming$util$FileGeneratingThread$$interval);
                    return localFile.delete();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.localTestDir$1 = localTestDir$1;
                    this.fs$1 = fs$1;
                    this.maxTries$1 = maxTries$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "File generating thread finished normally";
                }
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "File generating in killing thread";
                }
            }, exception);
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "File generating thread interrupted";
                }
            });
        }
        finally {
            ((FileSystem)fs.elem).close();
        }
    }

    public FileGeneratingThread(Seq<String> input, Path testDir, long interval) {
        this.org$apache$spark$streaming$util$FileGeneratingThread$$input = input;
        this.org$apache$spark$streaming$util$FileGeneratingThread$$testDir = testDir;
        this.org$apache$spark$streaming$util$FileGeneratingThread$$interval = interval;
        Logging.class.$init$((Logging)this);
    }
}

