/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.FileInputDStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.util.TimeStampedHashMap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rEb!B\u0001\u0003\u0001\u0011a!\u0001\u0005$jY\u0016Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!A\u0004egR\u0014X-Y7\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<W\u0003B\u0007\u001bKm\u001b\"\u0001\u0001\b\u0011\u0007=\u0001\"#D\u0001\u0003\u0013\t\t\"A\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0003\u0014-a!S\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\rQ+\b\u000f\\33!\tI\"\u0004\u0004\u0001\u0005\u000bm\u0001!\u0019A\u000f\u0003\u0003-\u001b\u0001!\u0005\u0002\u001fCA\u00111cH\u0005\u0003AQ\u0011qAT8uQ&tw\r\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0004\u0003:L\bCA\r&\t\u00151\u0003A1\u0001\u001e\u0005\u00051\u0006\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\tM\u001c8m\u0018\t\u0003U-j\u0011\u0001B\u0005\u0003Y\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;)\u0005\u001dr\u0003CA\n0\u0013\t\u0001DCA\u0005ue\u0006t7/[3oi\"A!\u0007\u0001B\u0001B\u0003%1'A\u0005eSJ,7\r^8ssB\u0011Ag\u000e\b\u0003'UJ!A\u000e\u000b\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003mQA\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\u0007M&dG/\u001a:\u0011\tMithR\u0005\u0003}Q\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015A\u00014t\u0015\t!\u0005\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\r\u0006\u0013A\u0001U1uQB\u00111\u0003S\u0005\u0003\u0013R\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003H\u00031qWm\u001e$jY\u0016\u001cxJ\u001c7z\u0011!i\u0005AaA!\u0002\u0017q\u0015AC3wS\u0012,gnY3%cA\u0019qJ\u0015\r\u000e\u0003AS!!\u0015\u000b\u0002\u000fI,g\r\\3di&\u00111\u000b\u0015\u0002\t\u00072\f7o\u001d+bO\"AQ\u000b\u0001B\u0002B\u0003-a+\u0001\u0006fm&$WM\\2fII\u00022a\u0014*%\u0011!A\u0006AaA!\u0002\u0017I\u0016AC3wS\u0012,gnY3%gA\u0019qJ\u0015.\u0011\u0005eYF!\u0002/\u0001\u0005\u0004i&!\u0001$\u0012\u0005yq\u0006\u0003B0c1\u0011j\u0011\u0001\u0019\u0006\u0003C\u000e\u000b\u0011\"\\1qe\u0016$WoY3\n\u0005\r\u0004'aC%oaV$hi\u001c:nCRDQ!\u001a\u0001\u0005\u0002\u0019\fa\u0001P5oSRtD#B4m[:|G\u0003\u00025jU.\u0004Ra\u0004\u0001\u0019IiCQ!\u00143A\u00049CQ!\u00163A\u0004YCQ\u0001\u00173A\u0004eCQ\u0001\u000b3A\u0002%BQA\r3A\u0002MBqa\u000f3\u0011\u0002\u0003\u0007A\bC\u0004LIB\u0005\t\u0019A$\t\u0011E\u0004!\u0019!C)\tI\fab\u00195fG.\u0004x.\u001b8u\t\u0006$\u0018-F\u0001t!\t!X/D\u0001\u0001\r\u00151\b\u0001\u0001\u0003x\u0005y1\u0015\u000e\\3J]B,H\u000fR*ue\u0016\fWn\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018m\u0005\u0002vqB\u0019q\"\u001f\n\n\u0005i\u0014!!\u0006#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u0005\u0006KV$\t\u0001 \u000b\u0002g\")a0\u001eC\u0001\u007f\u0006Y\u0001.\u00193p_B4\u0015\u000e\\3t+\t\t\t\u0001\u0005\u0005\u0002\u0004\u00055\u0011\u0011CA\f\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017!\u0012AC2pY2,7\r^5p]&!\u0011qBA\u0003\u0005\u001dA\u0015m\u001d5NCB\u00042AKA\n\u0013\r\t)\u0002\u0002\u0002\u0005)&lW\r\u0005\u0003\u0014\u00033\u0019\u0014bAA\u000e)\t)\u0011I\u001d:bs\"9\u0011qD;\u0005B\u0005\u0005\u0012AB;qI\u0006$X\r\u0006\u0003\u0002$\u0005%\u0002cA\n\u0002&%\u0019\u0011q\u0005\u000b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003W\ti\u00021\u0001\u0002\u0012\u0005!A/[7f\u0011\u001d\ty#\u001eC!\u0003c\tqa\u00197fC:,\b\u000f\u0006\u0003\u0002$\u0005M\u0002\u0002CA\u0016\u0003[\u0001\r!!\u0005\t\u000f\u0005]R\u000f\"\u0011\u0002:\u00059!/Z:u_J,GCAA\u0012\u0011\u001d\ti$\u001eC!\u0003\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003mC:<'BAA&\u0003\u0011Q\u0017M^1\n\u0007a\n)\u0005C\u0004\u0002R\u0001\u0001\u000b\u0011B:\u0002\u001f\rDWmY6q_&tG\u000fR1uC\u0002B\u0011\"!\u0016\u0001\u0005\u0004%I!a\u0016\u0002\u001d1\f7\u000f\u001e$pk:$g)\u001b7fgV\u0011\u0011\u0011\f\t\u0006\u0003\u0007\tYfM\u0005\u0005\u0003;\n)AA\u0004ICND7+\u001a;\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u00033\nq\u0002\\1ti\u001a{WO\u001c3GS2,7\u000f\t\u0005\n\u0003K\u0002\u0001\u0019!C\u0005\u0003O\n!\"[4o_J,G+[7f+\t\tI\u0007E\u0002\u0014\u0003WJ1!!\u001c\u0015\u0005\u0011auN\\4\t\u0013\u0005E\u0004\u00011A\u0005\n\u0005M\u0014AD5h]>\u0014X\rV5nK~#S-\u001d\u000b\u0005\u0003G\t)\b\u0003\u0006\u0002x\u0005=\u0014\u0011!a\u0001\u0003S\n1\u0001\u001f\u00132\u0011!\tY\b\u0001Q!\n\u0005%\u0014aC5h]>\u0014X\rV5nK\u0002B\u0011\"a \u0001\u0001\u0004%I!!!\u0002\u000bA\fG\u000f[0\u0016\u0003}B\u0011\"!\"\u0001\u0001\u0004%I!a\"\u0002\u0013A\fG\u000f[0`I\u0015\fH\u0003BA\u0012\u0003\u0013C\u0011\"a\u001e\u0002\u0004\u0006\u0005\t\u0019A \t\u000f\u00055\u0005\u0001)Q\u0005\u007f\u00051\u0001/\u0019;i?\u0002B3!a#/\u0011%\t\u0019\n\u0001a\u0001\n\u0013\t)*A\u0002gg~+\"!a&\u0011\u0007\u0001\u000bI*C\u0002\u0002\u001c\u0006\u0013!BR5mKNK8\u000f^3n\u0011%\ty\n\u0001a\u0001\n\u0013\t\t+A\u0004gg~{F%Z9\u0015\t\u0005\r\u00121\u0015\u0005\u000b\u0003o\ni*!AA\u0002\u0005]\u0005\u0002CAT\u0001\u0001\u0006K!a&\u0002\t\u0019\u001cx\f\t\u0015\u0004\u0003Ks\u0003\"CAW\u0001\u0001\u0007I\u0011\u0001\u0003\u0000\u0003\u00151\u0017\u000e\\3t\u0011)\t\t\f\u0001a\u0001\n\u0003!\u00111W\u0001\nM&dWm]0%KF$B!a\t\u00026\"Q\u0011qOAX\u0003\u0003\u0005\r!!\u0001\t\u0011\u0005e\u0006\u0001)Q\u0005\u0003\u0003\taAZ5mKN\u0004\u0003fAA\\]!I\u0011q\u0018\u0001A\u0002\u0013%\u0011\u0011Y\u0001\rM&dW-T8e)&lWm]\u000b\u0003\u0003\u0007\u0004r!!2\u0002LN\nI'\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a\u0004\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u001b\f9M\u0001\nUS6,7\u000b^1na\u0016$\u0007*Y:i\u001b\u0006\u0004\b\"CAi\u0001\u0001\u0007I\u0011BAj\u0003A1\u0017\u000e\\3N_\u0012$\u0016.\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005U\u0007BCA<\u0003\u001f\f\t\u00111\u0001\u0002D\"A\u0011\u0011\u001c\u0001!B\u0013\t\u0019-A\u0007gS2,Wj\u001c3US6,7\u000f\t\u0015\u0004\u0003/t\u0003\"CAp\u0001\u0001\u0007I\u0011BA4\u0003Ya\u0017m\u001d;OK^4\u0015\u000e\\3GS:$\u0017N\\4US6,\u0007\"CAr\u0001\u0001\u0007I\u0011BAs\u0003ia\u0017m\u001d;OK^4\u0015\u000e\\3GS:$\u0017N\\4US6,w\fJ3r)\u0011\t\u0019#a:\t\u0015\u0005]\u0014\u0011]A\u0001\u0002\u0004\tI\u0007\u0003\u0005\u0002l\u0002\u0001\u000b\u0015BA5\u0003]a\u0017m\u001d;OK^4\u0015\u000e\\3GS:$\u0017N\\4US6,\u0007\u0005K\u0002\u0002j:Bq!!=\u0001\t\u0003\nI$A\u0003ti\u0006\u0014H\u000fC\u0004\u0002v\u0002!\t%!\u000f\u0002\tM$x\u000e\u001d\u0005\b\u0003s\u0004A\u0011IA~\u0003\u001d\u0019w.\u001c9vi\u0016$B!!@\u0003\u0010A)1#a@\u0003\u0004%\u0019!\u0011\u0001\u000b\u0003\r=\u0003H/[8o!\u0015\u0011)Aa\u0003\u0013\u001b\t\u00119AC\u0002\u0003\n\u0019\t1A\u001d3e\u0013\u0011\u0011iAa\u0002\u0003\u0007I#E\t\u0003\u0005\u0003\u0012\u0005]\b\u0019AA\t\u0003%1\u0018\r\\5e)&lW\r\u0003\u0005\u0003\u0016\u0001!\t\u0006\u0002B\f\u00035\u0019G.Z1s\u001b\u0016$\u0018\rZ1uCR!\u00111\u0005B\r\u0011!\tYCa\u0005A\u0002\u0005E\u0001b\u0002B\u000f\u0001\u0011%!qD\u0001\rM&tGMT3x\r&dWm\u001d\u000b\u0005\u0005C\u0011Y\u0004\u0005\u0004\u0014-\t\r\u0012\u0011\u000e\t\u0006\u0005K\u0011)d\r\b\u0005\u0005O\u0011\tD\u0004\u0003\u0003*\t=RB\u0001B\u0016\u0015\r\u0011i\u0003H\u0001\u0007yI|w\u000e\u001e \n\u0003UI1Aa\r\u0015\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u000e\u0003:\t\u00191+Z9\u000b\u0007\tMB\u0003\u0003\u0005\u0003>\tm\u0001\u0019AA5\u0003-\u0019WO\u001d:f]R$\u0016.\\3\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D\u0005Qa-\u001b7fgR{'\u000b\u0012#\u0015\t\t\r!Q\t\u0005\t\u0003[\u0013y\u00041\u0001\u0003$!9!\u0011\n\u0001\u0005\n\u0005\u0005\u0015!\u00043je\u0016\u001cGo\u001c:z!\u0006$\b\u000e\u0003\u0004C\u0001\u0011%\u0011Q\u0013\u0005\b\u0005\u001f\u0002A\u0011\u0002B)\u000399W\r\u001e$jY\u0016lu\u000e\u001a+j[\u0016$B!!\u001b\u0003T!9!Q\u000bB'\u0001\u0004y\u0014\u0001\u00029bi\"DqA!\u0017\u0001\t\u0013\tI$A\u0003sKN,G\u000fC\u0004\u0003^\u0001!IAa\u0018\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG\u000f\u0006\u0003\u0002$\t\u0005\u0004\u0002\u0003B2\u00057\u0002\rA!\u001a\u0002\u0007=L7\u000f\u0005\u0003\u0003h\t5TB\u0001B5\u0015\u0011\u0011Y'!\u0013\u0002\u0005%|\u0017\u0002\u0002B8\u0005S\u0012\u0011c\u00142kK\u000e$\u0018J\u001c9viN#(/Z1nQ\u0019\u0011YFa\u001d\u0003\nB)1C!\u001e\u0003z%\u0019!q\u000f\u000b\u0003\rQD'o\\<t!\rI\"1\u0010\u0003\b\u0005{\u0002!\u0019\u0001B@\u0005\u0005!\u0016c\u0001\u0010\u0003\u0002B!!1\u0011BC\u001d\r\u0019\"\u0011G\u0005\u0005\u0005\u000f\u0013IDA\u0005UQJ|w/\u00192mK\u000e\u0012!1\u0012\t\u0005\u0005O\u0012i)\u0003\u0003\u0003\u0010\n%$aC%P\u000bb\u001cW\r\u001d;j_:4qAa%\u0001\u0001\u0011\u0011)J\u0001\tDkN$x.\u001c)bi\"4\u0015\u000e\u001c;feN1!\u0011\u0013BL\u0005;\u0003B!a\u0011\u0003\u001a&!!1TA#\u0005\u0019y%M[3diB\u0019\u0001Ia(\n\u0007\t\u0005\u0016I\u0001\u0006QCRDg)\u001b7uKJD1B!*\u0003\u0012\n\u0005\t\u0015!\u0003\u0002j\u0005QQ.\u0019=N_\u0012$\u0016.\\3\t\u000f\u0015\u0014\t\n\"\u0001\u0003*R!!1\u0016BW!\r!(\u0011\u0013\u0005\t\u0005K\u00139\u000b1\u0001\u0002j!Q!\u0011\u0017BI\u0001\u0004%\t!a\u001a\u0002#5LgNT3x\r&dW-T8e)&lW\r\u0003\u0006\u00036\nE\u0005\u0019!C\u0001\u0005o\u000bQ#\\5o\u001d\u0016<h)\u001b7f\u001b>$G+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002$\te\u0006BCA<\u0005g\u000b\t\u00111\u0001\u0002j!I!Q\u0018BIA\u0003&\u0011\u0011N\u0001\u0013[&tg*Z<GS2,Wj\u001c3US6,\u0007\u0005\u0003\u0005\u0003B\nEE\u0011\u0001Bb\u0003\u0019\t7mY3qiR\u0019qI!2\t\u000f\tU#q\u0018a\u0001\u007f\u001dA!\u0011\u001a\u0002\t\u0002\u0011\u0011Y-\u0001\tGS2,\u0017J\u001c9vi\u0012\u001bFO]3b[B\u0019qB!4\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0003PN1!Q\u001aBi\u0005/\u00042a\u0005Bj\u0013\r\u0011)\u000e\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0007M\u0011I.C\u0002\u0003\\R\u0011AbU3sS\u0006d\u0017N_1cY\u0016Dq!\u001aBg\t\u0003\u0011y\u000e\u0006\u0002\u0003L\"A!1\u001dBg\t\u0003\u0011)/A\u0007eK\u001a\fW\u000f\u001c;GS2$XM\u001d\u000b\u0004\u000f\n\u001d\bb\u0002B+\u0005C\u0004\ra\u0010\u0005\u000b\u0005W\u0014i-%A\u0005\u0002\t5\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0005\u0003p\u000e\u00151qAB\u0005+\t\u0011\tPK\u0002=\u0005g\\#A!>\u0011\t\t]8\u0011A\u0007\u0003\u0005sTAAa?\u0003~\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u007f$\u0012AC1o]>$\u0018\r^5p]&!11\u0001B}\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u00077\t%(\u0019A\u000f\u0005\r\u0019\u0012IO1\u0001\u001e\t\u001da&\u0011\u001eb\u0001\u0007\u0017\t2AHB\u0007!\u0019y&ma\u0004\u0004\u0012A\u0019\u0011d!\u0002\u0011\u0007e\u00199\u0001\u0003\u0006\u0004\u0016\t5\u0017\u0013!C\u0001\u0007/\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T\u0003CB\r\u0007;\u0019yb!\t\u0016\u0005\rm!fA$\u0003t\u001211da\u0005C\u0002u!aAJB\n\u0005\u0004iBa\u0002/\u0004\u0014\t\u000711E\t\u0004=\r\u0015\u0002CB0c\u0007O\u0019I\u0003E\u0002\u001a\u0007;\u00012!GB\u0010\u0011)\u0019iC!4\u0002\u0002\u0013%1qF\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0018\u0002")
public class FileInputDStream<K, V, F extends InputFormat<K, V>>
extends InputDStream<Tuple2<K, V>> {
    private final String directory;
    public final Function1<Path, Object> org$apache$spark$streaming$dstream$FileInputDStream$$filter;
    public final ClassTag<K> org$apache$spark$streaming$dstream$FileInputDStream$$evidence$1;
    public final ClassTag<V> org$apache$spark$streaming$dstream$FileInputDStream$$evidence$2;
    public final ClassTag<F> org$apache$spark$streaming$dstream$FileInputDStream$$evidence$3;
    private final FileInputDStreamCheckpointData checkpointData;
    private final HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$lastFoundFiles;
    private long org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime;
    private transient Path path_;
    private transient FileSystem fs_;
    private transient HashMap<Time, String[]> files;
    private transient TimeStampedHashMap<String, Object> org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes;
    private transient long lastNewFileFindingTime;

    public static <K, V, F extends InputFormat<K, V>> boolean $lessinit$greater$default$4() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$4();
    }

    public static <K, V, F extends InputFormat<K, V>> Function1<Path, Object> $lessinit$greater$default$3() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean defaultFilter(Path path) {
        return FileInputDStream$.MODULE$.defaultFilter(path);
    }

    public FileInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$lastFoundFiles() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$lastFoundFiles;
    }

    public long org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime;
    }

    private void org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime_$eq(long x$1) {
        this.org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime = x$1;
    }

    private Path path_() {
        return this.path_;
    }

    private void path__$eq(Path x$1) {
        this.path_ = x$1;
    }

    private FileSystem fs_() {
        return this.fs_;
    }

    private void fs__$eq(FileSystem x$1) {
        this.fs_ = x$1;
    }

    public HashMap<Time, String[]> files() {
        return this.files;
    }

    public void files_$eq(HashMap<Time, String[]> x$1) {
        this.files = x$1;
    }

    public TimeStampedHashMap<String, Object> org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes;
    }

    private void org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes_$eq(TimeStampedHashMap<String, Object> x$1) {
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes = x$1;
    }

    private long lastNewFileFindingTime() {
        return this.lastNewFileFindingTime;
    }

    private void lastNewFileFindingTime_$eq(long x$1) {
        this.lastNewFileFindingTime = x$1;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Option<RDD<Tuple2<K, V>>> compute(Time validTime) {
        Predef$.MODULE$.assert(validTime.milliseconds() >= this.org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime(), (Function0)new Serializable(this, validTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Time validTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Trying to get new files for a really old time [").append((Object)this.validTime$1).append((Object)" < ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime())).append((Object)"]").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.validTime$1 = validTime$1;
            }
        });
        Tuple2<Seq<String>, Object> tuple2 = this.findNewFiles(validTime.milliseconds());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq newFiles = (Seq)tuple2._1();
            long minNewFileModTime = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)newFiles, (Object)BoxesRunTime.boxToLong((long)minNewFileModTime));
            Seq newFiles2 = (Seq)tuple23._1();
            long minNewFileModTime2 = tuple23._2$mcJ$sp();
            this.logInfo((Function0<String>)new Serializable(this, validTime, newFiles2){
                public static final long serialVersionUID = 0L;
                private final Time validTime$1;
                private final Seq newFiles$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"New files at time ").append((Object)this.validTime$1).append((Object)":\n").append((Object)this.newFiles$1.mkString("\n")).toString();
                }
                {
                    void var3_3;
                    this.validTime$1 = validTime$1;
                    this.newFiles$1 = var3_3;
                }
            });
            if (!newFiles2.isEmpty()) {
                this.org$apache$spark$streaming$dstream$FileInputDStream$$lastFoundFiles().clear();
                this.org$apache$spark$streaming$dstream$FileInputDStream$$lastFoundFiles().$plus$plus$eq((TraversableOnce)newFiles2);
                this.org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime_$eq(minNewFileModTime2);
            }
            this.files().$plus$eq(new Tuple2((Object)validTime, newFiles2.toArray(ClassTag$.MODULE$.apply(String.class))));
            return new Some(this.org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)newFiles2));
        }
        throw new MatchError(tuple2);
    }

    @Override
    public void clearMetadata(Time time) {
        super.clearMetadata(time);
        HashMap oldFiles = (HashMap)this.files().filter((Function1)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Time time$1;

            public final boolean apply(Tuple2<Time, String[]> x$2) {
                return ((Time)x$2._1()).$less(this.time$1.$minus(this.$outer.rememberDuration()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.time$1 = time$1;
            }
        });
        this.files().$minus$minus$eq((TraversableOnce)oldFiles.keys());
        this.logInfo((Function0<String>)new Serializable(this, time, oldFiles){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Time time$1;
            private final HashMap oldFiles$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Cleared ").append((Object)BoxesRunTime.boxToInteger((int)this.oldFiles$1.size())).append((Object)" old files that were older than ").append((Object)this.time$1.$minus(this.$outer.rememberDuration())).append((Object)": ").append((Object)this.oldFiles$1.keys().mkString(", ")).toString();
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.time$1 = time$1;
                this.oldFiles$1 = var3_3;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, oldFiles){
            public static final long serialVersionUID = 0L;
            private final HashMap oldFiles$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Cleared files are:\n").append((Object)((TraversableOnce)this.oldFiles$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Time, String> apply(Tuple2<Time, String[]> p) {
                        return new Tuple2(p._1(), (Object)Predef$.MODULE$.refArrayOps((Object[])p._2()).mkString(", "));
                    }
                }, HashMap$.MODULE$.canBuildFrom())).mkString("\n")).toString();
            }
            {
                this.oldFiles$1 = oldFiles$1;
            }
        });
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes().clearOldValues(this.lastNewFileFindingTime() - 1L);
    }

    private Tuple2<Seq<String>, Object> findNewFiles(long currentTime) {
        this.logDebug((Function0<String>)new Serializable(this, currentTime){
            public static final long serialVersionUID = 0L;
            private final long currentTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Trying to get new files for time ").append((Object)BoxesRunTime.boxToLong((long)this.currentTime$1)).toString();
            }
            {
                this.currentTime$1 = currentTime$1;
            }
        });
        this.lastNewFileFindingTime_$eq(System.currentTimeMillis());
        CustomPathFilter filter2 = new CustomPathFilter(this, currentTime);
        String[] newFiles = (String[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$dstream$FileInputDStream$$fs().listStatus(this.directoryPath(), (PathFilter)filter2)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$3) {
                return x$3.getPath().toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long timeTaken = System.currentTimeMillis() - this.lastNewFileFindingTime();
        this.logInfo((Function0<String>)new Serializable(this, timeTaken){
            public static final long serialVersionUID = 0L;
            private final long timeTaken$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Finding new files took ").append((Object)BoxesRunTime.boxToLong((long)this.timeTaken$1)).append((Object)" ms").toString();
            }
            {
                this.timeTaken$1 = timeTaken$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"# cached file times = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes().size())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (timeTaken > this.slideDuration().milliseconds()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Time taken to find new files exceeds the batch size. Consider increasing the batch size or reduceing the number of files in the monitored directory.";
                }
            });
        }
        return new Tuple2((Object)Predef$.MODULE$.wrapRefArray((Object[])newFiles), (Object)BoxesRunTime.boxToLong((long)filter2.minNewFileModTime()));
    }

    public RDD<Tuple2<K, V>> org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD(Seq<String> files) {
        Seq fileRDDs = (Seq)files.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;

            public final RDD<Tuple2<K, V>> apply(String file) {
                return this.$outer.context().sparkContext().newAPIHadoopFile(file, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$1, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$2, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((IterableLike)files.zip((GenIterable)fileRDDs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;

            public final void apply(Tuple2<String, RDD<Tuple2<K, V>>> x0$1) {
                Tuple2<String, RDD<Tuple2<K, V>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String file = (String)tuple2._1();
                    RDD rdd = (RDD)tuple2._2();
                    if (Predef$.MODULE$.refArrayOps((Object[])rdd.partitions()).size() == 0) {
                        this.$outer.logError((Function0<String>)new Serializable(this, file){
                            public static final long serialVersionUID = 0L;
                            private final String file$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"File ").append((Object)this.file$1).append((Object)" has no data in it. Spark Streaming can only ingest ").append((Object)"files that have been \"moved\" to the directory assigned to the file stream. ").append((Object)"Refer to the streaming programming guide for more details.").toString();
                            }
                            {
                                this.file$1 = file$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return new UnionRDD(this.context().sparkContext(), fileRDDs, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private Path directoryPath() {
        if (this.path_() == null) {
            this.path__$eq(new Path(this.directory));
        }
        return this.path_();
    }

    public FileSystem org$apache$spark$streaming$dstream$FileInputDStream$$fs() {
        if (this.fs_() == null) {
            this.fs__$eq(this.directoryPath().getFileSystem(new Configuration()));
        }
        return this.fs_();
    }

    public long org$apache$spark$streaming$dstream$FileInputDStream$$getFileModTime(Path path) {
        return BoxesRunTime.unboxToLong((Object)this.org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes().getOrElseUpdate((Object)path.toString(), (Function0)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Path path$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fs().getFileStatus(this.path$1).getModificationTime();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        }));
    }

    public void org$apache$spark$streaming$dstream$FileInputDStream$$reset() {
        this.fs__$eq(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;

            public final String apply() {
                return new StringBuilder().append((Object)this.$outer.getClass().getSimpleName()).append((Object)".readObject used").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ois.defaultReadObject();
        this.generatedRDDs_$eq(new HashMap());
        this.files_$eq((HashMap<Time, String[]>)new HashMap());
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes_$eq((TimeStampedHashMap<String, Object>)new TimeStampedHashMap(true));
    }

    public FileInputDStream(StreamingContext ssc_, String directory, Function1<Path, Object> filter2, boolean newFilesOnly, ClassTag<K> evidence$1, ClassTag<V> evidence$2, ClassTag<F> evidence$3) {
        this.directory = directory;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$filter = filter2;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$1 = evidence$1;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$2 = evidence$2;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$3 = evidence$3;
        super(ssc_, ClassTag$.MODULE$.apply(Tuple2.class));
        this.checkpointData = new FileInputDStreamCheckpointData();
        this.org$apache$spark$streaming$dstream$FileInputDStream$$lastFoundFiles = new HashSet();
        this.org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime = newFilesOnly ? System.currentTimeMillis() : 0L;
        this.path_ = null;
        this.fs_ = null;
        this.files = new HashMap();
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileModTimes = new TimeStampedHashMap(true);
        this.lastNewFileFindingTime = 0L;
    }

    public class CustomPathFilter
    implements PathFilter {
        private final long maxModTime;
        private long minNewFileModTime;
        public final /* synthetic */ FileInputDStream $outer;

        public long minNewFileModTime() {
            return this.minNewFileModTime;
        }

        public void minNewFileModTime_$eq(long x$1) {
            this.minNewFileModTime = x$1;
        }

        public boolean accept(Path path) {
            block7: {
                try {
                    if (!BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$filter.apply((Object)path))) break block7;
                    if (this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$lastFoundFiles().contains((Object)path.toString())) {
                        this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().logDebug((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Mod time equal to last mod time, but file considered already";
                            }
                        });
                        return false;
                    }
                    long modTime = this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$getFileModTime(path);
                    this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final Path path$2;
                        private final long modTime$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Mod time for ").append((Object)this.path$2).append((Object)" is ").append((Object)BoxesRunTime.boxToLong((long)this.modTime$1)).toString();
                        }
                        {
                            this.path$2 = path$2;
                            this.modTime$1 = modTime$1;
                        }
                    });
                    if (modTime < this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime()) {
                        this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().logDebug((Function0<String>)new Serializable(this, modTime){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ CustomPathFilter $outer;
                            private final long modTime$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Mod time ").append((Object)BoxesRunTime.boxToLong((long)this.modTime$1)).append((Object)" less than ignore time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$ignoreTime())).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.modTime$1 = modTime$1;
                            }
                        });
                        return false;
                    }
                    if (modTime > this.maxModTime) {
                        this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().logDebug((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Mod time more than ";
                            }
                        });
                        return false;
                    }
                    if (this.minNewFileModTime() < 0L || modTime < this.minNewFileModTime()) {
                        this.minNewFileModTime_$eq(modTime);
                    }
                    this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().logDebug((Function0<String>)new Serializable(this, path){
                        public static final long serialVersionUID = 0L;
                        private final Path path$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Accepted ").append((Object)this.path$2).toString();
                        }
                        {
                            this.path$2 = path$2;
                        }
                    });
                    return true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error finding new files";
                        }
                    }, fileNotFoundException);
                    this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$reset();
                    return false;
                }
            }
            this.org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer().logDebug((Function0<String>)new Serializable(this, path){
                public static final long serialVersionUID = 0L;
                private final Path path$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Rejected by filter ").append((Object)this.path$2).toString();
                }
                {
                    this.path$2 = path$2;
                }
            });
            return false;
        }

        public /* synthetic */ FileInputDStream org$apache$spark$streaming$dstream$FileInputDStream$CustomPathFilter$$$outer() {
            return this.$outer;
        }

        public CustomPathFilter(FileInputDStream<K, V, F> $outer, long maxModTime) {
            this.maxModTime = maxModTime;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.minNewFileModTime = -1L;
        }
    }

    public class FileInputDStreamCheckpointData
    extends DStreamCheckpointData<Tuple2<K, V>> {
        public HashMap<Time, String[]> hadoopFiles() {
            return this.data();
        }

        @Override
        public void update(Time time) {
            this.hadoopFiles().clear();
            this.hadoopFiles().$plus$plus$eq(this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().files());
        }

        @Override
        public void cleanup(Time time) {
        }

        @Override
        public void restore() {
            ((IterableLike)this.hadoopFiles().toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Time apply(Tuple2<Time, String[]> x$4) {
                    return (Time)x$4._1();
                }
            }, Time$.MODULE$.ordering())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileInputDStreamCheckpointData $outer;

                public final HashMap<Time, RDD<Tuple2<K, V>>> apply(Tuple2<Time, String[]> x0$2) {
                    Tuple2<Time, String[]> tuple2 = x0$2;
                    if (tuple2 != null) {
                        Time t = (Time)tuple2._1();
                        String[] f = (String[])tuple2._2();
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final Time t$1;
                            private final String[] f$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Restoring files for time ").append((Object)this.t$1).append((Object)" - ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.f$1).mkString("[", ", ", "]")).toString();
                            }
                            {
                                this.t$1 = t$1;
                                this.f$1 = f$1;
                            }
                        });
                        this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().files().$plus$eq(new Tuple2((Object)t, (Object)f));
                        HashMap hashMap = this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(new Tuple2((Object)t, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])f))));
                        return hashMap;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        @Override
        public String toString() {
            return new StringBuilder().append((Object)"[\n").append((Object)BoxesRunTime.boxToInteger((int)this.hadoopFiles().size())).append((Object)" file sets\n").append((Object)((TraversableOnce)this.hadoopFiles().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Time, String> apply(Tuple2<Time, String[]> p) {
                    return new Tuple2(p._1(), (Object)Predef$.MODULE$.refArrayOps((Object[])p._2()).mkString(", "));
                }
            }, HashMap$.MODULE$.canBuildFrom())).mkString("\n")).append((Object)"\n]").toString();
        }

        public /* synthetic */ FileInputDStream org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer() {
            return FileInputDStream.this;
        }

        public FileInputDStreamCheckpointData() {
            if (FileInputDStream.this == null) {
                throw new NullPointerException();
            }
            super(FileInputDStream.this, ClassTag$.MODULE$.apply(Tuple2.class));
        }
    }
}

