/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.spark.Logging;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBus$;
import org.apache.spark.streaming.scheduler.StreamingListenerEvent;
import org.apache.spark.streaming.scheduler.StreamingListenerShutdown$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.SynchronizedBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q4Q!\u0001\u0002\u0001\r1\u0011Ac\u0015;sK\u0006l\u0017N\\4MSN$XM\\3s\u0005V\u001c(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u000ba\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?\u0007\u0001!\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0011\r\u0011\"\u0003 \u0003%a\u0017n\u001d;f]\u0016\u00148/F\u0001!%\r\tS\u0005\r\u0004\u0005E\r\u0002\u0001E\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0003\u0004%\u0001\u0001\u0006I\u0001I\u0001\u000bY&\u001cH/\u001a8feN\u0004\u0003c\u0001\u0014,[5\tqE\u0003\u0002)S\u00059Q.\u001e;bE2,'B\u0001\u0016\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Y\u001d\u00121\"\u0011:sCf\u0014UO\u001a4feB\u0011ADL\u0005\u0003_\t\u0011\u0011c\u0015;sK\u0006l\u0017N\\4MSN$XM\\3s!\r1\u0013'L\u0005\u0003e\u001d\u0012!cU=oG\"\u0014xN\\5{K\u0012\u0014UO\u001a4fe\"9A\u0007\u0001b\u0001\n\u0013)\u0014\u0001F#W\u000b:#v,U+F+\u0016{6)\u0011)B\u0007&#\u0016,F\u00017!\tqq'\u0003\u00029\u001f\t\u0019\u0011J\u001c;\t\ri\u0002\u0001\u0015!\u00037\u0003U)e+\u0012(U?F+V)V#`\u0007\u0006\u0003\u0016iQ%U3\u0002Bq\u0001\u0010\u0001C\u0002\u0013%Q(\u0001\u0006fm\u0016tG/U;fk\u0016,\u0012A\u0010\t\u0004\u007f\u0019CU\"\u0001!\u000b\u0005\u0005\u0013\u0015AC2p]\u000e,(O]3oi*\u00111\tR\u0001\u0005kRLGNC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0003%a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007C\u0001\u000fJ\u0013\tQ%A\u0001\fTiJ,\u0017-\\5oO2K7\u000f^3oKJ,e/\u001a8u\u0011\u0019a\u0005\u0001)A\u0005}\u0005YQM^3oiF+X-^3!\u0011\u001dq\u0005\u00011A\u0005\n=\u000b1$];fk\u00164U\u000f\u001c7FeJ|'/T3tg\u0006<W\rT8hO\u0016$W#\u0001)\u0011\u00059\t\u0016B\u0001*\u0010\u0005\u001d\u0011un\u001c7fC:Dq\u0001\u0016\u0001A\u0002\u0013%Q+A\u0010rk\u0016,XMR;mY\u0016\u0013(o\u001c:NKN\u001c\u0018mZ3M_\u001e<W\rZ0%KF$\"AV-\u0011\u000599\u0016B\u0001-\u0010\u0005\u0011)f.\u001b;\t\u000fi\u001b\u0016\u0011!a\u0001!\u0006\u0019\u0001\u0010J\u0019\t\rq\u0003\u0001\u0015)\u0003Q\u0003q\tX/Z;f\rVdG.\u0012:s_JlUm]:bO\u0016dunZ4fI\u0002BqA\u0018\u0001C\u0002\u0013\u0005q,\u0001\bmSN$XM\\3s)\"\u0014X-\u00193\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!a\u0019#\u0002\t1\fgnZ\u0005\u0003K\n\u0014a\u0001\u00165sK\u0006$\u0007BB4\u0001A\u0003%\u0001-A\bmSN$XM\\3s)\"\u0014X-\u00193!\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u0015\u0019H/\u0019:u)\u00051\u0006\"\u00027\u0001\t\u0003i\u0017aC1eI2K7\u000f^3oKJ$\"A\u00168\t\u000b=\\\u0007\u0019A\u0017\u0002\u00111L7\u000f^3oKJDQ!\u001d\u0001\u0005\u0002I\fA\u0001]8tiR\u0011ak\u001d\u0005\u0006iB\u0004\r\u0001S\u0001\u0006KZ,g\u000e\u001e\u0005\u0006m\u0002!\ta^\u0001\u000fo\u0006LG/\u00168uS2,U\u000e\u001d;z)\t\u0001\u0006\u0010C\u0003zk\u0002\u0007a'A\u0007uS6,w.\u001e;NS2d\u0017n\u001d\u0005\u0006w\u0002!\tA[\u0001\u0005gR|\u0007\u000f")
public class StreamingListenerBus
implements Logging {
    private final ArrayBuffer<StreamingListener> org$apache$spark$streaming$scheduler$StreamingListenerBus$$listeners;
    private final int EVENT_QUEUE_CAPACITY;
    private final LinkedBlockingQueue<StreamingListenerEvent> org$apache$spark$streaming$scheduler$StreamingListenerBus$$eventQueue;
    private boolean queueFullErrorMessageLogged;
    private final Thread listenerThread;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ArrayBuffer<StreamingListener> org$apache$spark$streaming$scheduler$StreamingListenerBus$$listeners() {
        return this.org$apache$spark$streaming$scheduler$StreamingListenerBus$$listeners;
    }

    private int EVENT_QUEUE_CAPACITY() {
        return this.EVENT_QUEUE_CAPACITY;
    }

    public LinkedBlockingQueue<StreamingListenerEvent> org$apache$spark$streaming$scheduler$StreamingListenerBus$$eventQueue() {
        return this.org$apache$spark$streaming$scheduler$StreamingListenerBus$$eventQueue;
    }

    private boolean queueFullErrorMessageLogged() {
        return this.queueFullErrorMessageLogged;
    }

    private void queueFullErrorMessageLogged_$eq(boolean x$1) {
        this.queueFullErrorMessageLogged = x$1;
    }

    public Thread listenerThread() {
        return this.listenerThread;
    }

    public void start() {
        this.listenerThread().start();
    }

    public void addListener(StreamingListener listener) {
        ((SynchronizedBuffer)this.org$apache$spark$streaming$scheduler$StreamingListenerBus$$listeners()).$plus$eq((Object)listener);
    }

    public void post(StreamingListenerEvent event) {
        boolean eventAdded = this.org$apache$spark$streaming$scheduler$StreamingListenerBus$$eventQueue().offer(event);
        if (!eventAdded && !this.queueFullErrorMessageLogged()) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Dropping StreamingListenerEvent because no remaining room in event queue. This likely means one of the StreamingListeners is too slow and cannot keep up with the rate at which events are being started by the scheduler.";
                }
            });
            this.queueFullErrorMessageLogged_$eq(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean waitUntilEmpty(int timeoutMillis) {
        long finishTime = System.currentTimeMillis() + (long)timeoutMillis;
        while (!this.org$apache$spark$streaming$scheduler$StreamingListenerBus$$eventQueue().isEmpty()) {
            void var2_2;
            if (System.currentTimeMillis() > var2_2) {
                return false;
            }
            Thread.sleep(10L);
        }
        return true;
    }

    public void stop() {
        this.post(StreamingListenerShutdown$.MODULE$);
    }

    public StreamingListenerBus() {
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$scheduler$StreamingListenerBus$$listeners = new $anon$1(this);
        this.EVENT_QUEUE_CAPACITY = 10000;
        this.org$apache$spark$streaming$scheduler$StreamingListenerBus$$eventQueue = new LinkedBlockingQueue(this.EVENT_QUEUE_CAPACITY());
        this.queueFullErrorMessageLogged = false;
        this.listenerThread = new $anon$2(this);
    }
}

