/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.CoGroupedRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Interval;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.ReducedWindowedDStream$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb!B\u0001\u0003\u0001\u0011a!A\u0006*fIV\u001cW\rZ,j]\u0012|w/\u001a3E'R\u0014X-Y7\u000b\u0005\r!\u0011a\u00023tiJ,\u0017-\u001c\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e,2!\u0004\u000e&'\t\u0001a\u0002E\u0002\u0010!Ii\u0011AA\u0005\u0003#\t\u0011q\u0001R*ue\u0016\fW\u000e\u0005\u0003\u0014-a!S\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\rQ+\b\u000f\\33!\tI\"\u0004\u0004\u0001\u0005\u000bm\u0001!\u0019A\u000f\u0003\u0003-\u001b\u0001!\u0005\u0002\u001fCA\u00111cH\u0005\u0003AQ\u0011qAT8uQ&tw\r\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0004\u0003:L\bCA\r&\t\u00151\u0003A1\u0001\u001e\u0005\u00051\u0006\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\b\u0002\rA\f'/\u001a8u\u0011!Q\u0003A!A!\u0002\u0013Y\u0013A\u0003:fIV\u001cWMR;oGB)1\u0003\f\u0013%I%\u0011Q\u0006\u0006\u0002\n\rVt7\r^5p]JB\u0001b\f\u0001\u0003\u0002\u0003\u0006IaK\u0001\u000eS:4(+\u001a3vG\u00164UO\\2\t\u0011E\u0002!\u0011!Q\u0001\nI\n!BZ5mi\u0016\u0014h)\u001e8d!\r\u00192'N\u0005\u0003iQ\u0011aa\u00149uS>t\u0007\u0003B\n7%aJ!a\u000e\u000b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\n:\u0013\tQDCA\u0004C_>dW-\u00198\t\u0011q\u0002!\u0011!Q\u0001\nu\nqbX<j]\u0012|w\u000fR;sCRLwN\u001c\t\u0003}}j\u0011\u0001B\u0005\u0003\u0001\u0012\u0011\u0001\u0002R;sCRLwN\u001c\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005{\u0005qql\u001d7jI\u0016$UO]1uS>t\u0007\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\u0002\u0017A\f'\u000f^5uS>tWM\u001d\t\u0003\r\u001ek\u0011AB\u0005\u0003\u0011\u001a\u00111\u0002U1si&$\u0018n\u001c8fe\"A!\n\u0001B\u0002B\u0003-1*\u0001\u0006fm&$WM\\2fIE\u00022\u0001T(\u0019\u001b\u0005i%B\u0001(\u0015\u0003\u001d\u0011XM\u001a7fGRL!\u0001U'\u0003\u0011\rc\u0017m]:UC\u001eD\u0001B\u0015\u0001\u0003\u0004\u0003\u0006YaU\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004c\u0001'PI!)Q\u000b\u0001C\u0001-\u00061A(\u001b8jiz\"\u0002bV.];z{\u0006-\u0019\u000b\u00041fS\u0006\u0003B\b\u00011\u0011BQA\u0013+A\u0004-CQA\u0015+A\u0004MCQ\u0001\u000b+A\u00029AQA\u000b+A\u0002-BQa\f+A\u0002-BQ!\r+A\u0002IBQ\u0001\u0010+A\u0002uBQA\u0011+A\u0002uBQ\u0001\u0012+A\u0002\u0015Cqa\u0019\u0001C\u0002\u0013\u0005A-A\u0007sK\u0012,8-\u001a3TiJ,\u0017-\\\u000b\u0002\u001d!1a\r\u0001Q\u0001\n9\taB]3ek\u000e,Gm\u0015;sK\u0006l\u0007\u0005C\u0003i\u0001\u0011\u0005\u0011.\u0001\bxS:$wn\u001e#ve\u0006$\u0018n\u001c8\u0016\u0003uBQa\u001b\u0001\u0005B1\fA\u0002Z3qK:$WM\\2jKN,\u0012!\u001c\t\u0004]NtQ\"A8\u000b\u0005A\f\u0018!C5n[V$\u0018M\u00197f\u0015\t\u0011H#\u0001\u0006d_2dWm\u0019;j_:L!\u0001^8\u0003\t1K7\u000f\u001e\u0005\u0006m\u0002!\t%[\u0001\u000eg2LG-\u001a#ve\u0006$\u0018n\u001c8\t\u000fa\u0004!\u0019!C!s\u0006qQ.^:u\u0007\",7m\u001b9pS:$X#\u0001\u001d\t\rm\u0004\u0001\u0015!\u00039\u0003=iWo\u001d;DQ\u0016\u001c7\u000e]8j]R\u0004\u0003\"B?\u0001\t\u0003J\u0017A\u00069be\u0016tGOU3nK6\u0014WM\u001d#ve\u0006$\u0018n\u001c8\t\r}\u0004A\u0011IA\u0001\u0003\u001d\u0001XM]:jgR$2ADA\u0002\u0011\u001d\t)A a\u0001\u0003\u000f\tAb\u001d;pe\u0006<W\rT3wK2\u0004B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b1\u0011aB:u_J\fw-Z\u0005\u0005\u0003#\tYA\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0004\u0002\u0016\u0001!\t%a\u0006\u0002\u0015\rDWmY6q_&tG\u000fF\u0002\u000f\u00033Aq!a\u0007\u0002\u0014\u0001\u0007Q(\u0001\u0005j]R,'O^1m\u0011\u001d\ty\u0002\u0001C!\u0003C\tqaY8naV$X\r\u0006\u0003\u0002$\u0005E\u0002\u0003B\n4\u0003K\u0001R!a\n\u0002.Ii!!!\u000b\u000b\u0007\u0005-b!A\u0002sI\u0012LA!a\f\u0002*\t\u0019!\u000b\u0012#\t\u0011\u0005M\u0012Q\u0004a\u0001\u0003k\t\u0011B^1mS\u0012$\u0016.\\3\u0011\u0007y\n9$C\u0002\u0002:\u0011\u0011A\u0001V5nK\u0002")
public class ReducedWindowedDStream<K, V>
extends DStream<Tuple2<K, V>> {
    public final DStream<Tuple2<K, V>> org$apache$spark$streaming$dstream$ReducedWindowedDStream$$parent;
    private final Function2<V, V, V> reduceFunc;
    private final Function2<V, V, V> invReduceFunc;
    private final Option<Function1<Tuple2<K, V>, Object>> filterFunc;
    public final Duration org$apache$spark$streaming$dstream$ReducedWindowedDStream$$_windowDuration;
    public final Duration org$apache$spark$streaming$dstream$ReducedWindowedDStream$$_slideDuration;
    private final Partitioner partitioner;
    private final ClassTag<K> evidence$1;
    private final DStream<Tuple2<K, V>> reducedStream;
    private final boolean mustCheckpoint;

    public DStream<Tuple2<K, V>> reducedStream() {
        return this.reducedStream;
    }

    public Duration windowDuration() {
        return this.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$_windowDuration;
    }

    @Override
    public List<DStream<Tuple2<K, V>>> dependencies() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DStream[]{this.reducedStream()}));
    }

    @Override
    public Duration slideDuration() {
        return this.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$_slideDuration;
    }

    @Override
    public boolean mustCheckpoint() {
        return this.mustCheckpoint;
    }

    @Override
    public Duration parentRememberDuration() {
        return this.rememberDuration().$plus(this.windowDuration());
    }

    @Override
    public DStream<Tuple2<K, V>> persist(StorageLevel storageLevel) {
        super.persist(storageLevel);
        this.reducedStream().persist(storageLevel);
        return this;
    }

    @Override
    public DStream<Tuple2<K, V>> checkpoint(Duration interval) {
        super.checkpoint(interval);
        return this;
    }

    @Override
    public Option<RDD<Tuple2<K, V>>> compute(Time validTime) {
        Function2<V, V, V> reduceF = this.reduceFunc;
        Function2<V, V, V> invReduceF = this.invReduceFunc;
        Time currentTime = validTime;
        Interval currentWindow = new Interval(currentTime.$minus(this.windowDuration()).$plus(this.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$parent.slideDuration()), currentTime);
        Interval previousWindow = currentWindow.$minus(this.slideDuration());
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReducedWindowedDStream $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Window time = ").append((Object)this.$outer.windowDuration()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReducedWindowedDStream $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Slide time = ").append((Object)this.$outer.slideDuration()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReducedWindowedDStream $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"ZeroTime = ").append((Object)this.$outer.zeroTime()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, currentWindow){
            public static final long serialVersionUID = 0L;
            private final Interval currentWindow$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Current window = ").append((Object)this.currentWindow$1).toString();
            }
            {
                this.currentWindow$1 = currentWindow$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, previousWindow){
            public static final long serialVersionUID = 0L;
            private final Interval previousWindow$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Previous window = ").append((Object)this.previousWindow$1).toString();
            }
            {
                this.previousWindow$1 = previousWindow$1;
            }
        });
        Seq<RDD<Tuple2<K, V>>> oldRDDs = this.reducedStream().slice(previousWindow.beginTime(), currentWindow.beginTime().$minus(this.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$parent.slideDuration()));
        this.logDebug((Function0<String>)new Serializable(this, oldRDDs){
            public static final long serialVersionUID = 0L;
            private final Seq oldRDDs$1;

            public final String apply() {
                return new StringBuilder().append((Object)"# old RDDs = ").append((Object)BoxesRunTime.boxToInteger((int)this.oldRDDs$1.size())).toString();
            }
            {
                this.oldRDDs$1 = oldRDDs$1;
            }
        });
        Seq<RDD<Tuple2<K, V>>> newRDDs = this.reducedStream().slice(previousWindow.endTime().$plus(this.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$parent.slideDuration()), currentWindow.endTime());
        this.logDebug((Function0<String>)new Serializable(this, newRDDs){
            public static final long serialVersionUID = 0L;
            private final Seq newRDDs$1;

            public final String apply() {
                return new StringBuilder().append((Object)"# new RDDs = ").append((Object)BoxesRunTime.boxToInteger((int)this.newRDDs$1.size())).toString();
            }
            {
                this.newRDDs$1 = newRDDs$1;
            }
        });
        RDD previousWindowRDD = (RDD)this.getOrCompute(previousWindow.endTime()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReducedWindowedDStream $outer;

            public final RDD<Tuple2<K, V>> apply() {
                SparkContext qual$1 = this.$outer.ssc().sc();
                Seq x$9 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                int x$10 = qual$1.makeRDD$default$2();
                return qual$1.makeRDD(x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ArrayBuffer allRDDs = new ArrayBuffer().$plus$eq((Object)previousWindowRDD).$plus$plus$eq(oldRDDs).$plus$plus$eq(newRDDs);
        CoGroupedRDD cogroupedRDD = new CoGroupedRDD(allRDDs.toSeq(), this.partitioner);
        int numOldValues = oldRDDs.size();
        int numNewValues = newRDDs.size();
        Serializable mergeValues = new Serializable(this, reduceF, invReduceF, numOldValues, numNewValues){
            public static final long serialVersionUID = 0L;
            private final Function2 reduceF$1;
            private final Function2 invReduceF$1;
            public final int numOldValues$1;
            private final int numNewValues$1;

            public final V apply(Iterable<V>[] arrayOfValues) {
                Object object;
                if (Predef$.MODULE$.refArrayOps((Object[])arrayOfValues).size() != 1 + this.numOldValues$1 + this.numNewValues$1) {
                    throw new Exception("Unexpected number of sequences of reduced values");
                }
                IndexedSeq oldValues = (IndexedSeq)((TraversableLike)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numOldValues$1).map((Function1)new Serializable(this, arrayOfValues){
                    public static final long serialVersionUID = 0L;
                    private final Iterable[] arrayOfValues$1;

                    public final Iterable<V> apply(int i) {
                        return this.arrayOfValues$1[i];
                    }
                    {
                        this.arrayOfValues$1 = arrayOfValues$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Iterable<V> x$1) {
                        return !x$1.isEmpty();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final V apply(Iterable<V> x$2) {
                        return (V)x$2.head();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq newValues = (IndexedSeq)((TraversableLike)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numNewValues$1).map((Function1)new Serializable(this, arrayOfValues){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final Iterable[] arrayOfValues$1;

                    public final Iterable<V> apply(int i) {
                        return this.arrayOfValues$1[this.$outer.numOldValues$1 + i];
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.arrayOfValues$1 = arrayOfValues$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Iterable<V> x$3) {
                        return !x$3.isEmpty();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final V apply(Iterable<V> x$4) {
                        return (V)x$4.head();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                if (arrayOfValues[0].isEmpty()) {
                    if (newValues.isEmpty()) {
                        throw new Exception("Neither previous window has value for key, nor new values found. Are you sure your key class hashes consistently?");
                    }
                    object = newValues.reduce(this.reduceF$1);
                } else {
                    Object tempValue = arrayOfValues[0].head();
                    if (!oldValues.isEmpty()) {
                        tempValue = this.invReduceF$1.apply(tempValue, oldValues.reduce(this.reduceF$1));
                    }
                    if (!newValues.isEmpty()) {
                        tempValue = this.reduceF$1.apply(tempValue, newValues.reduce(this.reduceF$1));
                    }
                    object = tempValue;
                }
                return (V)object;
            }
            {
                void var3_3;
                this.reduceF$1 = reduceF$1;
                this.invReduceF$1 = var3_3;
                this.numOldValues$1 = numOldValues$1;
                this.numNewValues$1 = numNewValues$1;
            }
        };
        CoGroupedRDD x$11 = cogroupedRDD;
        ClassTag<K> x$12 = this.evidence$1;
        ClassTag x$13 = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Iterable.class));
        Null$ x$14 = SparkContext$.MODULE$.rddToPairRDDFunctions$default$4((RDD)x$11);
        RDD mergedValuesRDD = SparkContext$.MODULE$.rddToPairRDDFunctions((RDD)x$11, x$12, x$13, null).mapValues((Function1)mergeValues);
        return this.filterFunc.isDefined() ? new Some((Object)mergedValuesRDD.filter((Function1)this.filterFunc.get())) : new Some((Object)mergedValuesRDD);
    }

    public ReducedWindowedDStream(DStream<Tuple2<K, V>> parent, Function2<V, V, V> reduceFunc, Function2<V, V, V> invReduceFunc, Option<Function1<Tuple2<K, V>, Object>> filterFunc, Duration _windowDuration, Duration _slideDuration, Partitioner partitioner, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        this.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$parent = parent;
        this.reduceFunc = reduceFunc;
        this.invReduceFunc = invReduceFunc;
        this.filterFunc = filterFunc;
        this.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$_windowDuration = _windowDuration;
        this.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$_slideDuration = _slideDuration;
        this.partitioner = partitioner;
        this.evidence$1 = evidence$1;
        super(parent.ssc(), ClassTag$.MODULE$.apply(Tuple2.class));
        Predef$.MODULE$.assert(_windowDuration.isMultipleOf(parent.slideDuration()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReducedWindowedDStream $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The window duration of ReducedWindowedDStream (").append((Object)this.$outer.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$_windowDuration).append((Object)") ").append((Object)"must be multiple of the slide duration of parent DStream (").append((Object)this.$outer.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$parent.slideDuration()).append((Object)")").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.assert(_slideDuration.isMultipleOf(parent.slideDuration()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReducedWindowedDStream $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The slide duration of ReducedWindowedDStream (").append((Object)this.$outer.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$_slideDuration).append((Object)") ").append((Object)"must be multiple of the slide duration of parent DStream (").append((Object)this.$outer.org$apache$spark$streaming$dstream$ReducedWindowedDStream$$parent.slideDuration()).append((Object)")").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        DStream<Tuple2<K, V>> x$5 = parent;
        ClassTag<K> x$6 = evidence$1;
        ClassTag<V> x$7 = evidence$2;
        Null$ x$8 = StreamingContext$.MODULE$.toPairDStreamFunctions$default$4(x$5);
        this.reducedStream = StreamingContext$.MODULE$.toPairDStreamFunctions(x$5, x$6, x$7, null).reduceByKey(reduceFunc, partitioner);
        super.persist(StorageLevel$.MODULE$.MEMORY_ONLY_SER());
        this.reducedStream().persist(StorageLevel$.MODULE$.MEMORY_ONLY_SER());
        this.mustCheckpoint = true;
    }
}

