/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.streaming.Time;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class Checkpoint$
implements Logging,
Serializable {
    public static final Checkpoint$ MODULE$;
    private final String PREFIX;
    private final Regex REGEX;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new Checkpoint$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String PREFIX() {
        return this.PREFIX;
    }

    public Regex REGEX() {
        return this.REGEX;
    }

    public Path checkpointFile(String checkpointDir, Time checkpointTime) {
        return new Path(checkpointDir, new StringBuilder().append((Object)this.PREFIX()).append((Object)BoxesRunTime.boxToLong((long)checkpointTime.milliseconds())).toString());
    }

    public Path checkpointBackupFile(String checkpointDir, Time checkpointTime) {
        return new Path(checkpointDir, new StringBuilder().append((Object)this.PREFIX()).append((Object)BoxesRunTime.boxToLong((long)checkpointTime.milliseconds())).append((Object)".bk").toString());
    }

    public Seq<Path> getCheckpointFiles(String checkpointDir, FileSystem fs) {
        Seq seq;
        Path path = new Path(checkpointDir);
        if (fs.exists(path)) {
            FileStatus[] statuses = fs.listStatus(path);
            if (statuses != null) {
                Path[] paths = (Path[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(FileStatus x$3) {
                        return x$3.getPath();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
                Path[] filtered = (Path[])Predef$.MODULE$.refArrayOps((Object[])paths).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Path p) {
                        return Checkpoint$.MODULE$.REGEX().findFirstIn((CharSequence)p.toString()).nonEmpty();
                    }
                });
                seq = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])filtered).sortWith((Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Path path1, Path path2) {
                        return Checkpoint$.MODULE$.org$apache$spark$streaming$Checkpoint$$sortFunc$1(path1, path2);
                    }
                }));
            } else {
                this.logWarning((Function0<String>)new Serializable(path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Listing ").append((Object)this.path$1).append((Object)" returned null").toString();
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
                seq = (Seq)Seq$.MODULE$.empty();
            }
        } else {
            this.logInfo((Function0<String>)new Serializable(path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Checkpoint directory ").append((Object)this.path$1).append((Object)" does not exist").toString();
                }
                {
                    this.path$1 = path$1;
                }
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final boolean org$apache$spark$streaming$Checkpoint$$sortFunc$1(Path path1, Path path2) {
        String string = path1.getName();
        Option option = this.REGEX().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String x = (String)((LinearSeqOptimized)option.get()).apply(0);
            String y = (String)((LinearSeqOptimized)option.get()).apply(1);
            Tuple2.mcJZ.sp sp2 = new Tuple2.mcJZ.sp(new StringOps(Predef$.MODULE$.augmentString(x)).toLong(), !y.isEmpty());
            Tuple2.mcJZ.sp sp3 = sp2;
            if (sp3 != null) {
                Tuple2.mcJZ.sp sp4;
                long time1 = sp3._1$mcJ$sp();
                boolean bk1 = sp3._2$mcZ$sp();
                Tuple2.mcJZ.sp sp5 = sp4 = new Tuple2.mcJZ.sp(time1, bk1);
                long time12 = sp5._1$mcJ$sp();
                boolean bk12 = sp5._2$mcZ$sp();
                String string2 = path2.getName();
                Option option2 = this.REGEX().unapplySeq((Object)string2);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String x2 = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String y2 = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    Tuple2.mcJZ.sp sp6 = new Tuple2.mcJZ.sp(new StringOps(Predef$.MODULE$.augmentString(x2)).toLong(), !y2.isEmpty());
                    Tuple2.mcJZ.sp sp7 = sp6;
                    if (sp7 != null) {
                        Tuple2.mcJZ.sp sp8;
                        long time2 = sp7._1$mcJ$sp();
                        boolean bk2 = sp7._2$mcZ$sp();
                        Tuple2.mcJZ.sp sp9 = sp8 = new Tuple2.mcJZ.sp(time2, bk2);
                        long time22 = sp9._1$mcJ$sp();
                        boolean bk22 = sp9._2$mcZ$sp();
                        return time12 < time22 || time12 == time22 && bk12;
                    }
                    throw new MatchError((Object)sp7);
                }
                throw new MatchError((Object)string2);
            }
            throw new MatchError((Object)sp3);
        }
        throw new MatchError((Object)string);
    }

    private Checkpoint$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.PREFIX = "checkpoint-";
        this.REGEX = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)this.PREFIX()).append((Object)"([\\d]+)([\\w\\.]*)").toString())).r();
    }
}

