/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.FileInputDStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.util.TimeStampedHashMap;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\rc!B\u0001\u0003\u0001\u0011a!\u0001\u0005$jY\u0016Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!A\u0004egR\u0014X-Y7\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<W\u0003B\u0007\u001bKm\u001b\"\u0001\u0001\b\u0011\u0007=\u0001\"#D\u0001\u0003\u0013\t\t\"A\u0001\u0007J]B,H\u000fR*ue\u0016\fW\u000e\u0005\u0003\u0014-a!S\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\rQ+\b\u000f\\33!\tI\"\u0004\u0004\u0001\u0005\u000bm\u0001!\u0019A\u000f\u0003\u0003-\u001b\u0001!\u0005\u0002\u001fCA\u00111cH\u0005\u0003AQ\u0011qAT8uQ&tw\r\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0004\u0003:L\bCA\r&\t\u00151\u0003A1\u0001\u001e\u0005\u00051\u0006\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\tM\u001c8m\u0018\t\u0003U-j\u0011\u0001B\u0005\u0003Y\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;)\u0005\u001dr\u0003CA\n0\u0013\t\u0001DCA\u0005ue\u0006t7/[3oi\"A!\u0007\u0001B\u0001B\u0003%1'A\u0005eSJ,7\r^8ssB\u0011Ag\u000e\b\u0003'UJ!A\u000e\u000b\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003mQA\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\u0007M&dG/\u001a:\u0011\tMithR\u0005\u0003}Q\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015A\u00014t\u0015\t!\u0005\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\r\u0006\u0013A\u0001U1uQB\u00111\u0003S\u0005\u0003\u0013R\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003H\u00031qWm\u001e$jY\u0016\u001cxJ\u001c7z\u0011!i\u0005AaA!\u0002\u0017q\u0015AC3wS\u0012,gnY3%cA\u0019qJ\u0015\r\u000e\u0003AS!!\u0015\u000b\u0002\u000fI,g\r\\3di&\u00111\u000b\u0015\u0002\t\u00072\f7o\u001d+bO\"AQ\u000b\u0001B\u0002B\u0003-a+\u0001\u0006fm&$WM\\2fII\u00022a\u0014*%\u0011!A\u0006AaA!\u0002\u0017I\u0016AC3wS\u0012,gnY3%gA\u0019qJ\u0015.\u0011\u0005eYF!\u0002/\u0001\u0005\u0004i&!\u0001$\u0012\u0005yq\u0006\u0003B0c1\u0011j\u0011\u0001\u0019\u0006\u0003C\u000e\u000b\u0011\"\\1qe\u0016$WoY3\n\u0005\r\u0004'aC%oaV$hi\u001c:nCRDQ!\u001a\u0001\u0005\u0002\u0019\fa\u0001P5oSRtD#B4m[:|G\u0003\u00025jU.\u0004Ra\u0004\u0001\u0019IiCQ!\u00143A\u00049CQ!\u00163A\u0004YCQ\u0001\u00173A\u0004eCQ\u0001\u000b3A\u0002%BQA\r3A\u0002MBqa\u000f3\u0011\u0002\u0003\u0007A\bC\u0004LIB\u0005\t\u0019A$\t\u0011E\u0004!\u0019!C)\tI\fab\u00195fG.\u0004x.\u001b8u\t\u0006$\u0018-F\u0001t!\t!X/D\u0001\u0001\r\u00151\b\u0001\u0001\u0003x\u0005y1\u0015\u000e\\3J]B,H\u000fR*ue\u0016\fWn\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018m\u0005\u0002vqB\u0019q\"\u001f\n\n\u0005i\u0014!!\u0006#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u0005\u0006KV$\t\u0001 \u000b\u0002g\")a0\u001eC\u0001\u007f\u0006Y\u0001.\u00193p_B4\u0015\u000e\\3t+\t\t\t\u0001\u0005\u0005\u0002\u0004\u00055\u0011\u0011CA\f\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017!\u0012AC2pY2,7\r^5p]&!\u0011qBA\u0003\u0005\u001dA\u0015m\u001d5NCB\u00042AKA\n\u0013\r\t)\u0002\u0002\u0002\u0005)&lW\r\u0005\u0003\u0014\u00033\u0019\u0014bAA\u000e)\t)\u0011I\u001d:bs\"9\u0011qD;\u0005B\u0005\u0005\u0012AB;qI\u0006$X\r\u0006\u0003\u0002$\u0005%\u0002cA\n\u0002&%\u0019\u0011q\u0005\u000b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003W\ti\u00021\u0001\u0002\u0012\u0005!A/[7f\u0011\u001d\ty#\u001eC!\u0003c\tqa\u00197fC:,\b\u000f\u0006\u0003\u0002$\u0005M\u0002\u0002CA\u0016\u0003[\u0001\r!!\u0005\t\u000f\u0005]R\u000f\"\u0011\u0002:\u00059!/Z:u_J,GCAA\u0012\u0011\u001d\ti$\u001eC!\u0003\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003mC:<'BAA&\u0003\u0011Q\u0017M^1\n\u0007a\n)\u0005C\u0004\u0002R\u0001\u0001\u000b\u0011B:\u0002\u001f\rDWmY6q_&tG\u000fR1uC\u0002B\u0011\"!\u0016\u0001\u0005\u0004%I!a\u0016\u0002;%t\u0017\u000e^5bY6{G\rV5nK&;gn\u001c:f)\"\u0014Xm\u001d5pY\u0012,\"!!\u0017\u0011\u0007M\tY&C\u0002\u0002^Q\u0011A\u0001T8oO\"A\u0011\u0011\r\u0001!\u0002\u0013\tI&\u0001\u0010j]&$\u0018.\u00197N_\u0012$\u0016.\\3JO:|'/\u001a+ie\u0016\u001c\bn\u001c7eA!I\u0011Q\r\u0001C\u0002\u0013%\u0011qM\u0001\u0015]Vl')\u0019;dQ\u0016\u001cHk\u001c*f[\u0016l'-\u001a:\u0016\u0005\u0005%\u0004cA\n\u0002l%\u0019\u0011Q\u000e\u000b\u0003\u0007%sG\u000f\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA5\u0003UqW/\u001c\"bi\u000eDWm\u001d+p%\u0016lW-\u001c2fe\u0002B\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\u0002%\u0011,(/\u0019;j_:$vNU3nK6\u0014WM]\u000b\u0003\u0003s\u00022AKA>\u0013\r\ti\b\u0002\u0002\t\tV\u0014\u0018\r^5p]\"A\u0011\u0011\u0011\u0001!\u0002\u0013\tI(A\nekJ\fG/[8o)>\u0014V-\\3nE\u0016\u0014\b\u0005C\u0004\u0002\u0006\u0002!\t%!\u000f\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005%\u0005\u0001\"\u0011\u0002:\u0005!1\u000f^8q\u0011\u001d\ti\t\u0001C!\u0003\u001f\u000bqaY8naV$X\r\u0006\u0003\u0002\u0012\u0006\r\u0006#B\n\u0002\u0014\u0006]\u0015bAAK)\t1q\n\u001d;j_:\u0004R!!'\u0002 Ji!!a'\u000b\u0007\u0005ue!A\u0002sI\u0012LA!!)\u0002\u001c\n\u0019!\u000b\u0012#\t\u0011\u0005\u0015\u00161\u0012a\u0001\u0003#\t\u0011B^1mS\u0012$\u0016.\\3\t\u0011\u0005%\u0006\u0001\"\u0015\u0005\u0003W\u000bQb\u00197fCJlU\r^1eCR\fG\u0003BA\u0012\u0003[C\u0001\"a\u000b\u0002(\u0002\u0007\u0011\u0011\u0003\u0005\b\u0003c\u0003A\u0011BAZ\u000311\u0017N\u001c3OK^4\u0015\u000e\\3t)\u0011\t9\"!.\t\u0011\u0005]\u0016q\u0016a\u0001\u00033\n1bY;se\u0016tG\u000fV5nK\"9\u00111\u0018\u0001\u0005\n\u0005u\u0016!C5t\u001d\u0016<h)\u001b7f)\u001d9\u0015qXAb\u0003\u000bDq!!1\u0002:\u0002\u0007q(\u0001\u0003qCRD\u0007\u0002CA\\\u0003s\u0003\r!!\u0017\t\u0011\u0005\u001d\u0017\u0011\u0018a\u0001\u00033\na#\\8e)&lW-S4o_J,G\u000b\u001b:fg\"|G\u000e\u001a\u0005\b\u0003\u0017\u0004A\u0011BAg\u0003)1\u0017\u000e\\3t)>\u0014F\t\u0012\u000b\u0005\u0003/\u000by\r\u0003\u0005\u0002R\u0006%\u0007\u0019AAj\u0003\u00151\u0017\u000e\\3t!\u0015\t).!:4\u001d\u0011\t9.!9\u000f\t\u0005e\u0017q\\\u0007\u0003\u00037T1!!8\u001d\u0003\u0019a$o\\8u}%\tQ#C\u0002\u0002dR\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002h\u0006%(aA*fc*\u0019\u00111\u001d\u000b\t\u000f\u00055\b\u0001\"\u0003\u0002p\u0006qq-\u001a;GS2,Wj\u001c3US6,G\u0003BA-\u0003cDq!!1\u0002l\u0002\u0007q\bC\u0004\u0002v\u0002!I!a>\u0002\u001b\u0011L'/Z2u_JL\b+\u0019;i+\u0005y\u0004B\u0002\"\u0001\t\u0013\tY0\u0006\u0002\u0002~B\u0019\u0001)a@\n\u0007\t\u0005\u0011I\u0001\u0006GS2,7+_:uK6DqA!\u0002\u0001\t\u0013\tI$A\u0003sKN,G\u000fC\u0004\u0003\n\u0001!IAa\u0003\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG\u000f\u0006\u0003\u0002$\t5\u0001\u0002\u0003B\b\u0005\u000f\u0001\rA!\u0005\u0002\u0007=L7\u000f\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\u0011\u00119\"!\u0013\u0002\u0005%|\u0017\u0002\u0002B\u000e\u0005+\u0011\u0011c\u00142kK\u000e$\u0018J\u001c9viN#(/Z1nQ\u0019\u00119Aa\b\u00036A)1C!\t\u0003&%\u0019!1\u0005\u000b\u0003\rQD'o\\<t!\rI\"q\u0005\u0003\b\u0005S\u0001!\u0019\u0001B\u0016\u0005\u0005!\u0016c\u0001\u0010\u0003.A!!q\u0006B\u0019\u001d\r\u0019\u0012\u0011]\u0005\u0005\u0005g\tIOA\u0005UQJ|w/\u00192mK\u000e\u0012!q\u0007\t\u0005\u0005'\u0011I$\u0003\u0003\u0003<\tU!aC%P\u000bb\u001cW\r\u001d;j_:D\u0011Ba\u0010\u0001\u0001\u0004%\t\u0001B@\u00021\t\fGo\u00195US6,Gk\\*fY\u0016\u001cG/\u001a3GS2,7\u000f\u0003\u0006\u0003D\u0001\u0001\r\u0011\"\u0001\u0005\u0005\u000b\nADY1uG\"$\u0016.\\3U_N+G.Z2uK\u00124\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002$\t\u001d\u0003B\u0003B%\u0005\u0003\n\t\u00111\u0001\u0002\u0002\u0005\u0019\u0001\u0010J\u0019\t\u0011\t5\u0003\u0001)Q\u0005\u0003\u0003\t\u0011DY1uG\"$\u0016.\\3U_N+G.Z2uK\u00124\u0015\u000e\\3tA!\u001a!1\n\u0018\t\u0013\tM\u0003\u00011A\u0005\n\tU\u0013!\u0006:fG\u0016tG\u000f\\=TK2,7\r^3e\r&dWm]\u000b\u0003\u0005/\u0002R!a\u0001\u0003ZMJAAa\u0017\u0002\u0006\t9\u0001*Y:i'\u0016$\b\"\u0003B0\u0001\u0001\u0007I\u0011\u0002B1\u0003e\u0011XmY3oi2L8+\u001a7fGR,GMR5mKN|F%Z9\u0015\t\u0005\r\"1\r\u0005\u000b\u0005\u0013\u0012i&!AA\u0002\t]\u0003\u0002\u0003B4\u0001\u0001\u0006KAa\u0016\u0002-I,7-\u001a8uYf\u001cV\r\\3di\u0016$g)\u001b7fg\u0002B3A!\u001a/\u0011%\u0011i\u0007\u0001a\u0001\n\u0013\u0011y'A\u0007gS2,Gk\\'pIRKW.Z\u000b\u0003\u0005c\u0002rAa\u001d\u0003zM\nI&\u0004\u0002\u0003v)\u0019!q\u000f\u0004\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005w\u0012)H\u0001\nUS6,7\u000b^1na\u0016$\u0007*Y:i\u001b\u0006\u0004\b\"\u0003B@\u0001\u0001\u0007I\u0011\u0002BA\u0003E1\u0017\u000e\\3U_6{G\rV5nK~#S-\u001d\u000b\u0005\u0003G\u0011\u0019\t\u0003\u0006\u0003J\tu\u0014\u0011!a\u0001\u0005cB\u0001Ba\"\u0001A\u0003&!\u0011O\u0001\u000fM&dW\rV8N_\u0012$\u0016.\\3!Q\r\u0011)I\f\u0005\n\u0005\u001b\u0003\u0001\u0019!C\u0005\u0003/\na\u0003\\1ti:+wOR5mK\u001aKg\u000eZ5oORKW.\u001a\u0005\n\u0005#\u0003\u0001\u0019!C\u0005\u0005'\u000b!\u0004\\1ti:+wOR5mK\u001aKg\u000eZ5oORKW.Z0%KF$B!a\t\u0003\u0016\"Q!\u0011\nBH\u0003\u0003\u0005\r!!\u0017\t\u0011\te\u0005\u0001)Q\u0005\u00033\nq\u0003\\1ti:+wOR5mK\u001aKg\u000eZ5oORKW.\u001a\u0011)\u0007\t]e\u0006C\u0005\u0003 \u0002\u0001\r\u0011\"\u0003\u0002x\u0006)\u0001/\u0019;i?\"I!1\u0015\u0001A\u0002\u0013%!QU\u0001\na\u0006$\bnX0%KF$B!a\t\u0003(\"I!\u0011\nBQ\u0003\u0003\u0005\ra\u0010\u0005\b\u0005W\u0003\u0001\u0015)\u0003@\u0003\u0019\u0001\u0018\r\u001e5`A!\u001a!\u0011\u0016\u0018\t\u0013\tE\u0006\u00011A\u0005\n\u0005m\u0018a\u00014t?\"I!Q\u0017\u0001A\u0002\u0013%!qW\u0001\bMN|v\fJ3r)\u0011\t\u0019C!/\t\u0015\t%#1WA\u0001\u0002\u0004\ti\u0010\u0003\u0005\u0003>\u0002\u0001\u000b\u0015BA\u007f\u0003\u001117o\u0018\u0011)\u0007\tmff\u0002\u0005\u0003D\nA\t\u0001\u0002Bc\u0003A1\u0015\u000e\\3J]B,H\u000fR*ue\u0016\fW\u000eE\u0002\u0010\u0005\u000f4q!\u0001\u0002\t\u0002\u0011\u0011Im\u0005\u0004\u0003H\n-'\u0011\u001b\t\u0004'\t5\u0017b\u0001Bh)\t1\u0011I\\=SK\u001a\u00042a\u0005Bj\u0013\r\u0011)\u000e\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\bK\n\u001dG\u0011\u0001Bm)\t\u0011)\r\u0003\u0006\u0003^\n\u001d'\u0019!C\u0005\u0003o\nQ#T%O?J+U*R'C\u000bJ{F)\u0016*B)&{e\nC\u0005\u0003b\n\u001d\u0007\u0015!\u0003\u0002z\u00051R*\u0013(`%\u0016kU)\u0014\"F%~#UKU!U\u0013>s\u0005\u0005\u0003\u0005\u0003f\n\u001dG\u0011\u0001Bt\u00035!WMZ1vYR4\u0015\u000e\u001c;feR\u0019qI!;\t\u000f\u0005\u0005'1\u001da\u0001\u007f!A!Q\u001eBd\t\u0003\u0011y/A\u000fdC2\u001cW\u000f\\1uK:+XNQ1uG\",7\u000fV8SK6,WNY3s)\u0011\tIG!=\t\u0011\tM(1\u001ea\u0001\u0003s\nQBY1uG\"$UO]1uS>t\u0007B\u0003B|\u0005\u000f\f\n\u0011\"\u0001\u0003z\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\u0002Ba?\u0004\u0012\rM1QC\u000b\u0003\u0005{T3\u0001\u0010B\u0000W\t\u0019\t\u0001\u0005\u0003\u0004\u0004\r5QBAB\u0003\u0015\u0011\u00199a!\u0003\u0002\u0013Ut7\r[3dW\u0016$'bAB\u0006)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r=1Q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GAB\u000e\u0003v\n\u0007Q\u0004\u0002\u0004'\u0005k\u0014\r!\b\u0003\b9\nU(\u0019AB\f#\rq2\u0011\u0004\t\u0007?\n\u001cYb!\b\u0011\u0007e\u0019\t\u0002E\u0002\u001a\u0007'A!b!\t\u0003HF\u0005I\u0011AB\u0012\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iUA1QEB\u0015\u0007W\u0019i#\u0006\u0002\u0004()\u001aqIa@\u0005\rm\u0019yB1\u0001\u001e\t\u001913q\u0004b\u0001;\u00119Ala\bC\u0002\r=\u0012c\u0001\u0010\u00042A1qLYB\u001a\u0007k\u00012!GB\u0015!\rI21\u0006\u0005\u000b\u0007s\u00119-!A\u0005\n\rm\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\u0010\u0011\t\u0005\r3qH\u0005\u0005\u0007\u0003\n)E\u0001\u0004PE*,7\r\u001e")
public class FileInputDStream<K, V, F extends InputFormat<K, V>>
extends InputDStream<Tuple2<K, V>> {
    private final String directory;
    private final Function1<Path, Object> filter;
    public final ClassTag<K> org$apache$spark$streaming$dstream$FileInputDStream$$evidence$1;
    public final ClassTag<V> org$apache$spark$streaming$dstream$FileInputDStream$$evidence$2;
    public final ClassTag<F> org$apache$spark$streaming$dstream$FileInputDStream$$evidence$3;
    private final FileInputDStreamCheckpointData checkpointData;
    private final long initialModTimeIgnoreThreshold;
    private final int numBatchesToRemember;
    private final Duration durationToRemember;
    private transient HashMap<Time, String[]> batchTimeToSelectedFiles;
    private transient HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles;
    private transient TimeStampedHashMap<String, Object> org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime;
    private transient long lastNewFileFindingTime;
    private transient Path path_;
    private transient FileSystem fs_;

    public static <K, V, F extends InputFormat<K, V>> boolean $lessinit$greater$default$4() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$4();
    }

    public static <K, V, F extends InputFormat<K, V>> Function1<Path, Object> $lessinit$greater$default$3() {
        return FileInputDStream$.MODULE$.$lessinit$greater$default$3();
    }

    public static int calculateNumBatchesToRemember(Duration duration) {
        return FileInputDStream$.MODULE$.calculateNumBatchesToRemember(duration);
    }

    public static boolean defaultFilter(Path path) {
        return FileInputDStream$.MODULE$.defaultFilter(path);
    }

    public FileInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    private long initialModTimeIgnoreThreshold() {
        return this.initialModTimeIgnoreThreshold;
    }

    private int numBatchesToRemember() {
        return this.numBatchesToRemember;
    }

    private Duration durationToRemember() {
        return this.durationToRemember;
    }

    public HashMap<Time, String[]> batchTimeToSelectedFiles() {
        return this.batchTimeToSelectedFiles;
    }

    public void batchTimeToSelectedFiles_$eq(HashMap<Time, String[]> x$1) {
        this.batchTimeToSelectedFiles = x$1;
    }

    public HashSet<String> org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles;
    }

    public void org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles_$eq(HashSet<String> x$1) {
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles = x$1;
    }

    public TimeStampedHashMap<String, Object> org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime() {
        return this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime;
    }

    public void org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime_$eq(TimeStampedHashMap<String, Object> x$1) {
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime = x$1;
    }

    private long lastNewFileFindingTime() {
        return this.lastNewFileFindingTime;
    }

    private void lastNewFileFindingTime_$eq(long x$1) {
        this.lastNewFileFindingTime = x$1;
    }

    private Path path_() {
        return this.path_;
    }

    private void path__$eq(Path x$1) {
        this.path_ = x$1;
    }

    private FileSystem fs_() {
        return this.fs_;
    }

    private void fs__$eq(FileSystem x$1) {
        this.fs_ = x$1;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Option<RDD<Tuple2<K, V>>> compute(Time validTime) {
        String[] newFiles = this.findNewFiles(validTime.milliseconds());
        this.logInfo((Function0<String>)new Serializable(this, validTime, newFiles){
            public static final long serialVersionUID = 0L;
            private final Time validTime$1;
            private final String[] newFiles$1;

            public final String apply() {
                return new StringBuilder().append((Object)"New files at time ").append((Object)this.validTime$1).append((Object)":\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.newFiles$1).mkString("\n")).toString();
            }
            {
                void var3_3;
                this.validTime$1 = validTime$1;
                this.newFiles$1 = var3_3;
            }
        });
        this.batchTimeToSelectedFiles().$plus$eq(new Tuple2((Object)validTime, (Object)newFiles));
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])newFiles));
        return new Some(this.org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])newFiles)));
    }

    @Override
    public void clearMetadata(Time time) {
        super.clearMetadata(time);
        HashMap oldFiles = (HashMap)this.batchTimeToSelectedFiles().filter((Function1)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Time time$1;

            public final boolean apply(Tuple2<Time, String[]> x$1) {
                return ((Time)x$1._1()).$less(this.time$1.$minus(this.$outer.rememberDuration()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.time$1 = time$1;
            }
        });
        this.batchTimeToSelectedFiles().$minus$minus$eq((TraversableOnce)oldFiles.keys());
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$minus$minus$eq((TraversableOnce)oldFiles.values().flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] xs) {
                return Predef$.MODULE$.refArrayOps((Object[])xs);
            }
        }));
        this.logInfo((Function0<String>)new Serializable(this, time, oldFiles){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Time time$1;
            private final HashMap oldFiles$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Cleared ").append((Object)BoxesRunTime.boxToInteger((int)this.oldFiles$1.size())).append((Object)" old files that were older than ").append((Object)this.time$1.$minus(this.$outer.rememberDuration())).append((Object)": ").append((Object)this.oldFiles$1.keys().mkString(", ")).toString();
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.time$1 = time$1;
                this.oldFiles$1 = var3_3;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, oldFiles){
            public static final long serialVersionUID = 0L;
            private final HashMap oldFiles$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Cleared files are:\n").append((Object)((TraversableOnce)this.oldFiles$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Time, String> apply(Tuple2<Time, String[]> p) {
                        return new Tuple2(p._1(), (Object)Predef$.MODULE$.refArrayOps((Object[])p._2()).mkString(", "));
                    }
                }, HashMap$.MODULE$.canBuildFrom())).mkString("\n")).toString();
            }
            {
                this.oldFiles$1 = oldFiles$1;
            }
        });
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime().clearOldValues(this.lastNewFileFindingTime() - 1L);
    }

    private String[] findNewFiles(long currentTime) {
        String[] stringArray;
        try {
            this.lastNewFileFindingTime_$eq(System.currentTimeMillis());
            long modTimeIgnoreThreshold = package$.MODULE$.max(this.initialModTimeIgnoreThreshold(), currentTime - this.durationToRemember().milliseconds());
            this.logDebug((Function0<String>)new Serializable(this, currentTime, modTimeIgnoreThreshold){
                public static final long serialVersionUID = 0L;
                private final long currentTime$1;
                private final long modTimeIgnoreThreshold$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Getting new files for time ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.currentTime$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ignoring files older than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.modTimeIgnoreThreshold$1)}))).toString();
                }
                {
                    this.currentTime$1 = currentTime$1;
                    this.modTimeIgnoreThreshold$1 = modTimeIgnoreThreshold$1;
                }
            });
            PathFilter filter2 = new PathFilter(this, currentTime, modTimeIgnoreThreshold){
                private final /* synthetic */ FileInputDStream $outer;
                private final long currentTime$1;
                private final long modTimeIgnoreThreshold$1;

                public boolean accept(Path path) {
                    return this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$isNewFile(path, this.currentTime$1, this.modTimeIgnoreThreshold$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.currentTime$1 = currentTime$1;
                    this.modTimeIgnoreThreshold$1 = modTimeIgnoreThreshold$1;
                }
            };
            String[] newFiles = (String[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$dstream$FileInputDStream$$fs().listStatus(this.directoryPath(), filter2)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$2) {
                    return x$2.getPath().toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            long timeTaken = System.currentTimeMillis() - this.lastNewFileFindingTime();
            this.logInfo((Function0<String>)new Serializable(this, timeTaken){
                public static final long serialVersionUID = 0L;
                private final long timeTaken$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Finding new files took ").append((Object)BoxesRunTime.boxToLong((long)this.timeTaken$1)).append((Object)" ms").toString();
                }
                {
                    this.timeTaken$1 = timeTaken$1;
                }
            });
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileInputDStream $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"# cached file times = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime().size())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (timeTaken > this.slideDuration().milliseconds()) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Time taken to find new files exceeds the batch size. Consider increasing the batch size or reducing the number of files in the monitored directory.";
                    }
                });
            }
            stringArray = newFiles;
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error finding new files";
                }
            }, exception);
            this.reset();
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public boolean org$apache$spark$streaming$dstream$FileInputDStream$$isNewFile(Path path, long currentTime, long modTimeIgnoreThreshold) {
        String pathStr = path.toString();
        if (BoxesRunTime.unboxToBoolean((Object)this.filter.apply((Object)path))) {
            long modTime = this.getFileModTime(path);
            if (modTime <= modTimeIgnoreThreshold) {
                this.logDebug((Function0<String>)new Serializable(this, modTimeIgnoreThreshold, pathStr, modTime){
                    public static final long serialVersionUID = 0L;
                    private final long modTimeIgnoreThreshold$2;
                    private final String pathStr$1;
                    private final long modTime$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ignored as mod time ", " <= ignore time ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1, BoxesRunTime.boxToLong((long)this.modTime$1), BoxesRunTime.boxToLong((long)this.modTimeIgnoreThreshold$2)}));
                    }
                    {
                        void var4_3;
                        this.modTimeIgnoreThreshold$2 = modTimeIgnoreThreshold$2;
                        this.pathStr$1 = var4_3;
                        this.modTime$1 = modTime$1;
                    }
                });
                return false;
            }
            if (modTime > currentTime) {
                this.logDebug((Function0<String>)new Serializable(this, currentTime, pathStr, modTime){
                    public static final long serialVersionUID = 0L;
                    private final long currentTime$2;
                    private final String pathStr$1;
                    private final long modTime$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not selected as mod time ", " > current time ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1, BoxesRunTime.boxToLong((long)this.modTime$1), BoxesRunTime.boxToLong((long)this.currentTime$2)}));
                    }
                    {
                        void var4_3;
                        this.currentTime$2 = currentTime$2;
                        this.pathStr$1 = var4_3;
                        this.modTime$1 = modTime$1;
                    }
                });
                return false;
            }
            if (this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().contains((Object)pathStr)) {
                this.logDebug((Function0<String>)new Serializable(this, pathStr){
                    public static final long serialVersionUID = 0L;
                    private final String pathStr$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " already considered"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1}));
                    }
                    {
                        this.pathStr$1 = pathStr$1;
                    }
                });
                return false;
            }
            this.logDebug((Function0<String>)new Serializable(this, pathStr, modTime){
                public static final long serialVersionUID = 0L;
                private final String pathStr$1;
                private final long modTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " accepted with mod time ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1, BoxesRunTime.boxToLong((long)this.modTime$1)}));
                }
                {
                    this.pathStr$1 = pathStr$1;
                    this.modTime$1 = modTime$1;
                }
            });
            return true;
        }
        this.logDebug((Function0<String>)new Serializable(this, pathStr){
            public static final long serialVersionUID = 0L;
            private final String pathStr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " rejected by filter"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathStr$1}));
            }
            {
                this.pathStr$1 = pathStr$1;
            }
        });
        return false;
    }

    public RDD<Tuple2<K, V>> org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD(Seq<String> files) {
        Seq fileRDDs = (Seq)files.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;

            /*
             * WARNING - void declaration
             */
            public final RDD<Tuple2<K, V>> apply(String file) {
                void var2_2;
                RDD rdd = this.$outer.context().sparkContext().newAPIHadoopFile(file, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$1, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$2, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$3);
                if (Predef$.MODULE$.refArrayOps((Object[])rdd.partitions()).size() == 0) {
                    this.$outer.logError((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final String file$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"File ").append((Object)this.file$1).append((Object)" has no data in it. Spark Streaming can only ingest ").append((Object)"files that have been \"moved\" to the directory assigned to the file stream. ").append((Object)"Refer to the streaming programming guide for more details.").toString();
                        }
                        {
                            this.file$1 = file$1;
                        }
                    });
                }
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new UnionRDD(this.context().sparkContext(), fileRDDs, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private long getFileModTime(Path path) {
        return BoxesRunTime.unboxToLong((Object)this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime().getOrElseUpdate((Object)path.toString(), (Function0)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final Path path$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fs().getFileStatus(this.path$1).getModificationTime();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$1 = path$1;
            }
        }));
    }

    private Path directoryPath() {
        if (this.path_() == null) {
            this.path__$eq(new Path(this.directory));
        }
        return this.path_();
    }

    public FileSystem org$apache$spark$streaming$dstream$FileInputDStream$$fs() {
        if (this.fs_() == null) {
            this.fs__$eq(this.directoryPath().getFileSystem(this.ssc().sparkContext().hadoopConfiguration()));
        }
        return this.fs_();
    }

    private void reset() {
        this.fs__$eq(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)new Serializable(this, ois){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileInputDStream $outer;
            private final ObjectInputStream ois$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$readObject$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$anonfun$$$outer().getClass().getSimpleName()).append((Object)".readObject used").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.ois$1.defaultReadObject();
                this.$outer.generatedRDDs_$eq(new HashMap());
                this.$outer.batchTimeToSelectedFiles_$eq((HashMap<Time, String[]>)new HashMap());
                this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles_$eq((HashSet<String>)new HashSet());
                this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime_$eq((TimeStampedHashMap<String, Object>)new TimeStampedHashMap(true));
            }

            public /* synthetic */ FileInputDStream org$apache$spark$streaming$dstream$FileInputDStream$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.ois$1 = ois$1;
            }
        });
    }

    public FileInputDStream(StreamingContext ssc_, String directory, Function1<Path, Object> filter2, boolean newFilesOnly, ClassTag<K> evidence$1, ClassTag<V> evidence$2, ClassTag<F> evidence$3) {
        this.directory = directory;
        this.filter = filter2;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$1 = evidence$1;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$2 = evidence$2;
        this.org$apache$spark$streaming$dstream$FileInputDStream$$evidence$3 = evidence$3;
        super(ssc_, ClassTag$.MODULE$.apply(Tuple2.class));
        this.checkpointData = new FileInputDStreamCheckpointData();
        this.initialModTimeIgnoreThreshold = newFilesOnly ? System.currentTimeMillis() : 0L;
        this.numBatchesToRemember = FileInputDStream$.MODULE$.calculateNumBatchesToRemember(this.slideDuration());
        this.durationToRemember = this.slideDuration().$times(this.numBatchesToRemember());
        this.remember(this.durationToRemember());
        this.batchTimeToSelectedFiles = new HashMap();
        this.org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles = new HashSet();
        this.org$apache$spark$streaming$dstream$FileInputDStream$$fileToModTime = new TimeStampedHashMap(true);
        this.lastNewFileFindingTime = 0L;
        this.path_ = null;
        this.fs_ = null;
    }

    public class FileInputDStreamCheckpointData
    extends DStreamCheckpointData<Tuple2<K, V>> {
        public HashMap<Time, String[]> hadoopFiles() {
            return this.data();
        }

        @Override
        public void update(Time time) {
            this.hadoopFiles().clear();
            this.hadoopFiles().$plus$plus$eq(this.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles());
        }

        @Override
        public void cleanup(Time time) {
        }

        @Override
        public void restore() {
            ((IterableLike)this.hadoopFiles().toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Time apply(Tuple2<Time, String[]> x$3) {
                    return (Time)x$3._1();
                }
            }, Time$.MODULE$.ordering())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileInputDStreamCheckpointData $outer;

                public final HashMap<Time, RDD<Tuple2<K, V>>> apply(Tuple2<Time, String[]> x0$1) {
                    Tuple2<Time, String[]> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Time t = (Time)tuple2._1();
                        String[] f = (String[])tuple2._2();
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final Time t$1;
                            private final String[] f$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Restoring files for time ").append((Object)this.t$1).append((Object)" - ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.f$1).mkString("[", ", ", "]")).toString();
                            }
                            {
                                this.t$1 = t$1;
                                this.f$1 = f$1;
                            }
                        });
                        this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().batchTimeToSelectedFiles().$plus$eq(new Tuple2((Object)t, (Object)f));
                        this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$recentlySelectedFiles().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])f));
                        HashMap hashMap = this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(new Tuple2((Object)t, this.$outer.org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer().org$apache$spark$streaming$dstream$FileInputDStream$$filesToRDD((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])f))));
                        return hashMap;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        @Override
        public String toString() {
            return new StringBuilder().append((Object)"[\n").append((Object)BoxesRunTime.boxToInteger((int)this.hadoopFiles().size())).append((Object)" file sets\n").append((Object)((TraversableOnce)this.hadoopFiles().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Time, String> apply(Tuple2<Time, String[]> p) {
                    return new Tuple2(p._1(), (Object)Predef$.MODULE$.refArrayOps((Object[])p._2()).mkString(", "));
                }
            }, HashMap$.MODULE$.canBuildFrom())).mkString("\n")).append((Object)"\n]").toString();
        }

        public /* synthetic */ FileInputDStream org$apache$spark$streaming$dstream$FileInputDStream$FileInputDStreamCheckpointData$$$outer() {
            return FileInputDStream.this;
        }

        public FileInputDStreamCheckpointData() {
            if (FileInputDStream.this == null) {
                throw new NullPointerException();
            }
            super(FileInputDStream.this, ClassTag$.MODULE$.apply(Tuple2.class));
        }
    }
}

