/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import org.apache.spark.Partitioner;
import org.apache.spark.rdd.PartitionerAwareUnionRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.UnionRDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Interval;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4Q!\u0001\u0002\u0001\t1\u0011qbV5oI><X\r\u001a#TiJ,\u0017-\u001c\u0006\u0003\u0007\u0011\tq\u0001Z:ue\u0016\fWN\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0011Q\u0002F\n\u0003\u00019\u00012a\u0004\t\u0013\u001b\u0005\u0011\u0011BA\t\u0003\u0005\u001d!5\u000b\u001e:fC6\u0004\"a\u0005\u000b\r\u0001\u0011)Q\u0003\u0001b\u0001/\t\tAk\u0001\u0001\u0012\u0005aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"a\u0002(pi\"Lgn\u001a\t\u00033}I!\u0001\t\u000e\u0003\u0007\u0005s\u0017\u0010\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u000f\u0003\u0019\u0001\u0018M]3oi\"AA\u0005\u0001B\u0001B\u0003%Q%A\b`o&tGm\\<EkJ\fG/[8o!\t1s%D\u0001\u0005\u0013\tACA\u0001\u0005EkJ\fG/[8o\u0011!Q\u0003A!A!\u0002\u0013)\u0013AD0tY&$W\rR;sCRLwN\u001c\u0005\tY\u0001\u0011\u0019\u0011)A\u0006[\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u00079\n$#D\u00010\u0015\t\u0001$$A\u0004sK\u001adWm\u0019;\n\u0005Iz#\u0001C\"mCN\u001cH+Y4\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111\u0014HO\u001e\u0015\u0005]B\u0004cA\b\u0001%!)Af\ra\u0002[!)!e\ra\u0001\u001d!)Ae\ra\u0001K!)!f\ra\u0001K!)Q\b\u0001C\u0001}\u0005qq/\u001b8e_^$UO]1uS>tW#A\u0013\t\u000b\u0001\u0003A\u0011I!\u0002\u0019\u0011,\u0007/\u001a8eK:\u001c\u0017.Z:\u0016\u0003\t\u00032a\u0011%\u000f\u001b\u0005!%BA#G\u0003%IW.\\;uC\ndWM\u0003\u0002H5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005%#%\u0001\u0002'jgRDQa\u0013\u0001\u0005By\nQb\u001d7jI\u0016$UO]1uS>t\u0007\"B'\u0001\t\u0003r\u0014A\u00069be\u0016tGOU3nK6\u0014WM\u001d#ve\u0006$\u0018n\u001c8\t\u000b=\u0003A\u0011\t)\u0002\u000fA,'o]5tiR\u0011a\"\u0015\u0005\u0006%:\u0003\raU\u0001\u0006Y\u00164X\r\u001c\t\u0003)^k\u0011!\u0016\u0006\u0003-\u001a\tqa\u001d;pe\u0006<W-\u0003\u0002Y+\na1\u000b^8sC\u001e,G*\u001a<fY\")!\f\u0001C!7\u000691m\\7qkR,GC\u0001/f!\rIRlX\u0005\u0003=j\u0011aa\u00149uS>t\u0007c\u00011d%5\t\u0011M\u0003\u0002c\r\u0005\u0019!\u000f\u001a3\n\u0005\u0011\f'a\u0001*E\t\")a-\u0017a\u0001O\u0006Ia/\u00197jIRKW.\u001a\t\u0003M!L!!\u001b\u0003\u0003\tQKW.\u001a")
public class WindowedDStream<T>
extends DStream<T> {
    private final DStream<T> parent;
    private final Duration _windowDuration;
    private final Duration _slideDuration;
    private final ClassTag<T> evidence$1;

    public Duration windowDuration() {
        return this._windowDuration;
    }

    @Override
    public List<DStream<T>> dependencies() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DStream[]{this.parent}));
    }

    @Override
    public Duration slideDuration() {
        return this._slideDuration;
    }

    @Override
    public Duration parentRememberDuration() {
        return this.rememberDuration().$plus(this.windowDuration());
    }

    @Override
    public DStream<T> persist(StorageLevel level) {
        this.parent.persist(level);
        return this;
    }

    @Override
    public Option<RDD<T>> compute(Time validTime) {
        PartitionerAwareUnionRDD partitionerAwareUnionRDD;
        Interval currentWindow = new Interval(validTime.$minus(this.windowDuration()).$plus(this.parent.slideDuration()), validTime);
        Seq<RDD<T>> rddsInWindow = this.parent.slice(currentWindow);
        if (((SeqLike)((SeqLike)rddsInWindow.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Partitioner> apply(RDD<T> x$1) {
                return Option$.MODULE$.option2Iterable(x$1.partitioner());
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct()).length() == 1) {
            this.logDebug((Function0<String>)new Serializable(this, validTime){
                public static final long serialVersionUID = 0L;
                private final Time validTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using partition aware union for windowing at ").append((Object)this.validTime$1).toString();
                }
                {
                    this.validTime$1 = validTime$1;
                }
            });
            partitionerAwareUnionRDD = new PartitionerAwareUnionRDD(this.ssc().sc(), rddsInWindow, this.evidence$1);
        } else {
            this.logDebug((Function0<String>)new Serializable(this, validTime){
                public static final long serialVersionUID = 0L;
                private final Time validTime$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using normal union for windowing at ").append((Object)this.validTime$1).toString();
                }
                {
                    this.validTime$1 = validTime$1;
                }
            });
            partitionerAwareUnionRDD = new UnionRDD(this.ssc().sc(), rddsInWindow, this.evidence$1);
        }
        PartitionerAwareUnionRDD windowRDD = partitionerAwareUnionRDD;
        return new Some((Object)windowRDD);
    }

    public WindowedDStream(DStream<T> parent, Duration _windowDuration, Duration _slideDuration, ClassTag<T> evidence$1) {
        this.parent = parent;
        this._windowDuration = _windowDuration;
        this._slideDuration = _slideDuration;
        this.evidence$1 = evidence$1;
        super(parent.ssc(), evidence$1);
        if (_windowDuration.isMultipleOf(parent.slideDuration())) {
            if (_slideDuration.isMultipleOf(parent.slideDuration())) {
                parent.persist(StorageLevel$.MODULE$.MEMORY_ONLY_SER());
                return;
            }
            throw new Exception(new StringBuilder().append((Object)"The slide duration of windowed DStream (").append((Object)_slideDuration).append((Object)") ").append((Object)"must be a multiple of the slide duration of parent DStream (").append((Object)parent.slideDuration()).append((Object)")").toString());
        }
        throw new Exception(new StringBuilder().append((Object)"The window duration of windowed DStream (").append((Object)_windowDuration).append((Object)") ").append((Object)"must be a multiple of the slide duration of parent DStream (").append((Object)parent.slideDuration()).append((Object)")").toString());
    }
}

