/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.CheckpointWriter;
import org.apache.spark.streaming.DStreamGraph;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.scheduler.ClearCheckpointData;
import org.apache.spark.streaming.scheduler.ClearMetadata;
import org.apache.spark.streaming.scheduler.DoCheckpoint;
import org.apache.spark.streaming.scheduler.GenerateJobs;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobGenerator$;
import org.apache.spark.streaming.scheduler.JobGenerator$$anonfun$start$1$;
import org.apache.spark.streaming.scheduler.JobGeneratorEvent;
import org.apache.spark.streaming.scheduler.JobScheduler;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobSet$;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.util.Clock;
import org.apache.spark.streaming.util.ManualClock;
import org.apache.spark.streaming.util.RecurringTimer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd!B\u0001\u0003\u0001\u0011a!\u0001\u0004&pE\u001e+g.\u001a:bi>\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!\u0011!Q\u0001\ni\tAB[8c'\u000eDW\rZ;mKJ\u001c\u0001\u0001\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\ta!j\u001c2TG\",G-\u001e7fe\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"\"!\t\u0012\u0011\u0005m\u0001\u0001\"\u0002\r\u001f\u0001\u0004Q\u0002b\u0002\u0013\u0001\u0005\u0004%I!J\u0001\u0004gN\u001cW#\u0001\u0014\u0011\u0005\u001dBS\"\u0001\u0003\n\u0005%\"!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011\u0019Y\u0003\u0001)A\u0005M\u0005!1o]2!\u0011\u001di\u0003A1A\u0005\n9\nAaY8oMV\tq\u0006\u0005\u0002\u0015a%\u0011\u0011G\u0002\u0002\n'B\f'o[\"p]\u001aDaa\r\u0001!\u0002\u0013y\u0013!B2p]\u001a\u0004\u0003bB\u001b\u0001\u0005\u0004%IAN\u0001\u0006OJ\f\u0007\u000f[\u000b\u0002oA\u0011q\u0005O\u0005\u0003s\u0011\u0011A\u0002R*ue\u0016\fWn\u0012:ba\"Daa\u000f\u0001!\u0002\u00139\u0014AB4sCBD\u0007\u0005C\u0004>\u0001\t\u0007I\u0011\u0001 \u0002\u000b\rdwnY6\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003\t\u0006\u0013Qa\u00117pG.DaA\u0012\u0001!\u0002\u0013y\u0014AB2m_\u000e\\\u0007\u0005C\u0004I\u0001\t\u0007I\u0011B%\u0002\u000bQLW.\u001a:\u0016\u0003)\u0003\"\u0001Q&\n\u00051\u000b%A\u0004*fGV\u0014(/\u001b8h)&lWM\u001d\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002&\u0002\rQLW.\u001a:!\u0011!\u0001\u0006\u0001#b\u0001\n\u0013\t\u0016\u0001E:i_VdGm\u00115fG.\u0004x.\u001b8u+\u0005\u0011\u0006C\u0001\bT\u0013\t!vBA\u0004C_>dW-\u00198\t\u0011Y\u0003\u0001\u0012!Q!\nI\u000b\u0011c\u001d5pk2$7\t[3dWB|\u0017N\u001c;!\u0011!A\u0006\u0001#b\u0001\n\u0013I\u0016\u0001E2iK\u000e\\\u0007o\\5oi^\u0013\u0018\u000e^3s+\u0005Q\u0006CA\u0014\\\u0013\taFA\u0001\tDQ\u0016\u001c7\u000e]8j]R<&/\u001b;fe\"Aa\f\u0001E\u0001B\u0003&!,A\tdQ\u0016\u001c7\u000e]8j]R<&/\u001b;fe\u0002Bq\u0001\u0019\u0001A\u0002\u0013%\u0011-\u0001\u0006fm\u0016tG/Q2u_J,\u0012A\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\fQ!Y2u_JT\u0011aZ\u0001\u0005C.\\\u0017-\u0003\u0002jI\nA\u0011i\u0019;peJ+g\rC\u0004l\u0001\u0001\u0007I\u0011\u00027\u0002\u001d\u00154XM\u001c;BGR|'o\u0018\u0013fcR\u0011Q\u000e\u001d\t\u0003\u001d9L!a\\\b\u0003\tUs\u0017\u000e\u001e\u0005\bc*\f\t\u00111\u0001c\u0003\rAH%\r\u0005\u0007g\u0002\u0001\u000b\u0015\u00022\u0002\u0017\u00154XM\u001c;BGR|'\u000f\t\u0005\bk\u0002\u0001\r\u0011\"\u0003w\u0003Ia\u0017m\u001d;Qe>\u001cWm]:fI\n\u000bGo\u00195\u0016\u0003]\u0004\"a\n=\n\u0005e$!\u0001\u0002+j[\u0016Dqa\u001f\u0001A\u0002\u0013%A0\u0001\fmCN$\bK]8dKN\u001cX\r\u001a\"bi\u000eDw\fJ3r)\tiW\u0010C\u0004ru\u0006\u0005\t\u0019A<\t\r}\u0004\u0001\u0015)\u0003x\u0003Ma\u0017m\u001d;Qe>\u001cWm]:fI\n\u000bGo\u00195!\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\tQa\u001d;beR$\u0012!\u001c\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003\u0011\u0019Ho\u001c9\u0015\u00075\fi\u0001C\u0004\u0002\u0010\u0005\u001d\u0001\u0019\u0001*\u0002'A\u0014xnY3tgJ+7-Z5wK\u0012$\u0015\r^1\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005\trN\u001c\"bi\u000eD7i\\7qY\u0016$\u0018n\u001c8\u0015\u00075\f9\u0002C\u0004\u0002\u001a\u0005E\u0001\u0019A<\u0002\tQLW.\u001a\u0005\b\u0003;\u0001A\u0011AA\u0010\u0003Yygn\u00115fG.\u0004x.\u001b8u\u0007>l\u0007\u000f\\3uS>tGcA7\u0002\"!9\u0011\u0011DA\u000e\u0001\u00049\bbBA\u0013\u0001\u0011%\u0011qE\u0001\raJ|7-Z:t\u000bZ,g\u000e\u001e\u000b\u0004[\u0006%\u0002\u0002CA\u0016\u0003G\u0001\r!!\f\u0002\u000b\u00154XM\u001c;\u0011\u0007m\ty#C\u0002\u00022\t\u0011\u0011CS8c\u000f\u0016tWM]1u_J,e/\u001a8u\u0011\u001d\t)\u0004\u0001C\u0005\u0003\u000b\tab\u001d;beR4\u0015N]:u)&lW\rC\u0004\u0002:\u0001!I!!\u0002\u0002\u000fI,7\u000f^1si\"9\u0011Q\b\u0001\u0005\n\u0005}\u0012\u0001D4f]\u0016\u0014\u0018\r^3K_\n\u001cHcA7\u0002B!9\u0011\u0011DA\u001e\u0001\u00049\bbBA#\u0001\u0011%\u0011qI\u0001\u000eG2,\u0017M]'fi\u0006$\u0017\r^1\u0015\u00075\fI\u0005C\u0004\u0002\u001a\u0005\r\u0003\u0019A<\t\u000f\u00055\u0003\u0001\"\u0003\u0002P\u0005\u00192\r\\3be\u000eCWmY6q_&tG\u000fR1uCR\u0019Q.!\u0015\t\u000f\u0005e\u00111\na\u0001o\"9\u0011Q\u000b\u0001\u0005\n\u0005]\u0013\u0001\u00043p\u0007\",7m\u001b9pS:$HcA7\u0002Z!9\u0011\u0011DA*\u0001\u00049\bbBA/\u0001\u0011%\u0011qL\u0001\u0018[\u0006\u00148NQ1uG\"4U\u000f\u001c7z!J|7-Z:tK\u0012$2!\\A1\u0011\u001d\tI\"a\u0017A\u0002]\u0004")
public class JobGenerator
implements Logging {
    public final JobScheduler org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler;
    private final StreamingContext ssc;
    private final SparkConf conf;
    private final DStreamGraph org$apache$spark$streaming$scheduler$JobGenerator$$graph;
    private final Clock clock;
    private final RecurringTimer timer;
    private boolean shouldCheckpoint;
    private CheckpointWriter checkpointWriter;
    private ActorRef org$apache$spark$streaming$scheduler$JobGenerator$$eventActor;
    private Time lastProcessedBatch;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    private boolean shouldCheckpoint$lzycompute() {
        JobGenerator jobGenerator = this;
        synchronized (jobGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldCheckpoint = this.ssc().checkpointDuration() != null && this.ssc().checkpointDir() != null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.shouldCheckpoint;
        }
    }

    private CheckpointWriter checkpointWriter$lzycompute() {
        JobGenerator jobGenerator = this;
        synchronized (jobGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.checkpointWriter = this.shouldCheckpoint() ? new CheckpointWriter(this, this.ssc().conf(), this.ssc().checkpointDir(), this.ssc().sparkContext().hadoopConfiguration()) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.checkpointWriter;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private StreamingContext ssc() {
        return this.ssc;
    }

    private SparkConf conf() {
        return this.conf;
    }

    public DStreamGraph org$apache$spark$streaming$scheduler$JobGenerator$$graph() {
        return this.org$apache$spark$streaming$scheduler$JobGenerator$$graph;
    }

    public Clock clock() {
        return this.clock;
    }

    private RecurringTimer timer() {
        return this.timer;
    }

    private boolean shouldCheckpoint() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldCheckpoint$lzycompute() : this.shouldCheckpoint;
    }

    private CheckpointWriter checkpointWriter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.checkpointWriter$lzycompute() : this.checkpointWriter;
    }

    public ActorRef org$apache$spark$streaming$scheduler$JobGenerator$$eventActor() {
        return this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor;
    }

    private void org$apache$spark$streaming$scheduler$JobGenerator$$eventActor_$eq(ActorRef x$1) {
        this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor = x$1;
    }

    private Time lastProcessedBatch() {
        return this.lastProcessedBatch;
    }

    private void lastProcessedBatch_$eq(Time x$1) {
        this.lastProcessedBatch = x$1;
    }

    public synchronized void start() {
        if (this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor() == null) {
            this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor_$eq(this.ssc().env().actorSystem().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobGenerator $outer;

                public final $anonfun$start$1$$anon$1 apply() {
                    return new Actor(this){
                        private final /* synthetic */ $anonfun$start$1 $outer;
                        private final ActorContext context;
                        private final ActorRef self;

                        public ActorContext context() {
                            return this.context;
                        }

                        public final ActorRef self() {
                            return this.self;
                        }

                        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
                            this.context = x$1;
                        }

                        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
                            this.self = x$1;
                        }

                        public final ActorRef sender() {
                            return Actor.class.sender((Actor)this);
                        }

                        public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
                            Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
                        }

                        public void aroundPreStart() {
                            Actor.class.aroundPreStart((Actor)this);
                        }

                        public void aroundPostStop() {
                            Actor.class.aroundPostStop((Actor)this);
                        }

                        public void aroundPreRestart(Throwable reason, Option<Object> message) {
                            Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
                        }

                        public void aroundPostRestart(Throwable reason) {
                            Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
                        }

                        public SupervisorStrategy supervisorStrategy() {
                            return Actor.class.supervisorStrategy((Actor)this);
                        }

                        public void preStart() throws Exception {
                            Actor.class.preStart((Actor)this);
                        }

                        public void postStop() throws Exception {
                            Actor.class.postStop((Actor)this);
                        }

                        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
                            Actor.class.preRestart((Actor)this, (Throwable)reason, message);
                        }

                        public void postRestart(Throwable reason) throws Exception {
                            Actor.class.postRestart((Actor)this, (Throwable)reason);
                        }

                        public void unhandled(Object message) {
                            Actor.class.unhandled((Actor)this, (Object)message);
                        }

                        public PartialFunction<Object, BoxedUnit> receive() {
                            return new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$start$1$$anon$1 $outer;

                                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    Object object;
                                    A1 A1 = x1;
                                    if (A1 instanceof JobGeneratorEvent) {
                                        JobGeneratorEvent jobGeneratorEvent = (JobGeneratorEvent)A1;
                                        this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$anon$$$outer().org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$$outer().org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(jobGeneratorEvent);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x1);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Object x1) {
                                    Object object = x1;
                                    boolean bl = object instanceof JobGeneratorEvent;
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            };
                        }

                        public /* synthetic */ $anonfun$start$1 org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$anon$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            Actor.class.$init$((Actor)this);
                        }
                    };
                }

                public /* synthetic */ JobGenerator org$apache$spark$streaming$scheduler$JobGenerator$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, ClassTag$.MODULE$.apply(Actor.class)), "JobGenerator"));
            if (this.ssc().isCheckpointPresent()) {
                this.restart();
            } else {
                this.startFirstTime();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void stop(boolean processReceivedData) {
        block6: {
            if (this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor() == null) {
                return;
            }
            if (processReceivedData) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Stopping JobGenerator gracefully";
                    }
                });
                long timeWhenStopStarted = System.currentTimeMillis();
                long stopTimeout = this.conf().getLong("spark.streaming.gracefulStopTimeout", 10L * this.ssc().graph().batchDuration().milliseconds());
                int pollTime = 100;
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Waiting for all received blocks to be consumed for job generation";
                    }
                });
                while (!this.hasTimedOut$1(timeWhenStopStarted, stopTimeout) && this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().hasUnallocatedBlocks()) {
                    Thread.sleep(pollTime);
                }
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Waited for all received blocks to be consumed for job generation";
                    }
                });
                long stopTime = this.timer().stop(false);
                this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().stop();
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Stopped generation timer";
                    }
                });
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Waiting for jobs to be processed and checkpoints to be written";
                    }
                });
                while (true) {
                    void var6_4;
                    if (this.hasTimedOut$1(timeWhenStopStarted, stopTimeout) || this.haveAllBatchesBeenProcessed$1(stopTime)) {
                        this.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Waited for jobs to be processed and checkpoints to be written";
                            }
                        });
                        break block6;
                    }
                    Thread.sleep((long)var6_4);
                }
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopping JobGenerator immediately";
                }
            });
            this.timer().stop(true);
            this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().stop();
        }
        if (this.shouldCheckpoint()) {
            this.checkpointWriter().stop();
        }
        this.ssc().env().actorSystem().stop(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped JobGenerator";
            }
        });
    }

    public void onBatchCompletion(Time time) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
        ClearMetadata x$4 = new ClearMetadata(time);
        ActorRef x$5 = qual$2.$bang$default$2((Object)x$4);
        qual$2.$bang((Object)x$4, x$5);
    }

    public void onCheckpointCompletion(Time time) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
        ClearCheckpointData x$6 = new ClearCheckpointData(time);
        ActorRef x$7 = qual$3.$bang$default$2((Object)x$6);
        qual$3.$bang((Object)x$6, x$7);
    }

    public void org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(JobGeneratorEvent event) {
        JobGeneratorEvent jobGeneratorEvent;
        block6: {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            this.logDebug((Function0<String>)new Serializable(this, event){
                                public static final long serialVersionUID = 0L;
                                private final JobGeneratorEvent event$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Got event ").append((Object)this.event$1).toString();
                                }
                                {
                                    this.event$1 = event$1;
                                }
                            });
                            jobGeneratorEvent = event;
                            if (!(jobGeneratorEvent instanceof GenerateJobs)) break block2;
                            GenerateJobs generateJobs2 = (GenerateJobs)jobGeneratorEvent;
                            Time time = generateJobs2.time();
                            this.generateJobs(time);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(jobGeneratorEvent instanceof ClearMetadata)) break block4;
                        ClearMetadata clearMetadata2 = (ClearMetadata)jobGeneratorEvent;
                        Time time = clearMetadata2.time();
                        this.clearMetadata(time);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(jobGeneratorEvent instanceof DoCheckpoint)) break block5;
                    DoCheckpoint doCheckpoint2 = (DoCheckpoint)jobGeneratorEvent;
                    Time time = doCheckpoint2.time();
                    this.doCheckpoint(time);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(jobGeneratorEvent instanceof ClearCheckpointData)) break block6;
                ClearCheckpointData clearCheckpointData2 = (ClearCheckpointData)jobGeneratorEvent;
                Time time = clearCheckpointData2.time();
                this.clearCheckpointData(time);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)jobGeneratorEvent);
    }

    private void startFirstTime() {
        Time startTime = new Time(this.timer().getStartTime());
        this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().start(startTime.$minus(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().batchDuration()));
        this.timer().start(startTime.milliseconds());
        this.logInfo((Function0<String>)new Serializable(this, startTime){
            public static final long serialVersionUID = 0L;
            private final Time startTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Started JobGenerator at ").append((Object)this.startTime$1).toString();
            }
            {
                this.startTime$1 = startTime$1;
            }
        });
    }

    private void restart() {
        if (this.clock() instanceof ManualClock) {
            long lastTime = this.ssc().initialCheckpoint().checkpointTime().milliseconds();
            long jumpTime = this.ssc().sc().conf().getLong("spark.streaming.manualClock.jump", 0L);
            ((ManualClock)this.clock()).setTime(lastTime + jumpTime);
        }
        Duration batchDuration = this.ssc().graph().batchDuration();
        Time checkpointTime = this.ssc().initialCheckpoint().checkpointTime();
        Time restartTime = new Time(this.timer().getRestartTime(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().zeroTime().milliseconds()));
        Seq<Time> downTimes = checkpointTime.until(restartTime, batchDuration);
        this.logInfo((Function0<String>)new Serializable(this, downTimes){
            public static final long serialVersionUID = 0L;
            private final Seq downTimes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Batches during down time (").append((Object)BoxesRunTime.boxToInteger((int)this.downTimes$1.size())).append((Object)" batches): ").append((Object)this.downTimes$1.mkString(", ")).toString();
            }
            {
                this.downTimes$1 = downTimes$1;
            }
        });
        Time[] pendingTimes = (Time[])Predef$.MODULE$.refArrayOps((Object[])this.ssc().initialCheckpoint().pendingTimes()).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)new Serializable(this, pendingTimes){
            public static final long serialVersionUID = 0L;
            private final Time[] pendingTimes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Batches pending processing (").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.pendingTimes$1).size())).append((Object)" batches): ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.pendingTimes$1).mkString(", ")).toString();
            }
            {
                this.pendingTimes$1 = pendingTimes$1;
            }
        });
        Time[] timesToReschedule = (Time[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pendingTimes).$plus$plus(downTimes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Time.class)))).distinct()).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)new Serializable(this, timesToReschedule){
            public static final long serialVersionUID = 0L;
            private final Time[] timesToReschedule$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Batches to reschedule (").append((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.timesToReschedule$1).size())).append((Object)" batches): ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.timesToReschedule$1).mkString(", ")).toString();
            }
            {
                this.timesToReschedule$1 = timesToReschedule$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])timesToReschedule).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JobGenerator $outer;

            public final void apply(Time time) {
                this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.submitJobSet(new JobSet(time, this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$graph().generateJobs(time), JobSet$.MODULE$.apply$default$3()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.timer().start(restartTime.milliseconds());
        this.logInfo((Function0<String>)new Serializable(this, restartTime){
            public static final long serialVersionUID = 0L;
            private final Time restartTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Restarted JobGenerator at ").append((Object)this.restartTime$1).toString();
            }
            {
                this.restartTime$1 = restartTime$1;
            }
        });
    }

    private void generateJobs(Time time) {
        Try try_;
        block4: {
            block3: {
                block2: {
                    SparkEnv$.MODULE$.set(this.ssc().env());
                    try_ = Try$.MODULE$.apply((Function0)new $anonfun$2(this, time));
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    Seq jobs = (Seq)success.value();
                    Map receivedBlockInfos = this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().getBlocksOfBatch(time).mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ReceivedBlockInfo[] apply(Seq<ReceivedBlockInfo> x$1) {
                            return (ReceivedBlockInfo[])x$1.toArray(ClassTag$.MODULE$.apply(ReceivedBlockInfo.class));
                        }
                    });
                    this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.submitJobSet(new JobSet(time, (Seq<Job>)jobs, (Map<Object, ReceivedBlockInfo[]>)receivedBlockInfos));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.reportError(new StringBuilder().append((Object)"Error generating jobs for time ").append((Object)time).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
            DoCheckpoint x$8 = new DoCheckpoint(time);
            ActorRef x$9 = qual$4.$bang$default$2((Object)x$8);
            qual$4.$bang((Object)x$8, x$9);
            return;
        }
        throw new MatchError((Object)try_);
    }

    private void clearMetadata(Time time) {
        this.ssc().graph().clearMetadata(time);
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().cleanupOldMetadata(time.$minus(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().batchDuration()));
        if (this.shouldCheckpoint()) {
            ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor());
            DoCheckpoint x$10 = new DoCheckpoint(time);
            ActorRef x$11 = qual$5.$bang$default$2((Object)x$10);
            qual$5.$bang((Object)x$10, x$11);
        } else {
            this.markBatchFullyProcessed(time);
        }
    }

    private void clearCheckpointData(Time time) {
        this.ssc().graph().clearCheckpointData(time);
        this.markBatchFullyProcessed(time);
    }

    private void doCheckpoint(Time time) {
        if (this.shouldCheckpoint() && time.$minus(this.org$apache$spark$streaming$scheduler$JobGenerator$$graph().zeroTime()).isMultipleOf(this.ssc().checkpointDuration())) {
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Checkpointing graph for time ").append((Object)this.time$2).toString();
                }
                {
                    this.time$2 = time$2;
                }
            });
            this.ssc().graph().updateCheckpointData(time);
            this.checkpointWriter().write(new Checkpoint(this.ssc(), time));
        }
    }

    private void markBatchFullyProcessed(Time time) {
        this.lastProcessedBatch_$eq(time);
    }

    private final boolean hasTimedOut$1(long timeWhenStopStarted$1, long stopTimeout$1) {
        boolean timedOut;
        boolean bl = timedOut = System.currentTimeMillis() - timeWhenStopStarted$1 > stopTimeout$1;
        if (timedOut) {
            this.logWarning((Function0<String>)new Serializable(this, stopTimeout$1){
                public static final long serialVersionUID = 0L;
                private final long stopTimeout$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Timed out while stopping the job generator (timeout = ").append((Object)BoxesRunTime.boxToLong((long)this.stopTimeout$1)).append((Object)")").toString();
                }
                {
                    this.stopTimeout$1 = stopTimeout$1;
                }
            });
        }
        return timedOut;
    }

    private final boolean haveAllBatchesBeenProcessed$1(long stopTime$1) {
        return this.lastProcessedBatch() != null && this.lastProcessedBatch().milliseconds() == stopTime$1;
    }

    public JobGenerator(JobScheduler jobScheduler) {
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler = jobScheduler;
        Logging.class.$init$((Logging)this);
        this.ssc = jobScheduler.ssc();
        this.conf = this.ssc().conf();
        this.org$apache$spark$streaming$scheduler$JobGenerator$$graph = this.ssc().graph();
        String clockClass = this.ssc().sc().conf().get("spark.streaming.clock", "org.apache.spark.streaming.util.SystemClock");
        this.clock = (Clock)Class.forName(clockClass).newInstance();
        this.timer = new RecurringTimer(this.clock(), this.ssc().graph().batchDuration().milliseconds(), (Function1<Object, BoxedUnit>)new $anonfun$1(this), "JobGenerator");
        this.org$apache$spark$streaming$scheduler$JobGenerator$$eventActor = null;
        this.lastProcessedBatch = null;
    }
}

