/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.spark.Logging;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockTracker;
import org.apache.spark.streaming.scheduler.ReceiverInfo;
import org.apache.spark.streaming.scheduler.ReceiverInfo$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverLauncher$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.SynchronizedMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd!B\u0001\u0003\u0001\u0011a!a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0004gN\u001c7\u0001\u0001\t\u00037qi\u0011\u0001B\u0005\u0003;\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n!c]6jaJ+7-Z5wKJd\u0015-\u001e8dQB\u0011a\"I\u0005\u0003E=\u0011qAQ8pY\u0016\fg\u000eC\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0004M!J\u0003CA\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\r$\u0001\u0004Q\u0002bB\u0010$!\u0003\u0005\r\u0001\t\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0003Q\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ngV\tQ\u0006E\u0002\u000f]AJ!aL\b\u0003\u000b\u0005\u0013(/Y=1\u0005EJ\u0004c\u0001\u001a6o5\t1G\u0003\u00025\t\u00059Am\u001d;sK\u0006l\u0017B\u0001\u001c4\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0011\u0001(\u000f\u0007\u0001\t%Q\u0004!!A\u0001\u0002\u000b\u0005\u0011IA\u0002`IYJ!\u0001P\u001f\u0002\u0011\u0011\ngn\u001c8gk:L!AP \u0002/\u001d,GOU3dK&4XM]%oaV$8\u000b\u001e:fC6\u001c\u0018B\u0001!\u0005\u00051!5\u000b\u001e:fC6<%/\u00199i#\t\u0011U\t\u0005\u0002\u000f\u0007&\u0011Ai\u0004\u0002\b\u001d>$\b.\u001b8h!\tqa)\u0003\u0002H\u001f\t\u0019\u0011I\\=\t\r%\u0003\u0001\u0015!\u0003.\u0003U\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ng\u0002Bqa\u0013\u0001C\u0002\u0013%A*\u0001\fsK\u000e,\u0017N^3s\u0013:\u0004X\u000f^*ue\u0016\fW.\u00133t+\u0005i\u0005c\u0001\b/\u001dB\u0011abT\u0005\u0003!>\u00111!\u00138u\u0011\u0019\u0011\u0006\u0001)A\u0005\u001b\u00069\"/Z2fSZ,'/\u00138qkR\u001cFO]3b[&#7\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003A\u0011XmY3jm\u0016\u0014X\t_3dkR|'/F\u0001W!\t9\u0006,D\u0001\u0001\r\u0011I\u0006\u0001\u0001.\u0003!I+7-Z5wKJd\u0015-\u001e8dQ\u0016\u00148C\u0001-\u000e\u0011\u0015!\u0003\f\"\u0001])\u00051\u0006\"\u00020Y\t\u0003y\u0016!B:uCJ$H#\u00011\u0011\u00059\t\u0017B\u00012\u0010\u0005\u0011)f.\u001b;\t\u000b\u0011DF\u0011A0\u0002\tM$x\u000e\u001d\u0005\u0006Mb#IaX\u0001\u000fgR\f'\u000f\u001e*fG\u0016Lg/\u001a:t\u0011\u0015A\u0007\f\"\u0003`\u00035\u0019Ho\u001c9SK\u000e,\u0017N^3sg\"9!\u000e\u0017b\u0001\n\u0003Y\u0017aA3omV\tA\u000e\u0005\u0002\u0015[&\u0011aN\u0002\u0002\t'B\f'o[#om\"1\u0001\u000f\u0017Q\u0001\n1\fA!\u001a8wA!\u0012qN\u001d\t\u0003\u001dML!\u0001^\b\u0003\u0013Q\u0014\u0018M\\:jK:$\bb\u0002<Y\u0005\u0004%\ta^\u0001\u0007i\"\u0014X-\u00193\u0016\u0003a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\t1\fgn\u001a\u0006\u0002{\u0006!!.\u0019<b\u0013\ty(P\u0001\u0004UQJ,\u0017\r\u001a\u0005\b\u0003\u0007A\u0006\u0015!\u0003y\u0003\u001d!\bN]3bI\u0002B3!!\u0001s\u0011\u001d\tI\u0001\u0001Q\u0001\nY\u000b\u0011C]3dK&4XM]#yK\u000e,Ho\u001c:!\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty!\u0001\u0007sK\u000e,\u0017N^3s\u0013:4w.\u0006\u0002\u0002\u0012I1\u00111CA\u000e\u0003c1q!!\u0006\u0002\u0018\u0001\t\tB\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\t\u00035\u0011XmY3jm\u0016\u0014\u0018J\u001c4pAA9\u0011QDA\u0014\u001d\u0006-RBAA\u0010\u0015\u0011\t\t#a\t\u0002\u000f5,H/\u00192mK*\u0019\u0011QE\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002*\u0005}!a\u0002%bg\"l\u0015\r\u001d\t\u0004O\u00055\u0012bAA\u0018\u0005\ta!+Z2fSZ,'/\u00138g_B9\u0011QDA\u001a\u001d\u0006-\u0012\u0002BA\u001b\u0003?\u0011qbU=oG\"\u0014xN\\5{K\u0012l\u0015\r\u001d\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003w\tAC]3dK&4X\r\u001a\"m_\u000e\\GK]1dW\u0016\u0014XCAA\u001f!\r9\u0013qH\u0005\u0004\u0003\u0003\u0012!\u0001\u0006*fG\u0016Lg/\u001a3CY>\u001c7\u000e\u0016:bG.,'\u000f\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001f\u0003U\u0011XmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6fe\u0002B\u0011\"!\u0013\u0001\u0005\u0004%I!a\u0013\u0002\u00171L7\u000f^3oKJ\u0014Uo]\u000b\u0003\u0003\u001b\u00022aJA(\u0013\r\t\tF\u0001\u0002\u0015'R\u0014X-Y7j]\u001ed\u0015n\u001d;f]\u0016\u0014()^:\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001b\nA\u0002\\5ti\u0016tWM\u001d\"vg\u0002B\u0011\"!\u0017\u0001\u0001\u0004%I!a\u0017\u0002\u000b\u0005\u001cGo\u001c:\u0016\u0005\u0005u\u0003\u0003BA0\u0003Oj!!!\u0019\u000b\t\u0005e\u00131\r\u0006\u0003\u0003K\nA!Y6lC&!\u0011\u0011NA1\u0005!\t5\r^8s%\u00164\u0007\"CA7\u0001\u0001\u0007I\u0011BA8\u0003%\t7\r^8s?\u0012*\u0017\u000fF\u0002a\u0003cB!\"a\u001d\u0002l\u0005\u0005\t\u0019AA/\u0003\rAH%\r\u0005\t\u0003o\u0002\u0001\u0015)\u0003\u0002^\u00051\u0011m\u0019;pe\u0002BQA\u0018\u0001\u0005\u0002}CQ\u0001\u001a\u0001\u0005\u0002}Cq!a \u0001\t\u0003\t\t)A\u000bbY2|7-\u0019;f\u00052|7m[:U_\n\u000bGo\u00195\u0015\u0007\u0001\f\u0019\t\u0003\u0005\u0002\u0006\u0006u\u0004\u0019AAD\u0003%\u0011\u0017\r^2i)&lW\rE\u0002\u001c\u0003\u0013K1!a#\u0005\u0005\u0011!\u0016.\\3\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u0006\u0001r-\u001a;CY>\u001c7n](g\u0005\u0006$8\r\u001b\u000b\u0005\u0003'\u000by\fE\u0004\u0002\u0016\u0006me*!)\u000f\u00079\t9*C\u0002\u0002\u001a>\ta\u0001\u0015:fI\u00164\u0017\u0002BAO\u0003?\u00131!T1q\u0015\r\tIj\u0004\t\u0007\u0003G\u000b\u0019,!/\u000f\t\u0005\u0015\u0016q\u0016\b\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111V\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012bAAY\u001f\u00059\u0001/Y2lC\u001e,\u0017\u0002BA[\u0003o\u00131aU3r\u0015\r\t\tl\u0004\t\u0004O\u0005m\u0016bAA_\u0005\t\t\"+Z2fSZ,GM\u00117pG.LeNZ8\t\u0011\u0005\u0015\u0015Q\u0012a\u0001\u0003\u000fCq!a1\u0001\t\u0003\t)-A\rhKR\u0014En\\2lg>3')\u0019;dQ\u0006sGm\u0015;sK\u0006lGCBAQ\u0003\u000f\fI\r\u0003\u0005\u0002\u0006\u0006\u0005\u0007\u0019AAD\u0011\u001d\tY-!1A\u00029\u000b\u0001b\u001d;sK\u0006l\u0017\n\u001a\u0005\b\u0003\u001f\u0004A\u0011AAi\u0003I\u0019G.Z1okB|E\u000eZ'fi\u0006$\u0017\r^1\u0015\u0007\u0001\f\u0019\u000e\u0003\u0005\u0002V\u00065\u0007\u0019AAD\u0003E\u0019G.Z1okB$\u0006N]3tQRKW.\u001a\u0005\b\u00033\u0004A\u0011BAn\u0003A\u0011XmZ5ti\u0016\u0014(+Z2fSZ,'\u000fF\u0006a\u0003;\fy.!;\u0002n\u0006E\bbBAf\u0003/\u0004\rA\u0014\u0005\t\u0003C\f9\u000e1\u0001\u0002d\u0006\u0019A/\u001f9\u0011\t\u0005U\u0015Q]\u0005\u0005\u0003O\fyJ\u0001\u0004TiJLgn\u001a\u0005\t\u0003W\f9\u000e1\u0001\u0002d\u0006!\u0001n\\:u\u0011!\ty/a6A\u0002\u0005u\u0013!\u0004:fG\u0016Lg/\u001a:BGR|'\u000f\u0003\u0005\u0002t\u0006]\u0007\u0019AA/\u0003\u0019\u0019XM\u001c3fe\"9\u0011q\u001f\u0001\u0005\n\u0005e\u0018A\u00053fe\u0016<\u0017n\u001d;feJ+7-Z5wKJ$r\u0001YA~\u0003{\u0014\t\u0001C\u0004\u0002L\u0006U\b\u0019\u0001(\t\u0011\u0005}\u0018Q\u001fa\u0001\u0003G\fq!\\3tg\u0006<W\r\u0003\u0005\u0003\u0004\u0005U\b\u0019AAr\u0003\u0015)'O]8s\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013\t\u0001\"\u00193e\u00052|7m\u001b\u000b\u0004A\t-\u0001\u0002\u0003B\u0007\u0005\u000b\u0001\r!!/\u0002#I,7-Z5wK\u0012\u0014En\\2l\u0013:4w\u000eC\u0004\u0003\u0012\u0001!IAa\u0005\u0002\u0017I,\u0007o\u001c:u\u000bJ\u0014xN\u001d\u000b\bA\nU!q\u0003B\r\u0011\u001d\tYMa\u0004A\u00029C\u0001\"a@\u0003\u0010\u0001\u0007\u00111\u001d\u0005\t\u0005\u0007\u0011y\u00011\u0001\u0002d\"9!Q\u0004\u0001\u0005\u0002\t}\u0011\u0001\u00065bgVs\u0017\r\u001c7pG\u0006$X\r\u001a\"m_\u000e\\7/F\u0001!\r\u0019\u0011\u0019\u0003\u0001\u0003\u0003&\t!\"+Z2fSZ,'\u000f\u0016:bG.,'/Q2u_J\u001cRA!\t\u000e\u0005O\u0001B!a\u0018\u0003*%!!1FA1\u0005\u0015\t5\r^8s\u0011\u001d!#\u0011\u0005C\u0001\u0005_!\"A!\r\u0011\u0007]\u0013\t\u0003\u0003\u0005\u00036\t\u0005B\u0011\u0001B\u001c\u0003\u001d\u0011XmY3jm\u0016,\"A!\u000f\u0011\u000b9\u0011Y$\u00121\n\u0007\turBA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o\u000f)\u0011\tEAA\u0001\u0012\u0003!!1I\u0001\u0010%\u0016\u001cW-\u001b<feR\u0013\u0018mY6feB\u0019qE!\u0012\u0007\u0013\u0005\u0011\u0011\u0011!E\u0001\t\t\u001d3c\u0001B#\u001b!9AE!\u0012\u0005\u0002\t-CC\u0001B\"\u0011)\u0011yE!\u0012\u0012\u0002\u0013\u0005!\u0011K\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tM#f\u0001\u0011\u0003V-\u0012!q\u000b\t\u0005\u00053\u0012\u0019'\u0004\u0002\u0003\\)!!Q\fB0\u0003%)hn\u00195fG.,GMC\u0002\u0003b=\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ga\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ReceiverTracker
implements Logging {
    public final StreamingContext org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc;
    private final boolean skipReceiverLaunch;
    private final ReceiverInputDStream<?>[] org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams;
    private final int[] receiverInputStreamIds;
    private final ReceiverLauncher receiverExecutor;
    private final HashMap<Object, ReceiverInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo;
    private final ReceivedBlockTracker receivedBlockTracker;
    private final StreamingListenerBus listenerBus;
    private ActorRef actor;
    private transient Logger org$apache$spark$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return ReceiverTracker$.MODULE$.$lessinit$greater$default$2();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ReceiverInputDStream<?>[] org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams;
    }

    private int[] receiverInputStreamIds() {
        return this.receiverInputStreamIds;
    }

    private ReceiverLauncher receiverExecutor() {
        return this.receiverExecutor;
    }

    public HashMap<Object, ReceiverInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo;
    }

    private ReceivedBlockTracker receivedBlockTracker() {
        return this.receivedBlockTracker;
    }

    private StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    private ActorRef actor() {
        return this.actor;
    }

    private void actor_$eq(ActorRef x$1) {
        this.actor = x$1;
    }

    public synchronized void start() {
        if (this.actor() == null) {
            if (!Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).isEmpty()) {
                this.actor_$eq(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().actorSystem().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverTracker $outer;

                    public final ReceiverTrackerActor apply() {
                        return this.$outer.new ReceiverTrackerActor();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(ReceiverTrackerActor.class)), "ReceiverTracker"));
                if (!this.skipReceiverLaunch) {
                    this.receiverExecutor().start();
                }
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "ReceiverTracker started";
                    }
                });
            }
            return;
        }
        throw new SparkException("ReceiverTracker already started");
    }

    public synchronized void stop() {
        if (!Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).isEmpty() && this.actor() != null) {
            if (!this.skipReceiverLaunch) {
                this.receiverExecutor().stop();
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().actorSystem().stop(this.actor());
            this.actor_$eq(null);
            this.receivedBlockTracker().stop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker stopped";
                }
            });
        }
    }

    public void allocateBlocksToBatch(Time batchTime) {
        if (Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).nonEmpty()) {
            this.receivedBlockTracker().allocateBlocksToBatch(batchTime);
        }
    }

    public Map<Object, Seq<ReceivedBlockInfo>> getBlocksOfBatch(Time batchTime) {
        return this.receivedBlockTracker().getBlocksOfBatch(batchTime);
    }

    public synchronized Seq<ReceivedBlockInfo> getBlocksOfBatchAndStream(Time batchTime, int streamId) {
        return this.receivedBlockTracker().getBlocksOfBatchAndStream(batchTime, streamId);
    }

    public void cleanupOldMetadata(Time cleanupThreshTime) {
        this.receivedBlockTracker().cleanupOldBatches(cleanupThreshTime);
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(int streamId, String typ, String host, ActorRef receiverActor, ActorRef sender) {
        if (Predef$.MODULE$.intArrayOps(this.receiverInputStreamIds()).contains((Object)BoxesRunTime.boxToInteger((int)streamId))) {
            ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)new ReceiverInfo(streamId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typ, BoxesRunTime.boxToInteger((int)streamId)})), receiverActor, true, host, ReceiverInfo$.MODULE$.apply$default$6(), ReceiverInfo$.MODULE$.apply$default$7()));
            this.listenerBus().post(new StreamingListenerReceiverStarted((ReceiverInfo)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            this.logInfo((Function0<String>)new Serializable(this, streamId, sender){
                public static final long serialVersionUID = 0L;
                private final int streamId$1;
                private final ActorRef sender$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Registered receiver for stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$1)).append((Object)" from ").append((Object)this.sender$1.path().address()).toString();
                }
                {
                    this.streamId$1 = streamId$1;
                    this.sender$1 = sender$1;
                }
            });
            return;
        }
        throw new SparkException(new StringBuilder().append((Object)"Register received for unexpected id ").append((Object)BoxesRunTime.boxToInteger((int)streamId)).toString());
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverInfo receiverInfo;
            block3: {
                block2: {
                    option = ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverInfo oldInfo = (ReceiverInfo)some.x();
                    Object x$8 = null;
                    boolean x$9 = false;
                    String x$10 = message;
                    String x$11 = error;
                    int x$12 = oldInfo.copy$default$1();
                    String x$13 = oldInfo.copy$default$2();
                    String x$14 = oldInfo.copy$default$5();
                    receiverInfo = oldInfo.copy(x$12, x$13, null, x$9, x$14, x$10, x$11);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                receiverInfo = new ReceiverInfo(streamId, "", null, false, "", message, error);
            }
            ReceiverInfo newReceiverInfo = receiverInfo;
            ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverInfo);
            this.listenerBus().post(new StreamingListenerReceiverStopped((ReceiverInfo)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logError((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$2;
                private final String messageWithError$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deregistered receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$2), this.messageWithError$1}));
                }
                {
                    this.streamId$2 = streamId$2;
                    this.messageWithError$1 = messageWithError$1;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(ReceivedBlockInfo receivedBlockInfo) {
        return this.receivedBlockTracker().addBlock(receivedBlockInfo);
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverInfo receiverInfo;
            block3: {
                block2: {
                    option = ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverInfo oldInfo = (ReceiverInfo)some.x();
                    String x$15 = message;
                    String x$16 = error;
                    int x$17 = oldInfo.copy$default$1();
                    String x$18 = oldInfo.copy$default$2();
                    ActorRef x$19 = oldInfo.copy$default$3();
                    boolean x$20 = oldInfo.copy$default$4();
                    String x$21 = oldInfo.copy$default$5();
                    receiverInfo = oldInfo.copy(x$17, x$18, x$19, x$20, x$21, x$15, x$16);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                receiverInfo = new ReceiverInfo(streamId, "", null, false, "", message, error);
            }
            ReceiverInfo newReceiverInfo = receiverInfo;
            ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverInfo);
            this.listenerBus().post(new StreamingListenerReceiverError((ReceiverInfo)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logWarning((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$3;
                private final String messageWithError$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reported by receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$3), this.messageWithError$2}));
                }
                {
                    this.streamId$3 = streamId$3;
                    this.messageWithError$2 = messageWithError$2;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean hasUnallocatedBlocks() {
        return this.receivedBlockTracker().hasUnallocatedReceivedBlocks();
    }

    public ReceiverTracker(StreamingContext ssc, boolean skipReceiverLaunch) {
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc = ssc;
        this.skipReceiverLaunch = skipReceiverLaunch;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams = ssc.graph().getReceiverInputStreams();
        this.receiverInputStreamIds = (int[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).map((Function1)new $anonfun$1(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.receiverExecutor = new ReceiverLauncher();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo = new $anon$1(this);
        this.receivedBlockTracker = new ReceivedBlockTracker(ssc.sparkContext().conf(), ssc.sparkContext().hadoopConfiguration(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(this.receiverInputStreamIds()), ssc.scheduler().clock(), (Option<String>)Option$.MODULE$.apply((Object)ssc.checkpointDir()));
        this.listenerBus = ssc.scheduler().listenerBus();
        this.actor = null;
    }

    public class ReceiverLauncher {
        private final transient SparkEnv env;
        private final transient Thread thread;

        public SparkEnv env() {
            return this.env;
        }

        public Thread thread() {
            return this.thread;
        }

        public void start() {
            this.thread().start();
        }

        public void stop() {
            this.stopReceivers();
            this.thread().join(10000L);
            if (((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).isEmpty()) {
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "All of the receivers have deregistered successfully";
                    }
                });
            } else {
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverLauncher $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"All of the receivers have not deregistered, ").append(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$startReceivers() {
            RDD rDD;
            Receiver[] receivers = (Receiver[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Receiver<?> apply(ReceiverInputDStream<?> nis) {
                    void var2_2;
                    Receiver<?> rcvr = nis.getReceiver();
                    rcvr.setReceiverId(nis.id());
                    return var2_2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Receiver.class)));
            boolean hasLocationPreferences = BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Receiver<?> x$2) {
                    return x$2.preferredLocation().isDefined();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()))).reduce((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(boolean x$3, boolean x$4) {
                    return x$3 && x$4;
                }
            }));
            if (hasLocationPreferences) {
                Tuple2[] receiversWithPreferences = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Receiver<Object>, Seq<String>> apply(Receiver<?> r) {
                        return new Tuple2(r, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)r.preferredLocation().get()})));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receiversWithPreferences), ClassTag$.MODULE$.apply(Receiver.class));
            } else {
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receivers), Predef$.MODULE$.refArrayOps((Object[])receivers).size(), ClassTag$.MODULE$.apply(Receiver.class));
            }
            RDD tempRDD = rDD;
            Option checkpointDirOption = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.checkpointDir());
            SerializableWritable serializableHadoopConf = new SerializableWritable((Writable)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().hadoopConfiguration());
            Serializable startReceiver2 = new Serializable(this, checkpointDirOption, serializableHadoopConf){
                public static final long serialVersionUID = 0L;
                private final Option checkpointDirOption$1;
                private final SerializableWritable serializableHadoopConf$1;

                public final void apply(Iterator<Receiver<?>> iterator) {
                    if (iterator.hasNext()) {
                        Receiver receiver = (Receiver)iterator.next();
                        ReceiverSupervisorImpl supervisor2 = new ReceiverSupervisorImpl(receiver, SparkEnv$.MODULE$.get(), (Configuration)this.serializableHadoopConf$1.value(), (Option<String>)this.checkpointDirOption$1);
                        supervisor2.start();
                        supervisor2.awaitTermination();
                        return;
                    }
                    throw new SparkException("Could not start receiver as object not found.");
                }
                {
                    this.checkpointDirOption$1 = checkpointDirOption$1;
                    this.serializableHadoopConf$1 = serializableHadoopConf$1;
                }
            };
            Object object = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().isLocal() ? BoxedUnit.UNIT : SparkContext$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(int x) {
                    return new Tuple2.mcII.sp(x, 1);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$5, int x$6) {
                    return this.apply$mcIII$sp(x$5, x$6);
                }

                public int apply$mcIII$sp(int x$5, int x$6) {
                    return x$5 + x$6;
                }
            }, 20).collect();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this, receivers){
                public static final long serialVersionUID = 0L;
                private final Receiver[] receivers$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Starting ").append((Object)BoxesRunTime.boxToInteger((int)this.receivers$1.length)).append((Object)" receivers").toString();
                }
                {
                    this.receivers$1 = receivers$1;
                }
            });
            SparkContext qual$1 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext();
            Serializable x$22 = startReceiver2;
            boolean x$23 = qual$1.clean$default$2();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().runJob(tempRDD, (Function1)qual$1.clean((Object)x$22, x$23), ClassTag$.MODULE$.Unit());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "All of the receivers have been terminated";
                }
            });
        }

        private void stopReceivers() {
            ((IterableLike)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<ActorRef> apply(ReceiverInfo info) {
                    return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)info.actor()));
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ActorRef x$7) {
                    ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(x$7);
                    StopReceiver$ x$24 = StopReceiver$.MODULE$;
                    ActorRef x$25 = qual$2.$bang$default$2((Object)x$24);
                    qual$2.$bang((Object)x$24, x$25);
                }
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverLauncher $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Sent stop signal to all ").append((Object)BoxesRunTime.boxToInteger((int)((SynchronizedMap)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).size())).append((Object)" receivers").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer() {
            return ReceiverTracker.this;
        }

        public ReceiverLauncher() {
            if (ReceiverTracker.this == null) {
                throw new NullPointerException();
            }
            this.env = ReceiverTracker.this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env();
            this.thread = new ReceiverLauncher$$anon$2(this);
        }
    }

    public class ReceiverTrackerActor
    implements Actor {
        private final ActorContext context;
        private final ActorRef self;

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public final ActorRef sender() {
            return Actor.class.sender((Actor)this);
        }

        public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
            Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
        }

        public void aroundPreStart() {
            Actor.class.aroundPreStart((Actor)this);
        }

        public void aroundPostStop() {
            Actor.class.aroundPostStop((Actor)this);
        }

        public void aroundPreRestart(Throwable reason, Option<Object> message) {
            Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
        }

        public void aroundPostRestart(Throwable reason) {
            Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.class.supervisorStrategy((Actor)this);
        }

        public void preStart() throws Exception {
            Actor.class.preStart((Actor)this);
        }

        public void postStop() throws Exception {
            Actor.class.postStop((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.class.preRestart((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.class.postRestart((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.class.unhandled((Actor)this, (Object)message);
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerActor $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver2 = (RegisterReceiver)A1;
                        int streamId = registerReceiver2.streamId();
                        String typ = registerReceiver2.typ();
                        String host = registerReceiver2.host();
                        ActorRef receiverActor = registerReceiver2.receiverActor();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(streamId, typ, host, receiverActor, this.$outer.sender());
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof AddBlock) {
                        AddBlock addBlock2 = (AddBlock)A1;
                        ReceivedBlockInfo receivedBlockInfo = addBlock2.receivedBlockInfo();
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(receivedBlockInfo)), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ReportError) {
                        ReportError reportError2 = (ReportError)A1;
                        int streamId = reportError2.streamId();
                        String message = reportError2.message();
                        String error = reportError2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(streamId, message, error);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver2 = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver2.streamId();
                        String message = deregisterReceiver2.msg();
                        String error = deregisterReceiver2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(streamId, message, error);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof RegisterReceiver ? true : (object instanceof AddBlock ? true : (object instanceof ReportError ? true : object instanceof DeregisterReceiver));
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer() {
            return ReceiverTracker.this;
        }

        public ReceiverTrackerActor() {
            if (ReceiverTracker.this == null) {
                throw new NullPointerException();
            }
            Actor.class.$init$((Actor)this);
        }
    }
}

