/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.spark.streaming.util.HdfsUtils$;
import org.apache.spark.streaming.util.WriteAheadLogFileSegment;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194Q!\u0001\u0002\u0001\t1\u0011\u0011d\u0016:ji\u0016\f\u0005.Z1e\u0019><'+\u00198e_6\u0014V-\u00193fe*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\u000b\u0011\u00059\u0019R\"A\b\u000b\u0005A\t\u0012\u0001\u00027b]\u001eT\u0011AE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0015\u001f\t1qJ\u00196fGR\u0004\"AF\r\u000e\u0003]Q!\u0001G\t\u0002\u0005%|\u0017B\u0001\u000e\u0018\u0005%\u0019En\\:fC\ndW\r\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0011\u0001\u0018\r\u001e5\u0004\u0001A\u0011q$\n\b\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%I\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#AB*ue&twM\u0003\u0002%C!A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\u0003d_:4\u0007CA\u00160\u001b\u0005a#BA\u0015.\u0015\tq\u0003\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003a1\u0012QbQ8oM&<WO]1uS>t\u0007\"\u0002\u001a\u0001\t\u0003\u0019\u0014A\u0002\u001fj]&$h\bF\u00025m]\u0002\"!\u000e\u0001\u000e\u0003\tAQ\u0001H\u0019A\u0002yAQ!K\u0019A\u0002)Bq!\u000f\u0001C\u0002\u0013%!(\u0001\u0005j]N$(/Z1n+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$B\u0001 .\u0003\t17/\u0003\u0002A{\t\tbi\u0015#bi\u0006Le\u000e];u'R\u0014X-Y7\t\r\t\u0003\u0001\u0015!\u0003<\u0003%Ign\u001d;sK\u0006l\u0007\u0005C\u0004E\u0001\u0001\u0007I\u0011B#\u0002\r\rdwn]3e+\u00051\u0005C\u0001\u0011H\u0013\tA\u0015EA\u0004C_>dW-\u00198\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\u0006Q1\r\\8tK\u0012|F%Z9\u0015\u00051{\u0005C\u0001\u0011N\u0013\tq\u0015E\u0001\u0003V]&$\bb\u0002)J\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\n\u0004B\u0002*\u0001A\u0003&a)A\u0004dY>\u001cX\r\u001a\u0011\t\u000bQ\u0003A\u0011A+\u0002\tI,\u0017\r\u001a\u000b\u0003-r\u0003\"a\u0016.\u000e\u0003aS!!W\t\u0002\u00079Lw.\u0003\u0002\\1\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bu\u001b\u0006\u0019\u00010\u0002\u000fM,w-\\3oiB\u0011QgX\u0005\u0003A\n\u0011\u0001d\u0016:ji\u0016\f\u0005.Z1e\u0019><g)\u001b7f'\u0016<W.\u001a8u\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003\u0015\u0019Gn\\:f)\u0005a\u0005\"B3\u0001\t\u0013\u0019\u0017AC1tg\u0016\u0014Ho\u00149f]\u0002")
public class WriteAheadLogRandomReader
implements Closeable {
    private final FSDataInputStream instream;
    private boolean closed;

    private FSDataInputStream instream() {
        return this.instream;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public synchronized ByteBuffer read(WriteAheadLogFileSegment segment) {
        this.assertOpen();
        this.instream().seek(segment.offset());
        int nextLength = this.instream().readInt();
        HdfsUtils$.MODULE$.checkState(nextLength == segment.length(), (Function0<String>)new Serializable(this, segment, nextLength){
            public static final long serialVersionUID = 0L;
            private final WriteAheadLogFileSegment segment$1;
            private final int nextLength$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected message length to be ", ", but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.segment$1.length()), BoxesRunTime.boxToInteger((int)this.nextLength$1)}));
            }
            {
                this.segment$1 = segment$1;
                this.nextLength$1 = nextLength$1;
            }
        });
        byte[] buffer = new byte[nextLength];
        this.instream().readFully(buffer);
        return ByteBuffer.wrap(buffer);
    }

    @Override
    public synchronized void close() {
        this.closed_$eq(true);
        this.instream().close();
    }

    private void assertOpen() {
        HdfsUtils$.MODULE$.checkState(!this.closed(), (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream is closed. Create a new Reader to read from the file.";
            }
        });
    }

    public WriteAheadLogRandomReader(String path, Configuration conf) {
        this.instream = HdfsUtils$.MODULE$.getInputStream(path, conf);
        this.closed = false;
    }
}

