/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Props$;
import akka.actor.ScalaActorSelection;
import akka.pattern.AskableActorSelection$;
import akka.pattern.package$;
import akka.util.Timeout$;
import com.google.common.base.Throwables;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Logging;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.receiver.ArrayBufferBlock;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockManagerBasedBlockHandler;
import org.apache.spark.streaming.receiver.ByteBufferBlock;
import org.apache.spark.streaming.receiver.IteratorBlock;
import org.apache.spark.streaming.receiver.ReceivedBlock;
import org.apache.spark.streaming.receiver.ReceivedBlockHandler;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl$;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.util.AkkaUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUa!B\u0001\u0003\u0001\u0011a!A\u0006*fG\u0016Lg/\u001a:TkB,'O^5t_JLU\u000e\u001d7\u000b\u0005\r!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e#A\u0011abD\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0013%\u0016\u001cW-\u001b<feN+\b/\u001a:wSN|'\u000f\u0005\u0002\u0013'5\ta!\u0003\u0002\u0015\r\t9Aj\\4hS:<\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0004\u0001A\u0012\u0001$\b\t\u0004\u001deY\u0012B\u0001\u000e\u0003\u0005!\u0011VmY3jm\u0016\u0014\bC\u0001\u000f\u001e\u0019\u0001!\u0011BH\u000b\u0002\u0002\u0003\u0005)\u0011A\u0010\u0003\u0007}#\u0013'\u0005\u0002!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t9aj\u001c;iS:<\u0007CA\u0011(\u0013\tA#EA\u0002B]fD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0004K:4\bC\u0001\n-\u0013\ticA\u0001\u0005Ta\u0006\u00148.\u00128w\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014A\u00035bI>|\u0007oQ8oMB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0005G>tgM\u0003\u00026\u0011\u00051\u0001.\u00193p_BL!a\u000e\u001a\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!I\u0004A!A!\u0002\u0013Q\u0014aE2iK\u000e\\\u0007o\\5oi\u0012K'o\u00149uS>t\u0007cA\u0011<{%\u0011AH\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y\neBA\u0011@\u0013\t\u0001%%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!#\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}Q)q\tS'O\u001fB\u0011a\u0002\u0001\u0005\u0006\u0007\u0011\u0003\r!\u0013\u0019\u0003\u00152\u00032AD\rL!\taB\nB\u0005\u001f\u0011\u0006\u0005\t\u0011!B\u0001?!)!\u0006\u0012a\u0001W!)q\u0006\u0012a\u0001a!)\u0011\b\u0012a\u0001u!9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0016\u0001\u0006:fG\u0016Lg/\u001a3CY>\u001c7\u000eS1oI2,'/F\u0001T!\tqA+\u0003\u0002V\u0005\t!\"+Z2fSZ,GM\u00117pG.D\u0015M\u001c3mKJDaa\u0016\u0001!\u0002\u0013\u0019\u0016!\u0006:fG\u0016Lg/\u001a3CY>\u001c7\u000eS1oI2,'\u000f\t\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u00031!(/Y2lKJ\f5\r^8s+\u0005Y\u0006C\u0001/b\u001b\u0005i&B\u00010`\u0003\u0015\t7\r^8s\u0015\u0005\u0001\u0017\u0001B1lW\u0006L!AY/\u0003\u001d\u0005\u001bGo\u001c:TK2,7\r^5p]\"1A\r\u0001Q\u0001\nm\u000bQ\u0002\u001e:bG.,'/Q2u_J\u0004\u0003b\u00024\u0001\u0005\u0004%IaZ\u0001\u000bCN\\G+[7f_V$X#\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u00055\u0014\u0013AC2p]\u000e,(O]3oi&\u0011qN\u001b\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011\u0019\t\b\u0001)A\u0005Q\u0006Y\u0011m]6US6,w.\u001e;!\u0011\u001dq\u0006A1A\u0005\nM,\u0012\u0001\u001e\t\u00039VL!A^/\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDa\u0001\u001f\u0001!\u0002\u0013!\u0018AB1di>\u0014\b\u0005C\u0004{\u0001\t\u0007I\u0011B>\u0002\u00159,wO\u00117pG.LE-F\u0001}!\ri\u00181B\u0007\u0002}*\u0019q0!\u0001\u0002\r\u0005$x.\\5d\u0015\ri\u00171\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003vi&d'BAA\u0005\u0003\u0011Q\u0017M^1\n\u0007\u00055aP\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDq!!\u0005\u0001A\u0003%A0A\u0006oK^\u0014En\\2l\u0013\u0012\u0004\u0003\"CA\u000b\u0001\t\u0007I\u0011BA\f\u00039\u0011Gn\\2l\u000f\u0016tWM]1u_J,\"!!\u0007\u0011\u00079\tY\"C\u0002\u0002\u001e\t\u0011aB\u00117pG.<UM\\3sCR|'\u000f\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\r\u0003=\u0011Gn\\2l\u000f\u0016tWM]1u_J\u0004\u0003bBA\u0013\u0001\u0011\u0005\u0011qE\u0001\u000baV\u001c\bnU5oO2,G\u0003BA\u0015\u0003_\u00012!IA\u0016\u0013\r\tiC\t\u0002\u0005+:LG\u000fC\u0004\u00022\u0005\r\u0002\u0019\u0001\u0014\u0002\t\u0011\fG/\u0019\u0005\b\u0003k\u0001A\u0011AA\u001c\u0003=\u0001Xo\u001d5BeJ\f\u0017PQ;gM\u0016\u0014H\u0003CA\u0015\u0003s\t)&a\u0017\t\u0011\u0005m\u00121\u0007a\u0001\u0003{\t1\"\u0019:sCf\u0014UO\u001a4feB\"\u0011qHA)!\u0019\t\t%a\u0013\u0002P5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0004nkR\f'\r\\3\u000b\u0007\u0005%#%\u0001\u0006d_2dWm\u0019;j_:LA!!\u0014\u0002D\tY\u0011I\u001d:bs\n+hMZ3s!\ra\u0012\u0011\u000b\u0003\f\u0003'\nI$!A\u0001\u0002\u000b\u0005qDA\u0002`IMB\u0001\"a\u0016\u00024\u0001\u0007\u0011\u0011L\u0001\u000f[\u0016$\u0018\rZ1uC>\u0003H/[8o!\r\t3H\n\u0005\t\u0003;\n\u0019\u00041\u0001\u0002`\u0005i!\r\\8dW&#w\n\u001d;j_:\u0004B!I\u001e\u0002bA!\u00111MA5\u001b\t\t)GC\u0002\u0002h\u0019\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002l\u0005\u0015$!D*ue\u0016\fWN\u00117pG.LE\rC\u0004\u0002p\u0001!\t!!\u001d\u0002\u0019A,8\u000f[%uKJ\fGo\u001c:\u0015\u0011\u0005%\u00121OAL\u00033C\u0001\"!\u001e\u0002n\u0001\u0007\u0011qO\u0001\tSR,'/\u0019;peB\"\u0011\u0011PAJ!\u0019\tY(a#\u0002\u0012:!\u0011QPAD\u001d\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAAB-\u00051AH]8pizJ\u0011aI\u0005\u0004\u0003\u0013\u0013\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\u000byI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tII\t\t\u00049\u0005MEaCAK\u0003g\n\t\u0011!A\u0003\u0002}\u00111a\u0018\u00135\u0011!\t9&!\u001cA\u0002\u0005e\u0003\u0002CA/\u0003[\u0002\r!a\u0018\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \u0006I\u0001/^:i\u0005f$Xm\u001d\u000b\t\u0003S\t\t+!-\u00024\"A\u00111UAN\u0001\u0004\t)+A\u0003csR,7\u000f\u0005\u0003\u0002(\u00065VBAAU\u0015\u0011\tY+a\u0002\u0002\u00079Lw.\u0003\u0003\u00020\u0006%&A\u0003\"zi\u0016\u0014UO\u001a4fe\"A\u0011qKAN\u0001\u0004\tI\u0006\u0003\u0005\u0002^\u0005m\u0005\u0019AA0\u0011\u001d\t9\f\u0001C\u0001\u0003s\u000b!\u0003];tQ\u0006sGMU3q_J$(\t\\8dWRA\u0011\u0011FA^\u0003\u000b\f9\r\u0003\u0005\u0002>\u0006U\u0006\u0019AA`\u00035\u0011XmY3jm\u0016$'\t\\8dWB\u0019a\"!1\n\u0007\u0005\r'AA\u0007SK\u000e,\u0017N^3e\u00052|7m\u001b\u0005\t\u0003/\n)\f1\u0001\u0002Z!A\u0011QLA[\u0001\u0004\ty\u0006C\u0004\u0002L\u0002!\t!!4\u0002\u0017I,\u0007o\u001c:u\u000bJ\u0014xN\u001d\u000b\u0007\u0003S\ty-a5\t\u000f\u0005E\u0017\u0011\u001aa\u0001{\u00059Q.Z:tC\u001e,\u0007\u0002CAk\u0003\u0013\u0004\r!a6\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\u0005m\u0014\u0011\\\u0005\u0005\u00037\fyIA\u0005UQJ|w/\u00192mK\"9\u0011q\u001c\u0001\u0005R\u0005\u0005\u0018aB8o'R\f'\u000f\u001e\u000b\u0003\u0003SAq!!:\u0001\t#\n9/\u0001\u0004p]N#x\u000e\u001d\u000b\u0007\u0003S\tI/a;\t\u000f\u0005E\u00171\u001da\u0001{!A\u0011Q[Ar\u0001\u0004\ti\u000f\u0005\u0003\"w\u0005]\u0007bBAy\u0001\u0011E\u0013\u0011]\u0001\u0010_:\u0014VmY3jm\u0016\u00148\u000b^1si\"9\u0011Q\u001f\u0001\u0005R\u0005]\u0018AD8o%\u0016\u001cW-\u001b<feN#x\u000e\u001d\u000b\u0007\u0003S\tI0a?\t\u000f\u0005E\u00171\u001fa\u0001{!A\u0011Q[Az\u0001\u0004\ti\u000fC\u0004\u0002\u0000\u0002!IA!\u0001\u0002\u00179,\u0007\u0010\u001e\"m_\u000e\\\u0017\nZ\u000b\u0003\u0003CBqA!\u0002\u0001\t\u0013\u00119!\u0001\tdY\u0016\fg.\u001e9PY\u0012\u0014En\\2lgR!\u0011\u0011\u0006B\u0005\u0011!\u0011YAa\u0001A\u0002\t5\u0011!E2mK\u0006tW\u000f\u001d+ie\u0016\u001c\b\u000eV5nKB!!q\u0002B\t\u001b\u0005!\u0011b\u0001B\n\t\t!A+[7f\u0001")
public class ReceiverSupervisorImpl
extends ReceiverSupervisor {
    private final Receiver<?> receiver;
    private final SparkEnv env;
    private final ReceivedBlockHandler receivedBlockHandler;
    private final ActorSelection trackerActor;
    private final FiniteDuration askTimeout;
    private final ActorRef actor;
    private final AtomicLong newBlockId;
    private final BlockGenerator blockGenerator;

    private ReceivedBlockHandler receivedBlockHandler() {
        return this.receivedBlockHandler;
    }

    private ActorSelection trackerActor() {
        return this.trackerActor;
    }

    private FiniteDuration askTimeout() {
        return this.askTimeout;
    }

    private ActorRef actor() {
        return this.actor;
    }

    private AtomicLong newBlockId() {
        return this.newBlockId;
    }

    private BlockGenerator blockGenerator() {
        return this.blockGenerator;
    }

    @Override
    public void pushSingle(Object data) {
        this.blockGenerator().addData(data);
    }

    @Override
    public void pushArrayBuffer(ArrayBuffer<?> arrayBuffer, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ArrayBufferBlock(arrayBuffer), metadataOption, blockIdOption);
    }

    @Override
    public void pushIterator(Iterator<Object> iterator, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new IteratorBlock(iterator), metadataOption, blockIdOption);
    }

    @Override
    public void pushBytes(ByteBuffer bytes, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ByteBufferBlock(bytes), metadataOption, blockIdOption);
    }

    public void pushAndReportBlock(ReceivedBlock receivedBlock, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        int n;
        StreamBlockId blockId = (StreamBlockId)blockIdOption.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final StreamBlockId apply() {
                return this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ReceivedBlock receivedBlock2 = receivedBlock;
        if (receivedBlock2 instanceof ArrayBufferBlock) {
            ArrayBufferBlock arrayBufferBlock = (ArrayBufferBlock)receivedBlock2;
            ArrayBuffer<?> arrayBuffer = arrayBufferBlock.arrayBuffer();
            n = arrayBuffer.size();
        } else {
            n = -1;
        }
        int numRecords = n;
        long time = System.currentTimeMillis();
        ReceivedBlockStoreResult blockStoreResult = this.receivedBlockHandler().storeBlock(blockId, receivedBlock);
        this.logDebug((Function0<String>)new Serializable(this, blockId, time){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$1;
            private final long time$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pushed block ", " in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.time$1))}));
            }
            {
                this.blockId$1 = blockId$1;
                this.time$1 = time$1;
            }
        });
        ReceivedBlockInfo blockInfo = new ReceivedBlockInfo(this.streamId(), numRecords, blockStoreResult);
        Future future = AskableActorSelection$.MODULE$.ask$extension(package$.MODULE$.ask(this.trackerActor()), (Object)new AddBlock(blockInfo), Timeout$.MODULE$.durationToTimeout(this.askTimeout()));
        Await$.MODULE$.result((Awaitable)future, (Duration)this.askTimeout());
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reported block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
    }

    @Override
    public void reportError(String message, Throwable error) {
        String errorString = (String)Option$.MODULE$.apply((Object)error).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala(this.trackerActor());
        ReportError x$1 = new ReportError(this.streamId(), message, errorString);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        this.logWarning((Function0<String>)new Serializable(this, message, error){
            public static final long serialVersionUID = 0L;
            private final String message$1;
            private final Throwable error$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Reported error ").append((Object)this.message$1).append((Object)" - ").append((Object)this.error$1).toString();
            }
            {
                this.message$1 = message$1;
                this.error$1 = error$1;
            }
        });
    }

    @Override
    public void onStart() {
        this.blockGenerator().start();
    }

    @Override
    public void onStop(String message, Option<Throwable> error) {
        this.blockGenerator().stop();
        this.env.actorSystem().stop(this.actor());
    }

    @Override
    public void onReceiverStart() {
        RegisterReceiver msg = new RegisterReceiver(this.streamId(), this.receiver.getClass().getSimpleName(), Utils$.MODULE$.localHostName(), this.actor());
        Future future = AskableActorSelection$.MODULE$.ask$extension(package$.MODULE$.ask(this.trackerActor()), (Object)msg, Timeout$.MODULE$.durationToTimeout(this.askTimeout()));
        Await$.MODULE$.result((Awaitable)future, (Duration)this.askTimeout());
    }

    @Override
    public void onReceiverStop(String message, Option<Throwable> error) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Deregistering receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String errorString = (String)error.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        Future future = AskableActorSelection$.MODULE$.ask$extension(package$.MODULE$.ask(this.trackerActor()), (Object)new DeregisterReceiver(this.streamId(), message, errorString), Timeout$.MODULE$.durationToTimeout(this.askTimeout()));
        Await$.MODULE$.result((Awaitable)future, (Duration)this.askTimeout());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Stopped receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public StreamBlockId org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId() {
        return new StreamBlockId(this.streamId(), this.newBlockId().getAndIncrement());
    }

    public void org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$cleanupOldBlocks(Time cleanupThreshTime) {
        this.logDebug((Function0<String>)new Serializable(this, cleanupThreshTime){
            public static final long serialVersionUID = 0L;
            private final Time cleanupThreshTime$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning up blocks older then ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanupThreshTime$1}));
            }
            {
                this.cleanupThreshTime$1 = cleanupThreshTime$1;
            }
        });
        this.receivedBlockHandler().cleanupOldBlocks(cleanupThreshTime.milliseconds());
    }

    public ReceiverSupervisorImpl(Receiver<?> receiver, SparkEnv env, Configuration hadoopConf, Option<String> checkpointDirOption) {
        Logging logging;
        this.receiver = receiver;
        this.env = env;
        super(receiver, env.conf());
        if (env.conf().getBoolean("spark.streaming.receiver.writeAheadLog.enable", false)) {
            if (checkpointDirOption.isEmpty()) {
                throw new SparkException("Cannot enable receiver write-ahead log without checkpoint directory set. Please use streamingContext.checkpoint() to set the checkpoint directory. See documentation for more details.");
            }
            logging = new WriteAheadLogBasedBlockHandler(env.blockManager(), receiver.streamId(), receiver.storageLevel(), env.conf(), hadoopConf, (String)checkpointDirOption.get(), WriteAheadLogBasedBlockHandler$.MODULE$.$lessinit$greater$default$7());
        } else {
            logging = new BlockManagerBasedBlockHandler(env.blockManager(), receiver.storageLevel());
        }
        this.receivedBlockHandler = logging;
        String ip = env.conf().get("spark.driver.host", "localhost");
        int port = env.conf().getInt("spark.driver.port", 7077);
        String url = new StringOps(Predef$.MODULE$.augmentString("akka.tcp://%s@%s:%s/user/ReceiverTracker")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkEnv$.MODULE$.driverActorSystemName(), ip, BoxesRunTime.boxToInteger((int)port)}));
        this.trackerActor = env.actorSystem().actorSelection(url);
        this.askTimeout = AkkaUtils$.MODULE$.askTimeout(env.conf());
        this.actor = env.actorSystem().actorOf(Props$.MODULE$.apply((Function0)new $anonfun$1(this), ClassTag$.MODULE$.apply(Actor.class)), new StringBuilder().append((Object)"Receiver-").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
        this.newBlockId = new AtomicLong(System.currentTimeMillis());
        this.blockGenerator = new BlockGenerator(new $anon$2(this), this.streamId(), env.conf());
    }
}

