/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.spark.Logging;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockTracker;
import org.apache.spark.streaming.scheduler.ReceiverInfo;
import org.apache.spark.streaming.scheduler.ReceiverInfo$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverLauncher$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.SynchronizedMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t-e!B\u0001\u0003\u0001\u0011a!a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0004gN\u001c7\u0001\u0001\t\u00037qi\u0011\u0001B\u0005\u0003;\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n!c]6jaJ+7-Z5wKJd\u0015-\u001e8dQB\u0011a\"I\u0005\u0003E=\u0011qAQ8pY\u0016\fg\u000eC\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0004M!J\u0003CA\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\r$\u0001\u0004Q\u0002bB\u0010$!\u0003\u0005\r\u0001\t\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0003Q\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ngV\tQ\u0006E\u0002\u000f]AJ!aL\b\u0003\u000b\u0005\u0013(/Y=1\u0005EJ\u0004c\u0001\u001a6o5\t1G\u0003\u00025\t\u00059Am\u001d;sK\u0006l\u0017B\u0001\u001c4\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0011\u0001(\u000f\u0007\u0001\t%Q\u0004!!A\u0001\u0002\u000b\u0005\u0011IA\u0002`IYJ!\u0001P\u001f\u0002\u0011\u0011\ngn\u001c8gk:L!AP \u0002/\u001d,GOU3dK&4XM]%oaV$8\u000b\u001e:fC6\u001c\u0018B\u0001!\u0005\u00051!5\u000b\u001e:fC6<%/\u00199i#\t\u0011U\t\u0005\u0002\u000f\u0007&\u0011Ai\u0004\u0002\b\u001d>$\b.\u001b8h!\tqa)\u0003\u0002H\u001f\t\u0019\u0011I\\=\t\r%\u0003\u0001\u0015!\u0003.\u0003U\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ng\u0002Bqa\u0013\u0001C\u0002\u0013%A*\u0001\fsK\u000e,\u0017N^3s\u0013:\u0004X\u000f^*ue\u0016\fW.\u00133t+\u0005i\u0005c\u0001\b/\u001dB\u0011abT\u0005\u0003!>\u00111!\u00138u\u0011\u0019\u0011\u0006\u0001)A\u0005\u001b\u00069\"/Z2fSZ,'/\u00138qkR\u001cFO]3b[&#7\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003A\u0011XmY3jm\u0016\u0014X\t_3dkR|'/F\u0001W!\t9\u0006,D\u0001\u0001\r\u0011I\u0006\u0001\u0001.\u0003!I+7-Z5wKJd\u0015-\u001e8dQ\u0016\u00148C\u0001-\u000e\u0011\u0015!\u0003\f\"\u0001])\u00051\u0006\"\u00020Y\t\u0003y\u0016!B:uCJ$H#\u00011\u0011\u00059\t\u0017B\u00012\u0010\u0005\u0011)f.\u001b;\t\u000b\u0011DF\u0011A3\u0002\tM$x\u000e\u001d\u000b\u0003A\u001aDQaZ2A\u0002\u0001\n\u0001b\u001a:bG\u00164W\u000f\u001c\u0005\u0006Sb#IaX\u0001\u000fgR\f'\u000f\u001e*fG\u0016Lg/\u001a:t\u0011\u0015Y\u0007\f\"\u0003`\u00035\u0019Ho\u001c9SK\u000e,\u0017N^3sg\"9Q\u000e\u0017b\u0001\n\u0003q\u0017aA3omV\tq\u000e\u0005\u0002\u0015a&\u0011\u0011O\u0002\u0002\t'B\f'o[#om\"11\u000f\u0017Q\u0001\n=\fA!\u001a8wA!\u0012!/\u001e\t\u0003\u001dYL!a^\b\u0003\u0013Q\u0014\u0018M\\:jK:$\bbB=Y\u0001\u0004%IA_\u0001\beVtg.\u001b8h+\u0005\u0001\u0003b\u0002?Y\u0001\u0004%I!`\u0001\feVtg.\u001b8h?\u0012*\u0017\u000f\u0006\u0002a}\"9qp_A\u0001\u0002\u0004\u0001\u0013a\u0001=%c!9\u00111\u0001-!B\u0013\u0001\u0013\u0001\u0003:v]:Lgn\u001a\u0011)\u0007\u0005\u0005Q\u000f\u000b\u0003\u0002\u0002\u0005%\u0001c\u0001\b\u0002\f%\u0019\u0011QB\b\u0003\u0011Y|G.\u0019;jY\u0016D\u0011\"!\u0005Y\u0005\u0004%\t!a\u0005\u0002\rQD'/Z1e+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\t1\fgn\u001a\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u0019!\u0006N]3bI\"A\u0011q\u0005-!\u0002\u0013\t)\"A\u0004uQJ,\u0017\r\u001a\u0011)\u0007\u0005\u0015R\u000fC\u0004\u0002.\u0001\u0001\u000b\u0011\u0002,\u0002#I,7-Z5wKJ,\u00050Z2vi>\u0014\b\u0005C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024\u0005a!/Z2fSZ,'/\u00138g_V\u0011\u0011Q\u0007\n\u0007\u0003o\ty$!\u0016\u0007\u000f\u0005e\u00121\b\u0001\u00026\taAH]3gS:,W.\u001a8u}!A\u0011Q\b\u0001!\u0002\u0013\t)$A\u0007sK\u000e,\u0017N^3s\u0013:4w\u000e\t\t\b\u0003\u0003\nYETA(\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0013z\u0011AC2pY2,7\r^5p]&!\u0011QJA\"\u0005\u001dA\u0015m\u001d5NCB\u00042aJA)\u0013\r\t\u0019F\u0001\u0002\r%\u0016\u001cW-\u001b<fe&sgm\u001c\t\b\u0003\u0003\n9FTA(\u0013\u0011\tI&a\u0011\u0003\u001fMKhn\u00195s_:L'0\u001a3NCBD\u0011\"!\u0018\u0001\u0005\u0004%I!a\u0018\u0002)I,7-Z5wK\u0012\u0014En\\2l)J\f7m[3s+\t\t\t\u0007E\u0002(\u0003GJ1!!\u001a\u0003\u0005Q\u0011VmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6fe\"A\u0011\u0011\u000e\u0001!\u0002\u0013\t\t'A\u000bsK\u000e,\u0017N^3e\u00052|7m\u001b+sC\u000e\\WM\u001d\u0011\t\u0013\u00055\u0004A1A\u0005\n\u0005=\u0014a\u00037jgR,g.\u001a:CkN,\"!!\u001d\u0011\u0007\u001d\n\u0019(C\u0002\u0002v\t\u0011Ac\u0015;sK\u0006l\u0017N\\4MSN$XM\\3s\u0005V\u001c\b\u0002CA=\u0001\u0001\u0006I!!\u001d\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\t\u0013\u0005u\u0004\u00011A\u0005\n\u0005}\u0014!B1di>\u0014XCAAA!\u0011\t\u0019)a#\u000e\u0005\u0005\u0015%\u0002BA?\u0003\u000fS!!!#\u0002\t\u0005\\7.Y\u0005\u0005\u0003\u001b\u000b)I\u0001\u0005BGR|'OU3g\u0011%\t\t\n\u0001a\u0001\n\u0013\t\u0019*A\u0005bGR|'o\u0018\u0013fcR\u0019\u0001-!&\t\u0013}\fy)!AA\u0002\u0005\u0005\u0005\u0002CAM\u0001\u0001\u0006K!!!\u0002\r\u0005\u001cGo\u001c:!\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0019!\u0007\u0001\"\u0001\u0002 R\u0019\u0001-!)\t\r\u001d\fi\n1\u0001!\u0011\u001d\t)\u000b\u0001C\u0001\u0003O\u000bQ#\u00197m_\u000e\fG/\u001a\"m_\u000e\\7\u000fV8CCR\u001c\u0007\u000eF\u0002a\u0003SC\u0001\"a+\u0002$\u0002\u0007\u0011QV\u0001\nE\u0006$8\r\u001b+j[\u0016\u00042aGAX\u0013\r\t\t\f\u0002\u0002\u0005)&lW\rC\u0004\u00026\u0002!\t!a.\u0002!\u001d,GO\u00117pG.\u001cxJ\u001a\"bi\u000eDG\u0003BA]\u0003K\u0004r!a/\u0002B:\u000b9MD\u0002\u000f\u0003{K1!a0\u0010\u0003\u0019\u0001&/\u001a3fM&!\u00111YAc\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u007f{\u0001CBAe\u00033\fyN\u0004\u0003\u0002L\u0006Ug\u0002BAg\u0003'l!!a4\u000b\u0007\u0005E\u0017$\u0001\u0004=e>|GOP\u0005\u0002!%\u0019\u0011q[\b\u0002\u000fA\f7m[1hK&!\u00111\\Ao\u0005\r\u0019V-\u001d\u0006\u0004\u0003/|\u0001cA\u0014\u0002b&\u0019\u00111\u001d\u0002\u0003#I+7-Z5wK\u0012\u0014En\\2l\u0013:4w\u000e\u0003\u0005\u0002,\u0006M\u0006\u0019AAW\u0011\u001d\tI\u000f\u0001C\u0001\u0003W\f\u0011dZ3u\u00052|7m[:PM\n\u000bGo\u00195B]\u0012\u001cFO]3b[R1\u0011qYAw\u0003_D\u0001\"a+\u0002h\u0002\u0007\u0011Q\u0016\u0005\b\u0003c\f9\u000f1\u0001O\u0003!\u0019HO]3b[&#\u0007bBA{\u0001\u0011\u0005\u0011q_\u0001\u001bG2,\u0017M\\;q\u001f2$'\t\\8dWN\fe\u000e\u001a\"bi\u000eDWm\u001d\u000b\u0004A\u0006e\b\u0002CA~\u0003g\u0004\r!!,\u0002#\rdW-\u00198vaRC'/Z:i)&lW\rC\u0004\u0002\u0000\u0002!IA!\u0001\u0002!I,w-[:uKJ\u0014VmY3jm\u0016\u0014Hc\u00031\u0003\u0004\t\u0015!q\u0002B\n\u0005/Aq!!=\u0002~\u0002\u0007a\n\u0003\u0005\u0003\b\u0005u\b\u0019\u0001B\u0005\u0003\r!\u0018\u0010\u001d\t\u0005\u0003w\u0013Y!\u0003\u0003\u0003\u000e\u0005\u0015'AB*ue&tw\r\u0003\u0005\u0003\u0012\u0005u\b\u0019\u0001B\u0005\u0003\u0011Awn\u001d;\t\u0011\tU\u0011Q a\u0001\u0003\u0003\u000bQB]3dK&4XM]!di>\u0014\b\u0002\u0003B\r\u0003{\u0004\r!!!\u0002\rM,g\u000eZ3s\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?\t!\u0003Z3sK\u001eL7\u000f^3s%\u0016\u001cW-\u001b<feR9\u0001M!\t\u0003$\t\u001d\u0002bBAy\u00057\u0001\rA\u0014\u0005\t\u0005K\u0011Y\u00021\u0001\u0003\n\u00059Q.Z:tC\u001e,\u0007\u0002\u0003B\u0015\u00057\u0001\rA!\u0003\u0002\u000b\u0015\u0014(o\u001c:\t\u000f\t5\u0002\u0001\"\u0003\u00030\u0005A\u0011\r\u001a3CY>\u001c7\u000eF\u0002!\u0005cA\u0001Ba\r\u0003,\u0001\u0007\u0011q\\\u0001\u0012e\u0016\u001cW-\u001b<fI\ncwnY6J]\u001a|\u0007b\u0002B\u001c\u0001\u0011%!\u0011H\u0001\fe\u0016\u0004xN\u001d;FeJ|'\u000fF\u0004a\u0005w\u0011iDa\u0010\t\u000f\u0005E(Q\u0007a\u0001\u001d\"A!Q\u0005B\u001b\u0001\u0004\u0011I\u0001\u0003\u0005\u0003*\tU\u0002\u0019\u0001B\u0005\u0011\u0019\u0011\u0019\u0005\u0001C\u0001u\u0006!\u0002.Y:V]\u0006dGn\\2bi\u0016$'\t\\8dWN4aAa\u0012\u0001\t\t%#\u0001\u0006*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:BGR|'oE\u0003\u0003F5\u0011Y\u0005\u0005\u0003\u0002\u0004\n5\u0013\u0002\u0002B(\u0003\u000b\u0013Q!Q2u_JDq\u0001\nB#\t\u0003\u0011\u0019\u0006\u0006\u0002\u0003VA\u0019qK!\u0012\t\u0011\te#Q\tC\u0001\u00057\nqA]3dK&4X-\u0006\u0002\u0003^A)aBa\u0018FA&\u0019!\u0011M\b\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:<!B!\u001a\u0003\u0003\u0003E\t\u0001\u0002B4\u0003=\u0011VmY3jm\u0016\u0014HK]1dW\u0016\u0014\bcA\u0014\u0003j\u0019I\u0011AAA\u0001\u0012\u0003!!1N\n\u0004\u0005Sj\u0001b\u0002\u0013\u0003j\u0011\u0005!q\u000e\u000b\u0003\u0005OB!Ba\u001d\u0003jE\u0005I\u0011\u0001B;\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u000f\u0016\u0004A\te4F\u0001B>!\u0011\u0011iHa\"\u000e\u0005\t}$\u0002\u0002BA\u0005\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015u\"\u0001\u0006b]:|G/\u0019;j_:LAA!#\u0003\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ReceiverTracker
implements Logging {
    public final StreamingContext org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc;
    private final boolean skipReceiverLaunch;
    private final ReceiverInputDStream<?>[] org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams;
    private final int[] receiverInputStreamIds;
    private final ReceiverLauncher receiverExecutor;
    private final HashMap<Object, ReceiverInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo;
    private final ReceivedBlockTracker receivedBlockTracker;
    private final StreamingListenerBus listenerBus;
    private ActorRef actor;
    private transient Logger org$apache$spark$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return ReceiverTracker$.MODULE$.$lessinit$greater$default$2();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ReceiverInputDStream<?>[] org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams;
    }

    private int[] receiverInputStreamIds() {
        return this.receiverInputStreamIds;
    }

    private ReceiverLauncher receiverExecutor() {
        return this.receiverExecutor;
    }

    public HashMap<Object, ReceiverInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo;
    }

    private ReceivedBlockTracker receivedBlockTracker() {
        return this.receivedBlockTracker;
    }

    private StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    private ActorRef actor() {
        return this.actor;
    }

    private void actor_$eq(ActorRef x$1) {
        this.actor = x$1;
    }

    public synchronized void start() {
        if (this.actor() == null) {
            if (!Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).isEmpty()) {
                this.actor_$eq(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().actorSystem().actorOf(Props$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverTracker $outer;

                    public final ReceiverTrackerActor apply() {
                        return this.$outer.new ReceiverTrackerActor();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(ReceiverTrackerActor.class)), "ReceiverTracker"));
                if (!this.skipReceiverLaunch) {
                    this.receiverExecutor().start();
                }
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "ReceiverTracker started";
                    }
                });
            }
            return;
        }
        throw new SparkException("ReceiverTracker already started");
    }

    public synchronized void stop(boolean graceful) {
        if (!Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).isEmpty() && this.actor() != null) {
            if (!this.skipReceiverLaunch) {
                this.receiverExecutor().stop(graceful);
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().actorSystem().stop(this.actor());
            this.actor_$eq(null);
            this.receivedBlockTracker().stop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker stopped";
                }
            });
        }
    }

    public void allocateBlocksToBatch(Time batchTime) {
        if (Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).nonEmpty()) {
            this.receivedBlockTracker().allocateBlocksToBatch(batchTime);
        }
    }

    public Map<Object, Seq<ReceivedBlockInfo>> getBlocksOfBatch(Time batchTime) {
        return this.receivedBlockTracker().getBlocksOfBatch(batchTime);
    }

    public synchronized Seq<ReceivedBlockInfo> getBlocksOfBatchAndStream(Time batchTime, int streamId) {
        return this.receivedBlockTracker().getBlocksOfBatchAndStream(batchTime, streamId);
    }

    public void cleanupOldBlocksAndBatches(Time cleanupThreshTime) {
        this.receivedBlockTracker().cleanupOldBatches(cleanupThreshTime, false);
        if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf().getBoolean("spark.streaming.receiver.writeAheadLog.enable", false)) {
            this.logInfo((Function0<String>)new Serializable(this, cleanupThreshTime){
                public static final long serialVersionUID = 0L;
                private final Time cleanupThreshTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleanup old received batch data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanupThreshTime$1}));
                }
                {
                    this.cleanupThreshTime$1 = cleanupThreshTime$1;
                }
            });
            ((IterableLike)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<ActorRef> apply(ReceiverInfo info) {
                    return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)info.actor()));
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, cleanupThreshTime){
                public static final long serialVersionUID = 0L;
                private final Time cleanupThreshTime$1;

                public final void apply(ActorRef x$2) {
                    ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(x$2);
                    CleanupOldBlocks x$9 = new CleanupOldBlocks(this.cleanupThreshTime$1);
                    ActorRef x$10 = qual$1.$bang$default$2((Object)x$9);
                    qual$1.$bang((Object)x$9, x$10);
                }
                {
                    this.cleanupThreshTime$1 = cleanupThreshTime$1;
                }
            });
        }
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(int streamId, String typ, String host, ActorRef receiverActor, ActorRef sender) {
        if (Predef$.MODULE$.intArrayOps(this.receiverInputStreamIds()).contains((Object)BoxesRunTime.boxToInteger((int)streamId))) {
            ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)new ReceiverInfo(streamId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typ, BoxesRunTime.boxToInteger((int)streamId)})), receiverActor, true, host, ReceiverInfo$.MODULE$.apply$default$6(), ReceiverInfo$.MODULE$.apply$default$7()));
            this.listenerBus().post(new StreamingListenerReceiverStarted((ReceiverInfo)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            this.logInfo((Function0<String>)new Serializable(this, streamId, sender){
                public static final long serialVersionUID = 0L;
                private final int streamId$1;
                private final ActorRef sender$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Registered receiver for stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$1)).append((Object)" from ").append((Object)this.sender$1.path().address()).toString();
                }
                {
                    this.streamId$1 = streamId$1;
                    this.sender$1 = sender$1;
                }
            });
            return;
        }
        throw new SparkException(new StringBuilder().append((Object)"Register received for unexpected id ").append((Object)BoxesRunTime.boxToInteger((int)streamId)).toString());
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverInfo receiverInfo;
            block3: {
                block2: {
                    option = ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverInfo oldInfo = (ReceiverInfo)some.x();
                    Object x$11 = null;
                    boolean x$12 = false;
                    String x$13 = message;
                    String x$14 = error;
                    int x$15 = oldInfo.copy$default$1();
                    String x$16 = oldInfo.copy$default$2();
                    String x$17 = oldInfo.copy$default$5();
                    receiverInfo = oldInfo.copy(x$15, x$16, null, x$12, x$17, x$13, x$14);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                receiverInfo = new ReceiverInfo(streamId, "", null, false, "", message, error);
            }
            ReceiverInfo newReceiverInfo = receiverInfo;
            ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).$minus$eq((Object)BoxesRunTime.boxToInteger((int)streamId));
            this.listenerBus().post(new StreamingListenerReceiverStopped(newReceiverInfo));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logError((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$2;
                private final String messageWithError$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deregistered receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$2), this.messageWithError$1}));
                }
                {
                    this.streamId$2 = streamId$2;
                    this.messageWithError$1 = messageWithError$1;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(ReceivedBlockInfo receivedBlockInfo) {
        return this.receivedBlockTracker().addBlock(receivedBlockInfo);
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverInfo receiverInfo;
            block3: {
                block2: {
                    option = ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverInfo oldInfo = (ReceiverInfo)some.x();
                    String x$18 = message;
                    String x$19 = error;
                    int x$20 = oldInfo.copy$default$1();
                    String x$21 = oldInfo.copy$default$2();
                    ActorRef x$22 = oldInfo.copy$default$3();
                    boolean x$23 = oldInfo.copy$default$4();
                    String x$24 = oldInfo.copy$default$5();
                    receiverInfo = oldInfo.copy(x$20, x$21, x$22, x$23, x$24, x$18, x$19);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                receiverInfo = new ReceiverInfo(streamId, "", null, false, "", message, error);
            }
            ReceiverInfo newReceiverInfo = receiverInfo;
            ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverInfo);
            this.listenerBus().post(new StreamingListenerReceiverError((ReceiverInfo)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logWarning((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$3;
                private final String messageWithError$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reported by receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$3), this.messageWithError$2}));
                }
                {
                    this.streamId$3 = streamId$3;
                    this.messageWithError$2 = messageWithError$2;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean hasUnallocatedBlocks() {
        return this.receivedBlockTracker().hasUnallocatedReceivedBlocks();
    }

    public ReceiverTracker(StreamingContext ssc, boolean skipReceiverLaunch) {
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc = ssc;
        this.skipReceiverLaunch = skipReceiverLaunch;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams = ssc.graph().getReceiverInputStreams();
        this.receiverInputStreamIds = (int[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).map((Function1)new $anonfun$1(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.receiverExecutor = new ReceiverLauncher();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo = new $anon$1(this);
        this.receivedBlockTracker = new ReceivedBlockTracker(ssc.sparkContext().conf(), ssc.sparkContext().hadoopConfiguration(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(this.receiverInputStreamIds()), ssc.scheduler().clock(), (Option<String>)Option$.MODULE$.apply((Object)ssc.checkpointDir()));
        this.listenerBus = ssc.scheduler().listenerBus();
        this.actor = null;
    }

    public class ReceiverLauncher {
        private final transient SparkEnv env;
        private volatile transient boolean running;
        private final transient Thread thread;

        public SparkEnv env() {
            return this.env;
        }

        private boolean running() {
            return this.running;
        }

        private void running_$eq(boolean x$1) {
            this.running = x$1;
        }

        public Thread thread() {
            return this.thread;
        }

        public void start() {
            this.thread().start();
        }

        /*
         * WARNING - void declaration
         */
        public void stop(boolean graceful) {
            this.stopReceivers();
            this.thread().join(10000L);
            if (graceful) {
                int pollTime = 100;
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Waiting for receiver job to terminate gracefully";
                    }
                });
                while (true) {
                    void var2_2;
                    if (this.done$1()) {
                        this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Waited for receiver job to terminate gracefully";
                            }
                        });
                        break;
                    }
                    Thread.sleep((long)var2_2);
                }
            }
            if (((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).isEmpty()) {
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "All of the receivers have deregistered successfully";
                    }
                });
            } else {
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverLauncher $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Not all of the receivers have deregistered, ").append(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$startReceivers() {
            RDD rDD;
            Receiver[] receivers = (Receiver[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Receiver<?> apply(ReceiverInputDStream<?> nis) {
                    void var2_2;
                    Receiver<?> rcvr = nis.getReceiver();
                    rcvr.setReceiverId(nis.id());
                    return var2_2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Receiver.class)));
            boolean hasLocationPreferences = BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Receiver<?> x$3) {
                    return x$3.preferredLocation().isDefined();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()))).reduce((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(boolean x$4, boolean x$5) {
                    return x$4 && x$5;
                }
            }));
            if (hasLocationPreferences) {
                Tuple2[] receiversWithPreferences = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Receiver<Object>, Seq<String>> apply(Receiver<?> r) {
                        return new Tuple2(r, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)r.preferredLocation().get()})));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receiversWithPreferences), ClassTag$.MODULE$.apply(Receiver.class));
            } else {
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receivers), Predef$.MODULE$.refArrayOps((Object[])receivers).size(), ClassTag$.MODULE$.apply(Receiver.class));
            }
            RDD tempRDD = rDD;
            Option checkpointDirOption = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.checkpointDir());
            SerializableWritable serializableHadoopConf = new SerializableWritable((Writable)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().hadoopConfiguration());
            Serializable startReceiver2 = new Serializable(this, checkpointDirOption, serializableHadoopConf){
                public static final long serialVersionUID = 0L;
                private final Option checkpointDirOption$1;
                private final SerializableWritable serializableHadoopConf$1;

                public final void apply(Iterator<Receiver<?>> iterator) {
                    if (iterator.hasNext()) {
                        Receiver receiver = (Receiver)iterator.next();
                        ReceiverSupervisorImpl supervisor2 = new ReceiverSupervisorImpl(receiver, SparkEnv$.MODULE$.get(), (Configuration)this.serializableHadoopConf$1.value(), (Option<String>)this.checkpointDirOption$1);
                        supervisor2.start();
                        supervisor2.awaitTermination();
                        return;
                    }
                    throw new SparkException("Could not start receiver as object not found.");
                }
                {
                    this.checkpointDirOption$1 = checkpointDirOption$1;
                    this.serializableHadoopConf$1 = serializableHadoopConf$1;
                }
            };
            Object object = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().isLocal() ? BoxedUnit.UNIT : SparkContext$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(int x) {
                    return new Tuple2.mcII.sp(x, 1);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$6, int x$7) {
                    return this.apply$mcIII$sp(x$6, x$7);
                }

                public int apply$mcIII$sp(int x$6, int x$7) {
                    return x$6 + x$7;
                }
            }, 20).collect();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this, receivers){
                public static final long serialVersionUID = 0L;
                private final Receiver[] receivers$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Starting ").append((Object)BoxesRunTime.boxToInteger((int)this.receivers$1.length)).append((Object)" receivers").toString();
                }
                {
                    this.receivers$1 = receivers$1;
                }
            });
            this.running_$eq(true);
            SparkContext qual$2 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext();
            Serializable x$25 = startReceiver2;
            boolean x$26 = qual$2.clean$default$2();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().runJob(tempRDD, (Function1)qual$2.clean((Object)x$25, x$26), ClassTag$.MODULE$.Unit());
            this.running_$eq(false);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "All of the receivers have been terminated";
                }
            });
        }

        private void stopReceivers() {
            ((IterableLike)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<ActorRef> apply(ReceiverInfo info) {
                    return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)info.actor()));
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ActorRef x$8) {
                    ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(x$8);
                    StopReceiver$ x$27 = StopReceiver$.MODULE$;
                    ActorRef x$28 = qual$3.$bang$default$2((Object)x$27);
                    qual$3.$bang((Object)x$27, x$28);
                }
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverLauncher $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Sent stop signal to all ").append((Object)BoxesRunTime.boxToInteger((int)((SynchronizedMap)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).size())).append((Object)" receivers").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer() {
            return ReceiverTracker.this;
        }

        private final boolean done$1() {
            return ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).isEmpty() && !this.running();
        }

        public ReceiverLauncher() {
            if (ReceiverTracker.this == null) {
                throw new NullPointerException();
            }
            this.env = ReceiverTracker.this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env();
            this.running = false;
            this.thread = new ReceiverLauncher$$anon$2(this);
        }
    }

    public class ReceiverTrackerActor
    implements Actor {
        private final ActorContext context;
        private final ActorRef self;

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public final ActorRef sender() {
            return Actor.class.sender((Actor)this);
        }

        public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
            Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
        }

        public void aroundPreStart() {
            Actor.class.aroundPreStart((Actor)this);
        }

        public void aroundPostStop() {
            Actor.class.aroundPostStop((Actor)this);
        }

        public void aroundPreRestart(Throwable reason, Option<Object> message) {
            Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
        }

        public void aroundPostRestart(Throwable reason) {
            Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.class.supervisorStrategy((Actor)this);
        }

        public void preStart() throws Exception {
            Actor.class.preStart((Actor)this);
        }

        public void postStop() throws Exception {
            Actor.class.postStop((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.class.preRestart((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.class.postRestart((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.class.unhandled((Actor)this, (Object)message);
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerActor $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver2 = (RegisterReceiver)A1;
                        int streamId = registerReceiver2.streamId();
                        String typ = registerReceiver2.typ();
                        String host = registerReceiver2.host();
                        ActorRef receiverActor = registerReceiver2.receiverActor();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(streamId, typ, host, receiverActor, this.$outer.sender());
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof AddBlock) {
                        AddBlock addBlock2 = (AddBlock)A1;
                        ReceivedBlockInfo receivedBlockInfo = addBlock2.receivedBlockInfo();
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(receivedBlockInfo)), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ReportError) {
                        ReportError reportError2 = (ReportError)A1;
                        int streamId = reportError2.streamId();
                        String message = reportError2.message();
                        String error = reportError2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(streamId, message, error);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver2 = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver2.streamId();
                        String message = deregisterReceiver2.msg();
                        String error = deregisterReceiver2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(streamId, message, error);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)BoxesRunTime.boxToBoolean((boolean)true), this.$outer.self());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof RegisterReceiver ? true : (object instanceof AddBlock ? true : (object instanceof ReportError ? true : object instanceof DeregisterReceiver));
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerActor$$$outer() {
            return ReceiverTracker.this;
        }

        public ReceiverTrackerActor() {
            if (ReceiverTracker.this == null) {
                throw new NullPointerException();
            }
            Actor.class.$init$((Actor)this);
        }
    }
}

