/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGenerator$Block$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.RateLimiter;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t%e!B\u0001\u0003\u0001\u0011a!A\u0004\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0006\u0003\u0007\u0011\t\u0001B]3dK&4XM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0012!\tqq\"D\u0001\u0003\u0013\t\u0001\"AA\u0006SCR,G*[7ji\u0016\u0014\bC\u0001\n\u0014\u001b\u00051\u0011B\u0001\u000b\u0007\u0005\u001daunZ4j]\u001eD\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\tY&\u001cH/\u001a8fe\u000e\u0001\u0001C\u0001\b\u001a\u0013\tQ\"A\u0001\fCY>\u001c7nR3oKJ\fGo\u001c:MSN$XM\\3s\u0011!a\u0002A!A!\u0002\u0013i\u0012A\u0003:fG\u0016Lg/\u001a:JIB\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t\u0019\u0011J\u001c;\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\nAaY8oMB\u0011!CJ\u0005\u0003O\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000b%\u0002A\u0011\u0001\u0016\u0002\rqJg.\u001b;?)\u0011YC&\f\u0018\u0011\u00059\u0001\u0001\"\u0002\f)\u0001\u0004A\u0002\"\u0002\u000f)\u0001\u0004i\u0002\"\u0002\u0013)\u0001\u0004)c\u0001\u0002\u0019\u0001\tF\u0012QA\u00117pG.\u001cBa\f\u001a6qA\u0011adM\u0005\u0003i}\u0011a!\u00118z%\u00164\u0007C\u0001\u00107\u0013\t9tDA\u0004Qe>$Wo\u0019;\u0011\u0005yI\u0014B\u0001\u001e \u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!atF!f\u0001\n\u0003i\u0014AA5e+\u0005q\u0004CA C\u001b\u0005\u0001%BA!\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016L!a\u0011!\u0003\u001bM#(/Z1n\u00052|7m[%e\u0011!)uF!E!\u0002\u0013q\u0014aA5eA!Aqi\fBK\u0002\u0013\u0005\u0001*\u0001\u0004ck\u001a4WM]\u000b\u0002\u0013B\u0019!jT)\u000e\u0003-S!\u0001T'\u0002\u000f5,H/\u00192mK*\u0011ajH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001)L\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005y\u0011\u0016BA* \u0005\r\te.\u001f\u0005\t+>\u0012\t\u0012)A\u0005\u0013\u00069!-\u001e4gKJ\u0004\u0003\"B\u00150\t\u00039Fc\u0001-[7B\u0011\u0011lL\u0007\u0002\u0001!)AH\u0016a\u0001}!)qI\u0016a\u0001\u0013\"9QlLA\u0001\n\u0003q\u0016\u0001B2paf$2\u0001W0a\u0011\u001daD\f%AA\u0002yBqa\u0012/\u0011\u0002\u0003\u0007\u0011\nC\u0004c_E\u0005I\u0011A2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAM\u000b\u0002?K.\na\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003W~\t!\"\u00198o_R\fG/[8o\u0013\ti\u0007NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dqa\\\u0018\u0012\u0002\u0013\u0005\u0001/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003ET#!S3\t\u000fM|\u0013\u0011!C!i\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012!\u001e\t\u0003mnl\u0011a\u001e\u0006\u0003qf\fA\u0001\\1oO*\t!0\u0001\u0003kCZ\f\u0017B\u0001?x\u0005\u0019\u0019FO]5oO\"9apLA\u0001\n\u0003y\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#A\u000f\t\u0013\u0005\rq&!A\u0005\u0002\u0005\u0015\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004#\u0006\u001d\u0001\"CA\u0005\u0003\u0003\t\t\u00111\u0001\u001e\u0003\rAH%\r\u0005\n\u0003\u001by\u0013\u0011!C!\u0003\u001f\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003#\u0001R!a\u0005\u0002\u0016Ek\u0011!T\u0005\u0004\u0003/i%\u0001C%uKJ\fGo\u001c:\t\u0013\u0005mq&!A\u0005\u0002\u0005u\u0011\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0011Q\u0005\t\u0004=\u0005\u0005\u0012bAA\u0012?\t9!i\\8mK\u0006t\u0007\"CA\u0005\u00033\t\t\u00111\u0001R\u0011%\tIcLA\u0001\n\u0003\nY#\u0001\u0005iCND7i\u001c3f)\u0005i\u0002\"CA\u0018_\u0005\u0005I\u0011IA\u0019\u0003!!xn\u0015;sS:<G#A;\t\u0013\u0005Ur&!A\u0005B\u0005]\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002 \u0005e\u0002\"CA\u0005\u0003g\t\t\u00111\u0001R\u000f%\ti\u0004AA\u0001\u0012\u0013\ty$A\u0003CY>\u001c7\u000eE\u0002Z\u0003\u00032\u0001\u0002\r\u0001\u0002\u0002#%\u00111I\n\u0006\u0003\u0003\n)\u0005\u000f\t\b\u0003\u000f\niEP%Y\u001b\t\tIEC\u0002\u0002L}\tqA];oi&lW-\u0003\u0003\u0002P\u0005%#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9\u0011&!\u0011\u0005\u0002\u0005MCCAA \u0011)\ty#!\u0011\u0002\u0002\u0013\u0015\u0013\u0011\u0007\u0005\u000b\u00033\n\t%!A\u0005\u0002\u0006m\u0013!B1qa2LH#\u0002-\u0002^\u0005}\u0003B\u0002\u001f\u0002X\u0001\u0007a\b\u0003\u0004H\u0003/\u0002\r!\u0013\u0005\u000b\u0003G\n\t%!A\u0005\u0002\u0006\u0015\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\n\u0019\bE\u0003\u001f\u0003S\ni'C\u0002\u0002l}\u0011aa\u00149uS>t\u0007#\u0002\u0010\u0002pyJ\u0015bAA9?\t1A+\u001e9mKJB\u0011\"!\u001e\u0002b\u0005\u0005\t\u0019\u0001-\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002z\u0005\u0005\u0013\u0011!C\u0005\u0003w\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0010\t\u0004m\u0006}\u0014bAAAo\n1qJ\u00196fGRD\u0011\"!\"\u0001\u0005\u0004%I!a\"\u0002\u000b\rdwnY6\u0016\u0005\u0005%\u0005\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=e!\u0001\u0003vi&d\u0017\u0002BAJ\u0003\u001b\u00131bU=ti\u0016l7\t\\8dW\"A\u0011q\u0013\u0001!\u0002\u0013\tI)\u0001\u0004dY>\u001c7\u000e\t\u0005\n\u00037\u0003!\u0019!C\u0005\u0003;\u000bQB\u00197pG.Le\u000e^3sm\u0006dWCAAP!\rq\u0012\u0011U\u0005\u0004\u0003G{\"\u0001\u0002'p]\u001eD\u0001\"a*\u0001A\u0003%\u0011qT\u0001\u000fE2|7m[%oi\u0016\u0014h/\u00197!\u0011%\tY\u000b\u0001b\u0001\n\u0013\ti+\u0001\ncY>\u001c7.\u00138uKJ4\u0018\r\u001c+j[\u0016\u0014XCAAX!\u0011\t\t,!.\u000e\u0005\u0005M&bAAH\t%!\u0011qWAZ\u00059\u0011VmY;se&tw\rV5nKJD\u0001\"a/\u0001A\u0003%\u0011qV\u0001\u0014E2|7m[%oi\u0016\u0014h/\u00197US6,'\u000f\t\u0005\t\u0003\u007f\u0003!\u0019!C\u0005\u007f\u0006q!\r\\8dWF+X-^3TSj,\u0007bBAb\u0001\u0001\u0006I!H\u0001\u0010E2|7m[)vKV,7+\u001b>fA!I\u0011q\u0019\u0001C\u0002\u0013%\u0011\u0011Z\u0001\u0011E2|7m[:G_J\u0004Vo\u001d5j]\u001e,\"!a3\u0011\u000b\u00055\u0017Q\u001b-\u000e\u0005\u0005='\u0002BAi\u0003'\f!bY8oGV\u0014(/\u001a8u\u0015\r\ty)_\u0005\u0005\u0003/\fyM\u0001\nBeJ\f\u0017P\u00117pG.LgnZ)vKV,\u0007\u0002CAn\u0001\u0001\u0006I!a3\u0002#\tdwnY6t\r>\u0014\b+^:iS:<\u0007\u0005C\u0005\u0002`\u0002\u0011\r\u0011\"\u0003\u0002b\u0006\u0011\"\r\\8dWB+8\u000f[5oORC'/Z1e+\t\t\u0019\u000fE\u0002w\u0003KL1!a:x\u0005\u0019!\u0006N]3bI\"A\u00111\u001e\u0001!\u0002\u0013\t\u0019/A\ncY>\u001c7\u000eU;tQ&tw\r\u00165sK\u0006$\u0007\u0005C\u0004\u0002p\u0002!\t!!=\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005M\bc\u0001\u0010\u0002v&\u0019\u0011q_\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003w\u0004A\u0011AAy\u0003\u0011\u0019Ho\u001c9\t\u000f\u0005}\b\u0001\"\u0001\u0003\u0002\u00059\u0011\r\u001a3ECR\fG\u0003BAz\u0005\u0007AqA!\u0002\u0002~\u0002\u0007\u0011+\u0001\u0003eCR\f\u0007b\u0002B\u0005\u0001\u0011\u0005!1B\u0001\u0014C\u0012$G)\u0019;b/&$\bnQ1mY\n\f7m\u001b\u000b\u0007\u0003g\u0014iAa\u0004\t\u000f\t\u0015!q\u0001a\u0001#\"9!\u0011\u0003B\u0004\u0001\u0004\t\u0016\u0001C7fi\u0006$\u0017\r^1\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018\u0005\u0019R\u000f\u001d3bi\u0016\u001cUO\u001d:f]R\u0014UO\u001a4feR!\u00111\u001fB\r\u0011!\u0011YBa\u0005A\u0002\u0005}\u0015\u0001\u0002;j[\u0016DqAa\b\u0001\t\u0013\t\t0A\tlK\u0016\u0004\b+^:iS:<'\t\\8dWNDqAa\t\u0001\t\u0013\u0011)#A\u0006sKB|'\u000f^#se>\u0014HCBAz\u0005O\u00119\u0004\u0003\u0005\u0003*\t\u0005\u0002\u0019\u0001B\u0016\u0003\u001diWm]:bO\u0016\u0004BA!\f\u000349\u0019aDa\f\n\u0007\tEr$\u0001\u0004Qe\u0016$WMZ\u0005\u0004y\nU\"b\u0001B\u0019?!A!\u0011\bB\u0011\u0001\u0004\u0011Y$A\u0001u!\u0011\u0011iD!\u0014\u000f\t\t}\"\u0011\n\b\u0005\u0005\u0003\u00129%\u0004\u0002\u0003D)\u0019!QI\f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013b\u0001B&?\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B(\u0005#\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\t-s\u0004C\u0004\u0003V\u0001!IAa\u0016\u0002\u0013A,8\u000f\u001b\"m_\u000e\\G\u0003BAz\u00053BqAa\u0017\u0003T\u0001\u0007\u0001,A\u0003cY>\u001c7\u000e\u0003\u0005\u0003`\u0001\u0001\r\u0011\"\u0003I\u00035\u0019WO\u001d:f]R\u0014UO\u001a4fe\"I!1\r\u0001A\u0002\u0013%!QM\u0001\u0012GV\u0014(/\u001a8u\u0005V4g-\u001a:`I\u0015\fH\u0003BAz\u0005OB\u0011\"!\u0003\u0003b\u0005\u0005\t\u0019A%\t\u000f\t-\u0004\u0001)Q\u0005\u0013\u0006q1-\u001e:sK:$()\u001e4gKJ\u0004\u0003\u0006\u0002B5\u0005_\u00022A\bB9\u0013\r\u0011\u0019h\b\u0002\tm>d\u0017\r^5mK\"I!q\u000f\u0001A\u0002\u0013%!\u0011P\u0001\bgR|\u0007\u000f]3e+\t\ty\u0002C\u0005\u0003~\u0001\u0001\r\u0011\"\u0003\u0003\u0000\u0005Y1\u000f^8qa\u0016$w\fJ3r)\u0011\t\u0019P!!\t\u0015\u0005%!1PA\u0001\u0002\u0004\ty\u0002\u0003\u0005\u0003\u0006\u0002\u0001\u000b\u0015BA\u0010\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003\u0006\u0002BB\u0005_\u0002")
public class BlockGenerator
extends RateLimiter {
    private final BlockGeneratorListener listener;
    private final int receiverId;
    private final SystemClock clock;
    private final long blockInterval;
    private final RecurringTimer blockIntervalTimer;
    private final int blockQueueSize;
    private final ArrayBlockingQueue<Block> org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing;
    private final Thread blockPushingThread;
    private volatile ArrayBuffer<Object> currentBuffer;
    private volatile boolean stopped;
    private volatile BlockGenerator$Block$ Block$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockGenerator$Block$ org$apache$spark$streaming$receiver$BlockGenerator$$Block$lzycompute() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.Block$module != null) return this.Block$module;
            this.Block$module = new BlockGenerator$Block$(this);
            return this.Block$module;
        }
    }

    public BlockGenerator$Block$ org$apache$spark$streaming$receiver$BlockGenerator$$Block() {
        return this.Block$module == null ? this.org$apache$spark$streaming$receiver$BlockGenerator$$Block$lzycompute() : this.Block$module;
    }

    private SystemClock clock() {
        return this.clock;
    }

    private long blockInterval() {
        return this.blockInterval;
    }

    private RecurringTimer blockIntervalTimer() {
        return this.blockIntervalTimer;
    }

    private int blockQueueSize() {
        return this.blockQueueSize;
    }

    public ArrayBlockingQueue<Block> org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing() {
        return this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing;
    }

    private Thread blockPushingThread() {
        return this.blockPushingThread;
    }

    private ArrayBuffer<Object> currentBuffer() {
        return this.currentBuffer;
    }

    private void currentBuffer_$eq(ArrayBuffer<Object> x$1) {
        this.currentBuffer = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public void start() {
        this.blockIntervalTimer().start();
        this.blockPushingThread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Started BlockGenerator";
            }
        });
    }

    public void stop() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping BlockGenerator";
            }
        });
        this.blockIntervalTimer().stop(false);
        this.stopped_$eq(true);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting for block pushing thread";
            }
        });
        this.blockPushingThread().join();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped BlockGenerator";
            }
        });
    }

    public void addData(Object data) {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            this.waitToPush();
            this.currentBuffer().$plus$eq(data);
            return;
        }
    }

    public synchronized void addDataWithCallback(Object data, Object metadata) {
        this.waitToPush();
        this.currentBuffer().$plus$eq(data);
        this.listener.onAddData(data, metadata);
    }

    public synchronized void org$apache$spark$streaming$receiver$BlockGenerator$$updateCurrentBuffer(long time) {
        try {
            ArrayBuffer<Object> newBlockBuffer = this.currentBuffer();
            this.currentBuffer_$eq((ArrayBuffer<Object>)new ArrayBuffer());
            if (newBlockBuffer.size() > 0) {
                StreamBlockId blockId = new StreamBlockId(this.receiverId, time - this.blockInterval());
                Block newBlock = new Block(this, blockId, newBlockBuffer);
                this.listener.onGenerateBlock(blockId);
                this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().put(newBlock);
                this.logDebug((Function0<String>)new Serializable(this, newBlockBuffer, blockId){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer newBlockBuffer$1;
                    private final StreamBlockId blockId$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Last element in ").append((Object)this.blockId$1).append((Object)" is ").append(this.newBlockBuffer$1.last()).toString();
                    }
                    {
                        this.newBlockBuffer$1 = newBlockBuffer$1;
                        this.blockId$1 = blockId$1;
                    }
                });
            }
        }
        catch (Exception exception) {
            this.reportError("Error in block updating thread", exception);
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Block updating timer thread was interrupted";
                }
            });
        }
    }

    public void org$apache$spark$streaming$receiver$BlockGenerator$$keepPushingBlocks() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Started block pushing thread";
            }
        });
        try {
            block8: {
                Option option;
                while (true) {
                    BoxedUnit boxedUnit;
                    if (this.stopped()) {
                        this.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ BlockGenerator $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Pushing out the last ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().size())).append((Object)" blocks").toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        while (true) {
                            if (!this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().isEmpty()) {
                                this.logDebug((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Getting block ";
                                    }
                                });
                                Block block = this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().take();
                                this.pushBlock(block);
                                this.logInfo((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ BlockGenerator $outer;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Blocks left to push ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().size())).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                continue;
                            }
                            break block8;
                            break;
                        }
                    }
                    option = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().poll(100L, TimeUnit.MILLISECONDS));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Block block = (Block)some.x();
                        this.pushBlock(block);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break;
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopped block pushing thread";
                }
            });
        }
        catch (Exception exception) {
            this.reportError("Error in block pushing thread", exception);
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Block pushing thread was interrupted";
                }
            });
        }
    }

    private void reportError(String message, Throwable t) {
        this.logError((Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        }, t);
        this.listener.onError(message, t);
    }

    private void pushBlock(Block block) {
        this.listener.onPushBlock(block.id(), block.buffer());
        this.logInfo((Function0<String>)new Serializable(this, block){
            public static final long serialVersionUID = 0L;
            private final Block block$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Pushed block ").append((Object)this.block$1.id()).toString();
            }
            {
                this.block$1 = block$1;
            }
        });
    }

    public BlockGenerator(BlockGeneratorListener listener, int receiverId, SparkConf conf) {
        this.listener = listener;
        this.receiverId = receiverId;
        super(conf);
        this.clock = new SystemClock();
        this.blockInterval = conf.getLong("spark.streaming.blockInterval", 200L);
        this.blockIntervalTimer = new RecurringTimer((Clock)this.clock(), this.blockInterval(), (Function1<Object, BoxedUnit>)new $anonfun$1(this), "BlockGenerator");
        this.blockQueueSize = conf.getInt("spark.streaming.blockQueueSize", 10);
        this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing = new ArrayBlockingQueue(this.blockQueueSize());
        this.blockPushingThread = new $anon$1(this);
        this.currentBuffer = new ArrayBuffer();
        this.stopped = false;
    }

    public class Block
    implements Product,
    Serializable {
        private final StreamBlockId id;
        private final ArrayBuffer<Object> buffer;
        public final /* synthetic */ BlockGenerator $outer;

        public StreamBlockId id() {
            return this.id;
        }

        public ArrayBuffer<Object> buffer() {
            return this.buffer;
        }

        public Block copy(StreamBlockId id, ArrayBuffer<Object> buffer) {
            return new Block(this.org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer(), id, buffer);
        }

        public StreamBlockId copy$default$1() {
            return this.id();
        }

        public ArrayBuffer<Object> copy$default$2() {
            return this.buffer();
        }

        public String productPrefix() {
            return "Block";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            StreamBlockId streamBlockId;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    streamBlockId = this.buffer();
                    break;
                }
                case 0: {
                    streamBlockId = this.id();
                }
            }
            return streamBlockId;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Block;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Block)) return false;
            boolean bl = true;
            if (!bl) return false;
            Block block = (Block)x$1;
            StreamBlockId streamBlockId = this.id();
            StreamBlockId streamBlockId2 = block.id();
            if (streamBlockId == null) {
                if (streamBlockId2 != null) {
                    return false;
                }
            } else if (!streamBlockId.equals(streamBlockId2)) return false;
            ArrayBuffer<Object> arrayBuffer = this.buffer();
            ArrayBuffer<Object> arrayBuffer2 = block.buffer();
            if (arrayBuffer == null) {
                if (arrayBuffer2 != null) {
                    return false;
                }
            } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
            if (!block.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BlockGenerator org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer() {
            return this.$outer;
        }

        public Block(BlockGenerator $outer, StreamBlockId id, ArrayBuffer<Object> buffer) {
            this.id = id;
            this.buffer = buffer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

