/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)3a!\u0001\u0002\u0002\u0002\ta!a\u0003*bi\u0016d\u0015.\\5uKJT!a\u0001\u0003\u0002\u0011I,7-Z5wKJT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Ui\u0011AB\u0005\u0003-\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011AcG\u0005\u00039\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\t\u0001#\u0005\u0005\u0002\"\u00015\t!\u0001C\u0003\u0019;\u0001\u0007!\u0004C\u0004%\u0001\u0001\u0007I\u0011B\u0013\u0002\u00191\f7\u000f^*z]\u000e$\u0016.\\3\u0016\u0003\u0019\u0002\"AD\u0014\n\u0005!z!\u0001\u0002'p]\u001eDqA\u000b\u0001A\u0002\u0013%1&\u0001\tmCN$8+\u001f8d)&lWm\u0018\u0013fcR\u0011Af\f\t\u0003\u001d5J!AL\b\u0003\tUs\u0017\u000e\u001e\u0005\ba%\n\t\u00111\u0001'\u0003\rAH%\r\u0005\u0007e\u0001\u0001\u000b\u0015\u0002\u0014\u0002\u001b1\f7\u000f^*z]\u000e$\u0016.\\3!\u0011\u001d!\u0004\u00011A\u0005\n\u0015\n\u0001$\\3tg\u0006<Wm],sSR$XM\\*j]\u000e,7+\u001f8d\u0011\u001d1\u0004\u00011A\u0005\n]\nA$\\3tg\u0006<Wm],sSR$XM\\*j]\u000e,7+\u001f8d?\u0012*\u0017\u000f\u0006\u0002-q!9\u0001'NA\u0001\u0002\u00041\u0003B\u0002\u001e\u0001A\u0003&a%A\rnKN\u001c\u0018mZ3t/JLG\u000f^3o'&t7-Z*z]\u000e\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%I!P\u0001\fI\u0016\u001c\u0018N]3e%\u0006$X-F\u0001?!\tqq(\u0003\u0002A\u001f\t\u0019\u0011J\u001c;\t\r\t\u0003\u0001\u0015!\u0003?\u00031!Wm]5sK\u0012\u0014\u0016\r^3!\u0011\u001d!\u0005A1A\u0005\n\u0015\nQbU-O\u0007~Ke\nV#S-\u0006c\u0005B\u0002$\u0001A\u0003%a%\u0001\bT3:\u001bu,\u0013(U\u000bJ3\u0016\t\u0014\u0011\t\u000b!\u0003A\u0011A%\u0002\u0015]\f\u0017\u000e\u001e+p!V\u001c\b\u000eF\u0001-\u0001")
public abstract class RateLimiter
implements Logging {
    private long lastSyncTime;
    private long messagesWrittenSinceSync;
    private final int org$apache$spark$streaming$receiver$RateLimiter$$desiredRate;
    private final long SYNC_INTERVAL;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private long lastSyncTime() {
        return this.lastSyncTime;
    }

    private void lastSyncTime_$eq(long x$1) {
        this.lastSyncTime = x$1;
    }

    private long messagesWrittenSinceSync() {
        return this.messagesWrittenSinceSync;
    }

    private void messagesWrittenSinceSync_$eq(long x$1) {
        this.messagesWrittenSinceSync = x$1;
    }

    public int org$apache$spark$streaming$receiver$RateLimiter$$desiredRate() {
        return this.org$apache$spark$streaming$receiver$RateLimiter$$desiredRate;
    }

    private long SYNC_INTERVAL() {
        return this.SYNC_INTERVAL;
    }

    public void waitToPush() {
        if (this.org$apache$spark$streaming$receiver$RateLimiter$$desiredRate() <= 0) {
            return;
        }
        long now = System.nanoTime();
        long elapsedNanosecs = package$.MODULE$.max(now - this.lastSyncTime(), 1L);
        double rate = (double)this.messagesWrittenSinceSync() * (double)1000000000 / (double)elapsedNanosecs;
        if (rate < (double)this.org$apache$spark$streaming$receiver$RateLimiter$$desiredRate()) {
            this.messagesWrittenSinceSync_$eq(this.messagesWrittenSinceSync() + 1L);
            if (now > this.lastSyncTime() + this.SYNC_INTERVAL()) {
                this.lastSyncTime_$eq(now);
                this.messagesWrittenSinceSync_$eq(1L);
            }
        } else {
            long elapsedTimeInMillis;
            long targetTimeInMillis = this.messagesWrittenSinceSync() * 1000L / (long)this.org$apache$spark$streaming$receiver$RateLimiter$$desiredRate();
            long sleepTimeInMillis = targetTimeInMillis - (elapsedTimeInMillis = elapsedNanosecs / 1000000L);
            if (sleepTimeInMillis > 0L) {
                this.logTrace((Function0<String>)new Serializable(this, rate, sleepTimeInMillis){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RateLimiter $outer;
                    private final double rate$1;
                    private final long sleepTimeInMillis$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Natural rate is ").append((Object)BoxesRunTime.boxToDouble((double)this.rate$1)).append((Object)" per second but desired rate is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$receiver$RateLimiter$$desiredRate())).append((Object)", sleeping for ").append((Object)BoxesRunTime.boxToLong((long)this.sleepTimeInMillis$1)).append((Object)" ms to compensate.").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rate$1 = rate$1;
                        this.sleepTimeInMillis$1 = sleepTimeInMillis$1;
                    }
                });
                Thread.sleep(sleepTimeInMillis);
            }
            this.waitToPush();
        }
    }

    public RateLimiter(SparkConf conf) {
        Logging.class.$init$((Logging)this);
        this.lastSyncTime = System.nanoTime();
        this.messagesWrittenSinceSync = 0L;
        this.org$apache$spark$streaming$receiver$RateLimiter$$desiredRate = conf.getInt("spark.streaming.receiver.maxRate", 0);
        this.SYNC_INTERVAL = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
    }
}

