/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import org.apache.spark.rdd.BlockRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD$;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.InputInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001q3Q!\u0001\u0002\u0002\u00025\u0011ACU3dK&4XM]%oaV$Hi\u0015;sK\u0006l'BA\u0002\u0005\u0003\u001d!7\u000f\u001e:fC6T!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0011a\"F\n\u0003\u0001=\u00012\u0001E\t\u0014\u001b\u0005\u0011\u0011B\u0001\n\u0003\u00051Ie\u000e];u\tN#(/Z1n!\t!R\u0003\u0004\u0001\u0005\u000bY\u0001!\u0019A\f\u0003\u0003Q\u000b\"\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000f9{G\u000f[5oOB\u0011\u0011dH\u0005\u0003Ai\u00111!\u00118z\u0011!\u0011\u0003A!A!\u0002\u0013\u0019\u0013\u0001B:tG~\u0003\"\u0001J\u0013\u000e\u0003\u0011I!A\n\u0003\u0003!M#(/Z1nS:<7i\u001c8uKb$\bFA\u0011)!\tI\u0012&\u0003\u0002+5\tIAO]1og&,g\u000e\u001e\u0005\tY\u0001\u0011\u0019\u0011)A\u0006[\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u00079\n4#D\u00010\u0015\t\u0001$$A\u0004sK\u001adWm\u0019;\n\u0005Iz#\u0001C\"mCN\u001cH+Y4\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\t1\u0014\b\u0006\u00028qA\u0019\u0001\u0003A\n\t\u000b1\u001a\u00049A\u0017\t\u000b\t\u001a\u0004\u0019A\u0012\t\u000bm\u0002a\u0011\u0001\u001f\u0002\u0017\u001d,GOU3dK&4XM\u001d\u000b\u0002{A\u0019a(Q\n\u000e\u0003}R!\u0001\u0011\u0003\u0002\u0011I,7-Z5wKJL!AQ \u0003\u0011I+7-Z5wKJDQ\u0001\u0012\u0001\u0005\u0002\u0015\u000bQa\u001d;beR$\u0012A\u0012\t\u00033\u001dK!\u0001\u0013\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\u0002!\t!R\u0001\u0005gR|\u0007\u000fC\u0003M\u0001\u0011\u0005S*A\u0004d_6\u0004X\u000f^3\u0015\u00059;\u0006cA\rP#&\u0011\u0001K\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007I+6#D\u0001T\u0015\t!f!A\u0002sI\u0012L!AV*\u0003\u0007I#E\tC\u0003Y\u0017\u0002\u0007\u0011,A\u0005wC2LG\rV5nKB\u0011AEW\u0005\u00037\u0012\u0011A\u0001V5nK\u0002")
public abstract class ReceiverInputDStream<T>
extends InputDStream<T> {
    private final ClassTag<T> evidence$1;

    public abstract Receiver<T> getReceiver();

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Option<RDD<T>> compute(Time validTime) {
        WriteAheadLogBackedBlockRDD<T> writeAheadLogBackedBlockRDD;
        if (validTime.$less(this.graph().startTime())) {
            writeAheadLogBackedBlockRDD = new BlockRDD(this.ssc().sc(), (BlockId[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockId.class)), this.evidence$1);
        } else {
            ReceiverTracker receiverTracker = this.ssc().scheduler().receiverTracker();
            Seq blockInfos = (Seq)receiverTracker.getBlocksOfBatch(validTime).getOrElse((Object)BoxesRunTime.boxToInteger((int)this.id()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.empty();
                }
            });
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BlockId apply(ReceivedBlockInfo x$1) {
                    return x$1.blockId();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            InputInfo inputInfo = new InputInfo(this.id(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(ReceivedBlockInfo x$2) {
                    return x$2.numRecords();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
            if (blockInfos.nonEmpty()) {
                boolean areWALRecordHandlesPresent = blockInfos.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ReceivedBlockInfo x$3) {
                        return x$3.walRecordHandleOption().nonEmpty();
                    }
                });
                if (areWALRecordHandlesPresent) {
                    boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ReceivedBlockInfo x$4) {
                            return x$4.isBlockIdValid();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
                    WriteAheadLogRecordHandle[] walRecordHandles = (WriteAheadLogRecordHandle[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final WriteAheadLogRecordHandle apply(ReceivedBlockInfo x$5) {
                            return (WriteAheadLogRecordHandle)x$5.walRecordHandleOption().get();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class));
                    writeAheadLogBackedBlockRDD = new WriteAheadLogBackedBlockRDD<T>(this.ssc().sparkContext(), blockIds, walRecordHandles, isBlockIdValid, WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5(), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), this.evidence$1);
                } else {
                    if (blockInfos.find((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ReceivedBlockInfo x$6) {
                            return x$6.walRecordHandleOption().nonEmpty();
                        }
                    }).nonEmpty()) {
                        if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.ssc().conf())) {
                            this.logError((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Some blocks do not have Write Ahead Log information; this is unexpected and data may not be recoverable after driver failures";
                                }
                            });
                        } else {
                            this.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Some blocks have Write Ahead Log information; this is unexpected";
                                }
                            });
                        }
                    }
                    writeAheadLogBackedBlockRDD = new BlockRDD(this.ssc().sc(), blockIds, this.evidence$1);
                }
            } else {
                writeAheadLogBackedBlockRDD = WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.ssc().conf()) ? new WriteAheadLogBackedBlockRDD<T>(this.ssc().sparkContext(), (BlockId[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockId.class)), (WriteAheadLogRecordHandle[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class)), (boolean[])Array$.MODULE$.empty(ClassTag$.MODULE$.Boolean()), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5(), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), this.evidence$1) : new BlockRDD(this.ssc().sc(), (BlockId[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockId.class)), this.evidence$1);
            }
        }
        WriteAheadLogBackedBlockRDD<T> blockRDD = writeAheadLogBackedBlockRDD;
        return new Some((Object)blockRDD);
    }

    public ReceiverInputDStream(StreamingContext ssc_, ClassTag<T> evidence$1) {
        this.evidence$1 = evidence$1;
        super(ssc_, evidence$1);
    }
}

