/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.util.BatchedWriteAheadLog;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.util.control.NonFatal$;

public final class WriteAheadLogUtils$
implements Logging {
    public static final WriteAheadLogUtils$ MODULE$;
    private final String RECEIVER_WAL_ENABLE_CONF_KEY;
    private final String RECEIVER_WAL_CLASS_CONF_KEY;
    private final String RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY;
    private final String RECEIVER_WAL_MAX_FAILURES_CONF_KEY;
    private final String RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY;
    private final String DRIVER_WAL_CLASS_CONF_KEY;
    private final String DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY;
    private final String DRIVER_WAL_MAX_FAILURES_CONF_KEY;
    private final String DRIVER_WAL_BATCHING_CONF_KEY;
    private final String DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY;
    private final String DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY;
    private final int DEFAULT_ROLLING_INTERVAL_SECS;
    private final int DEFAULT_MAX_FAILURES;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new WriteAheadLogUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public String RECEIVER_WAL_ENABLE_CONF_KEY() {
        return this.RECEIVER_WAL_ENABLE_CONF_KEY;
    }

    public String RECEIVER_WAL_CLASS_CONF_KEY() {
        return this.RECEIVER_WAL_CLASS_CONF_KEY;
    }

    public String RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY() {
        return this.RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY;
    }

    public String RECEIVER_WAL_MAX_FAILURES_CONF_KEY() {
        return this.RECEIVER_WAL_MAX_FAILURES_CONF_KEY;
    }

    public String RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY() {
        return this.RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY;
    }

    public String DRIVER_WAL_CLASS_CONF_KEY() {
        return this.DRIVER_WAL_CLASS_CONF_KEY;
    }

    public String DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY() {
        return this.DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY;
    }

    public String DRIVER_WAL_MAX_FAILURES_CONF_KEY() {
        return this.DRIVER_WAL_MAX_FAILURES_CONF_KEY;
    }

    public String DRIVER_WAL_BATCHING_CONF_KEY() {
        return this.DRIVER_WAL_BATCHING_CONF_KEY;
    }

    public String DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY() {
        return this.DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY;
    }

    public String DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY() {
        return this.DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY;
    }

    public int DEFAULT_ROLLING_INTERVAL_SECS() {
        return this.DEFAULT_ROLLING_INTERVAL_SECS;
    }

    public int DEFAULT_MAX_FAILURES() {
        return this.DEFAULT_MAX_FAILURES;
    }

    public boolean enableReceiverLog(SparkConf conf) {
        return conf.getBoolean(this.RECEIVER_WAL_ENABLE_CONF_KEY(), false);
    }

    public int getRollingIntervalSecs(SparkConf conf, boolean isDriver) {
        return isDriver ? conf.getInt(this.DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY(), this.DEFAULT_ROLLING_INTERVAL_SECS()) : conf.getInt(this.RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY(), this.DEFAULT_ROLLING_INTERVAL_SECS());
    }

    public int getMaxFailures(SparkConf conf, boolean isDriver) {
        return isDriver ? conf.getInt(this.DRIVER_WAL_MAX_FAILURES_CONF_KEY(), this.DEFAULT_MAX_FAILURES()) : conf.getInt(this.RECEIVER_WAL_MAX_FAILURES_CONF_KEY(), this.DEFAULT_MAX_FAILURES());
    }

    public boolean isBatchingEnabled(SparkConf conf, boolean isDriver) {
        return isDriver && conf.getBoolean(this.DRIVER_WAL_BATCHING_CONF_KEY(), true);
    }

    public long getBatchingTimeout(SparkConf conf) {
        return conf.getLong(this.DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY(), 5000L);
    }

    public boolean shouldCloseFileAfterWrite(SparkConf conf, boolean isDriver) {
        return isDriver ? conf.getBoolean(this.DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY(), false) : conf.getBoolean(this.RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY(), false);
    }

    public WriteAheadLog createLogForDriver(SparkConf sparkConf, String fileWalLogDirectory, Configuration fileWalHadoopConf) {
        return this.createLog(true, sparkConf, fileWalLogDirectory, fileWalHadoopConf);
    }

    public WriteAheadLog createLogForReceiver(SparkConf sparkConf, String fileWalLogDirectory, Configuration fileWalHadoopConf) {
        return this.createLog(false, sparkConf, fileWalLogDirectory, fileWalHadoopConf);
    }

    private WriteAheadLog createLog(boolean isDriver, SparkConf sparkConf, String fileWalLogDirectory, Configuration fileWalHadoopConf) {
        Option classNameOption = isDriver ? sparkConf.getOption(this.DRIVER_WAL_CLASS_CONF_KEY()) : sparkConf.getOption(this.RECEIVER_WAL_CLASS_CONF_KEY());
        WriteAheadLog wal = (WriteAheadLog)classNameOption.map((Function1)new Serializable(sparkConf){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;

            public final WriteAheadLog apply(String className) {
                try {
                    return WriteAheadLogUtils$.MODULE$.org$apache$spark$streaming$util$WriteAheadLogUtils$$instantiateClass(Utils$.MODULE$.classForName(className), this.sparkConf$1);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create a write ahead log of class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className})), e);
                }
            }
            {
                this.sparkConf$1 = sparkConf$1;
            }
        }).getOrElse((Function0)new Serializable(isDriver, sparkConf, fileWalLogDirectory, fileWalHadoopConf){
            public static final long serialVersionUID = 0L;
            private final boolean isDriver$1;
            private final SparkConf sparkConf$1;
            private final String fileWalLogDirectory$1;
            private final Configuration fileWalHadoopConf$1;

            public final FileBasedWriteAheadLog apply() {
                return new FileBasedWriteAheadLog(this.sparkConf$1, this.fileWalLogDirectory$1, this.fileWalHadoopConf$1, WriteAheadLogUtils$.MODULE$.getRollingIntervalSecs(this.sparkConf$1, this.isDriver$1), WriteAheadLogUtils$.MODULE$.getMaxFailures(this.sparkConf$1, this.isDriver$1), WriteAheadLogUtils$.MODULE$.shouldCloseFileAfterWrite(this.sparkConf$1, this.isDriver$1));
            }
            {
                this.isDriver$1 = isDriver$1;
                this.sparkConf$1 = sparkConf$1;
                this.fileWalLogDirectory$1 = fileWalLogDirectory$1;
                this.fileWalHadoopConf$1 = fileWalHadoopConf$1;
            }
        });
        return this.isBatchingEnabled(sparkConf, isDriver) ? new BatchedWriteAheadLog(wal, sparkConf) : wal;
    }

    public WriteAheadLog org$apache$spark$streaming$util$WriteAheadLogUtils$$instantiateClass(Class<? extends WriteAheadLog> cls, SparkConf conf) {
        WriteAheadLog writeAheadLog;
        try {
            writeAheadLog = cls.getConstructor(SparkConf.class).newInstance(conf);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            writeAheadLog = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return writeAheadLog;
    }

    private WriteAheadLogUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.RECEIVER_WAL_ENABLE_CONF_KEY = "spark.streaming.receiver.writeAheadLog.enable";
        this.RECEIVER_WAL_CLASS_CONF_KEY = "spark.streaming.receiver.writeAheadLog.class";
        this.RECEIVER_WAL_ROLLING_INTERVAL_CONF_KEY = "spark.streaming.receiver.writeAheadLog.rollingIntervalSecs";
        this.RECEIVER_WAL_MAX_FAILURES_CONF_KEY = "spark.streaming.receiver.writeAheadLog.maxFailures";
        this.RECEIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY = "spark.streaming.receiver.writeAheadLog.closeFileAfterWrite";
        this.DRIVER_WAL_CLASS_CONF_KEY = "spark.streaming.driver.writeAheadLog.class";
        this.DRIVER_WAL_ROLLING_INTERVAL_CONF_KEY = "spark.streaming.driver.writeAheadLog.rollingIntervalSecs";
        this.DRIVER_WAL_MAX_FAILURES_CONF_KEY = "spark.streaming.driver.writeAheadLog.maxFailures";
        this.DRIVER_WAL_BATCHING_CONF_KEY = "spark.streaming.driver.writeAheadLog.allowBatching";
        this.DRIVER_WAL_BATCHING_TIMEOUT_CONF_KEY = "spark.streaming.driver.writeAheadLog.batchingTimeout";
        this.DRIVER_WAL_CLOSE_AFTER_WRITE_CONF_KEY = "spark.streaming.driver.writeAheadLog.closeFileAfterWrite";
        this.DEFAULT_ROLLING_INTERVAL_SECS = 60;
        this.DEFAULT_MAX_FAILURES = 3;
    }
}

