/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingSource$;
import org.apache.spark.streaming.ui.BatchUIData;
import org.apache.spark.streaming.ui.StreamingJobProgressListener;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4Q!\u0001\u0002\u0001\u0005)\u0011qb\u0015;sK\u0006l\u0017N\\4T_V\u00148-\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0011!cF\u0007\u0002')\u0011A#F\u0001\u0007g>,(oY3\u000b\u0005Y!\u0011aB7fiJL7m]\u0005\u00031M\u0011aaU8ve\u000e,\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0007M\u001c8m\u0001\u0001\u0011\u0005uqR\"\u0001\u0002\n\u0005}\u0011!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00111\u0005\n\t\u0003;\u0001AQA\u0007\u0011A\u0002qAqA\n\u0001C\u0002\u0013\u0005s%\u0001\bnKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0016\u0003!\u0002\"!K\u0018\u000e\u0003)R!AF\u0016\u000b\u00051j\u0013\u0001C2pI\u0006D\u0017\r\\3\u000b\u00039\n1aY8n\u0013\t\u0001$F\u0001\bNKR\u0014\u0018n\u0019*fO&\u001cHO]=\t\rI\u0002\u0001\u0015!\u0003)\u0003=iW\r\u001e:jGJ+w-[:uef\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%\t%N\u0001\u000bg>,(oY3OC6,W#\u0001\u001c\u0011\u0005]RdB\u0001\u00079\u0013\tIT\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u0012aa\u0015;sS:<'BA\u001d\u000e\u0011\u0019q\u0004\u0001)A\u0005m\u0005Y1o\\;sG\u0016t\u0015-\\3!\u0011\u001d\u0001\u0005A1A\u0005\n\u0005\u000b\u0011c\u001d;sK\u0006l\u0017N\\4MSN$XM\\3s+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#\u0003\u0003\t)\u0018.\u0003\u0002H\t\na2\u000b\u001e:fC6Lgn\u001a&pEB\u0013xn\u001a:fgNd\u0015n\u001d;f]\u0016\u0014\bBB%\u0001A\u0003%!)\u0001\ntiJ,\u0017-\\5oO2K7\u000f^3oKJ\u0004\u0003\"B&\u0001\t\u0013a\u0015!\u0004:fO&\u001cH/\u001a:HCV<W-\u0006\u0002N5R!a*U*d!\taq*\u0003\u0002Q\u001b\t!QK\\5u\u0011\u0015\u0011&\n1\u00017\u0003\u0011q\u0017-\\3\t\u000bQS\u0005\u0019A+\u0002\u0003\u0019\u0004B\u0001\u0004,C1&\u0011q+\u0004\u0002\n\rVt7\r^5p]F\u0002\"!\u0017.\r\u0001\u0011)1L\u0013b\u00019\n\tA+\u0005\u0002^AB\u0011ABX\u0005\u0003?6\u0011qAT8uQ&tw\r\u0005\u0002\rC&\u0011!-\u0004\u0002\u0004\u0003:L\b\"\u00023K\u0001\u0004A\u0016\u0001\u00043fM\u0006,H\u000e\u001e,bYV,\u0007\"\u00024\u0001\t\u00139\u0017a\u0006:fO&\u001cH/\u001a:HCV<WmV5uQ>\u0003H/[8o+\tA\u0007\u000f\u0006\u0003OS*\f\b\"\u0002*f\u0001\u00041\u0004\"\u0002+f\u0001\u0004Y\u0007\u0003\u0002\u0007W\u00052\u00042\u0001D7p\u0013\tqWB\u0001\u0004PaRLwN\u001c\t\u00033B$QaW3C\u0002qCQ\u0001Z3A\u0002=\u0004")
public class StreamingSource
implements Source {
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final String sourceName;
    private final StreamingJobProgressListener org$apache$spark$streaming$StreamingSource$$streamingListener;

    public MetricRegistry metricRegistry() {
        return this.metricRegistry;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public StreamingJobProgressListener org$apache$spark$streaming$StreamingSource$$streamingListener() {
        return this.org$apache$spark$streaming$StreamingSource$$streamingListener;
    }

    private <T> void registerGauge(String name, Function1<StreamingJobProgressListener, T> f, T defaultValue) {
        this.registerGaugeWithOption(name, (Function1<StreamingJobProgressListener, Option<T>>)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingSource $outer;
            private final Function1 f$1;

            public final Option<T> apply(StreamingJobProgressListener l) {
                return Option$.MODULE$.apply(this.f$1.apply((Object)this.$outer.org$apache$spark$streaming$StreamingSource$$streamingListener()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        }, defaultValue);
    }

    private <T> void registerGaugeWithOption(String name, Function1<StreamingJobProgressListener, Option<T>> f, T defaultValue) {
        this.metricRegistry().register(MetricRegistry.name((String)"streaming", (String[])new String[]{name}), (Metric)new Gauge<T>(this, f, defaultValue){
            private final /* synthetic */ StreamingSource $outer;
            private final Function1 f$2;
            public final Object defaultValue$1;

            public T getValue() {
                return (T)((Option)this.f$2.apply((Object)this.$outer.org$apache$spark$streaming$StreamingSource$$streamingListener())).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final T apply() {
                        return (T)this.$outer.defaultValue$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$2 = f$2;
                this.defaultValue$1 = defaultValue$1;
            }
        });
    }

    public StreamingSource(StreamingContext ssc) {
        this.sourceName = new StringOps(Predef$.MODULE$.augmentString("%s.StreamingMetrics")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ssc.sparkContext().appName()}));
        this.org$apache$spark$streaming$StreamingSource$$streamingListener = ssc.progressListener();
        this.registerGauge("receivers", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(StreamingJobProgressListener x$1) {
                return x$1.numReceivers();
            }
        }, (Object)BoxesRunTime.boxToInteger((int)0));
        this.registerGauge("totalCompletedBatches", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(StreamingJobProgressListener x$2) {
                return x$2.numTotalCompletedBatches();
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.registerGauge("totalReceivedRecords", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(StreamingJobProgressListener x$3) {
                return x$3.numTotalReceivedRecords();
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.registerGauge("totalProcessedRecords", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(StreamingJobProgressListener x$4) {
                return x$4.numTotalProcessedRecords();
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.registerGauge("unprocessedBatches", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(StreamingJobProgressListener x$5) {
                return x$5.numUnprocessedBatches();
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.registerGauge("waitingBatches", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(StreamingJobProgressListener x$6) {
                return x$6.waitingBatches().size();
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.registerGauge("runningBatches", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(StreamingJobProgressListener x$7) {
                return x$7.runningBatches().size();
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.registerGauge("retainedCompletedBatches", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(StreamingJobProgressListener x$8) {
                return x$8.retainedCompletedBatches().size();
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
        this.registerGaugeWithOption("lastCompletedBatch_submissionTime", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(StreamingJobProgressListener x$9) {
                return x$9.lastCompletedBatch().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(BatchUIData x$10) {
                        return x$10.submissionTime();
                    }
                });
            }
        }, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.registerGaugeWithOption("lastCompletedBatch_processingStartTime", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(StreamingJobProgressListener x$11) {
                return x$11.lastCompletedBatch().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Object> apply(BatchUIData x$12) {
                        return x$12.processingStartTime();
                    }
                });
            }
        }, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.registerGaugeWithOption("lastCompletedBatch_processingEndTime", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(StreamingJobProgressListener x$13) {
                return x$13.lastCompletedBatch().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Object> apply(BatchUIData x$14) {
                        return x$14.processingEndTime();
                    }
                });
            }
        }, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.registerGaugeWithOption("lastCompletedBatch_processingDelay", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(StreamingJobProgressListener x$15) {
                return x$15.lastCompletedBatch().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Object> apply(BatchUIData x$16) {
                        return x$16.processingDelay();
                    }
                });
            }
        }, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.registerGaugeWithOption("lastCompletedBatch_schedulingDelay", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(StreamingJobProgressListener x$17) {
                return x$17.lastCompletedBatch().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Object> apply(BatchUIData x$18) {
                        return x$18.schedulingDelay();
                    }
                });
            }
        }, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.registerGaugeWithOption("lastCompletedBatch_totalDelay", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(StreamingJobProgressListener x$19) {
                return x$19.lastCompletedBatch().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Object> apply(BatchUIData x$20) {
                        return x$20.totalDelay();
                    }
                });
            }
        }, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.registerGaugeWithOption("lastReceivedBatch_submissionTime", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(StreamingJobProgressListener x$21) {
                return x$21.lastReceivedBatch().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(BatchUIData x$22) {
                        return x$22.submissionTime();
                    }
                });
            }
        }, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.registerGaugeWithOption("lastReceivedBatch_processingStartTime", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(StreamingJobProgressListener x$23) {
                return x$23.lastReceivedBatch().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Object> apply(BatchUIData x$24) {
                        return x$24.processingStartTime();
                    }
                });
            }
        }, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.registerGaugeWithOption("lastReceivedBatch_processingEndTime", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(StreamingJobProgressListener x$25) {
                return x$25.lastReceivedBatch().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Object> apply(BatchUIData x$26) {
                        return x$26.processingEndTime();
                    }
                });
            }
        }, (Object)BoxesRunTime.boxToLong((long)-1L));
        this.registerGauge("lastReceivedBatch_records", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(StreamingJobProgressListener x$27) {
                return BoxesRunTime.unboxToLong((Object)x$27.lastReceivedBatchRecords().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
        }, (Object)BoxesRunTime.boxToLong((long)0L));
    }
}

