/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.streaming.ui.UIUtils$;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class UIUtils$ {
    public static final UIUtils$ MODULE$;
    private final ThreadLocal<SimpleDateFormat> batchTimeFormat;
    private final ThreadLocal<SimpleDateFormat> batchTimeFormatWithMilliseconds;

    static {
        new UIUtils$();
    }

    public String shortTimeUnitString(TimeUnit unit) {
        TimeUnit timeUnit;
        block9: {
            String string;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        timeUnit = unit;
                                        TimeUnit timeUnit2 = TimeUnit.NANOSECONDS;
                                        TimeUnit timeUnit3 = timeUnit;
                                        if (timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null) break block2;
                                        string = "ns";
                                        break block3;
                                    }
                                    TimeUnit timeUnit4 = TimeUnit.MICROSECONDS;
                                    TimeUnit timeUnit5 = timeUnit;
                                    if (timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null) break block4;
                                    string = "us";
                                    break block3;
                                }
                                TimeUnit timeUnit6 = TimeUnit.MILLISECONDS;
                                TimeUnit timeUnit7 = timeUnit;
                                if (timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null) break block5;
                                string = "ms";
                                break block3;
                            }
                            TimeUnit timeUnit8 = TimeUnit.SECONDS;
                            TimeUnit timeUnit9 = timeUnit;
                            if (timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null) break block6;
                            string = "sec";
                            break block3;
                        }
                        TimeUnit timeUnit10 = TimeUnit.MINUTES;
                        TimeUnit timeUnit11 = timeUnit;
                        if (timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null) break block7;
                        string = "min";
                        break block3;
                    }
                    TimeUnit timeUnit12 = TimeUnit.HOURS;
                    TimeUnit timeUnit13 = timeUnit;
                    if (timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null) break block8;
                    string = "hrs";
                    break block3;
                }
                TimeUnit timeUnit14 = TimeUnit.DAYS;
                TimeUnit timeUnit15 = timeUnit;
                if (timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null) break block9;
                string = "days";
            }
            return string;
        }
        throw new MatchError((Object)timeUnit);
    }

    public Tuple2<Object, TimeUnit> normalizeDuration(long milliseconds) {
        if (milliseconds < 1000L) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)milliseconds), (Object)TimeUnit.MILLISECONDS);
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)seconds), (Object)TimeUnit.SECONDS);
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)60) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)minutes), (Object)TimeUnit.MINUTES);
        }
        double hours = minutes / (double)60;
        if (hours < (double)24) {
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)hours), (Object)TimeUnit.HOURS);
        }
        double days = hours / (double)24;
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)days), (Object)TimeUnit.DAYS);
    }

    public double convertToTimeUnit(long milliseconds, TimeUnit unit) {
        TimeUnit timeUnit;
        block9: {
            double d;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        timeUnit = unit;
                                        TimeUnit timeUnit2 = TimeUnit.NANOSECONDS;
                                        TimeUnit timeUnit3 = timeUnit;
                                        if (timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null) break block2;
                                        d = milliseconds * 1000L * 1000L;
                                        break block3;
                                    }
                                    TimeUnit timeUnit4 = TimeUnit.MICROSECONDS;
                                    TimeUnit timeUnit5 = timeUnit;
                                    if (timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null) break block4;
                                    d = milliseconds * 1000L;
                                    break block3;
                                }
                                TimeUnit timeUnit6 = TimeUnit.MILLISECONDS;
                                TimeUnit timeUnit7 = timeUnit;
                                if (timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null) break block5;
                                d = milliseconds;
                                break block3;
                            }
                            TimeUnit timeUnit8 = TimeUnit.SECONDS;
                            TimeUnit timeUnit9 = timeUnit;
                            if (timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null) break block6;
                            d = (double)milliseconds / 1000.0;
                            break block3;
                        }
                        TimeUnit timeUnit10 = TimeUnit.MINUTES;
                        TimeUnit timeUnit11 = timeUnit;
                        if (timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null) break block7;
                        d = (double)milliseconds / 1000.0 / 60.0;
                        break block3;
                    }
                    TimeUnit timeUnit12 = TimeUnit.HOURS;
                    TimeUnit timeUnit13 = timeUnit;
                    if (timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null) break block8;
                    d = (double)milliseconds / 1000.0 / 60.0 / 60.0;
                    break block3;
                }
                TimeUnit timeUnit14 = TimeUnit.DAYS;
                TimeUnit timeUnit15 = timeUnit;
                if (timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null) break block9;
                d = (double)milliseconds / 1000.0 / 60.0 / 60.0 / 24.0;
            }
            return d;
        }
        throw new MatchError((Object)timeUnit);
    }

    private ThreadLocal<SimpleDateFormat> batchTimeFormat() {
        return this.batchTimeFormat;
    }

    private ThreadLocal<SimpleDateFormat> batchTimeFormatWithMilliseconds() {
        return this.batchTimeFormatWithMilliseconds;
    }

    public String formatBatchTime(long batchTime, long batchInterval, boolean showYYYYMMSS, TimeZone timezone) {
        Tuple2 oldTimezones = new Tuple2((Object)((DateFormat)this.batchTimeFormat().get()).getTimeZone(), (Object)((DateFormat)this.batchTimeFormatWithMilliseconds().get()).getTimeZone());
        if (timezone != null) {
            ((DateFormat)this.batchTimeFormat().get()).setTimeZone(timezone);
            ((DateFormat)this.batchTimeFormatWithMilliseconds().get()).setTimeZone(timezone);
        }
        try {
            String formattedBatchTime;
            String string = formattedBatchTime = batchInterval < 1000L ? ((Format)this.batchTimeFormatWithMilliseconds().get()).format(BoxesRunTime.boxToLong((long)batchTime)) : ((Format)this.batchTimeFormat().get()).format(BoxesRunTime.boxToLong((long)batchTime));
            String string2 = showYYYYMMSS ? formattedBatchTime : formattedBatchTime.substring(formattedBatchTime.indexOf(32) + 1);
            return string2;
        }
        finally {
            if (timezone != null) {
                ((DateFormat)this.batchTimeFormat().get()).setTimeZone((TimeZone)oldTimezones._1());
                ((DateFormat)this.batchTimeFormatWithMilliseconds().get()).setTimeZone((TimeZone)oldTimezones._2());
            }
        }
    }

    public boolean formatBatchTime$default$3() {
        return true;
    }

    public TimeZone formatBatchTime$default$4() {
        return null;
    }

    public String createOutputOperationFailureForUI(String failure) {
        String string;
        if (failure.startsWith("org.apache.spark.Spark")) {
            string = new StringBuilder().append((Object)"Failed due to Spark job error\n").append((Object)failure).toString();
        } else {
            int nextLineIndex = failure.indexOf("\n");
            if (nextLineIndex < 0) {
                nextLineIndex = failure.length();
            }
            String firstLine = failure.substring(0, nextLineIndex);
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed due to error: ", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstLine, failure}));
        }
        return string;
    }

    public Seq<Node> failureReasonCell(String failureReason, int rowspan, boolean includeFirstLineInExpandDetails) {
        Elem elem;
        String details;
        Object object;
        String failureDetails;
        boolean isMultiline = failureReason.indexOf(10) >= 0;
        String failureReasonSummary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? failureReason.substring(0, failureReason.indexOf(10)) : failureReason));
        String string = failureDetails = isMultiline && !includeFirstLineInExpandDetails ? failureReason.substring(failureReason.indexOf(10) + 1) : failureReason;
        if (isMultiline) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("expand-details"), (MetaData)$md);
            $md = new UnprefixedAttribute("onclick", (Seq)new Text("this.parentNode.querySelector('.stacktrace-details').classList.toggle('collapsed')"), (MetaData)$md);
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        +details\n      "));
            Elem elem2 = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("stacktrace-details collapsed"), (MetaData)$md2);
            TopScope$ topScope$2 = Predef$.MODULE$.$scope();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            TopScope$ topScope$3 = Predef$.MODULE$.$scope();
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)failureDetails);
            $buf2.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, false, (Seq)$buf3));
            $buf2.$amp$plus((Object)new Text("\n        "));
            object = elem2.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)topScope$2, false, (Seq)$buf2), NodeSeq$.MODULE$.canBuildFrom());
        } else {
            object = details = "";
        }
        if (rowspan == 1) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)failureReasonSummary);
            $buf.$amp$plus((Object)details);
            Elem elem3 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
            elem = elem3;
        } else {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", ((Object)BoxesRunTime.boxToInteger((int)rowspan)).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("style", (Seq)new Text("max-width: 300px"), (MetaData)$md);
            $md = new UnprefixedAttribute("valign", (Seq)new Text("middle"), (MetaData)$md);
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)failureReasonSummary);
            $buf.$amp$plus((Object)details);
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem4 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
            elem = elem4;
        }
        return elem;
    }

    public int failureReasonCell$default$2() {
        return 1;
    }

    public boolean failureReasonCell$default$3() {
        return true;
    }

    private UIUtils$() {
        MODULE$ = this;
        this.batchTimeFormat = new anon.1();
        this.batchTimeFormatWithMilliseconds = new anon.2();
    }
}

