/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.PairRDDFunctions$;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.python.PythonDStream$;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.scheduler.ErrorReported;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager$;
import org.apache.spark.streaming.scheduler.InputInfoTracker;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobCompleted;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.apache.spark.streaming.scheduler.JobScheduler$;
import org.apache.spark.streaming.scheduler.JobSchedulerEvent;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobStarted;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.EventLoop;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tMb!B\u0001\u0003\u0001\u0011a!\u0001\u0004&pEN\u001b\u0007.\u001a3vY\u0016\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!r#D\u0001\u0016\u0015\t1b!\u0001\u0005j]R,'O\\1m\u0013\tARCA\u0004M_\u001e<\u0017N\\4\t\u0011i\u0001!Q1A\u0005\u0002q\t1a]:d\u0007\u0001)\u0012!\b\t\u0003=}i\u0011\u0001B\u0005\u0003A\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011\t\u0002!\u0011!Q\u0001\nu\tAa]:dA!)A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"\"A\n\u0015\u0011\u0005\u001d\u0002Q\"\u0001\u0002\t\u000bi\u0019\u0003\u0019A\u000f\t\u000f)\u0002!\u0019!C\u0005W\u00059!n\u001c2TKR\u001cX#\u0001\u0017\u0011\t5\u0012DgN\u0007\u0002])\u0011q\u0006M\u0001\u0005kRLGNC\u00012\u0003\u0011Q\u0017M^1\n\u0005Mr#aA'baB\u0011a$N\u0005\u0003m\u0011\u0011A\u0001V5nKB\u0011q\u0005O\u0005\u0003s\t\u0011aAS8c'\u0016$\bBB\u001e\u0001A\u0003%A&\u0001\u0005k_\n\u001cV\r^:!\u0011\u001di\u0004A1A\u0005\ny\n\u0011C\\;n\u0007>t7-\u001e:sK:$(j\u001c2t+\u0005y\u0004C\u0001\bA\u0013\t\tuBA\u0002J]RDaa\u0011\u0001!\u0002\u0013y\u0014A\u00058v[\u000e{gnY;se\u0016tGOS8cg\u0002Bq!\u0012\u0001C\u0002\u0013%a)A\u0006k_\n,\u00050Z2vi>\u0014X#A$\u0011\u0005![U\"A%\u000b\u0005)s\u0013AC2p]\u000e,(O]3oi&\u0011A*\u0013\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000f\u0003\u0004O\u0001\u0001\u0006IaR\u0001\rU>\u0014W\t_3dkR|'\u000f\t\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u00031QwNY$f]\u0016\u0014\u0018\r^8s+\u0005\u0011\u0006CA\u0014T\u0013\t!&A\u0001\u0007K_\n<UM\\3sCR|'\u000f\u0003\u0004W\u0001\u0001\u0006IAU\u0001\u000eU>\u0014w)\u001a8fe\u0006$xN\u001d\u0011\t\u000fa\u0003!\u0019!C\u00013\u0006)1\r\\8dWV\t!\f\u0005\u0002\\;6\tAL\u0003\u00020\r%\u0011a\f\u0018\u0002\u0006\u00072|7m\u001b\u0005\u0007A\u0002\u0001\u000b\u0011\u0002.\u0002\r\rdwnY6!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\f1\u0002\\5ti\u0016tWM\u001d\"vgV\tA\r\u0005\u0002(K&\u0011aM\u0001\u0002\u0015'R\u0014X-Y7j]\u001ed\u0015n\u001d;f]\u0016\u0014()^:\t\r!\u0004\u0001\u0015!\u0003e\u00031a\u0017n\u001d;f]\u0016\u0014()^:!\u0011\u001dQ\u0007\u00011A\u0005\u0002-\fqB]3dK&4XM\u001d+sC\u000e\\WM]\u000b\u0002YB\u0011q%\\\u0005\u0003]\n\u0011qBU3dK&4XM\u001d+sC\u000e\\WM\u001d\u0005\ba\u0002\u0001\r\u0011\"\u0001r\u0003M\u0011XmY3jm\u0016\u0014HK]1dW\u0016\u0014x\fJ3r)\t\u0011X\u000f\u0005\u0002\u000fg&\u0011Ao\u0004\u0002\u0005+:LG\u000fC\u0004w_\u0006\u0005\t\u0019\u00017\u0002\u0007a$\u0013\u0007\u0003\u0004y\u0001\u0001\u0006K\u0001\\\u0001\u0011e\u0016\u001cW-\u001b<feR\u0013\u0018mY6fe\u0002BqA\u001f\u0001A\u0002\u0013\u000510\u0001\tj]B,H/\u00138g_R\u0013\u0018mY6feV\tA\u0010\u0005\u0002({&\u0011aP\u0001\u0002\u0011\u0013:\u0004X\u000f^%oM>$&/Y2lKJD\u0011\"!\u0001\u0001\u0001\u0004%\t!a\u0001\u0002)%t\u0007/\u001e;J]\u001a|GK]1dW\u0016\u0014x\fJ3r)\r\u0011\u0018Q\u0001\u0005\bm~\f\t\u00111\u0001}\u0011\u001d\tI\u0001\u0001Q!\nq\f\u0011#\u001b8qkRLeNZ8Ue\u0006\u001c7.\u001a:!\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty!A\rfq\u0016\u001cW\u000f^8s\u00032dwnY1uS>tW*\u00198bO\u0016\u0014XCAA\t!\u0015q\u00111CA\f\u0013\r\t)b\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u001d\nI\"C\u0002\u0002\u001c\t\u0011\u0011$\u0012=fGV$xN]!mY>\u001c\u0017\r^5p]6\u000bg.Y4fe\"I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011E\u0001\u001eKb,7-\u001e;pe\u0006cGn\\2bi&|g.T1oC\u001e,'o\u0018\u0013fcR\u0019!/a\t\t\u0013Y\fi\"!AA\u0002\u0005E\u0001\u0002CA\u0014\u0001\u0001\u0006K!!\u0005\u00025\u0015DXmY;u_J\fE\u000e\\8dCRLwN\\'b]\u0006<WM\u001d\u0011\t\u0013\u0005-\u0002\u00011A\u0005\n\u00055\u0012!C3wK:$Hj\\8q+\t\ty\u0003E\u0003\\\u0003c\t)$C\u0002\u00024q\u0013\u0011\"\u0012<f]Rdun\u001c9\u0011\u0007\u001d\n9$C\u0002\u0002:\t\u0011\u0011CS8c'\u000eDW\rZ;mKJ,e/\u001a8u\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty$A\u0007fm\u0016tG\u000fT8pa~#S-\u001d\u000b\u0004e\u0006\u0005\u0003\"\u0003<\u0002<\u0005\u0005\t\u0019AA\u0018\u0011!\t)\u0005\u0001Q!\n\u0005=\u0012AC3wK:$Hj\\8qA!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013!B:uCJ$H#\u0001:\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R\u0005!1\u000f^8q)\r\u0011\u00181\u000b\u0005\t\u0003+\ni\u00051\u0001\u0002X\u00051\u0002O]8dKN\u001c\u0018\t\u001c7SK\u000e,\u0017N^3e\t\u0006$\u0018\rE\u0002\u000f\u00033J1!a\u0017\u0010\u0005\u001d\u0011un\u001c7fC:Dq!a\u0018\u0001\t\u0003\t\t'\u0001\u0007tk\nl\u0017\u000e\u001e&pEN+G\u000fF\u0002s\u0003GBq!!\u001a\u0002^\u0001\u0007q'\u0001\u0004k_\n\u001cV\r\u001e\u0005\b\u0003S\u0002A\u0011AA6\u0003=9W\r\u001e)f]\u0012Lgn\u001a+j[\u0016\u001cHCAA7!\u0015\ty'a 5\u001d\u0011\t\t(a\u001f\u000f\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e\u001c\u0003\u0019a$o\\8u}%\t\u0001#C\u0002\u0002~=\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0006\r%aA*fc*\u0019\u0011QP\b\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006Y!/\u001a9peR,%O]8s)\u0015\u0011\u00181RAO\u0011!\ti)!\"A\u0002\u0005=\u0015aA7tOB!\u0011\u0011SAL\u001d\rq\u00111S\u0005\u0004\u0003+{\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0006m%AB*ue&twMC\u0002\u0002\u0016>A\u0001\"a(\u0002\u0006\u0002\u0007\u0011\u0011U\u0001\u0002KB!\u0011qNAR\u0013\u0011\t)+a!\u0003\u0013QC'o\\<bE2,\u0007bBAU\u0001\u0011\u0005\u00111V\u0001\nSN\u001cF/\u0019:uK\u0012$\"!a\u0016\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\u0006a\u0001O]8dKN\u001cXI^3oiR\u0019!/a-\t\u0011\u0005U\u0016Q\u0016a\u0001\u0003k\tQ!\u001a<f]RDq!!/\u0001\t\u0013\tY,\u0001\biC:$G.\u001a&pEN#\u0018M\u001d;\u0015\u000bI\fi,a2\t\u0011\u0005}\u0016q\u0017a\u0001\u0003\u0003\f1A[8c!\r9\u00131Y\u0005\u0004\u0003\u000b\u0014!a\u0001&pE\"A\u0011\u0011ZA\\\u0001\u0004\tY-A\u0005ti\u0006\u0014H\u000fV5nKB\u0019a\"!4\n\u0007\u0005=wB\u0001\u0003M_:<\u0007bBAj\u0001\u0011%\u0011Q[\u0001\u0014Q\u0006tG\r\\3K_\n\u001cu.\u001c9mKRLwN\u001c\u000b\u0006e\u0006]\u0017\u0011\u001c\u0005\t\u0003\u007f\u000b\t\u000e1\u0001\u0002B\"A\u00111\\Ai\u0001\u0004\tY-A\u0007d_6\u0004H.\u001a;fIRKW.\u001a\u0005\b\u0003?\u0004A\u0011BAq\u0003-A\u0017M\u001c3mK\u0016\u0013(o\u001c:\u0015\u000bI\f\u0019/!:\t\u0011\u00055\u0015Q\u001ca\u0001\u0003\u001fC\u0001\"a(\u0002^\u0002\u0007\u0011\u0011\u0015\u0004\u0007\u0003S\u0004A!a;\u0003\u0015){'\rS1oI2,'oE\u0004\u0002h\u00065\u0018\u0011`\n\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cT1!a=1\u0003\u0011a\u0017M\\4\n\t\u0005]\u0018\u0011\u001f\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005=\u00181`\u0005\u0005\u0003{\f\tP\u0001\u0005Sk:t\u0017M\u00197f\u0011-\ty,a:\u0003\u0002\u0003\u0006I!!1\t\u000f\u0011\n9\u000f\"\u0001\u0003\u0004Q!!Q\u0001B\u0005!\u0011\u00119!a:\u000e\u0003\u0001A\u0001\"a0\u0003\u0002\u0001\u0007\u0011\u0011\u0019\u0005\t\u0005\u001b\t9\u000f\"\u0001\u0002L\u0005\u0019!/\u001e8\b\u0011\tE!\u0001#\u0001\u0005\u0005'\tABS8c'\u000eDW\rZ;mKJ\u00042a\nB\u000b\r\u001d\t!\u0001#\u0001\u0005\u0005/\u00192A!\u0006\u000e\u0011\u001d!#Q\u0003C\u0001\u00057!\"Aa\u0005\t\u0015\t}!Q\u0003b\u0001\n\u0003\u0011\t#A\fC\u0003R\u001b\u0005j\u0018+J\u001b\u0016{\u0006KU(Q\u000bJ#\u0016lX&F3V\u0011!1\u0005\t\u0005\u0003_\u0014)#\u0003\u0003\u0002\u001a\u0006E\b\"\u0003B\u0015\u0005+\u0001\u000b\u0011\u0002B\u0012\u0003a\u0011\u0015\tV\"I?RKU*R0Q%>\u0003VI\u0015+Z?.+\u0015\f\t\u0005\u000b\u0005[\u0011)B1A\u0005\u0002\t\u0005\u0012!G(V)B+FkX(Q?&#u\f\u0015*P!\u0016\u0013F+W0L\u000bfC\u0011B!\r\u0003\u0016\u0001\u0006IAa\t\u00025=+F\u000bU+U?>\u0003v,\u0013#`!J{\u0005+\u0012*U3~[U)\u0017\u0011")
public class JobScheduler
implements Logging {
    private final StreamingContext ssc;
    private final Map<Time, JobSet> jobSets;
    private final int numConcurrentJobs;
    private final ThreadPoolExecutor org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor;
    private final JobGenerator jobGenerator;
    private final Clock clock;
    private final StreamingListenerBus listenerBus;
    private ReceiverTracker receiverTracker;
    private InputInfoTracker inputInfoTracker;
    private Option<ExecutorAllocationManager> executorAllocationManager;
    private EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String OUTPUT_OP_ID_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY();
    }

    public static String BATCH_TIME_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    private Map<Time, JobSet> jobSets() {
        return this.jobSets;
    }

    private int numConcurrentJobs() {
        return this.numConcurrentJobs;
    }

    public ThreadPoolExecutor org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor;
    }

    private JobGenerator jobGenerator() {
        return this.jobGenerator;
    }

    public Clock clock() {
        return this.clock;
    }

    public StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public ReceiverTracker receiverTracker() {
        return this.receiverTracker;
    }

    public void receiverTracker_$eq(ReceiverTracker x$1) {
        this.receiverTracker = x$1;
    }

    public InputInfoTracker inputInfoTracker() {
        return this.inputInfoTracker;
    }

    public void inputInfoTracker_$eq(InputInfoTracker x$1) {
        this.inputInfoTracker = x$1;
    }

    private Option<ExecutorAllocationManager> executorAllocationManager() {
        return this.executorAllocationManager;
    }

    private void executorAllocationManager_$eq(Option<ExecutorAllocationManager> x$1) {
        this.executorAllocationManager = x$1;
    }

    public EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    }

    private void org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(EventLoop<JobSchedulerEvent> x$1) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = x$1;
    }

    public synchronized void start() {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() == null) {
            ExecutorAllocationClient executorAllocationClient;
            this.logDebug((Function0<String>)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobScheduler";
                }
            });
            this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(new EventLoop<JobSchedulerEvent>(this){
                private final /* synthetic */ JobScheduler $outer;

                public void onReceive(JobSchedulerEvent event) {
                    this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(event);
                }

                public void onError(Throwable e) {
                    this.$outer.reportError("Error in job scheduler", e);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super("JobScheduler");
                }
            });
            this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().start();
            Predef$.MODULE$.refArrayOps((Object[])this.ssc().graph().getInputStreams()).foreach((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobScheduler $outer;

                public final void apply(InputDStream<?> inputDStream) {
                    inputDStream.rateController().foreach((Function1)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$start$2 $outer;

                        public final void apply(RateController rateController) {
                            this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$anonfun$$$outer().ssc().addStreamingListener(rateController);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ JobScheduler org$apache$spark$streaming$scheduler$JobScheduler$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.listenerBus().start();
            this.receiverTracker_$eq(new ReceiverTracker(this.ssc(), ReceiverTracker$.MODULE$.$lessinit$greater$default$2()));
            this.inputInfoTracker_$eq(new InputInfoTracker(this.ssc()));
            SchedulerBackend schedulerBackend = this.ssc().sparkContext().schedulerBackend();
            if (schedulerBackend instanceof ExecutorAllocationClient) {
                SchedulerBackend schedulerBackend2 = schedulerBackend;
                executorAllocationClient = (ExecutorAllocationClient)schedulerBackend2;
            } else {
                executorAllocationClient = null;
            }
            ExecutorAllocationClient executorAllocClient = executorAllocationClient;
            this.executorAllocationManager_$eq(ExecutorAllocationManager$.MODULE$.createIfEnabled(executorAllocClient, this.receiverTracker(), this.ssc().conf(), this.ssc().graph().batchDuration().milliseconds(), this.clock()));
            this.executorAllocationManager().foreach((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobScheduler $outer;

                public final void apply(StreamingListener streamingListener) {
                    this.$outer.ssc().addStreamingListener(streamingListener);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.receiverTracker().start();
            this.jobGenerator().start();
            this.executorAllocationManager().foreach((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ExecutorAllocationManager x$1) {
                    x$1.start();
                }
            });
            this.logInfo((Function0<String>)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Started JobScheduler";
                }
            });
            return;
        }
    }

    public synchronized void stop(boolean processAllReceivedData) {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() == null) {
            return;
        }
        this.logDebug((Function0<String>)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping JobScheduler";
            }
        });
        if (this.receiverTracker() != null) {
            this.receiverTracker().stop(processAllReceivedData);
        }
        if (this.executorAllocationManager() != null) {
            this.executorAllocationManager().foreach((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ExecutorAllocationManager x$2) {
                    x$2.stop();
                }
            });
        }
        this.jobGenerator().stop(processAllReceivedData);
        this.logDebug((Function0<String>)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping job executor";
            }
        });
        this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().shutdown();
        boolean terminated = processAllReceivedData ? this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().awaitTermination(1L, TimeUnit.HOURS) : this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().awaitTermination(2L, TimeUnit.SECONDS);
        Object object = terminated ? BoxedUnit.UNIT : this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().shutdownNow();
        this.logDebug((Function0<String>)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped job executor";
            }
        });
        this.listenerBus().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(null);
        this.logInfo((Function0<String>)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped JobScheduler";
            }
        });
    }

    public void submitJobSet(JobSet jobSet) {
        if (jobSet.jobs().isEmpty()) {
            this.logInfo((Function0<String>)new scala.Serializable(this, jobSet){
                public static final long serialVersionUID = 0L;
                private final JobSet jobSet$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"No jobs added for time ").append((Object)this.jobSet$1.time()).toString();
                }
                {
                    this.jobSet$1 = jobSet$1;
                }
            });
        } else {
            this.listenerBus().post(new StreamingListenerBatchSubmitted(jobSet.toBatchInfo()));
            this.jobSets().put(jobSet.time(), jobSet);
            jobSet.jobs().foreach((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobScheduler $outer;

                public final void apply(Job job) {
                    this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().execute(new JobHandler(this.$outer, job));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.logInfo((Function0<String>)new scala.Serializable(this, jobSet){
                public static final long serialVersionUID = 0L;
                private final JobSet jobSet$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Added jobs for time ").append((Object)this.jobSet$1.time()).toString();
                }
                {
                    this.jobSet$1 = jobSet$1;
                }
            });
        }
    }

    public Seq<Time> getPendingTimes() {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.jobSets()).asScala()).keys().toSeq();
    }

    public void reportError(String msg, Throwable e) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().post((Object)new ErrorReported(msg, e));
    }

    public synchronized boolean isStarted() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() != null;
    }

    public void org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(JobSchedulerEvent event) {
        block5: {
            try {
                JobSchedulerEvent jobSchedulerEvent = event;
                if (jobSchedulerEvent instanceof JobStarted) {
                    JobStarted jobStarted = (JobStarted)jobSchedulerEvent;
                    Job job = jobStarted.job();
                    long startTime = jobStarted.startTime();
                    this.handleJobStart(job, startTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof JobCompleted) {
                    JobCompleted jobCompleted = (JobCompleted)jobSchedulerEvent;
                    Job job = jobCompleted.job();
                    long completedTime = jobCompleted.completedTime();
                    this.handleJobCompletion(job, completedTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof ErrorReported) {
                    ErrorReported errorReported = (ErrorReported)jobSchedulerEvent;
                    String m = errorReported.msg();
                    Throwable e = errorReported.e();
                    this.handleError(m, e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError((Object)jobSchedulerEvent);
            }
            catch (Throwable throwable) {
                this.reportError("Error in job scheduler", throwable);
            }
        }
    }

    private void handleJobStart(Job job, long startTime) {
        JobSet jobSet = this.jobSets().get(job.time());
        boolean isFirstJobOfJobSet = !jobSet.hasStarted();
        jobSet.handleJobStart(job);
        if (isFirstJobOfJobSet) {
            this.listenerBus().post(new StreamingListenerBatchStarted(jobSet.toBatchInfo()));
        }
        job.setStartTime(startTime);
        this.listenerBus().post(new StreamingListenerOutputOperationStarted(job.toOutputOperationInfo()));
        this.logInfo((Function0<String>)new scala.Serializable(this, job, jobSet){
            public static final long serialVersionUID = 0L;
            private final Job job$1;
            private final JobSet jobSet$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Starting job ").append((Object)this.job$1.id()).append((Object)" from job set of time ").append((Object)this.jobSet$2.time()).toString();
            }
            {
                this.job$1 = job$1;
                this.jobSet$2 = jobSet$2;
            }
        });
    }

    private void handleJobCompletion(Job job, long completedTime) {
        Try<?> try_;
        JobSet jobSet = this.jobSets().get(job.time());
        jobSet.handleJobCompletion(job);
        job.setEndTime(completedTime);
        this.listenerBus().post(new StreamingListenerOutputOperationCompleted(job.toOutputOperationInfo()));
        this.logInfo((Function0<String>)new scala.Serializable(this, job, jobSet){
            public static final long serialVersionUID = 0L;
            private final Job job$2;
            private final JobSet jobSet$3;

            public final String apply() {
                return new StringBuilder().append((Object)"Finished job ").append((Object)this.job$2.id()).append((Object)" from job set of time ").append((Object)this.jobSet$3.time()).toString();
            }
            {
                this.job$2 = job$2;
                this.jobSet$3 = jobSet$3;
            }
        });
        if (jobSet.hasCompleted()) {
            this.listenerBus().post(new StreamingListenerBatchCompleted(jobSet.toBatchInfo()));
        }
        if ((try_ = job.result()) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.reportError(new StringBuilder().append((Object)"Error running job ").append((Object)job).toString(), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (jobSet.hasCompleted()) {
                this.jobSets().remove(jobSet.time());
                this.jobGenerator().onBatchCompletion(jobSet.time());
                this.logInfo((Function0<String>)new scala.Serializable(this, jobSet){
                    public static final long serialVersionUID = 0L;
                    private final JobSet jobSet$3;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Total delay: %.3f s for time %s (execution: %.3f s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)this.jobSet$3.totalDelay() / 1000.0)), this.jobSet$3.time().toString(), BoxesRunTime.boxToDouble((double)((double)this.jobSet$3.processingDelay() / 1000.0))}));
                    }
                    {
                        this.jobSet$3 = jobSet$3;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void handleError(String msg, Throwable e) {
        this.logError((Function0<String>)new scala.Serializable(this, msg){
            public static final long serialVersionUID = 0L;
            private final String msg$1;

            public final String apply() {
                return this.msg$1;
            }
            {
                this.msg$1 = msg$1;
            }
        }, e);
        this.ssc().waiter().notifyError(e);
        PythonDStream$.MODULE$.stopStreamingContextIfPythonProcessIsDead(e);
    }

    public JobScheduler(StreamingContext ssc) {
        this.ssc = ssc;
        Logging.class.$init$((Logging)this);
        this.jobSets = new ConcurrentHashMap<Time, JobSet>();
        this.numConcurrentJobs = ssc.conf().getInt("spark.streaming.concurrentJobs", 1);
        this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.numConcurrentJobs(), "streaming-job-executor");
        this.jobGenerator = new JobGenerator(this);
        this.clock = this.jobGenerator().clock();
        this.listenerBus = new StreamingListenerBus(ssc.sparkContext().listenerBus());
        this.receiverTracker = null;
        this.inputInfoTracker = null;
        this.executorAllocationManager = None$.MODULE$;
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = null;
    }

    public class JobHandler
    implements Runnable,
    Logging {
        public final Job org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job;
        public final /* synthetic */ JobScheduler $outer;
        private transient Logger org$apache$spark$internal$Logging$$log_;

        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        public String logName() {
            return Logging.class.logName((Logging)this);
        }

        public Logger log() {
            return Logging.class.log((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.class.logInfo((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.class.logDebug((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.class.logTrace((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.class.logWarning((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.class.logError((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.class.logError((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.class.isTraceEnabled((Logging)this);
        }

        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
        }

        @Override
        public void run() {
            Properties oldProps = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().getLocalProperties();
            try {
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().setLocalProperties((Properties)SerializationUtils.clone((Serializable)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().savedProperties().get()));
                String formattedTime = UIUtils$.MODULE$.formatBatchTime(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.time().milliseconds(), this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().graph().batchDuration().milliseconds(), false, UIUtils$.MODULE$.formatBatchTime$default$4());
                String batchUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/streaming/batch/?id=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.time().milliseconds())}));
                String batchLinkText = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[output operation ", ", batch time ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.outputOpId()), formattedTime}));
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setJobDescription(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming job from <a href=\"", "\">", "</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchUrl, batchLinkText})));
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToLong((long)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.time().milliseconds())).toString());
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.outputOpId())).toString());
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().setLocalProperty(RDD$.MODULE$.CHECKPOINT_ALL_MARKED_ANCESTORS(), "true");
                EventLoop<JobSchedulerEvent> _eventLoop = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop();
                if (_eventLoop != null) {
                    _eventLoop.post((Object)new JobStarted(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job, this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().clock().getTimeMillis()));
                    PairRDDFunctions$.MODULE$.disableOutputSpecValidation().withValue((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function0)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ JobHandler $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.run();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    _eventLoop = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop();
                    if (_eventLoop != null) {
                        _eventLoop.post((Object)new JobCompleted(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job, this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().clock().getTimeMillis()));
                    }
                }
                return;
            }
            finally {
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sparkContext().setLocalProperties(oldProps);
            }
        }

        public /* synthetic */ JobScheduler org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer() {
            return this.$outer;
        }

        public JobHandler(JobScheduler $outer, Job job) {
            this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job = job;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging.class.$init$((Logging)this);
        }
    }
}

