/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor$;
import org.apache.spark.streaming.receiver.ReceiverSupervisor$ReceiverState$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\t\u001ddAB\u0001\u0003\u0003\u0003!AB\u0001\nSK\u000e,\u0017N^3s'V\u0004XM\u001d<jg>\u0014(BA\u0002\u0005\u0003!\u0011XmY3jm\u0016\u0014(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q)R\"\u0001\u0004\n\u0005Y1!a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u00053\r\u0001\u0001G\u0001\u000e!!\rYBDH\u0007\u0002\u0005%\u0011QD\u0001\u0002\t%\u0016\u001cW-\u001b<feB\u0011q\u0004\t\u0007\u0001\t%\ts#!A\u0001\u0002\u000b\u0005!EA\u0002`IE\n\"a\t\u0014\u0011\u00059!\u0013BA\u0013\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AD\u0014\n\u0005!z!aA!os\"A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0003d_:4\u0007C\u0001\u000b-\u0013\ticAA\u0005Ta\u0006\u00148nQ8oM\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"2!\r\u001a8!\tY\u0002\u0001C\u0003\u0004]\u0001\u00071\u0007\r\u00025mA\u00191\u0004H\u001b\u0011\u0005}1D!C\u00113\u0003\u0003\u0005\tQ!\u0001#\u0011\u0015Qc\u00061\u0001,\u000f\u0015I\u0004\u0001#\u0001;\u00035\u0011VmY3jm\u0016\u00148\u000b^1uKB\u00111\bP\u0007\u0002\u0001\u0019)Q\b\u0001E\u0001}\ti!+Z2fSZ,'o\u0015;bi\u0016\u001c\"\u0001P \u0011\u00059\u0001\u0015BA!\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000b=bD\u0011A\"\u0015\u0003i*A!\u0012\u001f\u0001\r\ny1\t[3dWB|\u0017N\u001c;Ti\u0006$X\r\u0005\u0002H\u00116\tA(\u0003\u0002J\u0001\n)a+\u00197vK\"91\n\u0010b\u0001\n\u0003a\u0015aC%oSRL\u0017\r\\5{K\u0012,\u0012A\u0012\u0005\u0007\u001dr\u0002\u000b\u0011\u0002$\u0002\u0019%s\u0017\u000e^5bY&TX\r\u001a\u0011\t\u000fAc$\u0019!C\u0001\u0019\u000691\u000b^1si\u0016$\u0007B\u0002*=A\u0003%a)\u0001\u0005Ti\u0006\u0014H/\u001a3!\u0011\u001d!FH1A\u0005\u00021\u000bqa\u0015;paB,G\r\u0003\u0004Wy\u0001\u0006IAR\u0001\t'R|\u0007\u000f]3eA!9\u0001\f\u0001b\u0001\n\u0013I\u0016A\u00064viV\u0014X-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003i\u0003\"a\u00170\u000e\u0003qS!!X\b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002`9\nyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\r\u0005\u0004\u0001\u0015!\u0003[\u0003]1W\u000f^;sK\u0016CXmY;uS>t7i\u001c8uKb$\b\u0005C\u0004d\u0001\t\u0007I\u0011\u00033\u0002\u0011M$(/Z1n\u0013\u0012,\u0012!\u001a\t\u0003\u001d\u0019L!aZ\b\u0003\u0007%sG\u000f\u0003\u0004j\u0001\u0001\u0006I!Z\u0001\ngR\u0014X-Y7JI\u0002Bqa\u001b\u0001C\u0002\u0013%A.A\u0005ti>\u0004H*\u0019;dQV\tQ\u000e\u0005\u0002oi6\tqN\u0003\u0002^a*\u0011\u0011O]\u0001\u0005kRLGNC\u0001t\u0003\u0011Q\u0017M^1\n\u0005U|'AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\u0007o\u0002\u0001\u000b\u0011B7\u0002\u0015M$x\u000e\u001d'bi\u000eD\u0007\u0005C\u0004z\u0001\t\u0007I\u0011\u00023\u0002'\u0011,g-Y;miJ+7\u000f^1si\u0012+G.Y=\t\rm\u0004\u0001\u0015!\u0003f\u0003Q!WMZ1vYR\u0014Vm\u001d;beR$U\r\\1zA!)Q\u0010\u0001D\u0001}\u0006Q\u0001/^:i'&tw\r\\3\u0015\u0007}\f)\u0001E\u0002\u000f\u0003\u0003I1!a\u0001\u0010\u0005\u0011)f.\u001b;\t\r\u0005\u001dA\u00101\u0001'\u0003\u0011!\u0017\r^1\t\u000f\u0005-\u0001A\"\u0001\u0002\u000e\u0005I\u0001/^:i\u0005f$Xm\u001d\u000b\b\u007f\u0006=\u0011qDA\u0015\u0011!\t\t\"!\u0003A\u0002\u0005M\u0011!\u00022zi\u0016\u001c\b\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005e!/A\u0002oS>LA!!\b\u0002\u0018\tQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\u0005\u0005\u0012\u0011\u0002a\u0001\u0003G\t\u0001c\u001c9uS>t\u0017\r\\'fi\u0006$\u0017\r^1\u0011\t9\t)CJ\u0005\u0004\u0003Oy!AB(qi&|g\u000e\u0003\u0005\u0002,\u0005%\u0001\u0019AA\u0017\u0003=y\u0007\u000f^5p]\u0006d'\t\\8dW&#\u0007#\u0002\b\u0002&\u0005=\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ub!A\u0004ti>\u0014\u0018mZ3\n\t\u0005e\u00121\u0007\u0002\u000e'R\u0014X-Y7CY>\u001c7.\u00133\t\u000f\u0005u\u0002A\"\u0001\u0002@\u0005a\u0001/^:i\u0013R,'/\u0019;peR9q0!\u0011\u0002f\u0005\u001d\u0004\u0002CA\"\u0003w\u0001\r!!\u0012\u0002\u0011%$XM]1u_J\u0004D!a\u0012\u0002bA1\u0011\u0011JA-\u0003?rA!a\u0013\u0002V9!\u0011QJA*\u001b\t\tyEC\u0002\u0002Ra\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u0007\u0005]s\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0013Q\f\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011qK\b\u0011\u0007}\t\t\u0007B\u0006\u0002d\u0005\u0005\u0013\u0011!A\u0001\u0006\u0003\u0011#aA0%e!A\u0011\u0011EA\u001e\u0001\u0004\t\u0019\u0003\u0003\u0005\u0002,\u0005m\u0002\u0019AA\u0017\u0011\u001d\tY\u0007\u0001D\u0001\u0003[\nq\u0002];tQ\u0006\u0013(/Y=Ck\u001a4WM\u001d\u000b\b\u007f\u0006=\u00141RAG\u0011!\t\t(!\u001bA\u0002\u0005M\u0014aC1se\u0006L()\u001e4gKJ\u0004D!!\u001e\u0002\bB1\u0011qOAA\u0003\u000bk!!!\u001f\u000b\t\u0005m\u0014QP\u0001\b[V$\u0018M\u00197f\u0015\r\tyhD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAB\u0003s\u00121\"\u0011:sCf\u0014UO\u001a4feB\u0019q$a\"\u0005\u0017\u0005%\u0015qNA\u0001\u0002\u0003\u0015\tA\t\u0002\u0004?\u0012\u001a\u0004\u0002CA\u0011\u0003S\u0002\r!a\t\t\u0011\u0005-\u0012\u0011\u000ea\u0001\u0003[Aq!!%\u0001\r\u0003\t\u0019*A\u0006sKB|'\u000f^#se>\u0014H#B@\u0002\u0016\u0006\u001d\u0006\u0002CAL\u0003\u001f\u0003\r!!'\u0002\u000f5,7o]1hKB!\u00111TAQ\u001d\rq\u0011QT\u0005\u0004\u0003?{\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002$\u0006\u0015&AB*ue&twMC\u0002\u0002 >A\u0001\"!+\u0002\u0010\u0002\u0007\u00111V\u0001\ni\"\u0014xn^1cY\u0016\u0004B!!\u0013\u0002.&!\u0011qVA/\u0005%!\u0006N]8xC\ndW\rC\u0004\u00024\u0002!\t\"!.\u0002\u000f=t7\u000b^1siR\tq\u0010C\u0004\u0002:\u0002!\t\"a/\u0002\r=t7\u000b^8q)\u0015y\u0018QXA`\u0011!\t9*a.A\u0002\u0005e\u0005\u0002CAa\u0003o\u0003\r!a1\u0002\u000b\u0015\u0014(o\u001c:\u0011\u000b9\t)#a+\t\u000f\u0005\u001d\u0007\u0001\"\u0005\u00026\u0006yqN\u001c*fG\u0016Lg/\u001a:Ti\u0006\u0014H\u000fC\u0004\u0002L\u0002!\t\"!4\u0002\u001d=t'+Z2fSZ,'o\u0015;paR)q0a4\u0002R\"A\u0011qSAe\u0001\u0004\tI\n\u0003\u0005\u0002B\u0006%\u0007\u0019AAb\u0011\u001d\t)\u000e\u0001C\u0001\u0003k\u000bQa\u001d;beRDq!!7\u0001\t\u0003\tY.\u0001\u0003ti>\u0004H#B@\u0002^\u0006}\u0007\u0002CAL\u0003/\u0004\r!!'\t\u0011\u0005\u0005\u0017q\u001ba\u0001\u0003\u0007Dq!a9\u0001\t\u0003\t),A\u0007ti\u0006\u0014HOU3dK&4XM\u001d\u0005\b\u0003O\u0004A\u0011AAu\u00031\u0019Ho\u001c9SK\u000e,\u0017N^3s)\u0015y\u00181^Aw\u0011!\t9*!:A\u0002\u0005e\u0005\u0002CAa\u0003K\u0004\r!a1\t\u000f\u0005E\b\u0001\"\u0001\u0002t\u0006y!/Z:uCJ$(+Z2fSZ,'\u000fF\u0003\u0000\u0003k\f9\u0010\u0003\u0005\u0002\u0018\u0006=\b\u0019AAM\u0011)\t\t-a<\u0011\u0002\u0003\u0007\u00111\u0019\u0005\b\u0003c\u0004A\u0011AA~)\u001dy\u0018Q`A\u0000\u0005\u0003A\u0001\"a&\u0002z\u0002\u0007\u0011\u0011\u0014\u0005\t\u0003\u0003\fI\u00101\u0001\u0002D\"9!1AA}\u0001\u0004)\u0017!\u00023fY\u0006L\bb\u0002B\u0004\u0001\u0011\u0005!\u0011B\u0001\u0012SN\u0014VmY3jm\u0016\u00148\u000b^1si\u0016$GC\u0001B\u0006!\rq!QB\u0005\u0004\u0005\u001fy!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005'\u0001A\u0011\u0001B\u0005\u0003EI7OU3dK&4XM]*u_B\u0004X\r\u001a\u0005\b\u0005/\u0001A\u0011AA[\u0003A\tw/Y5u)\u0016\u0014X.\u001b8bi&|g\u000eC\u0005\u0003\u001c\u0001\u0001\r\u0011\"\u0005\u0003\u001e\u0005i1\u000f^8qa&tw-\u0012:s_J,\"!a+\t\u0013\t\u0005\u0002\u00011A\u0005\u0012\t\r\u0012!E:u_B\u0004\u0018N\\4FeJ|'o\u0018\u0013fcR\u0019qP!\n\t\u0015\t\u001d\"qDA\u0001\u0002\u0004\tY+A\u0002yIEB\u0001Ba\u000b\u0001A\u0003&\u00111V\u0001\u000fgR|\u0007\u000f]5oO\u0016\u0013(o\u001c:!Q\u0011\u0011ICa\f\u0011\u00079\u0011\t$C\u0002\u00034=\u0011\u0001B^8mCRLG.\u001a\u0005\u000b\u0005o\u0001\u0001\u0019!C\u0001\t\te\u0012!\u0004:fG\u0016Lg/\u001a:Ti\u0006$X-\u0006\u0002\u0003<A\u0019!Q\b%\u000f\u0005mB\u0004B\u0003B!\u0001\u0001\u0007I\u0011\u0001\u0003\u0003D\u0005\t\"/Z2fSZ,'o\u0015;bi\u0016|F%Z9\u0015\u0007}\u0014)\u0005\u0003\u0006\u0003(\t}\u0012\u0011!a\u0001\u0005wA\u0001B!\u0013\u0001A\u0003&!1H\u0001\u000fe\u0016\u001cW-\u001b<feN#\u0018\r^3!Q\u0011\u00119Ea\f\t\u0013\t=\u0003!%A\u0005\u0002\tE\u0013!\u0007:fgR\f'\u000f\u001e*fG\u0016Lg/\u001a:%I\u00164\u0017-\u001e7uII*\"Aa\u0015+\t\u0005\r'QK\u0016\u0003\u0005/\u0002BA!\u0017\u0003d5\u0011!1\f\u0006\u0005\u0005;\u0012y&A\u0005v]\u000eDWmY6fI*\u0019!\u0011M\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003f\tm#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public abstract class ReceiverSupervisor
implements Logging {
    private final Receiver<?> receiver;
    private final ExecutionContextExecutorService futureExecutionContext;
    private final int streamId;
    private final CountDownLatch stopLatch;
    private final int defaultRestartDelay;
    private volatile Throwable stoppingError;
    private volatile Enumeration.Value receiverState;
    private volatile ReceiverSupervisor$ReceiverState$ ReceiverState$module;
    private transient Logger org$apache$spark$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReceiverSupervisor$ReceiverState$ ReceiverState$lzycompute() {
        ReceiverSupervisor receiverSupervisor = this;
        synchronized (receiverSupervisor) {
            if (this.ReceiverState$module != null) return this.ReceiverState$module;
            this.ReceiverState$module = new ReceiverSupervisor$ReceiverState$(this);
            return this.ReceiverState$module;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ReceiverSupervisor$ReceiverState$ ReceiverState() {
        return this.ReceiverState$module == null ? this.ReceiverState$lzycompute() : this.ReceiverState$module;
    }

    private ExecutionContextExecutorService futureExecutionContext() {
        return this.futureExecutionContext;
    }

    public int streamId() {
        return this.streamId;
    }

    private CountDownLatch stopLatch() {
        return this.stopLatch;
    }

    private int defaultRestartDelay() {
        return this.defaultRestartDelay;
    }

    public Throwable stoppingError() {
        return this.stoppingError;
    }

    public void stoppingError_$eq(Throwable x$1) {
        this.stoppingError = x$1;
    }

    public Enumeration.Value receiverState() {
        return this.receiverState;
    }

    public void receiverState_$eq(Enumeration.Value x$1) {
        this.receiverState = x$1;
    }

    public abstract void pushSingle(Object var1);

    public abstract void pushBytes(ByteBuffer var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushIterator(Iterator<?> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushArrayBuffer(ArrayBuffer<?> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void reportError(String var1, Throwable var2);

    public void onStart() {
    }

    public void onStop(String message, Option<Throwable> error) {
    }

    public void onReceiverStart() {
    }

    public void onReceiverStop(String message, Option<Throwable> error) {
    }

    public void start() {
        this.onStart();
        this.startReceiver();
    }

    public void stop(String message, Option<Throwable> error) {
        this.stoppingError_$eq((Throwable)error.orNull(Predef$.MODULE$.$conforms()));
        this.stopReceiver(message, error);
        this.onStop(message, error);
        this.futureExecutionContext().shutdownNow();
        this.stopLatch().countDown();
    }

    public synchronized void startReceiver() {
        try {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting receiver";
                }
            });
            this.receiver.onStart();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Called receiver onStart";
                }
            });
            this.onReceiverStart();
            this.receiverState_$eq(this.ReceiverState().Started());
        }
        catch (Throwable throwable) {
            this.stop(new StringBuilder().append((Object)"Error starting receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).toString(), (Option<Throwable>)new Some((Object)throwable));
        }
    }

    public synchronized void stopReceiver(String message, Option<Throwable> error) {
        try {
            this.logInfo((Function0<String>)new Serializable(this, message, error){
                public static final long serialVersionUID = 0L;
                private final String message$2;
                private final Option error$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopping receiver with message: ").append((Object)this.message$2).append((Object)": ").append(this.error$2.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    })).toString();
                }
                {
                    this.message$2 = message$2;
                    this.error$2 = error$2;
                }
            });
            this.receiverState_$eq(this.ReceiverState().Stopped());
            this.receiver.onStop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Called receiver onStop";
                }
            });
            this.onReceiverStop(message, error);
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverSupervisor $outer;
                private final Throwable t$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Error stopping receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).append((Object)Predef.RichException$.MODULE$.getStackTraceString$extension(Predef$.MODULE$.RichException(this.t$1))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.t$1 = t$1;
                }
            });
        }
    }

    public void restartReceiver(String message, Option<Throwable> error) {
        this.restartReceiver(message, error, this.defaultRestartDelay());
    }

    public void restartReceiver(String message, Option<Throwable> error, int delay) {
        Future$.MODULE$.apply((Function0)new Serializable(this, message, error, delay){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;
            public final String message$1;
            private final Option error$1;
            public final int delay$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$restartReceiver$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Restarting receiver with delay ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.delay$1)).append((Object)" ms: ").append((Object)this.$outer.message$1).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Throwable)this.error$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                this.$outer.stopReceiver(new StringBuilder().append((Object)"Restarting receiver with delay ").append((Object)BoxesRunTime.boxToInteger((int)this.delay$1)).append((Object)"ms: ").append((Object)this.message$1).toString(), (Option<Throwable>)this.error$1);
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$restartReceiver$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Sleeping for ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.delay$1)).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Thread.sleep(this.delay$1);
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting receiver again";
                    }
                });
                this.$outer.startReceiver();
                this.$outer.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Receiver started again";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$1 = message$1;
                this.error$1 = error$1;
                this.delay$1 = delay$1;
            }
        }, (ExecutionContext)this.futureExecutionContext());
    }

    public Option<Throwable> restartReceiver$default$2() {
        return None$.MODULE$;
    }

    public boolean isReceiverStarted() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"state = ").append((Object)this.$outer.receiverState()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean isReceiverStopped() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisor $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"state = ").append((Object)this.$outer.receiverState()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public void awaitTermination() {
        this.stopLatch().await();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting for executor stop is over";
            }
        });
        if (this.stoppingError() == null) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopped executor without error";
                }
            });
        } else {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverSupervisor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopped executor with error: ").append((Object)this.$outer.stoppingError()).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.stoppingError() == null) {
            return;
        }
        throw this.stoppingError();
    }

    public ReceiverSupervisor(Receiver<?> receiver, SparkConf conf) {
        this.receiver = receiver;
        Logging.class.$init$((Logging)this);
        receiver.attachExecutor(this);
        this.futureExecutionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("receiver-supervisor-future", 128));
        this.streamId = receiver.streamId();
        this.stopLatch = new CountDownLatch(1);
        this.defaultRestartDelay = conf.getInt("spark.streaming.receiverRestartDelay", 2000);
        this.stoppingError = null;
        this.receiverState = this.ReceiverState().Initialized();
    }
}

