/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import org.apache.spark.Logging;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.InputInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3Q!\u0001\u0002\u0001\t1\u0011\u0001#\u00138qkRLeNZ8Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0004gN\u001c7\u0001\u0001\t\u00037qi\u0011\u0001B\u0005\u0003;\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\t\t3\u0005\u0005\u0002#\u00015\t!\u0001C\u0003\u0019=\u0001\u0007!\u0004C\u0004&\u0001\t\u0007I\u0011\u0002\u0014\u0002+\t\fGo\u00195US6,Gk\\%oaV$\u0018J\u001c4pgV\tq\u0005\u0005\u0003)[=\u0012T\"A\u0015\u000b\u0005)Z\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003Y=\t!bY8mY\u0016\u001cG/[8o\u0013\tq\u0013FA\u0004ICNDW*\u00199\u0011\u0005m\u0001\u0014BA\u0019\u0005\u0005\u0011!\u0016.\\3\u0011\t!j3G\u000e\t\u0003\u001dQJ!!N\b\u0003\u0007%sG\u000f\u0005\u0002#o%\u0011\u0001H\u0001\u0002\n\u0013:\u0004X\u000f^%oM>DaA\u000f\u0001!\u0002\u00139\u0013A\u00062bi\u000eDG+[7f)>Le\u000e];u\u0013:4wn\u001d\u0011\t\u000bq\u0002A\u0011A\u001f\u0002\u0015I,\u0007o\u001c:u\u0013:4w\u000eF\u0002?\u0003\u000e\u0003\"AD \n\u0005\u0001{!\u0001B+oSRDQAQ\u001eA\u0002=\n\u0011BY1uG\"$\u0016.\\3\t\u000b\u0011[\u0004\u0019\u0001\u001c\u0002\u0013%t\u0007/\u001e;J]\u001a|\u0007\"\u0002$\u0001\t\u00039\u0015aB4fi&sgm\u001c\u000b\u0003\u0011>\u0003B!\u0013'4m9\u0011aBS\u0005\u0003\u0017>\ta\u0001\u0015:fI\u00164\u0017BA'O\u0005\ri\u0015\r\u001d\u0006\u0003\u0017>AQAQ#A\u0002=BQ!\u0015\u0001\u0005\u0002I\u000bqa\u00197fC:,\b\u000f\u0006\u0002?'\")A\u000b\u0015a\u0001_\u0005y!-\u0019;dQRC'/Z:i)&lW\r")
public class InputInfoTracker
implements Logging {
    private final HashMap<Time, HashMap<Object, InputInfo>> batchTimeToInputInfos;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private HashMap<Time, HashMap<Object, InputInfo>> batchTimeToInputInfos() {
        return this.batchTimeToInputInfos;
    }

    public void reportInfo(Time batchTime, InputInfo inputInfo) {
        InputInfoTracker inputInfoTracker = this;
        synchronized (inputInfoTracker) {
            HashMap inputInfos = (HashMap)this.batchTimeToInputInfos().getOrElseUpdate((Object)batchTime, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final HashMap<Object, InputInfo> apply() {
                    return new HashMap();
                }
            });
            if (inputInfos.contains((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId()))) {
                throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input stream ", "} for batch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is already added into InputInfoTracker, this is a illegal state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchTime}))).toString());
            }
            inputInfos.$plus$eq(new Tuple2((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId()), (Object)inputInfo));
            return;
        }
    }

    public synchronized Map<Object, InputInfo> getInfo(Time batchTime) {
        Option inputInfos = this.batchTimeToInputInfos().get((Object)batchTime);
        return (Map)inputInfos.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, InputInfo> apply(HashMap<Object, InputInfo> x$1) {
                return x$1.toMap(Predef$.MODULE$.$conforms());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, InputInfo> apply() {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            }
        });
    }

    public void cleanup(Time batchThreshTime) {
        InputInfoTracker inputInfoTracker = this;
        synchronized (inputInfoTracker) {
            Iterable timesToCleanup = (Iterable)this.batchTimeToInputInfos().keys().filter((Function1)new Serializable(this, batchThreshTime){
                public static final long serialVersionUID = 0L;
                private final Time batchThreshTime$1;

                public final boolean apply(Time x$2) {
                    return x$2.$less(this.batchThreshTime$1);
                }
                {
                    this.batchThreshTime$1 = batchThreshTime$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(this, timesToCleanup){
                public static final long serialVersionUID = 0L;
                private final Iterable timesToCleanup$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"remove old batch metadata: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timesToCleanup$1.mkString(" ")}));
                }
                {
                    this.timesToCleanup$1 = timesToCleanup$1;
                }
            });
            this.batchTimeToInputInfos().$minus$minus$eq((TraversableOnce)timesToCleanup);
            return;
        }
    }

    public InputInfoTracker(StreamingContext ssc) {
        Logging.class.$init$((Logging)this);
        this.batchTimeToInputInfos = new HashMap();
    }
}

