/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.spark.Logging;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockTracker;
import org.apache.spark.streaming.scheduler.ReceiverInfo;
import org.apache.spark.streaming.scheduler.ReceiverInfo$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.SynchronizedMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t5f!B\u0001\u0003\u0001\u0011a!a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0004gN\u001c7\u0001\u0001\t\u00037qi\u0011\u0001B\u0005\u0003;\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n!c]6jaJ+7-Z5wKJd\u0015-\u001e8dQB\u0011a\"I\u0005\u0003E=\u0011qAQ8pY\u0016\fg\u000eC\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0004M!J\u0003CA\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\r$\u0001\u0004Q\u0002bB\u0010$!\u0003\u0005\r\u0001\t\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0003Q\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ngV\tQ\u0006E\u0002\u000f]AJ!aL\b\u0003\u000b\u0005\u0013(/Y=1\u0005EJ\u0004c\u0001\u001a6o5\t1G\u0003\u00025\t\u00059Am\u001d;sK\u0006l\u0017B\u0001\u001c4\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0011\u0001(\u000f\u0007\u0001\t%Q\u0004!!A\u0001\u0002\u000b\u0005qHA\u0002`I]J!\u0001P\u001f\u0002/\u001d,GOU3dK&4XM]%oaV$8\u000b\u001e:fC6\u001c\u0018B\u0001 \u0005\u00051!5\u000b\u001e:fC6<%/\u00199i#\t\u00015\t\u0005\u0002\u000f\u0003&\u0011!i\u0004\u0002\b\u001d>$\b.\u001b8h!\tqA)\u0003\u0002F\u001f\t\u0019\u0011I\\=\t\r\u001d\u0003\u0001\u0015!\u0003.\u0003U\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ng\u0002Bq!\u0013\u0001C\u0002\u0013%!*\u0001\fsK\u000e,\u0017N^3s\u0013:\u0004X\u000f^*ue\u0016\fW.\u00133t+\u0005Y\u0005c\u0001\b/\u0019B\u0011a\"T\u0005\u0003\u001d>\u00111!\u00138u\u0011\u0019\u0001\u0006\u0001)A\u0005\u0017\u00069\"/Z2fSZ,'/\u00138qkR\u001cFO]3b[&#7\u000f\t\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0003A\u0011XmY3jm\u0016\u0014X\t_3dkR|'/F\u0001U!\t)f+D\u0001\u0001\r\u00119\u0006\u0001\u0001-\u0003!I+7-Z5wKJd\u0015-\u001e8dQ\u0016\u00148C\u0001,\u000e\u0011\u0015!c\u000b\"\u0001[)\u0005!\u0006\"\u0002/W\t\u0003i\u0016!B:uCJ$H#\u00010\u0011\u00059y\u0016B\u00011\u0010\u0005\u0011)f.\u001b;\t\u000b\t4F\u0011A2\u0002\tM$x\u000e\u001d\u000b\u0003=\u0012DQ!Z1A\u0002\u0001\n\u0001b\u001a:bG\u00164W\u000f\u001c\u0005\u0006OZ#I!X\u0001\u000fgR\f'\u000f\u001e*fG\u0016Lg/\u001a:t\u0011\u0015Ig\u000b\"\u0003^\u00035\u0019Ho\u001c9SK\u000e,\u0017N^3sg\"91N\u0016b\u0001\n\u0003a\u0017aA3omV\tQ\u000e\u0005\u0002\u0015]&\u0011qN\u0002\u0002\t'B\f'o[#om\"1\u0011O\u0016Q\u0001\n5\fA!\u001a8wA!\u0012\u0001o\u001d\t\u0003\u001dQL!!^\b\u0003\u0013Q\u0014\u0018M\\:jK:$\bbB<W\u0001\u0004%I\u0001_\u0001\beVtg.\u001b8h+\u0005\u0001\u0003b\u0002>W\u0001\u0004%Ia_\u0001\feVtg.\u001b8h?\u0012*\u0017\u000f\u0006\u0002_y\"9Q0_A\u0001\u0002\u0004\u0001\u0013a\u0001=%c!1qP\u0016Q!\n\u0001\n\u0001B];o]&tw\r\t\u0015\u0003}ND3A`A\u0003!\rq\u0011qA\u0005\u0004\u0003\u0013y!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u00055aK1A\u0005\u0002\u0005=\u0011A\u0002;ie\u0016\fG-\u0006\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011\u0001\u00027b]\u001eT!!a\u0007\u0002\t)\fg/Y\u0005\u0005\u0003?\t)B\u0001\u0004UQJ,\u0017\r\u001a\u0005\t\u0003G1\u0006\u0015!\u0003\u0002\u0012\u00059A\u000f\u001b:fC\u0012\u0004\u0003fAA\u0011g\"9\u0011\u0011\u0006\u0001!\u0002\u0013!\u0016!\u0005:fG\u0016Lg/\u001a:Fq\u0016\u001cW\u000f^8sA!I\u0011Q\u0006\u0001C\u0002\u0013%\u0011qF\u0001\re\u0016\u001cW-\u001b<fe&sgm\\\u000b\u0003\u0003c\u0011b!a\r\u0002<\u0005EcaBA\u001b\u0003o\u0001\u0011\u0011\u0007\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u00022\u0005i!/Z2fSZ,'/\u00138g_\u0002\u0002r!!\u0010\u0002H1\u000bY%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u001diW\u000f^1cY\u0016T1!!\u0012\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0013\nyDA\u0004ICNDW*\u00199\u0011\u0007\u001d\ni%C\u0002\u0002P\t\u0011ABU3dK&4XM]%oM>\u0004r!!\u0010\u0002T1\u000bY%\u0003\u0003\u0002V\u0005}\"aD*z]\u000eD'o\u001c8ju\u0016$W*\u00199\t\u0013\u0005e\u0003A1A\u0005\n\u0005m\u0013\u0001\u0006:fG\u0016Lg/\u001a3CY>\u001c7\u000e\u0016:bG.,'/\u0006\u0002\u0002^A\u0019q%a\u0018\n\u0007\u0005\u0005$A\u0001\u000bSK\u000e,\u0017N^3e\u00052|7m\u001b+sC\u000e\\WM\u001d\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002^\u0005)\"/Z2fSZ,GM\u00117pG.$&/Y2lKJ\u0004\u0003\"CA5\u0001\t\u0007I\u0011BA6\u0003-a\u0017n\u001d;f]\u0016\u0014()^:\u0016\u0005\u00055\u0004cA\u0014\u0002p%\u0019\u0011\u0011\u000f\u0002\u0003)M#(/Z1nS:<G*[:uK:,'OQ;t\u0011!\t)\b\u0001Q\u0001\n\u00055\u0014\u0001\u00047jgR,g.\u001a:CkN\u0004\u0003\"CA=\u0001\u0001\u0007I\u0011BA>\u0003!)g\u000e\u001a9pS:$XCAA?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAAB\r\u0005\u0019!\u000f]2\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011%\tY\t\u0001a\u0001\n\u0013\ti)\u0001\u0007f]\u0012\u0004x.\u001b8u?\u0012*\u0017\u000fF\u0002_\u0003\u001fC\u0011\"`AE\u0003\u0003\u0005\r!! \t\u0011\u0005M\u0005\u0001)Q\u0005\u0003{\n\u0011\"\u001a8ea>Lg\u000e\u001e\u0011\t\u000bq\u0003A\u0011A/\t\r\t\u0004A\u0011AAM)\rq\u00161\u0014\u0005\u0007K\u0006]\u0005\u0019\u0001\u0011\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\u0006)\u0012\r\u001c7pG\u0006$XM\u00117pG.\u001cHk\u001c\"bi\u000eDGc\u00010\u0002$\"A\u0011QUAO\u0001\u0004\t9+A\u0005cCR\u001c\u0007\u000eV5nKB\u00191$!+\n\u0007\u0005-FA\u0001\u0003US6,\u0007bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\u0011O\u0016$(\t\\8dWN|eMQ1uG\"$B!a-\u0002`B9\u0011QWA^\u0019\u0006\u0005gb\u0001\b\u00028&\u0019\u0011\u0011X\b\u0002\rA\u0013X\rZ3g\u0013\u0011\ti,a0\u0003\u00075\u000b\u0007OC\u0002\u0002:>\u0001b!a1\u0002T\u0006eg\u0002BAc\u0003\u001ftA!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017L\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\r\t\tnD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t).a6\u0003\u0007M+\u0017OC\u0002\u0002R>\u00012aJAn\u0013\r\tiN\u0001\u0002\u0012%\u0016\u001cW-\u001b<fI\ncwnY6J]\u001a|\u0007\u0002CAS\u0003[\u0003\r!a*\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\u0006Ir-\u001a;CY>\u001c7n](g\u0005\u0006$8\r[!oIN#(/Z1n)\u0019\t\t-a:\u0002j\"A\u0011QUAq\u0001\u0004\t9\u000bC\u0004\u0002l\u0006\u0005\b\u0019\u0001'\u0002\u0011M$(/Z1n\u0013\u0012Dq!a<\u0001\t\u0003\t\t0\u0001\u000edY\u0016\fg.\u001e9PY\u0012\u0014En\\2lg\u0006sGMQ1uG\",7\u000fF\u0002_\u0003gD\u0001\"!>\u0002n\u0002\u0007\u0011qU\u0001\u0012G2,\u0017M\\;q)\"\u0014Xm\u001d5US6,\u0007bBA}\u0001\u0011%\u00111`\u0001\u0011e\u0016<\u0017n\u001d;feJ+7-Z5wKJ$2BXA\u007f\u0003\u007f\u0014IA!\u0004\u0003\u0012!9\u00111^A|\u0001\u0004a\u0005\u0002\u0003B\u0001\u0003o\u0004\rAa\u0001\u0002\u0007QL\b\u000f\u0005\u0003\u00026\n\u0015\u0011\u0002\u0002B\u0004\u0003\u007f\u0013aa\u0015;sS:<\u0007\u0002\u0003B\u0006\u0003o\u0004\rAa\u0001\u0002\t!|7\u000f\u001e\u0005\t\u0005\u001f\t9\u00101\u0001\u0002~\u0005\u0001\"/Z2fSZ,'/\u00128ea>Lg\u000e\u001e\u0005\t\u0005'\t9\u00101\u0001\u0003\u0016\u0005i1/\u001a8eKJ\fE\r\u001a:fgN\u0004B!a \u0003\u0018%!!\u0011DAA\u0005)\u0011\u0006oY!eIJ,7o\u001d\u0005\b\u0005;\u0001A\u0011\u0002B\u0010\u0003I!WM]3hSN$XM\u001d*fG\u0016Lg/\u001a:\u0015\u000fy\u0013\tCa\t\u0003(!9\u00111\u001eB\u000e\u0001\u0004a\u0005\u0002\u0003B\u0013\u00057\u0001\rAa\u0001\u0002\u000f5,7o]1hK\"A!\u0011\u0006B\u000e\u0001\u0004\u0011\u0019!A\u0003feJ|'\u000fC\u0004\u0003.\u0001!IAa\f\u0002\u0011\u0005$GM\u00117pG.$2\u0001\tB\u0019\u0011!\u0011\u0019Da\u000bA\u0002\u0005e\u0017!\u0005:fG\u0016Lg/\u001a3CY>\u001c7.\u00138g_\"9!q\u0007\u0001\u0005\n\te\u0012a\u0003:fa>\u0014H/\u0012:s_J$rA\u0018B\u001e\u0005{\u0011y\u0004C\u0004\u0002l\nU\u0002\u0019\u0001'\t\u0011\t\u0015\"Q\u0007a\u0001\u0005\u0007A\u0001B!\u000b\u00036\u0001\u0007!1\u0001\u0005\u0007\u0005\u0007\u0002A\u0011\u0001=\u0002)!\f7/\u00168bY2|7-\u0019;fI\ncwnY6t\r\u0019\u00119\u0005\u0001\u0003\u0003J\t9\"+Z2fSZ,'\u000f\u0016:bG.,'/\u00128ea>Lg\u000e^\n\u0006\u0005\u000bj!1\n\t\u0005\u0003\u007f\u0012i%\u0003\u0003\u0003P\u0005\u0005%!\u0006+ie\u0016\fGmU1gKJ\u00038-\u00128ea>Lg\u000e\u001e\u0005\f\u0005'\u0012)E!b\u0001\n\u0003\u0012)&\u0001\u0004sa\u000e,eN^\u000b\u0003\u0005/\u0002B!a \u0003Z%!!1LAA\u0005\u0019\u0011\u0006oY#om\"Y!q\fB#\u0005\u0003\u0005\u000b\u0011\u0002B,\u0003\u001d\u0011\boY#om\u0002Bq\u0001\nB#\t\u0003\u0011\u0019\u0007\u0006\u0003\u0003f\t\u001d\u0004cA+\u0003F!A!1\u000bB1\u0001\u0004\u00119\u0006\u0003\u0005\u0003l\t\u0015C\u0011\tB7\u0003\u001d\u0011XmY3jm\u0016,\"Aa\u001c\u0011\u000b9\u0011\th\u00110\n\u0007\tMtBA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o\u0011!\u00119H!\u0012\u0005B\te\u0014a\u0004:fG\u0016Lg/Z!oIJ+\u0007\u000f\\=\u0015\t\t=$1\u0010\u0005\t\u0005{\u0012)\b1\u0001\u0003\u0000\u000591m\u001c8uKb$\b\u0003BA@\u0005\u0003KAAa!\u0002\u0002\nq!\u000b]2DC2d7i\u001c8uKb$xA\u0003BD\u0005\u0005\u0005\t\u0012\u0001\u0003\u0003\n\u0006y!+Z2fSZ,'\u000f\u0016:bG.,'\u000fE\u0002(\u0005\u00173\u0011\"\u0001\u0002\u0002\u0002#\u0005AA!$\u0014\u0007\t-U\u0002C\u0004%\u0005\u0017#\tA!%\u0015\u0005\t%\u0005B\u0003BK\u0005\u0017\u000b\n\u0011\"\u0001\u0003\u0018\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"A!'+\u0007\u0001\u0012Yj\u000b\u0002\u0003\u001eB!!q\u0014BU\u001b\t\u0011\tK\u0003\u0003\u0003$\n\u0015\u0016!C;oG\",7m[3e\u0015\r\u00119kD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BV\u0005C\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReceiverTracker
implements Logging {
    public final StreamingContext org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc;
    private final boolean skipReceiverLaunch;
    private final ReceiverInputDStream<?>[] org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams;
    private final int[] receiverInputStreamIds;
    private final ReceiverLauncher receiverExecutor;
    private final HashMap<Object, ReceiverInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo;
    private final ReceivedBlockTracker receivedBlockTracker;
    private final StreamingListenerBus listenerBus;
    private RpcEndpointRef endpoint;
    private transient Logger org$apache$spark$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return ReceiverTracker$.MODULE$.$lessinit$greater$default$2();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ReceiverInputDStream<?>[] org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams;
    }

    private int[] receiverInputStreamIds() {
        return this.receiverInputStreamIds;
    }

    private ReceiverLauncher receiverExecutor() {
        return this.receiverExecutor;
    }

    public HashMap<Object, ReceiverInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo;
    }

    private ReceivedBlockTracker receivedBlockTracker() {
        return this.receivedBlockTracker;
    }

    private StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public synchronized void start() {
        if (this.endpoint() == null) {
            if (!Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).isEmpty()) {
                this.endpoint_$eq(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().setupEndpoint("ReceiverTracker", (RpcEndpoint)new ReceiverTrackerEndpoint(this, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv())));
                if (!this.skipReceiverLaunch) {
                    this.receiverExecutor().start();
                }
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "ReceiverTracker started";
                    }
                });
            }
            return;
        }
        throw new SparkException("ReceiverTracker already started");
    }

    public synchronized void stop(boolean graceful) {
        if (!Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).isEmpty() && this.endpoint() != null) {
            if (!this.skipReceiverLaunch) {
                this.receiverExecutor().stop(graceful);
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().stop(this.endpoint());
            this.endpoint_$eq(null);
            this.receivedBlockTracker().stop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker stopped";
                }
            });
        }
    }

    public void allocateBlocksToBatch(Time batchTime) {
        if (Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).nonEmpty()) {
            this.receivedBlockTracker().allocateBlocksToBatch(batchTime);
        }
    }

    public Map<Object, Seq<ReceivedBlockInfo>> getBlocksOfBatch(Time batchTime) {
        return this.receivedBlockTracker().getBlocksOfBatch(batchTime);
    }

    public synchronized Seq<ReceivedBlockInfo> getBlocksOfBatchAndStream(Time batchTime, int streamId) {
        return this.receivedBlockTracker().getBlocksOfBatchAndStream(batchTime, streamId);
    }

    public void cleanupOldBlocksAndBatches(Time cleanupThreshTime) {
        this.receivedBlockTracker().cleanupOldBatches(cleanupThreshTime, false);
        if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf())) {
            this.logInfo((Function0<String>)new Serializable(this, cleanupThreshTime){
                public static final long serialVersionUID = 0L;
                private final Time cleanupThreshTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleanup old received batch data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanupThreshTime$1}));
                }
                {
                    this.cleanupThreshTime$1 = cleanupThreshTime$1;
                }
            });
            ((IterableLike)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<RpcEndpointRef> apply(ReceiverInfo info) {
                    return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)info.endpoint()));
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, cleanupThreshTime){
                public static final long serialVersionUID = 0L;
                private final Time cleanupThreshTime$1;

                public final void apply(RpcEndpointRef x$2) {
                    x$2.send((Object)new CleanupOldBlocks(this.cleanupThreshTime$1));
                }
                {
                    this.cleanupThreshTime$1 = cleanupThreshTime$1;
                }
            });
        }
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(int streamId, String typ, String host, RpcEndpointRef receiverEndpoint, RpcAddress senderAddress) {
        if (Predef$.MODULE$.intArrayOps(this.receiverInputStreamIds()).contains((Object)BoxesRunTime.boxToInteger((int)streamId))) {
            ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)new ReceiverInfo(streamId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typ, BoxesRunTime.boxToInteger((int)streamId)})), receiverEndpoint, true, host, ReceiverInfo$.MODULE$.apply$default$6(), ReceiverInfo$.MODULE$.apply$default$7(), ReceiverInfo$.MODULE$.apply$default$8()));
            this.listenerBus().post(new StreamingListenerReceiverStarted((ReceiverInfo)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            this.logInfo((Function0<String>)new Serializable(this, streamId, senderAddress){
                public static final long serialVersionUID = 0L;
                private final int streamId$1;
                private final RpcAddress senderAddress$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Registered receiver for stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$1)).append((Object)" from ").append((Object)this.senderAddress$1).toString();
                }
                {
                    this.streamId$1 = streamId$1;
                    this.senderAddress$1 = senderAddress$1;
                }
            });
            return;
        }
        throw new SparkException(new StringBuilder().append((Object)"Register received for unexpected id ").append((Object)BoxesRunTime.boxToInteger((int)streamId)).toString());
    }

    /*
     * Unable to fully structure code
     */
    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(int streamId, String message, String error) {
        block6: {
            block5: {
                block4: {
                    var4_4 = ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(var4_4 instanceof Some)) break block4;
                    var5_5 = (Some)var4_4;
                    oldInfo = (ReceiverInfo)var5_5.x();
                    if (error == null) ** GOTO lbl-1000
                    v0 = error;
                    var7_7 = "";
                    if (!(v0 != null ? v0.equals(var7_7) == false : var7_7 != null)) lbl-1000:
                    // 2 sources

                    {
                        v1 = -1L;
                    } else {
                        v1 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis();
                    }
                    lastErrorTime = v1;
                    x$9 = null;
                    x$10 = false;
                    x$11 = message;
                    x$12 = error;
                    x$13 = lastErrorTime;
                    x$14 = oldInfo.copy$default$1();
                    x$15 = oldInfo.copy$default$2();
                    x$16 = oldInfo.copy$default$5();
                    var19_17 = oldInfo.copy(x$14, x$15, null, x$10, x$16, x$11, x$12, x$13);
                    break block5;
                }
                if (!None$.MODULE$.equals(var4_4)) break block6;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                if (error == null) ** GOTO lbl-1000
                v2 = error;
                var20_18 = "";
                if (!(v2 != null ? v2.equals(var20_18) == false : var20_18 != null)) lbl-1000:
                // 2 sources

                {
                    v3 = -1L;
                } else {
                    v3 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis();
                }
                lastErrorTime = v3;
                var19_17 = new ReceiverInfo(streamId, "", null, false, "", message, error, lastErrorTime);
            }
            newReceiverInfo = var19_17;
            ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).$minus$eq((Object)BoxesRunTime.boxToInteger((int)streamId));
            this.listenerBus().post(new StreamingListenerReceiverStopped(newReceiverInfo));
            messageWithError = error == null || error.isEmpty() != false ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logError((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$2;
                private final String messageWithError$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deregistered receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$2), this.messageWithError$1}));
                }
                {
                    this.streamId$2 = streamId$2;
                    this.messageWithError$1 = messageWithError$1;
                }
            });
            return;
        }
        throw new MatchError((Object)var4_4);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(ReceivedBlockInfo receivedBlockInfo) {
        return this.receivedBlockTracker().addBlock(receivedBlockInfo);
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverInfo receiverInfo;
            block3: {
                block2: {
                    option = ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverInfo oldInfo = (ReceiverInfo)some.x();
                    String x$17 = message;
                    String x$18 = error;
                    int x$19 = oldInfo.copy$default$1();
                    String x$20 = oldInfo.copy$default$2();
                    RpcEndpointRef x$21 = oldInfo.copy$default$3();
                    boolean x$22 = oldInfo.copy$default$4();
                    String x$23 = oldInfo.copy$default$5();
                    long x$24 = oldInfo.copy$default$8();
                    receiverInfo = oldInfo.copy(x$19, x$20, x$21, x$22, x$23, x$17, x$18, x$24);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                receiverInfo = new ReceiverInfo(streamId, "", null, false, "", message, error, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis());
            }
            ReceiverInfo newReceiverInfo = receiverInfo;
            ((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverInfo);
            this.listenerBus().post(new StreamingListenerReceiverError((ReceiverInfo)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).apply((Object)BoxesRunTime.boxToInteger((int)streamId))));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logWarning((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$3;
                private final String messageWithError$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reported by receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$3), this.messageWithError$2}));
                }
                {
                    this.streamId$3 = streamId$3;
                    this.messageWithError$2 = messageWithError$2;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean hasUnallocatedBlocks() {
        return this.receivedBlockTracker().hasUnallocatedReceivedBlocks();
    }

    public ReceiverTracker(StreamingContext ssc, boolean skipReceiverLaunch) {
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc = ssc;
        this.skipReceiverLaunch = skipReceiverLaunch;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams = ssc.graph().getReceiverInputStreams();
        this.receiverInputStreamIds = (int[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ReceiverInputDStream<?> x$1) {
                return x$1.id();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.receiverExecutor = new ReceiverLauncher();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo = new SynchronizedMap<Object, ReceiverInfo>(this){

            public /* synthetic */ Option scala$collection$mutable$SynchronizedMap$$super$get(Object key) {
                return super.get(key);
            }

            public /* synthetic */ Iterator scala$collection$mutable$SynchronizedMap$$super$iterator() {
                return super.iterator();
            }

            public /* synthetic */ SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$$plus$eq(Tuple2 kv) {
                return (SynchronizedMap)super.$plus$eq(kv);
            }

            public /* synthetic */ SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$$minus$eq(Object key) {
                return (SynchronizedMap)super.$minus$eq(key);
            }

            public /* synthetic */ int scala$collection$mutable$SynchronizedMap$$super$size() {
                return super.size();
            }

            public /* synthetic */ Option scala$collection$mutable$SynchronizedMap$$super$put(Object key, Object value) {
                return super.put(key, value);
            }

            public /* synthetic */ void scala$collection$mutable$SynchronizedMap$$super$update(Object key, Object value) {
                super.update(key, value);
            }

            public /* synthetic */ Option scala$collection$mutable$SynchronizedMap$$super$remove(Object key) {
                return super.remove(key);
            }

            public /* synthetic */ void scala$collection$mutable$SynchronizedMap$$super$clear() {
                super.clear();
            }

            public /* synthetic */ Object scala$collection$mutable$SynchronizedMap$$super$getOrElseUpdate(Object key, Function0 op) {
                return MapLike.class.getOrElseUpdate((scala.collection.mutable.MapLike)this, (Object)key, (Function0)op);
            }

            public /* synthetic */ SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$transform(Function2 f) {
                return (SynchronizedMap)MapLike.class.transform((scala.collection.mutable.MapLike)this, (Function2)f);
            }

            public /* synthetic */ SynchronizedMap scala$collection$mutable$SynchronizedMap$$super$retain(Function2 p) {
                return (SynchronizedMap)MapLike.class.retain((scala.collection.mutable.MapLike)this, (Function2)p);
            }

            public /* synthetic */ Iterable scala$collection$mutable$SynchronizedMap$$super$values() {
                return super.values();
            }

            public /* synthetic */ Iterator scala$collection$mutable$SynchronizedMap$$super$valuesIterator() {
                return super.valuesIterator();
            }

            public /* synthetic */ scala.collection.mutable.Map scala$collection$mutable$SynchronizedMap$$super$clone() {
                return MapLike.class.clone((scala.collection.mutable.MapLike)this);
            }

            public /* synthetic */ void scala$collection$mutable$SynchronizedMap$$super$foreach(Function1 f) {
                super.foreach(f);
            }

            public /* synthetic */ Object scala$collection$mutable$SynchronizedMap$$super$apply(Object key) {
                return super.apply(key);
            }

            public /* synthetic */ Set scala$collection$mutable$SynchronizedMap$$super$keySet() {
                return super.keySet();
            }

            public /* synthetic */ Iterable scala$collection$mutable$SynchronizedMap$$super$keys() {
                return MapLike.class.keys((MapLike)this);
            }

            public /* synthetic */ Iterator scala$collection$mutable$SynchronizedMap$$super$keysIterator() {
                return super.keysIterator();
            }

            public /* synthetic */ boolean scala$collection$mutable$SynchronizedMap$$super$isEmpty() {
                return MapLike.class.isEmpty((MapLike)this);
            }

            public /* synthetic */ boolean scala$collection$mutable$SynchronizedMap$$super$contains(Object key) {
                return super.contains(key);
            }

            public /* synthetic */ boolean scala$collection$mutable$SynchronizedMap$$super$isDefinedAt(Object key) {
                return MapLike.class.isDefinedAt((MapLike)this, (Object)key);
            }

            public Option get(Object key) {
                return SynchronizedMap.class.get((SynchronizedMap)this, (Object)key);
            }

            public Iterator<Tuple2<Object, ReceiverInfo>> iterator() {
                return SynchronizedMap.class.iterator((SynchronizedMap)this);
            }

            public SynchronizedMap<Object, ReceiverInfo> $plus$eq(Tuple2<Object, ReceiverInfo> kv) {
                return SynchronizedMap.class.$plus$eq((SynchronizedMap)this, kv);
            }

            public SynchronizedMap $minus$eq(Object key) {
                return SynchronizedMap.class.$minus$eq((SynchronizedMap)this, (Object)key);
            }

            public int size() {
                return SynchronizedMap.class.size((SynchronizedMap)this);
            }

            public Option put(Object key, Object value) {
                return SynchronizedMap.class.put((SynchronizedMap)this, (Object)key, (Object)value);
            }

            public void update(Object key, Object value) {
                SynchronizedMap.class.update((SynchronizedMap)this, (Object)key, (Object)value);
            }

            public Option remove(Object key) {
                return SynchronizedMap.class.remove((SynchronizedMap)this, (Object)key);
            }

            public void clear() {
                SynchronizedMap.class.clear((SynchronizedMap)this);
            }

            public Object getOrElseUpdate(Object key, Function0 function0) {
                return SynchronizedMap.class.getOrElseUpdate((SynchronizedMap)this, (Object)key, (Function0)function0);
            }

            public SynchronizedMap<Object, ReceiverInfo> transform(Function2<Object, ReceiverInfo, ReceiverInfo> f) {
                return SynchronizedMap.class.transform((SynchronizedMap)this, f);
            }

            public SynchronizedMap<Object, ReceiverInfo> retain(Function2<Object, ReceiverInfo, Object> p) {
                return SynchronizedMap.class.retain((SynchronizedMap)this, p);
            }

            public Iterable<ReceiverInfo> values() {
                return SynchronizedMap.class.values((SynchronizedMap)this);
            }

            public Iterator<ReceiverInfo> valuesIterator() {
                return SynchronizedMap.class.valuesIterator((SynchronizedMap)this);
            }

            public scala.collection.mutable.Map<Object, ReceiverInfo> clone() {
                return SynchronizedMap.class.clone((SynchronizedMap)this);
            }

            public <U> void foreach(Function1<Tuple2<Object, ReceiverInfo>, U> f) {
                SynchronizedMap.class.foreach((SynchronizedMap)this, f);
            }

            public Object apply(Object key) {
                return SynchronizedMap.class.apply((SynchronizedMap)this, (Object)key);
            }

            public Set<Object> keySet() {
                return SynchronizedMap.class.keySet((SynchronizedMap)this);
            }

            public Iterable<Object> keys() {
                return SynchronizedMap.class.keys((SynchronizedMap)this);
            }

            public Iterator<Object> keysIterator() {
                return SynchronizedMap.class.keysIterator((SynchronizedMap)this);
            }

            public boolean isEmpty() {
                return SynchronizedMap.class.isEmpty((SynchronizedMap)this);
            }

            public boolean contains(Object key) {
                return SynchronizedMap.class.contains((SynchronizedMap)this, (Object)key);
            }

            public boolean isDefinedAt(Object key) {
                return SynchronizedMap.class.isDefinedAt((SynchronizedMap)this, (Object)key);
            }
            {
                SynchronizedMap.class.$init$((SynchronizedMap)this);
            }
        };
        this.receivedBlockTracker = new ReceivedBlockTracker(ssc.sparkContext().conf(), ssc.sparkContext().hadoopConfiguration(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(this.receiverInputStreamIds()), ssc.scheduler().clock(), ssc.isCheckpointPresent(), (Option<String>)Option$.MODULE$.apply((Object)ssc.checkpointDir()));
        this.listenerBus = ssc.scheduler().listenerBus();
        this.endpoint = null;
    }

    public class ReceiverLauncher {
        private final transient SparkEnv env;
        private volatile transient boolean running;
        private final transient Thread thread;

        public SparkEnv env() {
            return this.env;
        }

        private boolean running() {
            return this.running;
        }

        private void running_$eq(boolean x$1) {
            this.running = x$1;
        }

        public Thread thread() {
            return this.thread;
        }

        public void start() {
            this.thread().start();
        }

        public void stop(boolean graceful) {
            this.stopReceivers();
            this.thread().join(10000L);
            if (graceful) {
                int pollTime = 100;
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Waiting for receiver job to terminate gracefully";
                    }
                });
                while (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo().nonEmpty() || this.running()) {
                    Thread.sleep(pollTime);
                }
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Waited for receiver job to terminate gracefully";
                    }
                });
            }
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo().nonEmpty()) {
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverLauncher $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Not all of the receivers have deregistered, ").append(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            } else {
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "All of the receivers have deregistered successfully";
                    }
                });
            }
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$startReceivers() {
            RDD rDD;
            Receiver[] receivers = (Receiver[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInputStreams()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Receiver<?> apply(ReceiverInputDStream<?> nis) {
                    void var2_2;
                    Receiver<?> rcvr = nis.getReceiver();
                    rcvr.setReceiverId(nis.id());
                    return var2_2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Receiver.class)));
            boolean hasLocationPreferences = BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Receiver<?> x$3) {
                    return x$3.preferredLocation().isDefined();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()))).reduce((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(boolean x$4, boolean x$5) {
                    return x$4 && x$5;
                }
            }));
            if (hasLocationPreferences) {
                Tuple2[] receiversWithPreferences = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])receivers).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Receiver<Object>, Seq<String>> apply(Receiver<?> r) {
                        return new Tuple2(r, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)r.preferredLocation().get()})));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receiversWithPreferences), ClassTag$.MODULE$.apply(Receiver.class));
            } else {
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Predef$.MODULE$.wrapRefArray((Object[])receivers), Predef$.MODULE$.refArrayOps((Object[])receivers).size(), ClassTag$.MODULE$.apply(Receiver.class));
            }
            RDD tempRDD = rDD;
            Option checkpointDirOption = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.checkpointDir());
            SerializableWritable serializableHadoopConf = new SerializableWritable((Writable)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().hadoopConfiguration());
            Serializable startReceiver2 = new Serializable(this, checkpointDirOption, serializableHadoopConf){
                public static final long serialVersionUID = 0L;
                private final Option checkpointDirOption$1;
                private final SerializableWritable serializableHadoopConf$1;

                public final void apply(Iterator<Receiver<?>> iterator) {
                    if (iterator.hasNext()) {
                        Receiver receiver = (Receiver)iterator.next();
                        ReceiverSupervisorImpl supervisor2 = new ReceiverSupervisorImpl(receiver, SparkEnv$.MODULE$.get(), (Configuration)this.serializableHadoopConf$1.value(), (Option<String>)this.checkpointDirOption$1);
                        supervisor2.start();
                        supervisor2.awaitTermination();
                        return;
                    }
                    throw new SparkException("Could not start receiver as object not found.");
                }
                {
                    this.checkpointDirOption$1 = checkpointDirOption$1;
                    this.serializableHadoopConf$1 = serializableHadoopConf$1;
                }
            };
            Object object = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().isLocal() ? BoxedUnit.UNIT : RDD$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(int x) {
                    return new Tuple2.mcII.sp(x, 1);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$6, int x$7) {
                    return this.apply$mcIII$sp(x$6, x$7);
                }

                public int apply$mcIII$sp(int x$6, int x$7) {
                    return x$6 + x$7;
                }
            }, 20).collect();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this, receivers){
                public static final long serialVersionUID = 0L;
                private final Receiver[] receivers$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Starting ").append((Object)BoxesRunTime.boxToInteger((int)this.receivers$1.length)).append((Object)" receivers").toString();
                }
                {
                    this.receivers$1 = receivers$1;
                }
            });
            this.running_$eq(true);
            SparkContext qual$1 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext();
            Serializable x$25 = startReceiver2;
            boolean x$26 = qual$1.clean$default$2();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().runJob(tempRDD, (Function1)qual$1.clean((Object)x$25, x$26), ClassTag$.MODULE$.Unit());
            this.running_$eq(false);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "All of the receivers have been terminated";
                }
            });
        }

        private void stopReceivers() {
            ((IterableLike)((SynchronizedMap)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<RpcEndpointRef> apply(ReceiverInfo info) {
                    return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)info.endpoint()));
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(RpcEndpointRef x$8) {
                    x$8.send((Object)StopReceiver$.MODULE$);
                }
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverLauncher $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Sent stop signal to all ").append((Object)BoxesRunTime.boxToInteger((int)((SynchronizedMap)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverInfo()).size())).append((Object)" receivers").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer() {
            return ReceiverTracker.this;
        }

        public ReceiverLauncher() {
            if (ReceiverTracker.this == null) {
                throw null;
            }
            this.env = ReceiverTracker.this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env();
            this.running = false;
            this.thread = new Thread(this){
                private final /* synthetic */ ReceiverLauncher $outer;

                public void run() {
                    try {
                        SparkEnv$.MODULE$.set(this.$outer.env());
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$startReceivers();
                    }
                    catch (InterruptedException interruptedException) {
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverLauncher$$$outer().logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "ReceiverLauncher interrupted";
                            }
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }
    }

    public class ReceiverTrackerEndpoint
    implements ThreadSafeRpcEndpoint {
        private final RpcEnv rpcEnv;
        public final /* synthetic */ ReceiverTracker $outer;

        public final RpcEndpointRef self() {
            return RpcEndpoint.class.self((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.class.onError((RpcEndpoint)this, (Throwable)cause);
        }

        public void onStart() {
            RpcEndpoint.class.onStart((RpcEndpoint)this);
        }

        public void onStop() {
            RpcEndpoint.class.onStop((RpcEndpoint)this);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.class.onConnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            RpcEndpoint.class.onDisconnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.class.onNetworkError((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public final void stop() {
            RpcEndpoint.class.stop((RpcEndpoint)this);
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof ReportError) {
                        ReportError reportError2 = (ReportError)A1;
                        int streamId = reportError2.streamId();
                        String message = reportError2.message();
                        String error = reportError2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(streamId, message, error);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof ReportError;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                private final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver2 = (RegisterReceiver)A1;
                        int streamId = registerReceiver2.streamId();
                        String typ = registerReceiver2.typ();
                        String host = registerReceiver2.host();
                        RpcEndpointRef receiverEndpoint = registerReceiver2.receiverEndpoint();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(streamId, typ, host, receiverEndpoint, this.context$1.sender().address());
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof AddBlock) {
                        AddBlock addBlock2 = (AddBlock)A1;
                        ReceivedBlockInfo receivedBlockInfo = addBlock2.receivedBlockInfo();
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(receivedBlockInfo)));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver2 = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver2.streamId();
                        String message = deregisterReceiver2.msg();
                        String error = deregisterReceiver2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(streamId, message, error);
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    Object object = x2;
                    boolean bl = object instanceof RegisterReceiver ? true : (object instanceof AddBlock ? true : object instanceof DeregisterReceiver);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer() {
            return this.$outer;
        }

        public ReceiverTrackerEndpoint(ReceiverTracker $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.class.$init$((RpcEndpoint)this);
        }
    }
}

