/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rdd.RDDOperationScope;
import org.apache.spark.rdd.RDDOperationScope$;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.DStreamScopeSuite$;
import org.apache.spark.streaming.DummyDStream;
import org.apache.spark.streaming.DummyInputDStream;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.util.ManualClock;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ResizableArray;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u0017\t\tBi\u0015;sK\u0006l7kY8qKN+\u0018\u000e^3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011\u0001b\u0003\u0005\u0002\u000e\u001d5\tA!\u0003\u0002\u0010\t\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0005\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u000b\u0013\u00059\u0011UMZ8sK\u0006sG-\u00114uKJ\u0004\"!E\f\n\u0005a\u0011\"!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mY\")!\u0004\u0001C\u00017\u00051A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011A\u0001\u0005\b?\u0001\u0001\r\u0011\"\u0003!\u0003\r\u00198oY\u000b\u0002CA\u0011QDI\u0005\u0003G\t\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u000f\u0015\u0002\u0001\u0019!C\u0005M\u000591o]2`I\u0015\fHCA\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0011)f.\u001b;\t\u000f9\"\u0013\u0011!a\u0001C\u0005\u0019\u0001\u0010J\u0019\t\rA\u0002\u0001\u0015)\u0003\"\u0003\u0011\u00198o\u0019\u0011\t\u000fI\u0002!\u0019!C\u0005g\u0005i!-\u0019;dQ\u0012+(/\u0019;j_:,\u0012\u0001\u000e\t\u0003;UJ!A\u000e\u0002\u0003\u0011\u0011+(/\u0019;j_:Da\u0001\u000f\u0001!\u0002\u0013!\u0014A\u00042bi\u000eDG)\u001e:bi&|g\u000e\t\u0005\u0006u\u0001!\teO\u0001\nE\u00164wN]3BY2$\u0012a\n\u0005\u0006{\u0001!\teO\u0001\tC\u001a$XM]!mY\")q\b\u0001C\u0005w\u00051\u0012m]:feR\u0004&o\u001c9feRLWm\u001d(piN+G\u000fC\u0003B\u0001\u0011%!)\u0001\nbgN,'\u000f^*d_B,7i\u001c:sK\u000e$H\u0003B\u0014D\u00176CQ\u0001\u0012!A\u0002\u0015\u000b\u0011BY1tKN\u001bw\u000e]3\u0011\u0005\u0019KU\"A$\u000b\u0005!#\u0011a\u0001:eI&\u0011!j\u0012\u0002\u0012%\u0012#u\n]3sCRLwN\\*d_B,\u0007\"\u0002'A\u0001\u0004)\u0015\u0001\u0003:eIN\u001bw\u000e]3\t\u000b9\u0003\u0005\u0019A(\u0002\u0013\t\fGo\u00195US6,\u0007C\u0001\u0015Q\u0013\t\t\u0016F\u0001\u0003M_:<\u0007\"B*\u0001\t\u0013!\u0016!D1tg\u0016\u0014H\u000fR3gS:,G-\u0006\u0002VAR\u0011qE\u0016\u0005\u0006/J\u0003\r\u0001W\u0001\b_B$\u0018n\u001c8t!\rA\u0013lW\u0005\u00035&\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?!\rACLX\u0005\u0003;&\u0012aa\u00149uS>t\u0007CA0a\u0019\u0001!Q!\u0019*C\u0002\t\u0014\u0011\u0001V\t\u0003G\u001a\u0004\"\u0001\u000b3\n\u0005\u0015L#a\u0002(pi\"Lgn\u001a\t\u0003Q\u001dL!\u0001[\u0015\u0003\u0007\u0005s\u0017\u0010")
public class DStreamScopeSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private StreamingContext org$apache$spark$streaming$DStreamScopeSuite$$ssc;
    private final Duration batchDuration;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public StreamingContext org$apache$spark$streaming$DStreamScopeSuite$$ssc() {
        return this.org$apache$spark$streaming$DStreamScopeSuite$$ssc;
    }

    private void org$apache$spark$streaming$DStreamScopeSuite$$ssc_$eq(StreamingContext x$1) {
        this.org$apache$spark$streaming$DStreamScopeSuite$$ssc = x$1;
    }

    private Duration batchDuration() {
        return this.batchDuration;
    }

    public void beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
        SparkConf conf = new SparkConf().setMaster("local").setAppName("test");
        conf.set("spark.streaming.clock", ManualClock.class.getName());
        this.org$apache$spark$streaming$DStreamScopeSuite$$ssc_$eq(new StreamingContext(new SparkContext(conf), this.batchDuration()));
    }

    public void afterAll() {
        try {
            this.org$apache$spark$streaming$DStreamScopeSuite$$ssc().stop(true);
            return;
        }
        finally {
            super.afterAll();
        }
    }

    public void org$apache$spark$streaming$DStreamScopeSuite$$assertPropertiesNotSet() {
        StreamingContext $org_scalatest_assert_macro_left = this.org$apache$spark$streaming$DStreamScopeSuite$$ssc();
        Object $org_scalatest_assert_macro_right = null;
        StreamingContext streamingContext = $org_scalatest_assert_macro_left;
        Object var3_3 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, streamingContext != null ? !streamingContext.equals(var3_3) : var3_3 != null);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        String $org_scalatest_assert_macro_left2 = this.org$apache$spark$streaming$DStreamScopeSuite$$ssc().sc().getLocalProperty(SparkContext$.MODULE$.RDD_SCOPE_KEY());
        Object $org_scalatest_assert_macro_right2 = null;
        String string = $org_scalatest_assert_macro_left2;
        Object var7_7 = null;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(string != null ? !string.equals(var7_7) : var7_7 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        String $org_scalatest_assert_macro_left3 = this.org$apache$spark$streaming$DStreamScopeSuite$$ssc().sc().getLocalProperty(SparkContext$.MODULE$.RDD_SCOPE_NO_OVERRIDE_KEY());
        Object $org_scalatest_assert_macro_right3 = null;
        String string2 = $org_scalatest_assert_macro_left3;
        Object var11_11 = null;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", null, !(string2 != null ? !string2.equals(var11_11) : var11_11 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
    }

    public void org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect(RDDOperationScope baseScope, RDDOperationScope rddScope, long batchTime) {
        Tuple2 tuple2 = new Tuple2((Object)baseScope.id(), (Object)baseScope.name());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String baseScopeId = (String)tuple2._1();
            String baseScopeName = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)baseScopeId, (Object)baseScopeName);
            String baseScopeId2 = (String)tuple23._1();
            String baseScopeName2 = (String)tuple23._2();
            String formattedBatchTime = UIUtils$.MODULE$.formatBatchTime(batchTime, this.org$apache$spark$streaming$DStreamScopeSuite$$ssc().graph().batchDuration().milliseconds(), false, UIUtils$.MODULE$.formatBatchTime$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rddScope.id());
            String $org_scalatest_assert_macro_right = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseScopeId2, BoxesRunTime.boxToLong((long)batchTime)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rddScope.name().replaceAll("\\n", " "));
            String $org_scalatest_assert_macro_right2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " @ ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseScopeName2, formattedBatchTime}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            Option $org_scalatest_assert_macro_left3 = rddScope.parent();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public <T> void org$apache$spark$streaming$DStreamScopeSuite$$assertDefined(Seq<Option<T>> options) {
        ((IterableLike)options.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamScopeSuite $outer;

            public final void apply(Tuple2<Option<T>, Object> x0$2) {
                Tuple2<Option<T>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Option o = (Option)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(o.isDefined(), "o.isDefined");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " was empty!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public DStreamScopeSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.org$apache$spark$streaming$DStreamScopeSuite$$ssc = null;
        this.batchDuration = Seconds$.MODULE$.apply(1L);
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamScopeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertPropertiesNotSet();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.after((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamScopeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertPropertiesNotSet();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("dstream without scope", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamScopeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyDStream dummyStream = new DummyDStream(this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc());
                dummyStream.initialize(new Time(0L));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(dummyStream.baseScope());
                None$ $org_scalatest_assert_macro_right = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((RDD)dummyStream.getOrCompute(new Time(1000L)).get()).scope());
                None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(((RDD)dummyStream.getOrCompute(new Time(2000L)).get()).scope());
                None$ $org_scalatest_assert_macro_right3 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(((RDD)dummyStream.getOrCompute(new Time(3000L)).get()).scope());
                None$ $org_scalatest_assert_macro_right4 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("input dstream without scope", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamScopeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyInputDStream inputStream = new DummyInputDStream(this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc());
                inputStream.initialize(new Time(0L));
                Option baseScope = inputStream.baseScope().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDDOperationScope apply(String s) {
                        return RDDOperationScope$.MODULE$.fromJson(s);
                    }
                });
                Option scope1 = ((RDD)inputStream.getOrCompute(new Time(1000L)).get()).scope();
                Option scope2 = ((RDD)inputStream.getOrCompute(new Time(2000L)).get()).scope();
                Option scope3 = ((RDD)inputStream.getOrCompute(new Time(3000L)).get()).scope();
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertDefined(Predef$.MODULE$.wrapRefArray((Object[])new Option[]{baseScope, scope1, scope2, scope3}));
                String $org_scalatest_assert_macro_left = ((RDDOperationScope)baseScope.get()).name();
                String $org_scalatest_assert_macro_right = "dummy stream";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)baseScope.get(), (RDDOperationScope)scope1.get(), 1000L);
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)baseScope.get(), (RDDOperationScope)scope2.get(), 2000L);
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)baseScope.get(), (RDDOperationScope)scope3.get(), 3000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("scoping simple operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamScopeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyInputDStream inputStream = new DummyInputDStream(this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc());
                DStream mappedStream = inputStream.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    public int apply$mcII$sp(int i) {
                        return i + 1;
                    }
                }, ClassTag$.MODULE$.Int());
                DStream filteredStream = mappedStream.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return i % 2 == 0;
                    }
                });
                filteredStream.initialize(new Time(0L));
                Option mappedScopeBase = mappedStream.baseScope().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDDOperationScope apply(String s) {
                        return RDDOperationScope$.MODULE$.fromJson(s);
                    }
                });
                Option mappedScope1 = ((RDD)mappedStream.getOrCompute(new Time(1000L)).get()).scope();
                Option mappedScope2 = ((RDD)mappedStream.getOrCompute(new Time(2000L)).get()).scope();
                Option mappedScope3 = ((RDD)mappedStream.getOrCompute(new Time(3000L)).get()).scope();
                Option filteredScopeBase = filteredStream.baseScope().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDDOperationScope apply(String s) {
                        return RDDOperationScope$.MODULE$.fromJson(s);
                    }
                });
                Option filteredScope1 = ((RDD)filteredStream.getOrCompute(new Time(1000L)).get()).scope();
                Option filteredScope2 = ((RDD)filteredStream.getOrCompute(new Time(2000L)).get()).scope();
                Option filteredScope3 = ((RDD)filteredStream.getOrCompute(new Time(3000L)).get()).scope();
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertDefined(Predef$.MODULE$.wrapRefArray((Object[])new Option[]{mappedScopeBase, mappedScope1, mappedScope2, mappedScope3}));
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertDefined(Predef$.MODULE$.wrapRefArray((Object[])new Option[]{filteredScopeBase, filteredScope1, filteredScope2, filteredScope3}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(((RDDOperationScope)mappedScopeBase.get()).name());
                String $org_scalatest_assert_macro_right = "map";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((RDDOperationScope)filteredScopeBase.get()).name());
                String $org_scalatest_assert_macro_right2 = "filter";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)mappedScopeBase.get(), (RDDOperationScope)mappedScope1.get(), 1000L);
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)mappedScopeBase.get(), (RDDOperationScope)mappedScope2.get(), 2000L);
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)mappedScopeBase.get(), (RDDOperationScope)mappedScope3.get(), 3000L);
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)filteredScopeBase.get(), (RDDOperationScope)filteredScope1.get(), 1000L);
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)filteredScopeBase.get(), (RDDOperationScope)filteredScope2.get(), 2000L);
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)filteredScopeBase.get(), (RDDOperationScope)filteredScope3.get(), 3000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("scoping nested operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamScopeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyInputDStream inputStream = new DummyInputDStream(this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc());
                DStream countStream = inputStream.countByWindow(Seconds$.MODULE$.apply(10L), Seconds$.MODULE$.apply(1L));
                countStream.initialize(new Time(0L));
                Option countScopeBase = countStream.baseScope().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDDOperationScope apply(String s) {
                        return RDDOperationScope$.MODULE$.fromJson(s);
                    }
                });
                Option countScope1 = ((RDD)countStream.getOrCompute(new Time(1000L)).get()).scope();
                Option countScope2 = ((RDD)countStream.getOrCompute(new Time(2000L)).get()).scope();
                Option countScope3 = ((RDD)countStream.getOrCompute(new Time(3000L)).get()).scope();
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertDefined(Predef$.MODULE$.wrapRefArray((Object[])new Option[]{countScopeBase, countScope1, countScope2, countScope3}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(((RDDOperationScope)countScopeBase.get()).name());
                String $org_scalatest_assert_macro_right = "countByWindow";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)countScopeBase.get(), (RDDOperationScope)countScope1.get(), 1000L);
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)countScopeBase.get(), (RDDOperationScope)countScope2.get(), 2000L);
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)countScopeBase.get(), (RDDOperationScope)countScope3.get(), 3000L);
                this.org$apache$spark$streaming$DStreamScopeSuite$$anonfun$$testStream$1(countStream, inputStream, countScopeBase, countScope1, countScope2, countScope3);
            }

            public final void org$apache$spark$streaming$DStreamScopeSuite$$anonfun$$testStream$1(DStream stream, DummyInputDStream inputStream$1, Option countScopeBase$1, Option countScope1$1, Option countScope2$1, Option countScope3$1) {
                DStream dStream = stream;
                DummyInputDStream dummyInputDStream = inputStream$1;
                if (dStream == null ? dummyInputDStream != null : !dStream.equals((Object)((Object)dummyInputDStream))) {
                    Option myScopeBase = stream.baseScope().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RDDOperationScope apply(String s) {
                            return RDDOperationScope$.MODULE$.fromJson(s);
                        }
                    });
                    Option myScope1 = ((RDD)stream.getOrCompute(new Time(1000L)).get()).scope();
                    Option myScope2 = ((RDD)stream.getOrCompute(new Time(2000L)).get()).scope();
                    Option myScope3 = ((RDD)stream.getOrCompute(new Time(3000L)).get()).scope();
                    this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertDefined(Predef$.MODULE$.wrapRefArray((Object[])new Option[]{myScopeBase, myScope1, myScope2, myScope3}));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(myScopeBase);
                    Option $org_scalatest_assert_macro_right = countScopeBase$1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(myScope1);
                    Option $org_scalatest_assert_macro_right2 = countScope1$1;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(myScope2);
                    Option $org_scalatest_assert_macro_right3 = countScope2$1;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(myScope3);
                    Option $org_scalatest_assert_macro_right4 = countScope3$1;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    stream.dependencies().foreach((Function1)new Serializable(this, inputStream$1, countScopeBase$1, countScope1$1, countScope2$1, countScope3$1){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$8 $outer;
                        private final DummyInputDStream inputStream$1;
                        private final Option countScopeBase$1;
                        private final Option countScope1$1;
                        private final Option countScope2$1;
                        private final Option countScope3$1;

                        public final void apply(DStream<?> stream) {
                            this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$anonfun$$testStream$1(stream, this.inputStream$1, this.countScopeBase$1, this.countScope1$1, this.countScope2$1, this.countScope3$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.inputStream$1 = inputStream$1;
                            this.countScopeBase$1 = countScopeBase$1;
                            this.countScope1$1 = countScope1$1;
                            this.countScope2$1 = countScope2$1;
                            this.countScope3$1 = countScope3$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("transform should allow RDD operations to be captured in scopes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamScopeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyInputDStream inputStream = new DummyInputDStream(this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc());
                DStream transformedStream = inputStream.transform((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDD<Tuple2<Object, Object>> apply(RDD<Object> x$1) {
                        return RDD$.MODULE$.rddToPairRDDFunctions(x$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(int x$2) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x$2)), (Object)BoxesRunTime.boxToInteger((int)1));
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$3, int x$4) {
                                return this.apply$mcIII$sp(x$3, x$4);
                            }

                            public int apply$mcIII$sp(int x$3, int x$4) {
                                return x$3 + x$4;
                            }
                        });
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                transformedStream.initialize(new Time(0L));
                Option transformScopeBase = transformedStream.baseScope().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDDOperationScope apply(String s) {
                        return RDDOperationScope$.MODULE$.fromJson(s);
                    }
                });
                Option transformScope1 = ((RDD)transformedStream.getOrCompute(new Time(1000L)).get()).scope();
                Option transformScope2 = ((RDD)transformedStream.getOrCompute(new Time(2000L)).get()).scope();
                Option transformScope3 = ((RDD)transformedStream.getOrCompute(new Time(3000L)).get()).scope();
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertDefined(Predef$.MODULE$.wrapRefArray((Object[])new Option[]{transformScopeBase, transformScope1, transformScope2, transformScope3}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(((RDDOperationScope)transformScopeBase.get()).name());
                String $org_scalatest_assert_macro_right = "transform";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.assertNestedScopeCorrect$1((RDDOperationScope)transformScope1.get(), 1000L, transformScopeBase);
                this.assertNestedScopeCorrect$1((RDDOperationScope)transformScope2.get(), 2000L, transformScopeBase);
                this.assertNestedScopeCorrect$1((RDDOperationScope)transformScope3.get(), 3000L, transformScopeBase);
            }

            private final void assertNestedScopeCorrect$1(RDDOperationScope rddScope, long batchTime, Option transformScopeBase$1) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(rddScope.name());
                String $org_scalatest_assert_macro_right = "reduceByKey";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(rddScope.parent().isDefined(), "rddScope.parent.isDefined");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)transformScopeBase$1.get(), (RDDOperationScope)rddScope.parent().get(), batchTime);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("foreachRDD should allow RDD operations to be captured in scope", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamScopeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyInputDStream inputStream = new DummyInputDStream(this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc());
                ArrayBuffer generatedRDDs = new ArrayBuffer();
                inputStream.foreachRDD((Function1)new Serializable(this, generatedRDDs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer generatedRDDs$1;

                    public final void apply(RDD<Object> rdd) {
                        this.generatedRDDs$1.$plus$eq((Object)RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(int x$5) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x$5)), (Object)BoxesRunTime.boxToInteger((int)1));
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$6, int x$7) {
                                return this.apply$mcIII$sp(x$6, x$7);
                            }

                            public int apply$mcIII$sp(int x$6, int x$7) {
                                return x$6 + x$7;
                            }
                        }));
                    }
                    {
                        this.generatedRDDs$1 = generatedRDDs$1;
                    }
                });
                BatchCounter batchCounter = new BatchCounter(this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc());
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc().start();
                ManualClock clock = (ManualClock)this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc().scheduler().clock();
                clock.advance(3000L);
                batchCounter.waitUntilBatchesCompleted(3, 10000L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)generatedRDDs.size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Option foreachBaseScope = ((DStream)Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$ssc().graph().getOutputStreams()).head()).baseScope().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RDDOperationScope apply(String s) {
                        return RDDOperationScope$.MODULE$.fromJson(s);
                    }
                });
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertDefined(Predef$.MODULE$.wrapRefArray((Object[])new Option[]{foreachBaseScope}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((RDDOperationScope)foreachBaseScope.get()).name());
                String $org_scalatest_assert_macro_right2 = "foreachRDD";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ArrayBuffer rddScopes = (ArrayBuffer)generatedRDDs.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<RDDOperationScope> apply(RDD<Tuple2<Object, Object>> x$8) {
                        return x$8.scope();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
                this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$assertDefined(rddScopes);
                ((ResizableArray)rddScopes.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, foreachBaseScope){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;
                    private final Option foreachBaseScope$1;

                    public final void apply(Tuple2<Option<RDDOperationScope>, Object> x0$1) {
                        Tuple2<Option<RDDOperationScope>, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Option rddScope = (Option)tuple2._1();
                            int idx = tuple2._2$mcI$sp();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$anonfun$$$outer().convertToEqualizer(((RDDOperationScope)rddScope.get()).name());
                            String $org_scalatest_assert_macro_right = "reduceByKey";
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((RDDOperationScope)rddScope.get()).parent().isDefined(), "rddScope.get.parent.isDefined");
                            this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            this.$outer.org$apache$spark$streaming$DStreamScopeSuite$$anonfun$$$outer().org$apache$spark$streaming$DStreamScopeSuite$$assertScopeCorrect((RDDOperationScope)this.foreachBaseScope$1.get(), (RDDOperationScope)((RDDOperationScope)rddScope.get()).parent().get(), (idx + 1) * 1000);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.foreachBaseScope$1 = foreachBaseScope$1;
                    }
                });
            }

            public /* synthetic */ DStreamScopeSuite org$apache$spark$streaming$DStreamScopeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

